/*
 * Decompiled with CFR 0.152.
 */
package artofillusion.procedural;

import artofillusion.Vec3;
import artofillusion.procedural.IOPort;
import artofillusion.procedural.Module;
import artofillusion.procedural.PointInfo;
import java.awt.Point;

public class InterpModule
extends Module {
    double value;
    double error;
    double fract;
    double lastBlur;
    boolean valueOk;
    boolean errorOk;
    boolean gradOk;
    Vec3 gradient = new Vec3();
    Vec3 tempVec = new Vec3();

    public InterpModule(Point position) {
        super("Interp", new IOPort[]{new IOPort(0, 0, 0, new String[]{"Value 1", "(0)"}), new IOPort(0, 0, 1, new String[]{"Value 2", "(1)"}), new IOPort(0, 0, 2, new String[]{"Fraction", "(0)"})}, new IOPort[]{new IOPort(0, 1, 3, new String[]{"Interpolate"})}, position);
    }

    public void init(PointInfo p) {
        this.gradOk = false;
        this.errorOk = false;
        this.valueOk = false;
    }

    public double getAverageValue(int which, double blur) {
        if (this.valueOk && blur == this.lastBlur) {
            return this.value;
        }
        this.valueOk = true;
        this.lastBlur = blur;
        this.fract = this.linkFrom[2] == null ? 0.0 : this.linkFrom[2].getAverageValue(this.linkFromIndex[2], blur);
        double fractError = this.linkFrom[2] == null ? 0.0 : this.linkFrom[2].getValueError(this.linkFromIndex[2], blur);
        double min = this.fract - fractError;
        double max = this.fract + fractError;
        if (max <= 0.0) {
            this.fract = 0.0;
        } else if (min >= 1.0) {
            this.fract = 1.0;
        } else if (min < 0.0 || max > 1.0) {
            this.fract = 0.0;
            if (min < 0.0) {
                min = 0.0;
            }
            if (max > 1.0) {
                this.fract = max - 1.0;
                max = 1.0;
            }
            this.fract += 0.5 * (max + min) * (max - min);
            this.fract /= 2.0 * fractError;
        }
        double value1 = this.linkFrom[0] == null || this.fract == 1.0 ? 0.0 : this.linkFrom[0].getAverageValue(this.linkFromIndex[0], blur);
        double value2 = this.linkFrom[1] == null || this.fract == 0.0 ? 1.0 : this.linkFrom[1].getAverageValue(this.linkFromIndex[1], blur);
        this.value = (1.0 - this.fract) * value1 + this.fract * value2;
        return this.value;
    }

    public double getValueError(int which, double blur) {
        if (this.errorOk && blur == this.lastBlur) {
            return this.error;
        }
        this.errorOk = true;
        if (!this.valueOk || blur != this.lastBlur) {
            this.getAverageValue(which, blur);
        }
        double value1 = this.linkFrom[0] == null ? 0.0 : this.linkFrom[0].getValueError(this.linkFromIndex[0], blur);
        double value2 = this.linkFrom[1] == null ? 0.0 : this.linkFrom[1].getValueError(this.linkFromIndex[1], blur);
        this.error = (1.0 - this.fract) * value1 + this.fract * value2;
        return this.error;
    }

    public void getValueGradient(int which, Vec3 grad, double blur) {
        if (this.gradOk && blur == this.lastBlur) {
            grad.set(this.gradient);
            return;
        }
        this.gradOk = true;
        if (!this.valueOk || blur != this.lastBlur) {
            this.getAverageValue(which, blur);
        }
        if (this.linkFrom[0] == null || this.fract == 1.0) {
            grad.set(0.0, 0.0, 0.0);
        } else {
            this.linkFrom[0].getValueGradient(this.linkFromIndex[0], grad, blur);
            grad.scale(1.0 - this.fract);
        }
        if (this.linkFrom[1] == null || this.fract == 0.0) {
            this.tempVec.set(0.0, 0.0, 0.0);
        } else {
            this.linkFrom[1].getValueGradient(this.linkFromIndex[1], this.tempVec, blur);
            this.tempVec.scale(this.fract);
        }
        grad.add(this.tempVec);
        this.gradient.set(grad);
    }
}

