/*
 * Decompiled with CFR 0.152.
 */
package artofillusion.procedural;

import artofillusion.ImageMap;
import artofillusion.MaterialPreviewer;
import artofillusion.RGBColor;
import artofillusion.Scene;
import artofillusion.Texture;
import artofillusion.Texture3D;
import artofillusion.TextureParameter;
import artofillusion.TextureSpec;
import artofillusion.procedural.ImageModule;
import artofillusion.procedural.Module;
import artofillusion.procedural.OutputModule;
import artofillusion.procedural.ParameterModule;
import artofillusion.procedural.PointInfo;
import artofillusion.procedural.Procedure;
import artofillusion.procedural.ProcedureEditor;
import artofillusion.procedural.ProcedureOwner;
import artofillusion.ui.ComponentsDialog;
import artofillusion.ui.FloatingDialog;
import artofillusion.ui.ValueField;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Frame;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InvalidObjectException;

public class ProceduralTexture3D
extends Texture3D
implements ProcedureOwner {
    Procedure proc;
    PointInfo info;
    double antialiasing;

    public ProceduralTexture3D() {
        this.proc = new Procedure(new OutputModule[]{new OutputModule("Diffuse", "white", 0.0, new RGBColor(1.0f, 1.0f, 1.0f), 1), new OutputModule("Specular", "white", 0.0, new RGBColor(1.0f, 1.0f, 1.0f), 1), new OutputModule("Transparent", "white", 0.0, new RGBColor(1.0f, 1.0f, 1.0f), 1), new OutputModule("Emissive", "black", 0.0, new RGBColor(0.0f, 0.0f, 0.0f), 1), new OutputModule("Transparency", "0", 0.0, null, 0), new OutputModule("Specularity", "0", 0.0, null, 0), new OutputModule("Roughness", "0", 0.0, null, 0), new OutputModule("Cloudiness", "0", 0.0, null, 0), new OutputModule("Bump Height", "0", 0.0, null, 0), new OutputModule("Displacement", "0", 0.0, null, 0)});
        this.info = new PointInfo();
        this.antialiasing = 1.0;
    }

    public static String getTypeName() {
        return "Procedural 3D";
    }

    public void getAverageSpec(TextureSpec spec, double time, double[] param) {
        this.getTextureSpec(spec, 0.0, 0.0, 0.0, 1000.0, 1000.0, 1000.0, time, param);
    }

    public void getTextureSpec(TextureSpec spec, double x, double y, double z, double xsize, double ysize, double zsize, double t, double[] param) {
        OutputModule[] output = this.proc.getOutputModules();
        this.info.x = x;
        this.info.y = y;
        this.info.z = z;
        this.info.xsize = xsize * this.antialiasing;
        this.info.ysize = ysize * this.antialiasing;
        this.info.zsize = zsize * this.antialiasing;
        this.info.t = t;
        this.info.param = param;
        this.proc.initForPoint(this.info);
        double transparency = output[4].getAverageValue(0, 0.0);
        double specularity = output[5].getAverageValue(0, 0.0);
        if (transparency < 0.0) {
            transparency = 0.0;
        }
        if (transparency > 1.0) {
            transparency = 1.0;
        }
        if (specularity < 0.0) {
            specularity = 0.0;
        }
        if (specularity > 1.0) {
            specularity = 1.0;
        }
        output[0].getColor(0, spec.diffuse, 0.0);
        output[1].getColor(0, spec.specular, 0.0);
        output[2].getColor(0, spec.transparent, 0.0);
        output[3].getColor(0, spec.emissive, 0.0);
        spec.diffuse.scale((1.0 - transparency) * (1.0 - specularity));
        spec.specular.scale((1.0 - transparency) * specularity);
        spec.transparent.scale(transparency);
        spec.roughness = output[6].getAverageValue(0, 0.0);
        spec.cloudiness = output[7].getAverageValue(0, 0.0);
        if (spec.roughness < 0.0) {
            spec.roughness = 0.0;
        }
        if (spec.roughness > 1.0) {
            spec.roughness = 1.0;
        }
        if (spec.cloudiness < 0.0) {
            spec.cloudiness = 0.0;
        }
        if (spec.cloudiness > 1.0) {
            spec.cloudiness = 1.0;
        }
        output[8].getValueGradient(0, spec.bumpGrad, 0.0);
        spec.bumpGrad.scale(0.04);
    }

    public void getTransparency(RGBColor trans, double x, double y, double z, double xsize, double ysize, double zsize, double t, double[] param) {
        OutputModule[] output = this.proc.getOutputModules();
        this.info.x = x;
        this.info.y = y;
        this.info.z = z;
        this.info.xsize = xsize * this.antialiasing;
        this.info.ysize = ysize * this.antialiasing;
        this.info.zsize = zsize * this.antialiasing;
        this.info.t = t;
        this.info.param = param;
        this.proc.initForPoint(this.info);
        double transparency = output[4].getAverageValue(0, 0.0);
        if (transparency < 0.0) {
            transparency = 0.0;
        }
        if (transparency > 1.0) {
            transparency = 1.0;
        }
        output[2].getColor(0, trans, 0.0);
        trans.scale(transparency);
    }

    public boolean usesImage(ImageMap image) {
        Module[] modules = this.proc.getModules();
        int i = 0;
        while (i < modules.length) {
            if (modules[i] instanceof ImageModule && ((ImageModule)modules[i]).map == image) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public boolean displacementMapped() {
        OutputModule[] output = this.proc.getOutputModules();
        return output[9].inputConnected(0);
    }

    public double getDisplacement(double x, double y, double z, double xsize, double ysize, double zsize, double t, double[] param) {
        OutputModule[] output = this.proc.getOutputModules();
        this.info.x = x;
        this.info.y = y;
        this.info.z = z;
        this.info.xsize = xsize * this.antialiasing;
        this.info.ysize = ysize * this.antialiasing;
        this.info.zsize = zsize * this.antialiasing;
        this.info.t = t;
        this.info.param = param;
        this.proc.initForPoint(this.info);
        return output[9].getAverageValue(0, 0.0);
    }

    public boolean bumpMapped() {
        OutputModule[] output = this.proc.getOutputModules();
        return output[8].inputConnected(0);
    }

    public TextureParameter[] getParameters() {
        Module[] module = this.proc.getModules();
        int count = 0;
        int i = 0;
        while (i < module.length) {
            if (module[i] instanceof ParameterModule) {
                ++count;
            }
            ++i;
        }
        TextureParameter[] params = new TextureParameter[count];
        count = 0;
        int i2 = 0;
        while (i2 < module.length) {
            if (module[i2] instanceof ParameterModule) {
                params[count] = ((ParameterModule)module[i2]).getParameter(this);
                ((ParameterModule)module[i2]).setIndex(count++);
            }
            ++i2;
        }
        return params;
    }

    public Texture duplicate() {
        ProceduralTexture3D tex = new ProceduralTexture3D();
        tex.proc.copy(this.proc);
        tex.setName(this.getName());
        return tex;
    }

    public void edit(Frame fr, Scene sc) {
        new ProcedureEditor(this.proc, this, sc);
    }

    public ProceduralTexture3D(DataInputStream in, Scene theScene) throws IOException, InvalidObjectException {
        short version = in.readShort();
        if (version != 0) {
            throw new InvalidObjectException("");
        }
        this.setName(in.readUTF());
        this.antialiasing = in.readDouble();
        this.proc = new Procedure(new OutputModule[]{new OutputModule("Diffuse", "white", 0.0, new RGBColor(1.0f, 1.0f, 1.0f), 1), new OutputModule("Specular", "white", 0.0, new RGBColor(1.0f, 1.0f, 1.0f), 1), new OutputModule("Transparent", "white", 0.0, new RGBColor(1.0f, 1.0f, 1.0f), 1), new OutputModule("Emissive", "black", 0.0, new RGBColor(0.0f, 0.0f, 0.0f), 1), new OutputModule("Transparency", "0", 0.0, null, 0), new OutputModule("Specularity", "0", 0.0, null, 0), new OutputModule("Roughness", "0", 0.0, null, 0), new OutputModule("Cloudiness", "0", 0.0, null, 0), new OutputModule("Bump Height", "0", 0.0, null, 0), new OutputModule("Displacement", "0", 0.0, null, 0)});
        this.proc.readFromStream(in, theScene);
        this.info = new PointInfo();
    }

    public void writeToFile(DataOutputStream out, Scene theScene) throws IOException {
        out.writeShort(0);
        out.writeUTF(this.getName());
        out.writeDouble(this.antialiasing);
        this.proc.writeToStream(out, theScene);
    }

    public String getWindowTitle() {
        return "Procedural 3D Texture";
    }

    public Object getPreview(ProcedureEditor editor) {
        FloatingDialog dlg = new FloatingDialog(editor.getParentFrame(), "Preview", false);
        MaterialPreviewer preview = new MaterialPreviewer(this, null, 200, 160);
        dlg.add(preview);
        dlg.pack();
        dlg.show();
        return preview;
    }

    public void updatePreview(Object preview) {
        ((MaterialPreviewer)preview).render();
    }

    public void disposePreview(Object preview) {
        ((Dialog)((MaterialPreviewer)preview).getParent()).dispose();
    }

    public boolean allowParameters() {
        return true;
    }

    public boolean canEditName() {
        return true;
    }

    public void acceptEdits(ProcedureEditor editor) {
        int i = editor.getScene().getTextures().indexOf(this);
        if (i > -1) {
            editor.getScene().changeTexture(i);
        }
    }

    public void editProperties(ProcedureEditor editor) {
        ValueField aliasField = new ValueField(this.antialiasing, 1);
        ComponentsDialog dlg = new ComponentsDialog(editor.getParentFrame(), "Set Texture Properties:", new Component[]{aliasField}, new String[]{"Antialiasing"});
        if (!dlg.clickedOk()) {
            return;
        }
        editor.saveState(false);
        this.antialiasing = aliasField.getValue();
        editor.updatePreview();
    }
}

