/*
 * Decompiled with CFR 0.152.
 */
package artofillusion.procedural;

import artofillusion.EditingWindow;
import artofillusion.Scene;
import artofillusion.Vec2;
import artofillusion.procedural.AbsModule;
import artofillusion.procedural.BiasModule;
import artofillusion.procedural.BlendModule;
import artofillusion.procedural.BlurModule;
import artofillusion.procedural.BrickModule;
import artofillusion.procedural.CellsModule;
import artofillusion.procedural.CheckerModule;
import artofillusion.procedural.ClipModule;
import artofillusion.procedural.ColorDarkenModule;
import artofillusion.procedural.ColorDifferenceModule;
import artofillusion.procedural.ColorLightenModule;
import artofillusion.procedural.ColorModule;
import artofillusion.procedural.ColorProductModule;
import artofillusion.procedural.ColorScaleModule;
import artofillusion.procedural.ColorSumModule;
import artofillusion.procedural.CompareModule;
import artofillusion.procedural.CoordinateModule;
import artofillusion.procedural.CosineModule;
import artofillusion.procedural.DifferenceModule;
import artofillusion.procedural.ExpModule;
import artofillusion.procedural.ExprModule;
import artofillusion.procedural.FunctionModule;
import artofillusion.procedural.GainModule;
import artofillusion.procedural.GridModule;
import artofillusion.procedural.HSVModule;
import artofillusion.procedural.IOPort;
import artofillusion.procedural.ImageModule;
import artofillusion.procedural.InfoBox;
import artofillusion.procedural.InterpModule;
import artofillusion.procedural.JitterModule;
import artofillusion.procedural.Link;
import artofillusion.procedural.LogModule;
import artofillusion.procedural.MarbleModule;
import artofillusion.procedural.MaxModule;
import artofillusion.procedural.MinModule;
import artofillusion.procedural.ModModule;
import artofillusion.procedural.Module;
import artofillusion.procedural.NoiseModule;
import artofillusion.procedural.NumberModule;
import artofillusion.procedural.OutputModule;
import artofillusion.procedural.ParameterModule;
import artofillusion.procedural.PolarModule;
import artofillusion.procedural.PowerModule;
import artofillusion.procedural.Procedure;
import artofillusion.procedural.ProcedureOwner;
import artofillusion.procedural.ProductModule;
import artofillusion.procedural.RGBModule;
import artofillusion.procedural.RandomModule;
import artofillusion.procedural.RatioModule;
import artofillusion.procedural.ScaleShiftModule;
import artofillusion.procedural.SineModule;
import artofillusion.procedural.SpectrumModule;
import artofillusion.procedural.SphericalModule;
import artofillusion.procedural.SqrtModule;
import artofillusion.procedural.SumModule;
import artofillusion.procedural.TransformModule;
import artofillusion.procedural.TurbulenceModule;
import artofillusion.procedural.WoodModule;
import artofillusion.ui.AutoScroller;
import artofillusion.ui.MessageDialog;
import java.awt.Button;
import java.awt.Canvas;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Label;
import java.awt.Menu;
import java.awt.MenuBar;
import java.awt.MenuItem;
import java.awt.MenuShortcut;
import java.awt.Panel;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.ScrollPane;
import java.awt.TextField;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;

public class ProcedureEditor
extends Canvas
implements ActionListener,
KeyListener,
MouseListener,
MouseMotionListener {
    Frame parent;
    Procedure proc;
    ProcedureOwner owner;
    Scene theScene;
    EditingWindow win;
    Dimension size;
    MenuItem undoItem;
    TextField nameField;
    boolean[] selectedModule;
    boolean[] selectedLink;
    boolean draggingLink;
    boolean draggingModule;
    boolean draggingBox;
    boolean undoIsRedo;
    Point clickPos;
    Point lastPos;
    InfoBox inputInfo;
    InfoBox outputInfo;
    IOPort dragFromPort;
    IOPort dragToPort;
    ScrollPane scroll;
    Object preview;
    ByteArrayOutputStream undoBuffer;
    ByteArrayOutputStream cancelBuffer;

    public ProcedureEditor(Procedure proc, ProcedureOwner owner, Scene scene) {
        this.proc = proc;
        this.owner = owner;
        this.theScene = scene;
        this.selectedModule = new boolean[proc.getModules().length];
        this.selectedLink = new boolean[proc.getLinks().length];
        this.inputInfo = new InfoBox();
        this.outputInfo = new InfoBox();
        this.undoBuffer = new ByteArrayOutputStream();
        this.cancelBuffer = new ByteArrayOutputStream();
        this.parent = new Frame(owner.getWindowTitle());
        this.scroll = new ScrollPane();
        this.parent.add((Component)this.scroll, "Center");
        this.scroll.add(this);
        this.scroll.setSize(500, 550);
        new AutoScroller(this, this.scroll, 5, 5);
        this.size = new Dimension(1000, 1000);
        this.addKeyListener(this);
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
        DataOutputStream out = new DataOutputStream(this.cancelBuffer);
        try {
            proc.writeToStream(out, this.theScene);
            out.close();
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
        Panel p = new Panel();
        p.setLayout(new GridBagLayout());
        GridBagConstraints gc = new GridBagConstraints();
        gc.gridy = 0;
        gc.insets = new Insets(0, 0, 0, 5);
        if (owner.canEditName()) {
            p.add((Component)new Label("Name:"), gc);
            gc.fill = 2;
            gc.weightx = 1.0;
            this.nameField = new TextField(owner.getName());
            p.add((Component)this.nameField, gc);
        } else {
            gc.fill = 2;
            gc.weightx = 1.0;
            p.add((Component)new Label(), gc);
        }
        gc.weightx = 0.0;
        Button b = new Button("OK");
        p.add((Component)b, gc);
        b.setActionCommand("ok");
        b.addActionListener(this);
        b = new Button("Cancel");
        p.add((Component)b, gc);
        b.setActionCommand("cancel");
        b.addActionListener(this);
        this.parent.add((Component)p, "North");
        OutputModule[] output = proc.getOutputModules();
        int widest = 0;
        int i = 0;
        while (i < output.length) {
            output[i].calcSize();
            if (output[i].getBounds().width > widest) {
                widest = output[i].getBounds().width;
            }
            ++i;
        }
        int x = this.size.width - widest;
        int y = 20;
        i = 0;
        while (i < output.length) {
            output[i].setWidth(widest);
            output[i].setPosition(x, y);
            y += output[i].getBounds().height + 20;
            ++i;
        }
        MenuBar mb = new MenuBar();
        this.parent.setMenuBar(mb);
        mb.add(this.getEditMenu());
        mb.add(this.getInsertMenu());
        this.parent.pack();
        this.scroll.setScrollPosition(500 + this.scroll.getVScrollbarWidth(), 0);
        this.scroll.getHAdjustable().setBlockIncrement(100);
        this.scroll.getVAdjustable().setBlockIncrement(100);
        this.scroll.getHAdjustable().setUnitIncrement(10);
        this.scroll.getVAdjustable().setUnitIncrement(10);
        this.parent.show();
        this.preview = owner.getPreview(this);
    }

    private Menu getEditMenu() {
        Menu editMenu = new Menu("Edit");
        MenuItem item = new MenuItem("Undo", new MenuShortcut(90));
        editMenu.add(item);
        item.setActionCommand("undo");
        item.addActionListener(this);
        item.setEnabled(false);
        this.undoItem = item;
        item = new MenuItem("Properties...", new MenuShortcut(80));
        editMenu.add(item);
        item.setActionCommand("properties");
        item.addActionListener(this);
        return editMenu;
    }

    private Menu getInsertMenu() {
        Menu insertMenu = new Menu("Insert");
        Menu subMenu = new Menu("Values");
        insertMenu.add(subMenu);
        MenuItem item = new MenuItem("Number");
        subMenu.add(item);
        item.setActionCommand("number");
        item.addActionListener(this);
        item = new MenuItem("Color");
        subMenu.add(item);
        item.setActionCommand("color");
        item.addActionListener(this);
        item = new MenuItem("X");
        subMenu.add(item);
        item.setActionCommand("x");
        item.addActionListener(this);
        item = new MenuItem("Y");
        subMenu.add(item);
        item.setActionCommand("y");
        item.addActionListener(this);
        item = new MenuItem("Z");
        subMenu.add(item);
        item.setActionCommand("z");
        item.addActionListener(this);
        item = new MenuItem("Time");
        subMenu.add(item);
        item.setActionCommand("time");
        item.addActionListener(this);
        if (this.owner.allowParameters()) {
            item = new MenuItem("Parameter");
            subMenu.add(item);
            item.setActionCommand("parameter");
            item.addActionListener(this);
        }
        subMenu = new Menu("Functions");
        insertMenu.add(subMenu);
        item = new MenuItem("Expression");
        subMenu.add(item);
        item.setActionCommand("expression");
        item.addActionListener(this);
        item = new MenuItem("Custom");
        subMenu.add(item);
        item.setActionCommand("function");
        item.addActionListener(this);
        item = new MenuItem("Scale/Shift");
        subMenu.add(item);
        item.setActionCommand("scaleshift");
        item.addActionListener(this);
        item = new MenuItem("Add");
        subMenu.add(item);
        item.setActionCommand("sum");
        item.addActionListener(this);
        item = new MenuItem("Subtract");
        subMenu.add(item);
        item.setActionCommand("difference");
        item.addActionListener(this);
        item = new MenuItem("Multiply");
        subMenu.add(item);
        item.setActionCommand("product");
        item.addActionListener(this);
        item = new MenuItem("Divide");
        subMenu.add(item);
        item.setActionCommand("ratio");
        item.addActionListener(this);
        subMenu.addSeparator();
        item = new MenuItem("Abs");
        subMenu.add(item);
        item.setActionCommand("abs");
        item.addActionListener(this);
        item = new MenuItem("Blur");
        subMenu.add(item);
        item.setActionCommand("blur");
        item.addActionListener(this);
        item = new MenuItem("Clip");
        subMenu.add(item);
        item.setActionCommand("clip");
        item.addActionListener(this);
        item = new MenuItem("Greater Than");
        subMenu.add(item);
        item.setActionCommand("compare");
        item.addActionListener(this);
        item = new MenuItem("Min");
        subMenu.add(item);
        item.setActionCommand("min");
        item.addActionListener(this);
        item = new MenuItem("Max");
        subMenu.add(item);
        item.setActionCommand("max");
        item.addActionListener(this);
        item = new MenuItem("Interpolate");
        subMenu.add(item);
        item.setActionCommand("interpolate");
        item.addActionListener(this);
        item = new MenuItem("Mod");
        subMenu.add(item);
        item.setActionCommand("mod");
        item.addActionListener(this);
        subMenu.addSeparator();
        item = new MenuItem("Sine");
        subMenu.add(item);
        item.setActionCommand("sine");
        item.addActionListener(this);
        item = new MenuItem("Cosine");
        subMenu.add(item);
        item.setActionCommand("cosine");
        item.addActionListener(this);
        item = new MenuItem("Square Root");
        subMenu.add(item);
        item.setActionCommand("sqrt");
        item.addActionListener(this);
        item = new MenuItem("Exponential");
        subMenu.add(item);
        item.setActionCommand("exp");
        item.addActionListener(this);
        item = new MenuItem("Log");
        subMenu.add(item);
        item.setActionCommand("log");
        item.addActionListener(this);
        item = new MenuItem("Power");
        subMenu.add(item);
        item.setActionCommand("pow");
        item.addActionListener(this);
        item = new MenuItem("Bias");
        subMenu.add(item);
        item.setActionCommand("bias");
        item.addActionListener(this);
        item = new MenuItem("Gain");
        subMenu.add(item);
        item.setActionCommand("gain");
        item.addActionListener(this);
        item = new MenuItem("Random");
        subMenu.add(item);
        item.setActionCommand("random");
        item.addActionListener(this);
        subMenu = new Menu("Color Functions");
        insertMenu.add(subMenu);
        item = new MenuItem("Custom");
        subMenu.add(item);
        item.setActionCommand("spectrum");
        item.addActionListener(this);
        item = new MenuItem("Blend");
        subMenu.add(item);
        item.setActionCommand("blend");
        item.addActionListener(this);
        item = new MenuItem("Add");
        subMenu.add(item);
        item.setActionCommand("colorsum");
        item.addActionListener(this);
        item = new MenuItem("Subtract");
        subMenu.add(item);
        item.setActionCommand("colordifference");
        item.addActionListener(this);
        item = new MenuItem("Multiply");
        subMenu.add(item);
        item.setActionCommand("colorproduct");
        item.addActionListener(this);
        item = new MenuItem("Lighter");
        subMenu.add(item);
        item.setActionCommand("lightercolor");
        item.addActionListener(this);
        item = new MenuItem("Darker");
        subMenu.add(item);
        item.setActionCommand("darkercolor");
        item.addActionListener(this);
        item = new MenuItem("Scale");
        subMenu.add(item);
        item.setActionCommand("colorscale");
        item.addActionListener(this);
        item = new MenuItem("RGB");
        subMenu.add(item);
        item.setActionCommand("rgb");
        item.addActionListener(this);
        item = new MenuItem("HSV");
        subMenu.add(item);
        item.setActionCommand("hsv");
        item.addActionListener(this);
        subMenu = new Menu("Transforms");
        insertMenu.add(subMenu);
        item = new MenuItem("Linear");
        subMenu.add(item);
        item.setActionCommand("lineartransform");
        item.addActionListener(this);
        item = new MenuItem("Polar");
        subMenu.add(item);
        item.setActionCommand("polartransform");
        item.addActionListener(this);
        item = new MenuItem("Spherical");
        subMenu.add(item);
        item.setActionCommand("sphericaltransform");
        item.addActionListener(this);
        item = new MenuItem("Jitter");
        subMenu.add(item);
        item.setActionCommand("jitter");
        item.addActionListener(this);
        subMenu = new Menu("Patterns");
        insertMenu.add(subMenu);
        item = new MenuItem("Noise");
        subMenu.add(item);
        item.setActionCommand("noise");
        item.addActionListener(this);
        item = new MenuItem("Turbulence");
        subMenu.add(item);
        item.setActionCommand("turbulence");
        item.addActionListener(this);
        item = new MenuItem("Grid");
        subMenu.add(item);
        item.setActionCommand("grid");
        item.addActionListener(this);
        item = new MenuItem("Cells");
        subMenu.add(item);
        item.setActionCommand("cells");
        item.addActionListener(this);
        item = new MenuItem("Marble");
        subMenu.add(item);
        item.setActionCommand("marble");
        item.addActionListener(this);
        item = new MenuItem("Wood");
        subMenu.add(item);
        item.setActionCommand("wood");
        item.addActionListener(this);
        item = new MenuItem("Checker");
        subMenu.add(item);
        item.setActionCommand("checker");
        item.addActionListener(this);
        item = new MenuItem("Bricks");
        subMenu.add(item);
        item.setActionCommand("brick");
        item.addActionListener(this);
        item = new MenuItem("Image");
        subMenu.add(item);
        item.setActionCommand("image");
        item.addActionListener(this);
        return insertMenu;
    }

    public Frame getParentFrame() {
        return this.parent;
    }

    public Scene getScene() {
        return this.theScene;
    }

    public void setEditingWindow(EditingWindow window) {
        this.win = window;
    }

    public EditingWindow getEditingWindow() {
        return this.win;
    }

    public Dimension getPreferredSize() {
        return this.size;
    }

    public void paint(Graphics g) {
        OutputModule[] output = this.proc.getOutputModules();
        Module[] module = this.proc.getModules();
        Link[] link = this.proc.getLinks();
        int divider = output[0].getBounds().x - 1;
        int i = 0;
        while (i < output.length) {
            output[i].draw(g);
            ++i;
        }
        int i2 = 0;
        while (i2 < module.length) {
            if (!this.selectedModule[i2]) {
                module[i2].draw(g);
            }
            ++i2;
        }
        int i3 = 0;
        while (i3 < module.length) {
            if (this.selectedModule[i3]) {
                g.setColor(Color.red);
                Rectangle rect = module[i3].getBounds();
                g.drawRect(rect.x - 1, rect.y - 1, rect.width + 2, rect.height + 2);
                module[i3].draw(g);
            }
            ++i3;
        }
        g.setColor(Color.black);
        int i4 = 0;
        while (i4 < link.length) {
            if (!this.selectedLink[i4]) {
                Point p1 = link[i4].from.getPosition();
                Point p2 = link[i4].to.getPosition();
                g.drawLine(p1.x, p1.y, p2.x, p2.y);
            }
            ++i4;
        }
        g.setColor(Color.red);
        int i5 = 0;
        while (i5 < link.length) {
            if (this.selectedLink[i5]) {
                Point p1 = link[i5].from.getPosition();
                Point p2 = link[i5].to.getPosition();
                g.drawLine(p1.x, p1.y, p2.x, p2.y);
            }
            ++i5;
        }
        g.setColor(Color.black);
        g.drawLine(divider, 0, divider, this.size.height);
        if (this.draggingLink) {
            boolean isInput;
            boolean bl = isInput = this.dragFromPort.getType() == 0;
            if (isInput || this.dragToPort != null) {
                this.inputInfo.draw(g);
            }
            if (!isInput || this.dragToPort != null) {
                this.outputInfo.draw(g);
            }
        }
        g.setXORMode(Color.white);
        if (this.draggingBox && this.lastPos != null) {
            Rectangle rect = this.getRectangle(this.clickPos, this.lastPos);
            g.drawRect(rect.x, rect.y, rect.width, rect.height);
        }
        if (this.draggingLink && this.lastPos != null) {
            if (this.dragToPort == null) {
                g.drawLine(this.clickPos.x, this.clickPos.y, this.lastPos.x, this.lastPos.y);
            } else {
                Point pos = this.dragToPort.getPosition();
                g.drawLine(this.clickPos.x, this.clickPos.y, pos.x, pos.y);
            }
        }
        if (this.draggingModule && this.lastPos != null) {
            int dx = this.lastPos.x - this.clickPos.x;
            int dy = this.lastPos.y - this.clickPos.y;
            int i6 = 0;
            while (i6 < this.selectedModule.length) {
                if (this.selectedModule[i6]) {
                    Rectangle rect = module[i6].getBounds();
                    g.drawRect(rect.x + dx, rect.y + dy, rect.width, rect.height);
                }
                ++i6;
            }
        }
    }

    public void actionPerformed(ActionEvent e) {
        String command = e.getActionCommand();
        Point p = this.scroll.getScrollPosition();
        Dimension dim = this.scroll.getSize();
        p.x += (int)(0.5 * (double)dim.width * Math.random());
        p.y += (int)(0.5 * (double)dim.height * Math.random());
        if (command.equals("cancel")) {
            this.undoBuffer = this.cancelBuffer;
            this.undo();
            this.owner.disposePreview(this.preview);
            this.parent.dispose();
            return;
        }
        if (command.equals("ok")) {
            if (this.owner.canEditName()) {
                this.owner.setName(this.nameField.getText());
            }
            this.owner.acceptEdits(this);
            this.owner.disposePreview(this.preview);
            this.parent.dispose();
            return;
        }
        if (command.equals("undo")) {
            this.undo();
            return;
        }
        if (command.equals("properties")) {
            this.owner.editProperties(this);
        }
        this.saveState(false);
        this.setCursor(Cursor.getPredefinedCursor(3));
        if (command.equals("number")) {
            this.addModule(new NumberModule(p));
        } else if (command.equals("color")) {
            this.addModule(new ColorModule(p));
        } else if (command.equals("x")) {
            this.addModule(new CoordinateModule(p, 0));
        } else if (command.equals("y")) {
            this.addModule(new CoordinateModule(p, 1));
        } else if (command.equals("z")) {
            this.addModule(new CoordinateModule(p, 2));
        } else if (command.equals("time")) {
            this.addModule(new CoordinateModule(p, 3));
        } else if (command.equals("parameter")) {
            this.addModule(new ParameterModule(p));
        } else if (command.equals("sum")) {
            this.addModule(new SumModule(p));
        } else if (command.equals("difference")) {
            this.addModule(new DifferenceModule(p));
        } else if (command.equals("product")) {
            this.addModule(new ProductModule(p));
        } else if (command.equals("ratio")) {
            this.addModule(new RatioModule(p));
        } else if (command.equals("scaleshift")) {
            this.addModule(new ScaleShiftModule(p));
        } else if (command.equals("interpolate")) {
            this.addModule(new InterpModule(p));
        } else if (command.equals("compare")) {
            this.addModule(new CompareModule(p));
        } else if (command.equals("min")) {
            this.addModule(new MinModule(p));
        } else if (command.equals("max")) {
            this.addModule(new MaxModule(p));
        } else if (command.equals("mod")) {
            this.addModule(new ModModule(p));
        } else if (command.equals("abs")) {
            this.addModule(new AbsModule(p));
        } else if (command.equals("clip")) {
            this.addModule(new ClipModule(p));
        } else if (command.equals("sine")) {
            this.addModule(new SineModule(p));
        } else if (command.equals("cosine")) {
            this.addModule(new CosineModule(p));
        } else if (command.equals("sqrt")) {
            this.addModule(new SqrtModule(p));
        } else if (command.equals("exp")) {
            this.addModule(new ExpModule(p));
        } else if (command.equals("log")) {
            this.addModule(new LogModule(p));
        } else if (command.equals("pow")) {
            this.addModule(new PowerModule(p));
        } else if (command.equals("bias")) {
            this.addModule(new BiasModule(p));
        } else if (command.equals("gain")) {
            this.addModule(new GainModule(p));
        } else if (command.equals("random")) {
            this.addModule(new RandomModule(p));
        } else if (command.equals("blur")) {
            this.addModule(new BlurModule(p));
        } else if (command.equals("function")) {
            this.addModule(new FunctionModule(p));
        } else if (command.equals("expression")) {
            this.addModule(new ExprModule(p));
        } else if (command.equals("lineartransform")) {
            this.addModule(new TransformModule(p));
        } else if (command.equals("polartransform")) {
            this.addModule(new PolarModule(p));
        } else if (command.equals("sphericaltransform")) {
            this.addModule(new SphericalModule(p));
        } else if (command.equals("jitter")) {
            this.addModule(new JitterModule(p));
        } else if (command.equals("colorsum")) {
            this.addModule(new ColorSumModule(p));
        } else if (command.equals("colordifference")) {
            this.addModule(new ColorDifferenceModule(p));
        } else if (command.equals("colorproduct")) {
            this.addModule(new ColorProductModule(p));
        } else if (command.equals("lightercolor")) {
            this.addModule(new ColorLightenModule(p));
        } else if (command.equals("darkercolor")) {
            this.addModule(new ColorDarkenModule(p));
        } else if (command.equals("colorscale")) {
            this.addModule(new ColorScaleModule(p));
        } else if (command.equals("blend")) {
            this.addModule(new BlendModule(p));
        } else if (command.equals("spectrum")) {
            this.addModule(new SpectrumModule(p));
        } else if (command.equals("rgb")) {
            this.addModule(new RGBModule(p));
        } else if (command.equals("hsv")) {
            this.addModule(new HSVModule(p));
        } else if (command.equals("noise")) {
            this.addModule(new NoiseModule(p));
        } else if (command.equals("turbulence")) {
            this.addModule(new TurbulenceModule(p));
        } else if (command.equals("marble")) {
            this.addModule(new MarbleModule(p));
        } else if (command.equals("wood")) {
            this.addModule(new WoodModule(p));
        } else if (command.equals("grid")) {
            this.addModule(new GridModule(p));
        } else if (command.equals("cells")) {
            this.addModule(new CellsModule(p));
        } else if (command.equals("checker")) {
            this.addModule(new CheckerModule(p));
        } else if (command.equals("brick")) {
            this.addModule(new BrickModule(p));
        } else if (command.equals("image")) {
            this.addModule(new ImageModule(p));
        }
        this.setCursor(Cursor.getDefaultCursor());
        this.repaint();
    }

    private void addModule(Module mod) {
        this.selectedModule = new boolean[this.selectedModule.length + 1];
        this.selectedModule[this.selectedModule.length - 1] = true;
        int i = 0;
        while (i < this.selectedLink.length) {
            this.selectedLink[i] = false;
            ++i;
        }
        this.proc.addModule(mod);
    }

    private void addLink(IOPort port1, IOPort port2) {
        IOPort to;
        IOPort from;
        this.selectedLink = new boolean[this.selectedLink.length + 1];
        this.selectedLink[this.selectedLink.length - 1] = true;
        int i = 0;
        while (i < this.selectedModule.length) {
            this.selectedModule[i] = false;
            ++i;
        }
        if (port1.getType() == 1) {
            from = port1;
            to = port2;
        } else {
            from = port2;
            to = port1;
        }
        to.getModule().setInput(to, from);
        this.proc.addLink(new Link(from, to));
        if (this.proc.checkFeedback()) {
            this.proc.deleteLink(this.proc.getLinks().length - 1);
            new MessageDialog(this.parent, new String[]{"The link you have selected cannot be created,", "as it would result in a feedback loop."});
        }
    }

    public void saveState(boolean redo) {
        this.undoBuffer.reset();
        DataOutputStream out = new DataOutputStream(this.undoBuffer);
        try {
            this.proc.writeToStream(out, this.theScene);
            out.close();
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
        this.undoIsRedo = redo & !this.undoIsRedo;
        this.undoItem.setLabel(this.undoIsRedo ? "Redo" : "Undo");
        this.undoItem.setEnabled(true);
    }

    private void undo() {
        byte[] buffer = this.undoBuffer.toByteArray();
        DataInputStream in = new DataInputStream(new ByteArrayInputStream(buffer));
        this.saveState(true);
        try {
            this.proc.readFromStream(in, this.theScene);
            in.close();
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
        this.selectedModule = new boolean[this.proc.getModules().length];
        this.selectedLink = new boolean[this.proc.getLinks().length];
        this.repaint();
        this.updatePreview();
    }

    public void updatePreview() {
        this.owner.updatePreview(this.preview);
    }

    public boolean isFocusTraversable() {
        return true;
    }

    public void mouseClicked(MouseEvent e) {
        Point pos = e.getPoint();
        if (e.getClickCount() == 2) {
            Module[] module = this.proc.getModules();
            int i = 0;
            while (i < module.length) {
                if (module[i].getBounds().contains(pos)) {
                    this.saveState(false);
                    if (module[i].edit(this.parent, this.theScene)) {
                        this.repaint();
                        this.updatePreview();
                    }
                    return;
                }
                ++i;
            }
        }
    }

    public void mousePressed(MouseEvent e) {
        IOPort port;
        OutputModule[] output = this.proc.getOutputModules();
        Module[] module = this.proc.getModules();
        Link[] link = this.proc.getLinks();
        this.requestFocus();
        this.clickPos = e.getPoint();
        this.lastPos = null;
        int i = 0;
        while (i < module.length) {
            port = module[i].getClickedPort(this.clickPos);
            if (port != null) {
                this.startDragLink(port);
                return;
            }
            ++i;
        }
        i = 0;
        while (i < output.length) {
            port = output[i].getClickedPort(this.clickPos);
            if (port != null) {
                this.startDragLink(port);
                return;
            }
            ++i;
        }
        i = module.length - 1;
        while (i >= 0) {
            if (this.selectedModule[i] && module[i].getBounds().contains(this.clickPos)) {
                this.draggingModule = true;
                this.repaint();
                return;
            }
            --i;
        }
        i = module.length - 1;
        while (i >= 0) {
            if (!this.selectedModule[i] && module[i].getBounds().contains(this.clickPos)) {
                this.draggingModule = true;
                if (!e.isShiftDown()) {
                    int j = 0;
                    while (j < this.selectedModule.length) {
                        this.selectedModule[j] = false;
                        ++j;
                    }
                    j = 0;
                    while (j < this.selectedLink.length) {
                        this.selectedLink[j] = false;
                        ++j;
                    }
                }
                this.selectedModule[i] = true;
                this.repaint();
                return;
            }
            --i;
        }
        i = 0;
        while (i < link.length) {
            Point p1 = link[i].from.getPosition();
            Point p2 = link[i].to.getPosition();
            int tol = 2;
            if (!(this.clickPos.x < p1.x - tol && this.clickPos.x < p2.x - tol || this.clickPos.x > p1.x + tol && this.clickPos.x > p2.x + tol || this.clickPos.y < p1.y - tol && this.clickPos.y < p2.y - tol || this.clickPos.y > p1.y + tol && this.clickPos.y > p2.y + tol)) {
                Vec2 v1 = new Vec2(p2.x - p1.x, p2.y - p1.y);
                Vec2 v2 = new Vec2(this.clickPos.x - p1.x, this.clickPos.y - p1.y);
                v1.normalize();
                double dot = v1.dot(v2);
                v1.scale(dot);
                v2.subtract(v1);
                if (v2.length2() <= (double)(tol * tol)) {
                    if (!e.isShiftDown() && !this.selectedLink[i]) {
                        int j = 0;
                        while (j < this.selectedModule.length) {
                            this.selectedModule[j] = false;
                            ++j;
                        }
                        j = 0;
                        while (j < this.selectedLink.length) {
                            this.selectedLink[j] = false;
                            ++j;
                        }
                    }
                    this.selectedLink[i] = true;
                    this.repaint();
                    return;
                }
            }
            ++i;
        }
        if (!e.isShiftDown()) {
            i = 0;
            while (i < this.selectedModule.length) {
                this.selectedModule[i] = false;
                ++i;
            }
            i = 0;
            while (i < this.selectedLink.length) {
                this.selectedLink[i] = false;
                ++i;
            }
        }
        this.draggingBox = true;
        this.repaint();
    }

    public void mouseReleased(MouseEvent e) {
        Point pos = e.getPoint();
        if (this.draggingLink) {
            this.draggingLink = false;
            if (this.dragToPort != null) {
                this.saveState(false);
                this.addLink(this.dragFromPort, this.dragToPort);
                this.updatePreview();
            }
            this.repaint();
            return;
        }
        if (this.draggingBox) {
            if (this.lastPos == null) {
                this.draggingBox = false;
                this.repaint();
                return;
            }
            Rectangle rect = this.getRectangle(this.clickPos, this.lastPos);
            Module[] module = this.proc.getModules();
            int i = 0;
            while (i < this.selectedModule.length) {
                if (module[i].getBounds().intersects(rect)) {
                    this.selectedModule[i] = true;
                }
                ++i;
            }
            this.draggingBox = false;
            this.repaint();
            return;
        }
        if (this.draggingModule) {
            this.saveState(false);
            this.draggingModule = false;
            int dx = pos.x - this.clickPos.x;
            int dy = pos.y - this.clickPos.y;
            Module[] module = this.proc.getModules();
            int i = 0;
            while (i < this.selectedModule.length) {
                if (this.selectedModule[i]) {
                    Rectangle rect = module[i].getBounds();
                    module[i].setPosition(rect.x + dx, rect.y + dy);
                }
                ++i;
            }
        }
        this.repaint();
    }

    public void mouseEntered(MouseEvent e) {
    }

    public void mouseExited(MouseEvent e) {
    }

    public void mouseDragged(MouseEvent e) {
        Point pos = e.getPoint();
        if (this.draggingBox) {
            Rectangle rect;
            Graphics g = this.getGraphics();
            g.setColor(Color.black);
            g.setXORMode(Color.white);
            if (this.lastPos != null) {
                rect = this.getRectangle(this.clickPos, this.lastPos);
                g.drawRect(rect.x, rect.y, rect.width, rect.height);
            }
            this.lastPos = pos;
            rect = this.getRectangle(this.clickPos, this.lastPos);
            g.drawRect(rect.x, rect.y, rect.width, rect.height);
            g.dispose();
            return;
        }
        if (this.draggingLink) {
            boolean isInput;
            if (this.dragToPort != null && this.dragToPort.contains(pos)) {
                return;
            }
            Graphics g = this.getGraphics();
            boolean bl = isInput = this.dragFromPort.getType() == 0;
            if (this.dragToPort != null) {
                this.dragToPort = null;
                ((Component)this).update(g);
            }
            g.setColor(Color.black);
            g.setXORMode(Color.white);
            if (this.lastPos != null) {
                g.drawLine(this.clickPos.x, this.clickPos.y, this.lastPos.x, this.lastPos.y);
            }
            OutputModule[] output = this.proc.getOutputModules();
            Module[] module = this.proc.getModules();
            int i = 0;
            while (i < module.length) {
                IOPort[] port = isInput ? module[i].getOutputPorts() : module[i].getInputPorts();
                int j = 0;
                while (j < port.length) {
                    if ((isInput || !module[i].inputConnected(j)) && port[j].getValueType() == this.dragFromPort.getValueType() && port[j].contains(pos)) {
                        this.dragToPort = port[j];
                    }
                    ++j;
                }
                if (this.dragToPort != null) break;
                ++i;
            }
            if (!isInput) {
                int i2 = 0;
                while (i2 < output.length) {
                    IOPort[] port = output[i2].getInputPorts();
                    int j = 0;
                    while (j < port.length) {
                        if (!output[i2].inputConnected(j) && port[j].getValueType() == this.dragFromPort.getValueType() && port[j].contains(pos)) {
                            this.dragToPort = port[j];
                        }
                        ++j;
                    }
                    if (this.dragToPort != null) break;
                    ++i2;
                }
            }
            if (this.dragToPort != null) {
                InfoBox info = isInput ? this.outputInfo : this.inputInfo;
                Rectangle rect = info.getBounds();
                pos = this.dragToPort.getPosition();
                if (isInput) {
                    info.setPosition(pos.x - rect.width - 10, pos.y - rect.height / 2);
                } else {
                    info.setPosition(pos.x + 10, pos.y - rect.height / 2);
                }
                info.setText(this.dragToPort.getDescription());
                g.setPaintMode();
                this.repaint();
                g.setColor(Color.black);
                g.setXORMode(Color.white);
            } else {
                g.drawLine(this.clickPos.x, this.clickPos.y, pos.x, pos.y);
            }
            g.dispose();
            this.lastPos = pos;
            return;
        }
        if (!this.draggingModule) {
            return;
        }
        int dx = pos.x - this.clickPos.x;
        int dy = pos.y - this.clickPos.y;
        int lastdx = 0;
        int lastdy = 0;
        Module[] module = this.proc.getModules();
        Graphics g = this.getGraphics();
        if (this.lastPos != null) {
            lastdx = this.lastPos.x - this.clickPos.x;
            lastdy = this.lastPos.y - this.clickPos.y;
        }
        g.setColor(Color.black);
        g.setXORMode(Color.white);
        int i = 0;
        while (i < this.selectedModule.length) {
            if (this.selectedModule[i]) {
                Rectangle rect = module[i].getBounds();
                if (this.lastPos != null) {
                    g.drawRect(rect.x + lastdx, rect.y + lastdy, rect.width, rect.height);
                }
                g.drawRect(rect.x + dx, rect.y + dy, rect.width, rect.height);
            }
            ++i;
        }
        g.dispose();
        this.lastPos = pos;
    }

    public void mouseMoved(MouseEvent e) {
    }

    private void startDragLink(IOPort port) {
        boolean isInput = port.getType() == 0;
        InfoBox info = isInput ? this.inputInfo : this.outputInfo;
        Point pos = port.getPosition();
        this.draggingLink = true;
        this.draggingModule = false;
        this.dragFromPort = port;
        this.dragToPort = null;
        this.clickPos = port.getPosition();
        info.setText(port.getDescription());
        Rectangle rect = info.getBounds();
        if (isInput) {
            info.setPosition(pos.x + 10, pos.y - rect.height / 2);
        } else {
            info.setPosition(pos.x - rect.width - 10, pos.y - rect.height / 2);
        }
        Graphics g = this.getGraphics();
        info.draw(g);
        g.dispose();
        if (isInput) {
            Module module = port.getModule();
            IOPort[] inputs = module.getInputPorts();
            int i = 0;
            while (i < inputs.length) {
                if (inputs[i] == port && module.inputConnected(i)) {
                    this.draggingLink = false;
                }
                ++i;
            }
        }
    }

    public void keyPressed(KeyEvent e) {
        int key = e.getKeyCode();
        if (key != 8 && key != 127) {
            return;
        }
        this.saveState(false);
        Module[] module = this.proc.getModules();
        Link[] link = this.proc.getLinks();
        boolean num = false;
        int i = 0;
        while (i < this.selectedLink.length) {
            int j = 0;
            while (j < this.selectedModule.length) {
                if (module[j] == link[i].from.getModule() && this.selectedModule[j] || module[j] == link[i].to.getModule() && this.selectedModule[j]) {
                    this.selectedLink[i] = true;
                }
                ++j;
            }
            ++i;
        }
        i = this.selectedLink.length - 1;
        while (i >= 0) {
            if (this.selectedLink[i]) {
                this.proc.deleteLink(i);
            }
            --i;
        }
        i = this.selectedModule.length - 1;
        while (i >= 0) {
            if (this.selectedModule[i]) {
                this.proc.deleteModule(i);
            }
            --i;
        }
        this.selectedModule = new boolean[this.proc.getModules().length];
        this.selectedLink = new boolean[this.proc.getLinks().length];
        this.updatePreview();
        this.repaint();
    }

    public void keyReleased(KeyEvent e) {
    }

    public void keyTyped(KeyEvent e) {
    }

    public Rectangle getRectangle(Point p1, Point p2) {
        int x = Math.min(p1.x, p2.x);
        int y = Math.min(p1.y, p2.y);
        int width = Math.abs(p1.x - p2.x);
        int height = Math.abs(p1.y - p2.y);
        return new Rectangle(x, y, width, height);
    }
}

