/*
 * Decompiled with CFR 0.152.
 */
package artofillusion.procedural;

import artofillusion.Vec3;
import artofillusion.procedural.IOPort;
import artofillusion.procedural.Module;
import artofillusion.procedural.PointInfo;
import java.awt.Point;

public class ProductModule
extends Module {
    boolean valueOk;
    boolean errorOk;
    double value;
    double error;
    double valueIn1;
    double valueIn2;
    double errorIn1;
    double errorIn2;
    double lastBlur;
    Vec3 tempVec = new Vec3();

    public ProductModule(Point position) {
        super("\u00d7", new IOPort[]{new IOPort(0, 0, 0, new String[]{"Value 1", "(0)"}), new IOPort(0, 0, 1, new String[]{"Value 2", "(0)"})}, new IOPort[]{new IOPort(0, 1, 3, new String[]{"Product"})}, position);
    }

    public void init(PointInfo p) {
        this.errorOk = false;
        this.valueOk = false;
    }

    public double getAverageValue(int which, double blur) {
        if (this.valueOk && blur == this.lastBlur) {
            return this.value;
        }
        this.valueOk = true;
        this.lastBlur = blur;
        if (this.linkFrom[0] == null || this.linkFrom[1] == null) {
            this.error = 0.0;
            this.value = 0.0;
            this.valueIn2 = 0.0;
            this.valueIn1 = 0.0;
            this.errorOk = true;
            return 0.0;
        }
        this.valueIn1 = this.linkFrom[0].getAverageValue(this.linkFromIndex[0], blur);
        this.valueIn2 = this.linkFrom[1].getAverageValue(this.linkFromIndex[1], blur);
        this.value = this.valueIn1 * this.valueIn2;
        return this.value;
    }

    public double getValueError(int which, double blur) {
        if (!this.valueOk || blur != this.lastBlur) {
            this.getAverageValue(which, blur);
        }
        if (this.errorOk) {
            return this.error;
        }
        this.errorOk = true;
        this.valueOk = true;
        this.errorIn1 = this.linkFrom[0].getValueError(this.linkFromIndex[0], blur);
        this.errorIn2 = this.linkFrom[1].getValueError(this.linkFromIndex[1], blur);
        this.error = Math.abs(this.valueIn1 * this.errorIn2) + Math.abs(this.valueIn2 * this.errorIn1);
        return this.error;
    }

    public void getValueGradient(int which, Vec3 grad, double blur) {
        if (this.linkFrom[0] == null || this.linkFrom[1] == null) {
            grad.set(0.0, 0.0, 0.0);
            return;
        }
        if (!this.valueOk || blur != this.lastBlur) {
            this.getAverageValue(which, blur);
        }
        this.linkFrom[0].getValueGradient(this.linkFromIndex[0], grad, blur);
        this.linkFrom[1].getValueGradient(this.linkFromIndex[1], this.tempVec, blur);
        grad.scale(this.valueIn2);
        this.tempVec.scale(this.valueIn1);
        grad.add(this.tempVec);
    }
}

