/*
 * Decompiled with CFR 0.152.
 */
package artofillusion.procedural;

import artofillusion.Scene;
import artofillusion.Vec3;
import artofillusion.procedural.IOPort;
import artofillusion.procedural.Module;
import artofillusion.procedural.PointInfo;
import artofillusion.ui.ComponentsDialog;
import artofillusion.ui.ValueField;
import java.awt.Component;
import java.awt.Frame;
import java.awt.Point;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Random;

public class RandomModule
extends Module {
    boolean repeat;
    boolean valueOk;
    boolean errorOk;
    boolean gradOk;
    int lastBase = Integer.MAX_VALUE;
    int octaves = 3;
    double a1;
    double a2;
    double a3;
    double value;
    double error;
    double deriv;
    double amplitude = 1.0;
    double lastBlur;
    Random random;
    Vec3 gradient = new Vec3();
    PointInfo point;

    public RandomModule(Point position) {
        super("Random", new IOPort[]{new IOPort(0, 0, 2, new String[]{"Input", "(time)"}), new IOPort(0, 0, 2, new String[]{"Noise", "(0.5)"})}, new IOPort[]{new IOPort(0, 1, 3, new String[]{"Output"})}, position);
        this.random = new Random();
    }

    public void init(PointInfo p) {
        this.gradOk = false;
        this.errorOk = false;
        this.valueOk = false;
        this.point = p;
    }

    private void calcCoefficients(int base) {
        if (base == this.lastBase) {
            return;
        }
        this.lastBase = base;
        this.random.setSeed(base);
        this.random.nextDouble();
        this.a1 = this.random.nextDouble();
        this.random.setSeed(base + 1);
        this.random.nextDouble();
        double m2 = this.random.nextDouble();
        this.a2 = -2.0 * this.a1 - m2;
        this.a3 = this.a1 + m2;
    }

    private double calcNoise(double fract) {
        return fract * (this.a1 + fract * (this.a2 + fract * this.a3));
    }

    private double calcNoiseDeriv(double fract) {
        return this.a1 + fract * (2.0 * this.a2 + fract * 3.0 * this.a3);
    }

    private double calcNoiseIntegral(double fract) {
        return fract * fract * (0.5 * this.a1 + fract * (0.3333333333333333 * this.a2 + fract * 0.25 * this.a3));
    }

    private double calcNoiseUnitIntegral() {
        return 0.5 * this.a1 + (0.3333333333333333 * this.a2 + 0.25 * this.a3);
    }

    public double getAverageValue(int which, double blur) {
        if (this.valueOk && blur == this.lastBlur) {
            return this.value;
        }
        double x = this.linkFrom[0] == null ? this.point.t : this.linkFrom[0].getAverageValue(this.linkFromIndex[0], blur);
        double persistence = this.linkFrom[1] == null ? 0.5 : this.linkFrom[1].getAverageValue(this.linkFromIndex[1], blur);
        double xsize = this.linkFrom[0] == null ? blur : this.linkFrom[0].getValueError(this.linkFromIndex[0], blur);
        double amp = this.amplitude;
        double scale = 1.0;
        double cutoff = 0.5 / xsize;
        this.value = 0.0;
        int i = 0;
        while (i < this.octaves && cutoff > scale) {
            double x1;
            if (xsize == 0.0) {
                x1 = x * scale + 123.456;
                int base = (int)Math.floor(x1);
                this.calcCoefficients(base);
                this.value += amp * this.calcNoise(x1 - (double)base);
            } else {
                x1 = (x - xsize) * scale + 123.456;
                double x2 = (x + xsize) * scale + 123.456;
                int base1 = (int)Math.floor(x1);
                int base2 = (int)Math.floor(x2);
                this.calcCoefficients(base1);
                double integral = -this.calcNoiseIntegral(x1 - (double)base1);
                while (base1 < base2) {
                    integral += this.calcNoiseUnitIntegral();
                    this.calcCoefficients(++base1);
                }
                this.value += 0.5 * amp * (integral += this.calcNoiseIntegral(x2 - (double)base2)) / xsize;
            }
            amp *= persistence;
            scale *= 2.0;
            ++i;
        }
        this.value += 0.5;
        this.valueOk = true;
        this.lastBlur = blur;
        return this.value;
    }

    public double getValueError(int which, double blur) {
        if (!this.valueOk || blur != this.lastBlur) {
            this.getAverageValue(which, blur);
        }
        if (this.errorOk) {
            return this.error;
        }
        double x = this.linkFrom[0] == null ? this.point.t : this.linkFrom[0].getAverageValue(this.linkFromIndex[0], blur);
        double persistence = this.linkFrom[1] == null ? 0.5 : this.linkFrom[1].getAverageValue(this.linkFromIndex[1], blur);
        double xsize = this.linkFrom[0] == null ? blur : this.linkFrom[0].getValueError(this.linkFromIndex[0], blur);
        double amp = this.amplitude;
        double scale = 1.0;
        double cutoff = 0.5 / xsize;
        this.deriv = 0.0;
        this.error = 0.0;
        int i = 0;
        while (i < this.octaves && cutoff > scale) {
            double x1 = x * scale + 123.456;
            int base = (int)Math.floor(x1);
            this.calcCoefficients(base);
            this.deriv += amp * this.calcNoiseDeriv(x1 - (double)base);
            amp *= persistence;
            scale *= 2.0;
            ++i;
        }
        this.error = xsize * this.deriv;
        while (i < this.octaves) {
            this.error += amp;
            amp *= persistence;
            scale *= 2.0;
            ++i;
        }
        this.errorOk = true;
        return this.error;
    }

    public void getValueGradient(int which, Vec3 grad, double blur) {
        if (!this.errorOk || blur != this.lastBlur) {
            this.getValueError(which, blur);
        }
        if (this.gradOk && blur == this.lastBlur) {
            grad.set(this.gradient);
            return;
        }
        if (this.linkFrom[0] == null) {
            this.gradient.set(0.0, 0.0, 0.0);
            grad.set(0.0, 0.0, 0.0);
            this.gradOk = true;
            return;
        }
        this.lastBlur = blur;
        this.gradOk = true;
        this.linkFrom[0].getValueGradient(this.linkFromIndex[0], this.gradient, blur);
        this.gradient.scale(this.deriv);
        grad.set(this.gradient);
    }

    public Module duplicate() {
        RandomModule mod = new RandomModule(new Point(this.bounds.x, this.bounds.y));
        mod.octaves = this.octaves;
        mod.amplitude = this.amplitude;
        return mod;
    }

    public void writeToStream(DataOutputStream out, Scene theScene) throws IOException {
        out.writeInt(this.octaves);
        out.writeDouble(this.amplitude);
    }

    public void readFromStream(DataInputStream in, Scene theScene) throws IOException {
        this.octaves = in.readInt();
        this.amplitude = in.readDouble();
    }

    public boolean edit(Frame fr, Scene theScene) {
        ValueField octavesField = new ValueField((double)this.octaves, 7);
        ValueField ampField = new ValueField(this.amplitude, 0);
        ComponentsDialog dlg = new ComponentsDialog(fr, "Set properties for random function:", new Component[]{ampField, octavesField}, new String[]{"Amplitude", "Octaves"});
        if (!dlg.clickedOk()) {
            return false;
        }
        this.octaves = (int)octavesField.getValue();
        this.amplitude = ampField.getValue();
        return true;
    }
}

