/*
 * Decompiled with CFR 0.152.
 */
package artofillusion.ui;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.ScrollPane;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;

public class AutoScroller
implements MouseListener,
MouseMotionListener,
Runnable {
    protected Component target;
    protected ScrollPane sp;
    protected Thread scrollThread;
    protected int x;
    protected int y;
    protected int xinc;
    protected int yinc;
    protected int delay;

    public AutoScroller(Component scroll, ScrollPane pane, int xincrement, int yincrement) {
        this.xinc = xincrement;
        this.yinc = yincrement;
        this.target = scroll;
        this.sp = pane;
        this.target.addMouseListener(this);
        this.target.addMouseMotionListener(this);
        this.delay = 100;
    }

    public void mousePressed(MouseEvent ev) {
        this.x = ev.getX();
        this.y = ev.getY();
        this.scrollThread = new Thread(this);
        this.scrollThread.start();
    }

    public void mouseReleased(MouseEvent ev) {
        this.scrollThread.interrupt();
        this.scrollThread = null;
    }

    public void mouseClicked(MouseEvent ev) {
    }

    public void mouseEntered(MouseEvent ev) {
    }

    public void mouseExited(MouseEvent ev) {
    }

    public void mouseMoved(MouseEvent ev) {
    }

    public void mouseDragged(MouseEvent ev) {
        this.x = ev.getX();
        this.y = ev.getY();
    }

    public void run() {
        while (true) {
            Dimension scrollSize = this.sp.getViewportSize();
            Point scrollPos = this.sp.getScrollPosition();
            if (this.x < scrollPos.x || this.y < scrollPos.y || this.x > scrollPos.x + scrollSize.width || this.y > scrollPos.y + scrollSize.height) {
                this.scrollWhileDragging(scrollSize, scrollPos);
            }
            try {
                Thread.sleep(this.delay);
            }
            catch (InterruptedException ex) {
                return;
            }
        }
    }

    protected void scrollWhileDragging(Dimension scrollSize, Point scrollPos) {
        Point newPos = scrollPos;
        if (this.x < scrollPos.x) {
            newPos.x -= this.xinc;
        }
        if (this.y < scrollPos.y) {
            newPos.y -= this.yinc;
        }
        if (this.x > scrollPos.x + scrollSize.width) {
            newPos.x += this.xinc;
        }
        if (this.y > scrollPos.y + scrollSize.height) {
            newPos.y += this.yinc;
        }
        this.sp.setScrollPosition(newPos);
        this.x += newPos.x - scrollPos.x;
        this.y += newPos.y - scrollPos.y;
    }
}

