/*
 * Decompiled with CFR 0.152.
 */
package artofillusion.ui;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.image.ImageProducer;

public class ImageCanvas
extends Component {
    Image im;

    public ImageCanvas(String name) {
        ImageProducer ip;
        try {
            ip = (ImageProducer)this.getClass().getResource(name).getContent();
        }
        catch (Exception e) {
            System.out.println("Error loading image: " + name);
            return;
        }
        this.im = this.createImage(ip);
        MediaTracker mt = new MediaTracker(this);
        mt.addImage(this.im, 0);
        try {
            mt.waitForID(0);
        }
        catch (InterruptedException ex) {
            System.out.println("Error loading image: " + name);
        }
    }

    public void paint(Graphics g) {
        if (this.im != null) {
            g.drawImage(this.im, 0, 0, null);
        }
    }

    public Dimension getPreferredSize() {
        if (this.im == null) {
            return new Dimension(0, 0);
        }
        return new Dimension(this.im.getWidth(null), this.im.getHeight(null));
    }
}

