/*
 * Decompiled with CFR 0.152.
 */
package artofillusion.ui;

import artofillusion.ModellingApp;
import java.awt.Button;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Label;
import java.awt.Panel;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;

public class PanelDialog
extends Dialog
implements ActionListener,
KeyListener {
    boolean ok;

    public PanelDialog(Frame parent, String prompt, Panel thePanel) {
        super(parent, true);
        GridBagConstraints c = new GridBagConstraints();
        this.setLayout(new GridBagLayout());
        c.gridx = 0;
        this.add((Component)new Label(prompt), c);
        this.add((Component)thePanel, c);
        Panel p = new Panel();
        this.add((Component)p, c);
        Button b = new Button("OK");
        p.add(b);
        b.setActionCommand("ok");
        b.addActionListener(this);
        b = new Button("Cancel");
        p.add(b);
        b.setActionCommand("cancel");
        b.addActionListener(this);
        this.addAsListener(this);
        this.pack();
        this.setResizable(false);
        ModellingApp.centerWindow(this);
        this.show();
    }

    public boolean clickedOk() {
        return this.ok;
    }

    public Insets getInsets() {
        Insets in = super.getInsets();
        return new Insets(in.top + 10, in.left + 10, in.bottom + 10, in.right + 10);
    }

    public void actionPerformed(ActionEvent e) {
        String command = e.getActionCommand();
        this.ok = !command.equals("cancel");
        this.removeAsListener(this);
        this.dispose();
    }

    public void keyPressed(KeyEvent ev) {
        int code = ev.getKeyCode();
        if (code != 10 && code != 27) {
            return;
        }
        if (code == 10 && ev.getSource() instanceof Button) {
            return;
        }
        this.ok = code == 10;
        this.removeAsListener(this);
        this.dispose();
    }

    public void keyReleased(KeyEvent ev) {
    }

    public void keyTyped(KeyEvent ev) {
    }

    private void addAsListener(Component c) {
        c.addKeyListener(this);
        if (c instanceof Container) {
            Component[] children = ((Container)c).getComponents();
            int i = 0;
            while (i < children.length) {
                this.addAsListener(children[i]);
                ++i;
            }
        }
    }

    private void removeAsListener(Component c) {
        c.removeKeyListener(this);
        if (c instanceof Container) {
            Component[] children = ((Container)c).getComponents();
            int i = 0;
            while (i < children.length) {
                this.removeAsListener(children[i]);
                ++i;
            }
        }
    }
}

