/*
 * Decompiled with CFR 0.152.
 */
package artofillusion.ui;

import java.awt.AWTEventMulticaster;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Panel;
import java.awt.Scrollbar;
import java.awt.TextField;
import java.awt.event.ActionListener;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.awt.event.TextEvent;
import java.awt.event.TextListener;

public class ValueSlider
extends Panel
implements AdjustmentListener,
TextListener {
    TextField field;
    Scrollbar scroll;
    double value;
    double min;
    double max;
    int increments;
    AdjustmentListener listener = null;
    boolean forceInt;
    boolean vertical;
    Dimension prefSize;

    public ValueSlider(double min, double max, int increments, double value) {
        this.value = value;
        this.min = min;
        this.max = max;
        this.increments = increments;
        this.init(false);
    }

    public ValueSlider(double min, double max, int increments, double value, boolean vertical) {
        this.value = value;
        this.min = min;
        this.max = max;
        this.increments = increments;
        this.init(vertical);
    }

    void init(boolean vertical) {
        this.setLayout(new GridBagLayout());
        GridBagConstraints gc = new GridBagConstraints();
        if (vertical) {
            gc.gridy = 0;
            gc.gridx = 0;
            this.field = new TextField("", 5);
            this.add((Component)this.field, gc);
            gc.fill = 3;
            gc.gridx = 0;
            gc.gridy = 1;
            gc.gridheight = 0;
            gc.weighty = 1.0;
            this.scroll = new Scrollbar(1, (int)((this.value - this.min) * (double)this.increments / (this.max - this.min)), 1, 0, this.increments + 1);
            this.add((Component)this.scroll, gc);
        } else {
            gc.fill = 2;
            this.field = new TextField("", 5);
            this.add((Component)this.field, gc);
            gc.gridx = 1;
            gc.weightx = 1.0;
            this.scroll = new Scrollbar(0, (int)((this.value - this.min) * (double)this.increments / (this.max - this.min)), 1, 0, this.increments + 1);
            this.add((Component)this.scroll, gc);
        }
        this.setText();
        this.field.addTextListener(this);
        this.scroll.addAdjustmentListener(this);
        this.scroll.setEnabled(!Double.isNaN(this.value));
        this.vertical = vertical;
    }

    public void setForceInteger(boolean force) {
        this.forceInt = force;
    }

    public void adjustmentValueChanged(AdjustmentEvent e) {
        this.value = (double)e.getValue() * (this.max - this.min) / (double)this.increments + this.min;
        this.setText();
        this.field.setForeground(Color.black);
        if (this.listener != null) {
            this.listener.adjustmentValueChanged(e);
        }
    }

    public void textValueChanged(TextEvent e) {
        double val;
        try {
            val = new Double(this.field.getText());
        }
        catch (NumberFormatException ex) {
            this.field.setForeground(Color.red);
            return;
        }
        if (val < this.min || val > this.max) {
            this.field.setForeground(Color.red);
        } else if (this.forceInt && val != Math.floor(val)) {
            this.field.setForeground(Color.red);
        } else {
            this.value = val;
            this.field.setForeground(Color.black);
            this.scroll.setValue((int)((this.value - this.min) * (double)this.increments / (this.max - this.min)));
            this.scroll.setEnabled(true);
            if (this.listener != null) {
                this.listener.adjustmentValueChanged(new AdjustmentEvent(this.scroll, 601, 5, this.scroll.getValue()));
            }
        }
    }

    public double getValue() {
        return this.value;
    }

    public void setValue(double val) {
        this.scroll.setValue((int)((val - this.min) * (double)this.increments / (this.max - this.min)));
        this.value = val;
        this.setText();
    }

    private void setText() {
        String text;
        if (Double.isNaN(this.value)) {
            text = "";
        } else if (this.value == 0.0 || this.value == -0.0) {
            text = "0.0";
        } else {
            int digits = (int)Math.floor(Math.log(Math.abs(this.value)) / Math.log(10.0));
            double scale = Math.pow(10.0, digits < 0 ? (double)(2 - digits) : 3.0);
            text = Double.toString((double)Math.round(this.value * scale) / scale);
        }
        this.field.setText(text);
    }

    public void setEnabled(boolean enabled) {
        this.field.setEnabled(enabled);
        this.scroll.setEnabled(enabled && !Double.isNaN(this.value));
        super.setEnabled(enabled);
    }

    public void addActionListener(ActionListener l) {
        this.field.addActionListener(l);
    }

    public void removeActionListener(ActionListener l) {
        this.field.removeActionListener(l);
    }

    public void addAdjustmentListener(AdjustmentListener l) {
        this.listener = AWTEventMulticaster.add(this.listener, l);
    }

    public void removeAdjustmentListener(AdjustmentListener l) {
        this.listener = AWTEventMulticaster.remove(this.listener, l);
    }

    public Dimension getPreferredSize() {
        if (this.prefSize == null) {
            Dimension dim1 = this.field.getPreferredSize();
            Dimension dim2 = this.scroll.getPreferredSize();
            this.prefSize = this.vertical ? new Dimension(Math.max(dim1.width, dim2.width), dim1.height + dim2.height + this.increments) : new Dimension(dim1.width + dim2.width + this.increments, Math.max(dim1.height, dim2.height));
        }
        return new Dimension(this.prefSize.width, this.prefSize.height);
    }
}

