/*
 * Decompiled with CFR 0.152.
 */
package artofillusion.tools;

import artofillusion.EditingWindow;
import artofillusion.Object3D;
import artofillusion.ObjectPreviewCanvas;
import artofillusion.Scene;
import artofillusion.TriangleMesh;
import artofillusion.tools.CSGModeller;
import artofillusion.tools.CSGObject;
import java.awt.Button;
import java.awt.Choice;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Label;
import java.awt.Panel;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;

public class CSGDialog
extends Dialog
implements ActionListener,
ItemListener {
    CSGObject theObject;
    CSGModeller modeller;
    Choice opChoice;
    Button okButton;
    Button cancelButton;
    ObjectPreviewCanvas preview;
    int[] operation;
    boolean ok;
    private static int counter = 1;

    public CSGDialog(EditingWindow window, CSGObject obj) {
        super((Frame)window, "Boolean", true);
        this.theObject = obj;
        Scene scene = window.getScene();
        this.setLayout(new GridBagLayout());
        GridBagConstraints gc = new GridBagConstraints();
        gc.anchor = 17;
        gc.gridx = 0;
        this.add((Component)new Label("Operation:"), gc);
        this.opChoice = new Choice();
        this.add((Component)this.opChoice, gc);
        int i = 0;
        this.operation = new int[4];
        if (obj.obj1.object.isClosed() && obj.obj2.object.isClosed()) {
            this.opChoice.add("Union");
            this.operation[i++] = 0;
        }
        this.opChoice.add("Intersection");
        this.operation[i++] = 1;
        if (obj.obj2.object.isClosed()) {
            this.opChoice.add("First - Second");
            this.operation[i++] = 2;
        }
        if (obj.obj1.object.isClosed()) {
            this.opChoice.add("Second - First");
            this.operation[i++] = 3;
        }
        int j = 0;
        while (j < i) {
            if (obj.operation == this.operation[j]) {
                this.opChoice.select(j);
            }
            ++j;
        }
        this.opChoice.addItemListener(this);
        gc.gridx = 0;
        gc.fill = 1;
        gc.weighty = 1.0;
        gc.weightx = 1.0;
        this.preview = new ObjectPreviewCanvas(null);
        this.add((Component)this.preview, gc);
        this.preview.setPreferredSize(200, 200);
        gc.gridwidth = 2;
        gc.weighty = 0.0;
        gc.weightx = 0.0;
        Panel p = new Panel();
        this.okButton = new Button("OK");
        p.add(this.okButton);
        this.okButton.addActionListener(this);
        this.cancelButton = new Button("Cancel");
        p.add(this.cancelButton);
        this.cancelButton.addActionListener(this);
        this.add((Component)p, gc);
        this.makePreview();
        this.pack();
        this.show();
    }

    public void itemStateChanged(ItemEvent e) {
        this.makePreview();
    }

    public void actionPerformed(ActionEvent e) {
        if (this.okButton == e.getSource()) {
            this.theObject.operation = this.operation[this.opChoice.getSelectedIndex()];
            this.ok = true;
        }
        this.dispose();
    }

    private void makePreview() {
        if (this.modeller == null) {
            TriangleMesh mesh1 = this.theObject.obj1.object.convertToTriangleMesh(0.05);
            TriangleMesh mesh2 = this.theObject.obj2.object.convertToTriangleMesh(0.05);
            this.modeller = new CSGModeller(mesh1, mesh2, this.theObject.obj1.coords, this.theObject.obj2.coords);
        }
        this.preview.setObject((Object3D)this.modeller.getMesh(this.operation[this.opChoice.getSelectedIndex()]));
        this.preview.updateImage();
        this.preview.repaint();
    }

    public boolean clickedOk() {
        return this.ok;
    }
}

