/*
 * Decompiled with CFR 0.152.
 */
package artofillusion.tools;

import artofillusion.BoundingBox;
import artofillusion.Callback;
import artofillusion.Camera;
import artofillusion.CoordinateSystem;
import artofillusion.DirectionalLight;
import artofillusion.EditingTool;
import artofillusion.EditingWindow;
import artofillusion.Mat4;
import artofillusion.ModellingApp;
import artofillusion.MoveObjectTool;
import artofillusion.MoveViewTool;
import artofillusion.Object3D;
import artofillusion.ObjectInfo;
import artofillusion.RGBColor;
import artofillusion.RenderingDialog;
import artofillusion.RotateObjectTool;
import artofillusion.RotateViewTool;
import artofillusion.ScaleObjectTool;
import artofillusion.Scene;
import artofillusion.SceneViewer;
import artofillusion.ToolPalette;
import artofillusion.TransformDialog;
import artofillusion.TriangleMesh;
import artofillusion.UndoRecord;
import artofillusion.Vec3;
import artofillusion.ViewerCanvas;
import artofillusion.tools.CSGDialog;
import artofillusion.tools.CSGObject;
import artofillusion.ui.ComponentsDialog;
import artofillusion.ui.EntriesDialog;
import artofillusion.ui.MessageDialog;
import artofillusion.ui.ValueField;
import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.CheckboxMenuItem;
import java.awt.Choice;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Label;
import java.awt.Menu;
import java.awt.MenuBar;
import java.awt.MenuItem;
import java.awt.MenuShortcut;
import java.awt.Panel;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.util.Vector;

public class CSGEditorWindow
extends Frame
implements EditingWindow,
KeyListener,
ActionListener,
ItemListener {
    EditingWindow parentWindow;
    SceneViewer theView;
    EditingTool defaultTool;
    EditingTool currentTool;
    Label helpText;
    CSGObject oldObject;
    CSGObject theObject;
    UndoRecord undo;
    ToolPalette tools;
    MenuBar menubar;
    Menu editMenu;
    Menu objectMenu;
    MenuItem undoItem;
    MenuItem[] objectMenuItem;
    CheckboxMenuItem[] displayItem;
    Scene theScene;
    Callback onClose;

    public CSGEditorWindow(EditingWindow parent, String title, CSGObject obj, Callback onClose) {
        super(title);
        this.parentWindow = parent;
        this.oldObject = obj;
        this.theObject = (CSGObject)obj.duplicate();
        this.onClose = onClose;
        this.theScene = new Scene();
        this.theScene.addObject(obj.obj1.object.duplicate(), obj.obj1.coords.duplicate(), obj.obj1.name, null);
        this.theScene.addObject(obj.obj2.object.duplicate(), obj.obj2.coords.duplicate(), obj.obj2.name, null);
        this.helpText = new Label();
        this.add((Component)this.helpText, "South");
        Panel p1 = new Panel();
        this.add((Component)p1, "Center");
        p1.setLayout(new BorderLayout());
        Panel p2 = new Panel();
        p1.add((Component)p2, "North");
        p2.setLayout(new BorderLayout());
        Panel p3 = new Panel();
        p2.add((Component)p3, "West");
        this.theView = new SceneViewer(this.theScene, p3, (EditingWindow)this);
        p1.add((Component)this.theView, "Center");
        p3 = new Panel();
        p2.add((Component)p3, "East");
        Button btn = new Button("OK");
        p3.add(btn);
        btn.setActionCommand("ok");
        btn.addActionListener(this);
        btn = new Button("Cancel");
        p3.add(btn);
        btn.setActionCommand("cancel");
        btn.addActionListener(this);
        Panel p4 = new Panel();
        this.add((Component)p4, "West");
        p4.setLayout(new BorderLayout());
        this.tools = new ToolPalette(1, 5);
        p4.add((Component)this.tools, "North");
        this.defaultTool = new MoveObjectTool((EditingWindow)this);
        this.tools.addTool(this.defaultTool);
        this.tools.addTool((EditingTool)new RotateObjectTool((EditingWindow)this));
        this.tools.addTool((EditingTool)new ScaleObjectTool((EditingWindow)this));
        this.tools.addTool((EditingTool)new MoveViewTool((EditingWindow)this));
        this.tools.addTool((EditingTool)new RotateViewTool((EditingWindow)this));
        this.tools.selectTool(this.defaultTool);
        this.helpText.setBackground(ModellingApp.APP_BACKGROUND_COLOR);
        p2.setBackground(ModellingApp.APP_BACKGROUND_COLOR);
        p3.setBackground(ModellingApp.APP_BACKGROUND_COLOR);
        p4.setBackground(ModellingApp.APP_BACKGROUND_COLOR);
        this.menubar = new MenuBar();
        this.setMenuBar(this.menubar);
        this.createEditMenu();
        this.createObjectMenu();
        this.recursivelyAddListeners(this);
        this.pack();
        Dimension d1 = Toolkit.getDefaultToolkit().getScreenSize();
        Dimension d2 = new Dimension(d1.width * 2 / 3, d1.height * 2 / 3);
        ((Component)this).setSize(d2);
        ((Component)this).setLocation((d1.width - d2.width) / 2, (d1.height - d2.height) / 2);
        this.updateMenus();
        this.show();
    }

    void createEditMenu() {
        this.editMenu = new Menu("Edit");
        this.menubar.add(this.editMenu);
        this.undoItem = new MenuItem("Undo", new MenuShortcut(90));
        this.editMenu.add(this.undoItem);
        this.undoItem.setActionCommand("undo");
        this.undoItem.addActionListener(this);
        this.undoItem.setEnabled(false);
        this.editMenu.addSeparator();
        MenuItem item = new MenuItem("Select All", new MenuShortcut(65));
        this.editMenu.add(item);
        item.setActionCommand("selectAll");
        item.addActionListener(this);
        item = new MenuItem("Properties...", new MenuShortcut(80));
        this.editMenu.add(item);
        item.setActionCommand("properties");
        item.addActionListener(this);
    }

    void createObjectMenu() {
        this.objectMenu = new Menu("Object");
        this.menubar.add(this.objectMenu);
        this.objectMenuItem = new MenuItem[5];
        this.objectMenuItem[0] = new MenuItem("Edit Object...", new MenuShortcut(69));
        this.objectMenu.add(this.objectMenuItem[0]);
        this.objectMenuItem[0].setActionCommand("editObject");
        this.objectMenuItem[0].addActionListener(this);
        this.objectMenuItem[1] = new MenuItem("Object Layout...", new MenuShortcut(76));
        this.objectMenu.add(this.objectMenuItem[1]);
        this.objectMenuItem[1].setActionCommand("objectLayout");
        this.objectMenuItem[1].addActionListener(this);
        this.objectMenuItem[2] = new MenuItem("Transform Object...", new MenuShortcut(84));
        this.objectMenu.add(this.objectMenuItem[2]);
        this.objectMenuItem[2].setActionCommand("transformObject");
        this.objectMenuItem[2].addActionListener(this);
        this.objectMenuItem[3] = new MenuItem("Align Objects...");
        this.objectMenu.add(this.objectMenuItem[3]);
        this.objectMenuItem[3].setActionCommand("alignObjects");
        this.objectMenuItem[3].addActionListener(this);
        MenuItem item = new MenuItem("Center Objects");
        this.objectMenu.add(item);
        item.setActionCommand("centerObjects");
        item.addActionListener(this);
        this.objectMenuItem[4] = new MenuItem("Convert to Triangle Mesh...");
        this.objectMenu.add(this.objectMenuItem[4]);
        this.objectMenuItem[4].setActionCommand("convertToTriangle");
        this.objectMenuItem[4].addActionListener(this);
        this.objectMenu.addSeparator();
        if (ModellingApp.previewRenderer() != null) {
            item = new MenuItem("Render Preview...", new MenuShortcut(82));
            this.objectMenu.add(item);
            item.setActionCommand("render");
            item.addActionListener(this);
        }
        Menu displayMenu = new Menu("Display Mode");
        this.objectMenu.add(displayMenu);
        this.displayItem = new CheckboxMenuItem[3];
        this.displayItem[0] = new CheckboxMenuItem("Wireframe", this.theView.getRenderMode() == 0);
        displayMenu.add(this.displayItem[0]);
        this.displayItem[0].addItemListener(this);
        this.displayItem[1] = new CheckboxMenuItem("Shaded", this.theView.getRenderMode() == 1);
        displayMenu.add(this.displayItem[1]);
        this.displayItem[1].addItemListener(this);
        this.displayItem[2] = new CheckboxMenuItem("Smooth", this.theView.getRenderMode() == 2);
        displayMenu.add(this.displayItem[2]);
        this.displayItem[2].addItemListener(this);
    }

    void recursivelyAddListeners(Component c) {
        c.addKeyListener(this);
        if (c instanceof Container) {
            Component[] children = ((Container)c).getComponents();
            int i = 0;
            while (i < children.length) {
                this.recursivelyAddListeners(children[i]);
                ++i;
            }
        }
    }

    public boolean confirmClose() {
        return true;
    }

    public void setTool(EditingTool tool) {
        this.theView.setTool(tool);
        this.currentTool = tool;
    }

    public void setHelpText(String text) {
        this.helpText.setText(text);
    }

    public Frame getFrame() {
        return this;
    }

    public void updateImage() {
        this.theView.updateImage();
        this.theView.repaint();
    }

    public void updateMenus() {
        int[] selected = this.theScene.getSelection();
        this.objectMenuItem[0].setEnabled(selected.length == 1);
        this.objectMenuItem[1].setEnabled(selected.length > 0);
        this.objectMenuItem[2].setEnabled(selected.length > 0);
        this.objectMenuItem[3].setEnabled(selected.length > 0);
        this.objectMenuItem[4].setEnabled(selected.length == 1);
    }

    public void setUndoRecord(UndoRecord command) {
        this.undo = command;
        this.undoItem.setEnabled(true);
        if (this.undo.isRedo()) {
            this.undoItem.setLabel("Redo");
        } else {
            this.undoItem.setLabel("Undo");
        }
        this.updateMenus();
    }

    public Scene getScene() {
        return this.theScene;
    }

    public void keyPressed(KeyEvent e) {
        this.currentTool.keyPressed(e, (ViewerCanvas)this.theView);
    }

    public void keyReleased(KeyEvent e) {
    }

    public void keyTyped(KeyEvent e) {
    }

    public void actionPerformed(ActionEvent e) {
        String command = e.getActionCommand();
        this.setCursor(Cursor.getPredefinedCursor(3));
        if (command.equals("ok")) {
            this.updateFromScene();
            this.oldObject.copyObject(this.theObject);
            this.theObject = null;
            this.oldObject = null;
            this.theScene = null;
            this.dispose();
            this.onClose.execute();
            this.parentWindow.updateImage();
            this.parentWindow.updateMenus();
        } else if (command.equals("cancel")) {
            this.theObject = null;
            this.oldObject = null;
            this.theScene = null;
            this.dispose();
        } else if (command.equals("undo")) {
            this.undoCommand();
        } else if (command.equals("selectAll")) {
            this.selectAllCommand();
        } else if (command.equals("properties")) {
            this.propertiesCommand();
        } else if (command.equals("editObject")) {
            this.editObjectCommand();
        } else if (command.equals("objectLayout")) {
            this.objectLayoutCommand();
        } else if (command.equals("transformObject")) {
            this.transformObjectCommand();
        } else if (command.equals("alignObjects")) {
            this.alignObjectsCommand();
        } else if (command.equals("centerObjects")) {
            this.centerObjectsCommand();
        } else if (command.equals("convertToTriangle")) {
            this.convertToTriangleCommand();
        } else if (command.equals("render")) {
            this.renderPreviewCommand();
        }
        this.setCursor(Cursor.getDefaultCursor());
    }

    public void itemStateChanged(ItemEvent e) {
        Object source = e.getSource();
        int i = 0;
        while (i < this.displayItem.length) {
            this.displayItem[i].setState(source == this.displayItem[i]);
            ++i;
        }
        if (source == this.displayItem[0]) {
            this.theView.setRenderMode(0);
        } else if (source == this.displayItem[1]) {
            this.theView.setRenderMode(1);
        } else if (source == this.displayItem[2]) {
            this.theView.setRenderMode(2);
        }
        this.updateImage();
    }

    private void updateFromScene() {
        Vector obj = this.theScene.getObjects();
        this.theObject.setComponentObjects((ObjectInfo)obj.elementAt(0), (ObjectInfo)obj.elementAt(1));
    }

    void undoCommand() {
        if (this.undo == null) {
            return;
        }
        this.setUndoRecord(this.undo.execute());
        this.updateImage();
        this.updateMenus();
    }

    void selectAllCommand() {
        this.theScene.setSelection(new int[]{0, 1});
    }

    void propertiesCommand() {
        this.updateFromScene();
        CSGDialog cSGDialog = new CSGDialog(this, this.theObject);
    }

    void editObjectCommand() {
        int[] sel = this.theScene.getSelection();
        Vector objects = this.theScene.getObjects();
        if (sel.length != 1) {
            return;
        }
        Object3D obj = ((ObjectInfo)objects.elementAt((int)sel[0])).object;
        if (obj.editable()) {
            this.setUndoRecord(new UndoRecord((EditingWindow)this, false, 0, new Object[]{obj, obj.duplicate()}));
            obj.edit((EditingWindow)this, (ObjectInfo)objects.elementAt(sel[0]), null);
        }
    }

    void objectLayoutCommand() {
        int[] sel = this.theScene.getSelection();
        Vector objects = this.theScene.getObjects();
        Object3D[] obj = new Object3D[sel.length];
        CoordinateSystem[] coords = new CoordinateSystem[sel.length];
        if (sel.length == 0) {
            return;
        }
        this.setUndoRecord(new UndoRecord((EditingWindow)this, false));
        int i = 0;
        while (i < sel.length) {
            obj[i] = ((ObjectInfo)objects.elementAt((int)sel[i])).object;
            coords[i] = ((ObjectInfo)objects.elementAt((int)sel[i])).coords;
            this.undo.addCommand(0, new Object[]{obj[i], obj[i].duplicate()});
            this.undo.addCommand(1, new Object[]{coords[i], coords[i].duplicate()});
            ++i;
        }
        if (sel.length == 1) {
            Vec3 orig = coords[0].getOrigin();
            double[] angles = coords[0].getRotationAngles();
            Vec3 size = obj[0].getBounds().getSize();
            TransformDialog dlg = new TransformDialog((Frame)this, "Layout for '" + ((ObjectInfo)objects.elementAt((int)sel[0])).name + "'", new double[]{orig.x, orig.y, orig.z, angles[0], angles[1], angles[2], size.x, size.y, size.z}, false, false);
            double[] values = dlg.getValues();
            if (!Double.isNaN(values[0])) {
                orig.x = values[0];
            }
            if (!Double.isNaN(values[1])) {
                orig.y = values[1];
            }
            if (!Double.isNaN(values[2])) {
                orig.z = values[2];
            }
            if (!Double.isNaN(values[3])) {
                angles[0] = values[3];
            }
            if (!Double.isNaN(values[4])) {
                angles[1] = values[4];
            }
            if (!Double.isNaN(values[5])) {
                angles[2] = values[5];
            }
            if (!Double.isNaN(values[6])) {
                size.x = values[6];
            }
            if (!Double.isNaN(values[7])) {
                size.y = values[7];
            }
            if (!Double.isNaN(values[8])) {
                size.z = values[8];
            }
            coords[0].setOrigin(orig);
            coords[0].setOrientation(angles[0], angles[1], angles[2]);
            obj[0].setSize(size.x, size.y, size.z);
        } else {
            TransformDialog dlg = new TransformDialog((Frame)this, "Layout for Selected Objects", false, false);
            double[] values = dlg.getValues();
            i = 0;
            while (i < sel.length) {
                Vec3 orig = coords[i].getOrigin();
                double[] angles = coords[i].getRotationAngles();
                Vec3 size = obj[i].getBounds().getSize();
                if (!Double.isNaN(values[0])) {
                    orig.x = values[0];
                }
                if (!Double.isNaN(values[1])) {
                    orig.y = values[1];
                }
                if (!Double.isNaN(values[2])) {
                    orig.z = values[2];
                }
                if (!Double.isNaN(values[3])) {
                    angles[0] = values[3];
                }
                if (!Double.isNaN(values[4])) {
                    angles[1] = values[4];
                }
                if (!Double.isNaN(values[5])) {
                    angles[2] = values[5];
                }
                if (!Double.isNaN(values[6])) {
                    size.x = values[6];
                }
                if (!Double.isNaN(values[7])) {
                    size.y = values[7];
                }
                if (!Double.isNaN(values[8])) {
                    size.z = values[8];
                }
                coords[i].setOrigin(orig);
                coords[i].setOrientation(angles[0], angles[1], angles[2]);
                obj[i].setSize(size.x, size.y, size.z);
                ++i;
            }
        }
        this.updateImage();
    }

    void transformObjectCommand() {
        int[] sel = this.theScene.getSelection();
        Vector objects = this.theScene.getObjects();
        if (sel.length == 0) {
            return;
        }
        TransformDialog dlg = sel.length == 1 ? new TransformDialog((Frame)this, "Transform '" + ((ObjectInfo)objects.elementAt((int)sel[0])).name + "'", new double[]{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 1.0, 1.0}, true, true) : new TransformDialog((Frame)this, "Transform Selected Objects", new double[]{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 1.0, 1.0}, true, true);
        double[] values = dlg.getValues();
        this.setUndoRecord(new UndoRecord((EditingWindow)this, false));
        int i = 0;
        while (i < sel.length) {
            Object3D obj = ((ObjectInfo)objects.elementAt((int)sel[i])).object;
            CoordinateSystem coords = ((ObjectInfo)objects.elementAt((int)sel[i])).coords;
            this.undo.addCommand(0, new Object[]{obj, obj.duplicate()});
            this.undo.addCommand(1, new Object[]{coords, coords.duplicate()});
            Vec3 orig = coords.getOrigin();
            Vec3 size = obj.getBounds().getSize();
            if (!Double.isNaN(values[0])) {
                orig.x += values[0];
            }
            if (!Double.isNaN(values[1])) {
                orig.y += values[1];
            }
            if (!Double.isNaN(values[2])) {
                orig.z += values[2];
            }
            Mat4 m = Mat4.identity();
            if (!Double.isNaN(values[3])) {
                m = m.times(Mat4.xrotation((double)(values[3] * Math.PI / 180.0)));
            }
            if (!Double.isNaN(values[4])) {
                m = m.times(Mat4.yrotation((double)(values[4] * Math.PI / 180.0)));
            }
            if (!Double.isNaN(values[5])) {
                m = m.times(Mat4.zrotation((double)(values[5] * Math.PI / 180.0)));
            }
            if (!Double.isNaN(values[6])) {
                size.x *= values[6];
            }
            if (!Double.isNaN(values[7])) {
                size.y *= values[7];
            }
            if (!Double.isNaN(values[8])) {
                size.z *= values[8];
            }
            coords.setOrigin(orig);
            coords.transformAxes(m);
            obj.setSize(size.x, size.y, size.z);
            ++i;
        }
        this.updateImage();
    }

    void alignObjectsCommand() {
        Vec3 orig;
        Vec3 center;
        BoundingBox bounds;
        CoordinateSystem coords;
        Object3D obj;
        int[] sel = this.theScene.getSelection();
        Vector objects = this.theScene.getObjects();
        Panel px = new Panel();
        Panel py = new Panel();
        Panel pz = new Panel();
        if (sel.length == 0) {
            return;
        }
        Choice xchoice = new Choice();
        px.add(xchoice);
        xchoice.add("Do not align");
        xchoice.add("Right");
        xchoice.add("Center");
        xchoice.add("Left");
        xchoice.add("Origin");
        px.add(new Label("align to"));
        ValueField vfx = new ValueField(Double.NaN, 0, 5);
        px.add((Component)vfx);
        Choice ychoice = new Choice();
        py.add(ychoice);
        ychoice.add("Do not align");
        ychoice.add("Top");
        ychoice.add("Center");
        ychoice.add("Bottom");
        ychoice.add("Origin");
        py.add(new Label("align to"));
        ValueField vfy = new ValueField(Double.NaN, 0, 5);
        py.add((Component)vfy);
        Choice zchoice = new Choice();
        pz.add(zchoice);
        zchoice.add("Do not align");
        zchoice.add("Front");
        zchoice.add("Center");
        zchoice.add("Back");
        zchoice.add("Origin");
        pz.add(new Label("align to"));
        ValueField vfz = new ValueField(Double.NaN, 0, 5);
        pz.add((Component)vfz);
        ComponentsDialog dlg = new ComponentsDialog((Frame)this, "Align to which point:", new Component[]{px, py, pz}, new String[]{"X", "Y", "Z"});
        if (!dlg.clickedOk()) {
            return;
        }
        this.setUndoRecord(new UndoRecord((EditingWindow)this, false));
        Vec3 alignTo = new Vec3();
        int i = 0;
        while (i < sel.length) {
            obj = ((ObjectInfo)objects.elementAt((int)sel[i])).object;
            coords = ((ObjectInfo)objects.elementAt((int)sel[i])).coords;
            bounds = obj.getBounds();
            bounds = bounds.transformAndOutset(coords.fromLocal());
            center = bounds.getCenter();
            orig = coords.getOrigin();
            if (!Double.isNaN(vfx.getValue())) {
                alignTo.x += vfx.getValue();
            } else if (xchoice.getSelectedIndex() == 1) {
                alignTo.x += bounds.maxx;
            } else if (xchoice.getSelectedIndex() == 2) {
                alignTo.x += center.x;
            } else if (xchoice.getSelectedIndex() == 3) {
                alignTo.x += bounds.minx;
            } else if (xchoice.getSelectedIndex() == 4) {
                alignTo.x += orig.x;
            }
            if (!Double.isNaN(vfy.getValue())) {
                alignTo.y += vfy.getValue();
            } else if (ychoice.getSelectedIndex() == 1) {
                alignTo.y += bounds.maxy;
            } else if (ychoice.getSelectedIndex() == 2) {
                alignTo.y += center.y;
            } else if (ychoice.getSelectedIndex() == 3) {
                alignTo.y += bounds.miny;
            } else if (ychoice.getSelectedIndex() == 4) {
                alignTo.y += orig.y;
            }
            if (!Double.isNaN(vfz.getValue())) {
                alignTo.z += vfz.getValue();
            } else if (zchoice.getSelectedIndex() == 1) {
                alignTo.z += bounds.maxz;
            } else if (zchoice.getSelectedIndex() == 2) {
                alignTo.z += center.z;
            } else if (zchoice.getSelectedIndex() == 3) {
                alignTo.z += bounds.minz;
            } else if (zchoice.getSelectedIndex() == 4) {
                alignTo.z += orig.z;
            }
            ++i;
        }
        alignTo.scale(1.0 / (double)sel.length);
        i = 0;
        while (i < sel.length) {
            obj = ((ObjectInfo)objects.elementAt((int)sel[i])).object;
            coords = ((ObjectInfo)objects.elementAt((int)sel[i])).coords;
            bounds = obj.getBounds();
            bounds = bounds.transformAndOutset(coords.fromLocal());
            center = bounds.getCenter();
            orig = coords.getOrigin();
            this.undo.addCommand(1, new Object[]{coords, coords.duplicate()});
            if (xchoice.getSelectedIndex() == 1) {
                orig.x += alignTo.x - bounds.maxx;
            } else if (xchoice.getSelectedIndex() == 2) {
                orig.x += alignTo.x - center.x;
            } else if (xchoice.getSelectedIndex() == 3) {
                orig.x += alignTo.x - bounds.minx;
            } else if (xchoice.getSelectedIndex() == 4) {
                orig.x += alignTo.x - orig.x;
            }
            if (ychoice.getSelectedIndex() == 1) {
                orig.y += alignTo.y - bounds.maxy;
            } else if (ychoice.getSelectedIndex() == 2) {
                orig.y += alignTo.y - center.y;
            } else if (ychoice.getSelectedIndex() == 3) {
                orig.y += alignTo.y - bounds.miny;
            } else if (ychoice.getSelectedIndex() == 4) {
                orig.y += alignTo.y - orig.y;
            }
            if (zchoice.getSelectedIndex() == 1) {
                orig.z += alignTo.z - bounds.maxz;
            } else if (zchoice.getSelectedIndex() == 2) {
                orig.z += alignTo.z - center.z;
            } else if (zchoice.getSelectedIndex() == 3) {
                orig.z += alignTo.z - bounds.minz;
            } else if (zchoice.getSelectedIndex() == 4) {
                orig.z += alignTo.z - orig.z;
            }
            coords.setOrigin(orig);
            ++i;
        }
        this.updateImage();
    }

    void centerObjectsCommand() {
        Vector objects = this.theScene.getObjects();
        BoundingBox bounds = null;
        int i = 0;
        while (i < objects.size()) {
            ObjectInfo info = (ObjectInfo)objects.elementAt(i);
            BoundingBox b = info.object.getBounds().transformAndOutset(info.coords.fromLocal());
            bounds = bounds == null ? b : bounds.merge(b);
            ++i;
        }
        Vec3 center = bounds.getCenter();
        this.setUndoRecord(new UndoRecord((EditingWindow)this, false));
        int i2 = 0;
        while (i2 < objects.size()) {
            ObjectInfo info = (ObjectInfo)objects.elementAt(i2);
            this.undo.addCommand(1, new Object[]{info.coords, info.coords.duplicate()});
            info.coords.setOrigin(info.coords.getOrigin().minus(center));
            ++i2;
        }
        this.updateImage();
    }

    void convertToTriangleCommand() {
        TriangleMesh mesh;
        int[] sel = this.theScene.getSelection();
        Vector objects = this.theScene.getObjects();
        if (sel.length != 1) {
            return;
        }
        ObjectInfo info = (ObjectInfo)objects.elementAt(sel[0]);
        Object3D obj = info.object;
        if (obj.canConvertToTriangleMesh() == 0) {
            return;
        }
        this.setUndoRecord(new UndoRecord((EditingWindow)this, false, 2, new Object[]{info, info.duplicate()}));
        if (obj.canConvertToTriangleMesh() == 1) {
            mesh = obj.convertToTriangleMesh(0.0);
        } else {
            double tol;
            EntriesDialog dlg = new EntriesDialog((Frame)this, "Specify tolerance for triangle mesh:", new String[]{"Max Error"}, new String[]{"0.1"});
            String[] val = dlg.getEntries();
            if (val == null) {
                return;
            }
            try {
                tol = Double.valueOf(val[0]);
            }
            catch (NumberFormatException ex) {
                new MessageDialog((Frame)this, "Illegal entry for error tolerance.");
                return;
            }
            if (tol < 0.0) {
                new MessageDialog((Frame)this, "Error tolerance cannot be negative.");
                return;
            }
            mesh = obj.convertToTriangleMesh(tol);
        }
        if (mesh == null) {
            new MessageDialog((Frame)this, "Unable to triangulate object.");
            return;
        }
        mesh.setTexture(obj.getTexture());
        mesh.setTextureMapping(obj.getTextureMapping());
        mesh.setMaterial(obj.getMaterial());
        mesh.setMaterialMapping(obj.getMaterialMapping());
        ((ObjectInfo)objects.elementAt((int)sel[0])).object = mesh;
        this.theView.updateImage();
        this.updateMenus();
    }

    public void renderPreviewCommand() {
        Scene sc = new Scene();
        Camera theCamera = this.theView.getCamera();
        Container parent = this;
        double dist = theCamera.getDistToScreen();
        this.updateFromScene();
        sc.addObject((Object3D)new DirectionalLight(new RGBColor(1.0f, 1.0f, 1.0f), 0.8f), theCamera.getCameraCoordinates(), "", null);
        sc.addObject((Object3D)this.theObject, new CoordinateSystem(new Vec3(), Vec3.vz(), Vec3.vy()), "", null);
        while (!(parent instanceof Frame)) {
            parent = parent.getParent();
        }
        this.theView.adjustCamera(true);
        ModellingApp.previewRenderer().configurePreview();
        new RenderingDialog((Frame)parent, ModellingApp.previewRenderer(), sc, theCamera, dist / 2.0, dist);
    }
}

