/*
 * Decompiled with CFR 0.152.
 */
package artofillusion.tools;

import artofillusion.CoordinateSystem;
import artofillusion.EditingWindow;
import artofillusion.LayoutWindow;
import artofillusion.ModellingTool;
import artofillusion.Object3D;
import artofillusion.ObjectInfo;
import artofillusion.Scene;
import artofillusion.TriangleMesh;
import artofillusion.UndoRecord;
import artofillusion.Vec3;
import artofillusion.animation.PositionTrack;
import artofillusion.animation.RotationTrack;
import artofillusion.animation.Track;
import artofillusion.tools.CSGDialog;
import artofillusion.tools.CSGObject;
import artofillusion.ui.MessageDialog;
import java.awt.Frame;
import java.util.Vector;

public class CSGTool
implements ModellingTool {
    private static int counter = 1;

    public String getName() {
        return "Boolean Modelling...";
    }

    public void commandSelected(LayoutWindow window) {
        Scene scene = window.getScene();
        int[] selection = scene.getSelection();
        int closedCount = 0;
        Vector objects = scene.getObjects();
        Vector<ObjectInfo> inputObj = new Vector<ObjectInfo>();
        int i = 0;
        while (i < selection.length) {
            ObjectInfo obj = (ObjectInfo)objects.elementAt(selection[i]);
            if (obj.object.canSetMaterial() && (obj.object instanceof TriangleMesh || obj.object.canConvertToTriangleMesh() != 0)) {
                inputObj.addElement(obj);
                if (obj.object.isClosed()) {
                    ++closedCount;
                }
            }
            ++i;
        }
        if (inputObj.size() < 2 || closedCount < 1) {
            new MessageDialog((Frame)window, new String[]{"You must select two objects for boolean modelling,", "at least one of which must be solid."});
            return;
        }
        CSGObject newobj = new CSGObject((ObjectInfo)inputObj.elementAt(0), (ObjectInfo)inputObj.elementAt(1), 0);
        Vec3 center = newobj.centerObjects();
        newobj.setTexture(scene.getDefaultTexture());
        newobj.setTextureMapping(newobj.getTexture().getDefaultMapping());
        CSGDialog dial = new CSGDialog((EditingWindow)window, newobj);
        if (!dial.clickedOk()) {
            return;
        }
        ObjectInfo info = new ObjectInfo((Object3D)newobj, new CoordinateSystem(center, Vec3.vz(), Vec3.vy()), "Boolean " + counter++);
        info.addTrack((Track)new PositionTrack(info), 0);
        info.addTrack((Track)new RotationTrack(info), 1);
        window.addObject(info, null);
        Vector obj = window.getScene().getObjects();
        window.setSelection(obj.size() - 1);
        window.setUndoRecord(new UndoRecord((EditingWindow)window, false, 5, new Object[]{new Integer(obj.size() - 1)}));
        window.updateImage();
    }
}

