/*
 * Decompiled with CFR 0.152.
 */
package artofillusion.tools;

import artofillusion.CoordinateSystem;
import artofillusion.Curve;
import artofillusion.EditingWindow;
import artofillusion.LayoutWindow;
import artofillusion.Mat4;
import artofillusion.MeshVertex;
import artofillusion.Object3D;
import artofillusion.ObjectInfo;
import artofillusion.ObjectPreviewCanvas;
import artofillusion.Scene;
import artofillusion.SplineMesh;
import artofillusion.TriangleMesh;
import artofillusion.UndoRecord;
import artofillusion.Vec3;
import artofillusion.ui.ValueField;
import java.awt.Button;
import java.awt.Checkbox;
import java.awt.CheckboxGroup;
import java.awt.Choice;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Label;
import java.awt.Panel;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.TextEvent;
import java.awt.event.TextListener;
import java.util.Vector;

public class ExtrudeDialog
extends Dialog
implements ActionListener,
ItemListener,
TextListener {
    LayoutWindow window;
    Choice objChoice;
    Choice pathChoice;
    CheckboxGroup pathGroup;
    Checkbox pathBox;
    Checkbox xBox;
    Checkbox yBox;
    Checkbox zBox;
    Checkbox vectorBox;
    Checkbox orientBox;
    ValueField distField;
    ValueField xField;
    ValueField yField;
    ValueField zField;
    ValueField segField;
    ValueField angleField;
    ValueField tolField;
    Button okButton;
    Button cancelButton;
    ObjectPreviewCanvas preview;
    Vector objects;
    Vector paths;
    private static int counter = 1;

    public ExtrudeDialog(LayoutWindow window) {
        super((Frame)window, "Extrude", true);
        this.window = window;
        Scene scene = window.getScene();
        int[] selection = scene.getSelection();
        Vector sceneObj = scene.getObjects();
        this.objects = new Vector();
        this.paths = new Vector();
        int i = 0;
        while (i < selection.length) {
            ObjectInfo obj = (ObjectInfo)sceneObj.elementAt(selection[i]);
            if (obj.object instanceof Curve) {
                this.objects.addElement(obj);
                this.paths.addElement(obj);
            } else if ((obj.object instanceof TriangleMesh || obj.object.canConvertToTriangleMesh() != 0) && !obj.object.isClosed()) {
                this.objects.addElement(obj);
            }
            ++i;
        }
        if (this.objects.size() == 1) {
            this.paths.removeAllElements();
        }
        this.setLayout(new GridBagLayout());
        GridBagConstraints gc = new GridBagConstraints();
        gc.anchor = 17;
        gc.gridx = 0;
        gc.gridwidth = 2;
        this.add((Component)new Label("Object to Extrude:"), gc);
        gc.anchor = 10;
        this.objChoice = new Choice();
        this.add((Component)this.objChoice, gc);
        int i2 = 0;
        while (i2 < this.objects.size()) {
            this.objChoice.add(((ObjectInfo)this.objects.elementAt((int)i2)).name);
            ++i2;
        }
        this.objChoice.addItemListener(this);
        gc.anchor = 17;
        this.add((Component)new Label("Extrude Direction:"), gc);
        gc.gridwidth = 1;
        this.pathGroup = new CheckboxGroup();
        this.xBox = new Checkbox("X", true, this.pathGroup);
        this.add((Component)this.xBox, gc);
        this.yBox = new Checkbox("Y", true, this.pathGroup);
        this.add((Component)this.yBox, gc);
        this.zBox = new Checkbox("Z", true, this.pathGroup);
        this.add((Component)this.zBox, gc);
        this.pathBox = new Checkbox("Curve", true, this.pathGroup);
        this.add((Component)this.pathBox, gc);
        this.vectorBox = new Checkbox("Vector", true, this.pathGroup);
        this.add((Component)this.vectorBox, gc);
        this.pathBox.setEnabled(this.paths.size() > 0);
        this.xBox.addItemListener(this);
        this.yBox.addItemListener(this);
        this.zBox.addItemListener(this);
        this.pathBox.addItemListener(this);
        this.vectorBox.addItemListener(this);
        this.pathGroup.setSelectedCheckbox(this.zBox);
        gc.gridx = 1;
        gc.gridwidth = 2;
        this.add((Component)new Label(), gc);
        Panel p = new Panel();
        this.add((Component)p, gc);
        p.add(new Label("Distance:"));
        this.distField = new ValueField(1.0, 3, 5);
        p.add((Component)this.distField);
        this.distField.addTextListener((TextListener)this);
        this.add((Component)new Label(), gc);
        this.pathChoice = new Choice();
        this.add((Component)this.pathChoice, gc);
        int i3 = 0;
        while (i3 < this.paths.size()) {
            this.pathChoice.add(((ObjectInfo)this.paths.elementAt((int)i3)).name);
            ++i3;
        }
        this.pathChoice.addItemListener(this);
        p = new Panel();
        this.add((Component)p, gc);
        p.add((Component)new Label("X"), gc);
        this.xField = new ValueField(0.0, 0, 4);
        p.add((Component)this.xField);
        this.xField.addTextListener((TextListener)this);
        p.add((Component)new Label("Y"), gc);
        this.yField = new ValueField(0.0, 0, 4);
        p.add((Component)this.yField);
        this.yField.addTextListener((TextListener)this);
        p.add((Component)new Label("Z"), gc);
        this.zField = new ValueField(1.0, 0, 4);
        p.add((Component)this.zField);
        this.zField.addTextListener((TextListener)this);
        gc.gridx = 0;
        gc.gridwidth = 3;
        this.orientBox = new Checkbox("Orientation Follows Curve", true);
        this.add((Component)this.orientBox, gc);
        this.orientBox.addItemListener(this);
        gc.gridx = 3;
        gc.gridwidth = 1;
        this.add((Component)new Label("Number of Segments:"), gc);
        this.add((Component)new Label("Twist (degrees):"), gc);
        this.add((Component)new Label("Surface Accuracy:"), gc);
        gc.gridx = 4;
        this.segField = new ValueField(1.0, 7, 5);
        this.add((Component)this.segField, gc);
        this.angleField = new ValueField(0.0, 0, 5);
        this.add((Component)this.angleField, gc);
        this.tolField = new ValueField(0.1, 3, 5);
        this.add((Component)this.tolField, gc);
        this.segField.addTextListener((TextListener)this);
        this.angleField.addTextListener((TextListener)this);
        this.tolField.addTextListener((TextListener)this);
        if (this.paths.size() > 0) {
            int i4 = 0;
            while (i4 < this.objects.size()) {
                if (this.objects.elementAt(i4) != this.paths.elementAt(0)) {
                    this.objChoice.select(i4);
                    break;
                }
                ++i4;
            }
        }
        gc.gridx = 3;
        gc.gridwidth = 2;
        gc.gridheight = 6;
        gc.fill = 1;
        this.preview = new ObjectPreviewCanvas((ObjectInfo)this.objects.elementAt(0));
        this.add((Component)this.preview, gc);
        p = new Panel();
        this.okButton = new Button("OK");
        p.add(this.okButton);
        this.okButton.addActionListener(this);
        this.okButton.setActionCommand("ok");
        this.cancelButton = new Button("Cancel");
        p.add(this.cancelButton);
        this.cancelButton.addActionListener(this);
        this.cancelButton.setActionCommand("cancel");
        gc.gridx = 0;
        gc.gridheight = 1;
        gc.gridwidth = 0;
        gc.anchor = 10;
        gc.fill = 0;
        this.add((Component)p, gc);
        this.makeObject();
        this.pack();
        this.updateComponents();
        this.show();
    }

    public void itemStateChanged(ItemEvent e) {
        this.makeObject();
        this.updateComponents();
    }

    public void textValueChanged(TextEvent e) {
        this.makeObject();
    }

    private void updateComponents() {
        this.distField.setEnabled(this.xBox.getState() || this.yBox.getState() || this.zBox.getState());
        this.xField.setEnabled(this.vectorBox.getState());
        this.yField.setEnabled(this.vectorBox.getState());
        this.zField.setEnabled(this.vectorBox.getState());
        this.pathChoice.setEnabled(this.pathBox.getState());
        this.segField.setEnabled(!this.pathBox.getState());
        this.orientBox.setEnabled(this.pathBox.getState());
        Object3D profile = ((ObjectInfo)this.objects.elementAt((int)this.objChoice.getSelectedIndex())).object;
        this.tolField.setEnabled(!(profile instanceof Curve) && !(profile instanceof TriangleMesh));
        if (this.pathBox.getState()) {
            this.okButton.setEnabled(this.objects.elementAt(this.objChoice.getSelectedIndex()) != this.paths.elementAt(this.pathChoice.getSelectedIndex()));
        } else {
            this.okButton.setEnabled(true);
        }
    }

    public void actionPerformed(ActionEvent e) {
        if ("ok".equals(e.getActionCommand())) {
            this.window.addObject(this.preview.getObject().object, new CoordinateSystem(new Vec3(), Vec3.vz(), Vec3.vy()), "Extruded Object " + counter++, null);
            Vector obj = this.window.getScene().getObjects();
            this.window.setSelection(obj.size() - 1);
            this.window.setUndoRecord(new UndoRecord((EditingWindow)this.window, false, 5, new Object[]{new Integer(obj.size() - 1)}));
            this.window.updateImage();
        }
        this.dispose();
    }

    private void makeObject() {
        CoordinateSystem pathCoords;
        Curve path;
        ObjectInfo profile = (ObjectInfo)this.objects.elementAt(this.objChoice.getSelectedIndex());
        if (this.pathBox.getState()) {
            ObjectInfo info = (ObjectInfo)this.paths.elementAt(this.pathChoice.getSelectedIndex());
            path = (Curve)info.object;
            pathCoords = info.coords;
        } else {
            Vec3 dir = new Vec3();
            if (this.xBox.getState()) {
                dir.x = this.distField.getValue();
            } else if (this.yBox.getState()) {
                dir.y = this.distField.getValue();
            } else if (this.zBox.getState()) {
                dir.z = this.distField.getValue();
            } else {
                dir.set(this.xField.getValue(), this.yField.getValue(), this.zField.getValue());
            }
            Vec3[] v = new Vec3[(int)this.segField.getValue() + 1];
            float[] smooth = new float[v.length];
            int i = 0;
            while (i < v.length) {
                v[i] = new Vec3(dir);
                v[i].scale((double)i / this.segField.getValue());
                smooth[i] = 1.0f;
                ++i;
            }
            path = new Curve(v, smooth, 2, false);
            pathCoords = new CoordinateSystem(new Vec3(), Vec3.vz(), Vec3.vy());
        }
        Object3D obj = profile.object == path ? null : (profile.object instanceof TriangleMesh ? this.extrudeMesh((TriangleMesh)profile.object, path, profile.coords, pathCoords, this.angleField.getValue() * Math.PI / 180.0, this.orientBox.getState()) : (profile.object instanceof Curve ? this.extrudeCurve((Curve)profile.object, path, profile.coords, pathCoords, this.angleField.getValue() * Math.PI / 180.0, this.orientBox.getState()) : this.extrudeMesh(profile.object.convertToTriangleMesh(this.tolField.getValue()), path, profile.coords, pathCoords, this.angleField.getValue() * Math.PI / 180.0, this.orientBox.getState())));
        this.preview.setObject(obj);
        this.preview.updateImage();
        this.preview.repaint();
    }

    private Object3D extrudeCurve(Curve profile, Curve path, CoordinateSystem profCoords, CoordinateSystem pathCoords, double angle, boolean orient) {
        int j;
        MeshVertex[] profVert = profile.getVertices();
        MeshVertex[] pathVert = path.getVertices();
        Vec3[] profv = new Vec3[profVert.length];
        Vec3[] pathv = new Vec3[pathVert.length];
        Vec3 center = new Vec3();
        float[] usmooth = new float[pathVert.length];
        float[] vsmooth = new float[profVert.length];
        float[] profSmooth = profile.getSmoothness();
        float[] pathSmooth = path.getSmoothness();
        CoordinateSystem localCoords = new CoordinateSystem(new Vec3(), Vec3.vz(), Vec3.vy());
        int i = 0;
        while (i < profVert.length) {
            profv[i] = profCoords.fromLocal().timesDirection(profVert[i].r);
            ++i;
        }
        i = 0;
        while (i < pathVert.length) {
            pathv[i] = pathCoords.fromLocal().timesDirection(pathVert[i].r);
            ++i;
        }
        Vec3[] subdiv = path.subdivideCurve(pathv, pathSmooth, 0);
        Vec3[] t = new Vec3[subdiv.length];
        Vec3[] zdir = new Vec3[subdiv.length];
        Vec3[] updir = new Vec3[subdiv.length];
        t[0] = subdiv[1].minus(subdiv[0]);
        t[0].normalize();
        zdir[0] = Vec3.vz();
        updir[0] = Vec3.vy();
        double zfrac1 = t[0].dot(zdir[0]);
        double zfrac2 = Math.sqrt(1.0 - zfrac1 * zfrac1);
        Vec3 dir1 = zdir[0].minus(t[0].times(zfrac1));
        dir1.normalize();
        double upfrac1 = t[0].dot(updir[0]);
        double upfrac2 = Math.sqrt(1.0 - upfrac1 * upfrac1);
        Vec3 dir2 = updir[0].minus(t[0].times(upfrac1));
        dir2.normalize();
        i = 1;
        while (i < subdiv.length) {
            t[i] = i == subdiv.length - 1 ? (path.isClosed() ? subdiv[0].minus(subdiv[subdiv.length - 2]) : subdiv[subdiv.length - 1].minus(subdiv[subdiv.length - 2])) : subdiv[i + 1].minus(subdiv[i - 1]);
            t[i].normalize();
            if (orient) {
                dir1 = dir1.minus(t[i].times(t[i].dot(dir1)));
                dir1.normalize();
                dir2 = dir2.minus(t[i].times(t[i].dot(dir2)));
                dir2.normalize();
                zdir[i] = t[i].times(zfrac1).plus(dir1.times(zfrac2));
                updir[i] = t[i].times(upfrac1).plus(dir2.times(upfrac2));
            } else {
                zdir[i] = zdir[i - 1];
                updir[i] = updir[i - 1];
            }
            ++i;
        }
        if (path.getSmoothingMethod() != 0) {
            i = 0;
            while (i < usmooth.length) {
                usmooth[i] = pathSmooth[i];
                ++i;
            }
        }
        if (profile.getSmoothingMethod() != 0) {
            i = 0;
            while (i < vsmooth.length) {
                vsmooth[i] = profSmooth[i];
                ++i;
            }
        }
        if (profile.getSmoothingMethod() == 3 && path.getSmoothingMethod() == 2) {
            pathv = subdiv;
            usmooth = new float[pathv.length];
            i = 0;
            while (i < usmooth.length) {
                usmooth[i] = i % 2 == 0 ? Math.min(pathSmooth[i / 2] * 2.0f, 1.0f) : 1.0f;
                ++i;
            }
        }
        if (profile.getSmoothingMethod() == 2 && path.getSmoothingMethod() == 3) {
            profv = profile.subdivideCurve(profv, profSmooth, 0);
            vsmooth = new float[profv.length];
            i = 0;
            while (i < vsmooth.length) {
                vsmooth[i] = i % 2 == 0 ? Math.min(profSmooth[i / 2] * 2.0f, 1.0f) : 1.0f;
                ++i;
            }
        }
        Vec3[][] v = new Vec3[pathv.length][profv.length];
        i = 0;
        while (i < pathv.length) {
            localCoords.setOrigin(pathv[i]);
            int k = pathv.length == subdiv.length ? i : 2 * i;
            localCoords.setOrientation(zdir[k], updir[k]);
            if (angle != 0.0) {
                Mat4 rotate = Mat4.axisRotation((Vec3)t[k], (double)((double)i * angle / (double)(pathv.length - 1)));
                localCoords.transformAxes(rotate);
            }
            j = 0;
            while (j < profv.length) {
                v[i][j] = localCoords.fromLocal().times(profv[j]);
                center.add(v[i][j]);
                ++j;
            }
            ++i;
        }
        center.scale(1.0 / (double)(profv.length * pathv.length));
        i = 0;
        while (i < pathv.length) {
            j = 0;
            while (j < profv.length) {
                v[i][j].subtract(center);
                ++j;
            }
            ++i;
        }
        SplineMesh mesh = new SplineMesh(v, usmooth, vsmooth, Math.max(profile.getSmoothingMethod(), path.getSmoothingMethod()), path.isClosed(), profile.isClosed());
        mesh.setTexture(this.window.getScene().getDefaultTexture());
        mesh.setTextureMapping(mesh.getTexture().getDefaultMapping());
        mesh.makeRightSideOut();
        return mesh;
    }

    private Object3D extrudeMesh(TriangleMesh profile, Curve path, CoordinateSystem profCoords, CoordinateSystem pathCoords, double angle, boolean orient) {
        Mat4 rotate;
        int k;
        boolean angled;
        int[][] index;
        TriangleMesh.Vertex[] profVert = (TriangleMesh.Vertex[])profile.getVertices();
        MeshVertex[] pathVert = path.getVertices();
        TriangleMesh.Edge[] profEdge = profile.getEdges();
        TriangleMesh.Face[] profFace = profile.getFaces();
        Vec3[] profv = new Vec3[profVert.length];
        Vec3[] pathv = new Vec3[pathVert.length];
        float[] pathSmooth = path.getSmoothness();
        CoordinateSystem localCoords = new CoordinateSystem(new Vec3(), Vec3.vz(), Vec3.vy());
        int numBoundaryEdges = 0;
        int numBoundaryPoints = 0;
        int i = 0;
        while (i < profVert.length) {
            profv[i] = profCoords.fromLocal().timesDirection(profVert[i].r);
            ++i;
        }
        i = 0;
        while (i < pathVert.length) {
            pathv[i] = pathCoords.fromLocal().timesDirection(pathVert[i].r);
            ++i;
        }
        if (path.getSmoothingMethod() == 0) {
            i = 0;
            while (i < pathSmooth.length) {
                pathSmooth[i] = 0.0f;
                ++i;
            }
        }
        boolean[] onBound = new boolean[profv.length];
        i = 0;
        while (i < profEdge.length) {
            if (profEdge[i].f2 == -1) {
                ++numBoundaryEdges;
                onBound[profEdge[i].v2] = true;
                onBound[profEdge[i].v1] = true;
            }
            ++i;
        }
        i = 0;
        while (i < onBound.length) {
            if (onBound[i]) {
                ++numBoundaryPoints;
            }
            ++i;
        }
        int[] boundaryEdge = new int[numBoundaryEdges];
        int[] boundaryPoint = new int[numBoundaryPoints];
        i = 0;
        int j = 0;
        while (i < profEdge.length) {
            if (profEdge[i].f2 == -1) {
                boundaryEdge[j++] = i;
            }
            ++i;
        }
        i = 0;
        j = 0;
        while (i < onBound.length) {
            if (onBound[i]) {
                boundaryPoint[j++] = i;
            }
            ++i;
        }
        boolean[] forward = new boolean[boundaryEdge.length];
        int[][] edgeVertIndex = new int[boundaryEdge.length][2];
        i = 0;
        while (i < boundaryEdge.length) {
            TriangleMesh.Edge ed = profEdge[boundaryEdge[i]];
            TriangleMesh.Face fc = profFace[ed.f1];
            forward[i] = fc.v1 == ed.v1 && fc.v2 == ed.v2 || fc.v2 == ed.v1 && fc.v3 == ed.v2 || fc.v3 == ed.v1 && fc.v1 == ed.v2;
            j = 0;
            while (j < boundaryPoint.length) {
                if (boundaryPoint[j] == ed.v1) {
                    edgeVertIndex[i][0] = j;
                } else if (boundaryPoint[j] == ed.v2) {
                    edgeVertIndex[i][1] = j;
                }
                ++j;
            }
            ++i;
        }
        if (path.isClosed()) {
            index = new int[pathv.length + 1][boundaryPoint.length];
            i = 0;
            while (i < boundaryPoint.length) {
                j = 0;
                while (j < pathv.length) {
                    index[j][i] = j * boundaryPoint.length + i;
                    ++j;
                }
                index[j][i] = i;
                ++i;
            }
        } else {
            index = new int[pathv.length][boundaryPoint.length];
            i = 0;
            while (i < boundaryPoint.length) {
                index[0][i] = boundaryPoint[i];
                index[pathv.length - 1][i] = boundaryPoint[i] + profv.length;
                j = 1;
                while (j < pathv.length - 1) {
                    index[j][i] = (j - 1) * boundaryPoint.length + i + 2 * profv.length;
                    ++j;
                }
                ++i;
            }
        }
        Vec3[] subdiv = path.subdivideCurve(pathv, pathSmooth, 0);
        Vec3[] t = new Vec3[subdiv.length];
        Vec3[] zdir = new Vec3[subdiv.length];
        Vec3[] updir = new Vec3[subdiv.length];
        t[0] = subdiv[1].minus(subdiv[0]);
        t[0].normalize();
        zdir[0] = Vec3.vz();
        updir[0] = Vec3.vy();
        double zfrac1 = t[0].dot(zdir[0]);
        double zfrac2 = Math.sqrt(1.0 - zfrac1 * zfrac1);
        Vec3 dir1 = zdir[0].minus(t[0].times(zfrac1));
        dir1.normalize();
        double upfrac1 = t[0].dot(updir[0]);
        double upfrac2 = Math.sqrt(1.0 - upfrac1 * upfrac1);
        Vec3 dir2 = updir[0].minus(t[0].times(upfrac1));
        dir2.normalize();
        i = 1;
        while (i < subdiv.length) {
            t[i] = i == subdiv.length - 1 ? (path.isClosed() ? subdiv[0].minus(subdiv[subdiv.length - 2]) : subdiv[subdiv.length - 1].minus(subdiv[subdiv.length - 2])) : subdiv[i + 1].minus(subdiv[i - 1]);
            t[i].normalize();
            if (orient) {
                dir1 = dir1.minus(t[i].times(t[i].dot(dir1)));
                dir1.normalize();
                dir2 = dir2.minus(t[i].times(t[i].dot(dir2)));
                dir2.normalize();
                zdir[i] = t[i].times(zfrac1).plus(dir1.times(zfrac2));
                updir[i] = t[i].times(upfrac1).plus(dir2.times(upfrac2));
            } else {
                zdir[i] = zdir[i - 1];
                updir[i] = updir[i - 1];
            }
            ++i;
        }
        Vec3[] v = path.isClosed() ? new Vec3[numBoundaryPoints * pathv.length] : new Vec3[2 * profv.length + numBoundaryPoints * (pathv.length - 2)];
        Vector<EdgeInfo> newEdge = new Vector<EdgeInfo>();
        Vector<int[]> newFace = new Vector<int[]>();
        boolean bl = angled = profile.getSmoothingMethod() == 0 && path.getSmoothingMethod() != 0;
        if (!path.isClosed()) {
            localCoords.setOrigin(pathv[0]);
            localCoords.setOrientation(zdir[0], updir[0]);
            i = 0;
            while (i < profv.length) {
                v[i] = localCoords.fromLocal().times(profv[i]);
                ++i;
            }
            k = pathv.length == subdiv.length ? pathv.length - 1 : 2 * (pathv.length - 1);
            localCoords.setOrigin(pathv[pathv.length - 1]);
            localCoords.setOrientation(zdir[k], updir[k]);
            if (angle != 0.0) {
                rotate = Mat4.axisRotation((Vec3)t[k], (double)angle);
                localCoords.transformAxes(rotate);
            }
            i = 0;
            while (i < profv.length) {
                v[i + profv.length] = localCoords.fromLocal().times(profv[i]);
                ++i;
            }
            i = 0;
            while (i < profEdge.length) {
                float smoothness = profEdge[i].smoothness;
                if (angled || profEdge[i].f2 == -1) {
                    smoothness = 0.0f;
                }
                newEdge.addElement(new EdgeInfo(profEdge[i].v1, profEdge[i].v2, smoothness));
                newEdge.addElement(new EdgeInfo(profEdge[i].v1 + profv.length, profEdge[i].v2 + profv.length, smoothness));
                ++i;
            }
            i = 0;
            while (i < profFace.length) {
                TriangleMesh.Face f = profFace[i];
                newFace.addElement(new int[]{f.v1, f.v2, f.v3});
                newFace.addElement(new int[]{f.v1 + profv.length, f.v3 + profv.length, f.v2 + profv.length});
                ++i;
            }
        }
        i = 0;
        while (i < pathv.length) {
            if (!path.isClosed() && i == pathv.length - 1) break;
            j = 0;
            while (j < boundaryEdge.length) {
                int v2;
                int v1;
                TriangleMesh.Edge ed = profEdge[boundaryEdge[j]];
                if (forward[j]) {
                    v1 = edgeVertIndex[j][0];
                    v2 = edgeVertIndex[j][1];
                } else {
                    v1 = edgeVertIndex[j][1];
                    v2 = edgeVertIndex[j][0];
                }
                newFace.addElement(new int[]{index[i][v1], index[i + 1][v1], index[i + 1][v2]});
                newFace.addElement(new int[]{index[i][v2], index[i][v1], index[i + 1][v2]});
                EdgeInfo ed1 = new EdgeInfo(index[i][v1], index[i + 1][v1], angled ? 0.0f : profVert[boundaryPoint[v1]].smoothness);
                newEdge.addElement(ed1);
                ed1 = new EdgeInfo(index[i][v2], index[i + 1][v2], angled ? 0.0f : profVert[boundaryPoint[v2]].smoothness);
                newEdge.addElement(ed1);
                ed1 = new EdgeInfo(index[i][v1], index[i + 1][v2], 1.0f);
                newEdge.addElement(ed1);
                if (path.isClosed() || i > 0) {
                    ed1 = new EdgeInfo(index[i][v1], index[i][v2], pathSmooth[i]);
                    newEdge.addElement(ed1);
                }
                ++j;
            }
            localCoords.setOrigin(pathv[i]);
            k = pathv.length == subdiv.length ? i : 2 * i;
            localCoords.setOrientation(zdir[k], updir[k]);
            if (angle != 0.0) {
                rotate = Mat4.axisRotation((Vec3)t[k], (double)((double)i * angle / (double)(pathv.length - 1)));
                localCoords.transformAxes(rotate);
            }
            j = 0;
            while (j < boundaryPoint.length) {
                v[index[i][j]] = localCoords.fromLocal().times(profv[boundaryPoint[j]]);
                ++j;
            }
            ++i;
        }
        Vec3 center = new Vec3();
        i = 0;
        while (i < v.length) {
            center.add(v[i]);
            ++i;
        }
        center.scale(1.0 / (double)v.length);
        i = 0;
        while (i < v.length) {
            v[i].subtract(center);
            ++i;
        }
        int[][] faces = new int[newFace.size()][];
        i = 0;
        while (i < faces.length) {
            faces[i] = (int[])newFace.elementAt(i);
            ++i;
        }
        TriangleMesh mesh = new TriangleMesh(v, (int[][])faces);
        TriangleMesh.Edge[] meshEdge = mesh.getEdges();
        i = 0;
        while (i < newEdge.size()) {
            EdgeInfo info = (EdgeInfo)newEdge.elementAt(i);
            if (info.smoothness != 1.0f) {
                j = 0;
                while (j < meshEdge.length) {
                    if (meshEdge[j].v1 == info.v1 && meshEdge[j].v2 == info.v2 || meshEdge[j].v1 == info.v2 && meshEdge[j].v2 == info.v1) {
                        meshEdge[j].smoothness = info.smoothness;
                    }
                    ++j;
                }
            }
            ++i;
        }
        mesh.setTexture(this.window.getScene().getDefaultTexture());
        mesh.setTextureMapping(mesh.getTexture().getDefaultMapping());
        mesh.setSmoothingMethod(Math.max(profile.getSmoothingMethod(), path.getSmoothingMethod()));
        mesh.makeRightSideOut();
        return mesh;
    }

    private class EdgeInfo {
        int v1;
        int v2;
        float smoothness;

        public EdgeInfo(int vert1, int vert2, float smooth) {
            this.v1 = vert1;
            this.v2 = vert2;
            this.smoothness = smooth;
        }
    }
}

