/*
 * Decompiled with CFR 0.152.
 */
package artofillusion.tools;

import artofillusion.CoordinateSystem;
import artofillusion.Curve;
import artofillusion.EditingWindow;
import artofillusion.LayoutWindow;
import artofillusion.MeshVertex;
import artofillusion.Object3D;
import artofillusion.ObjectInfo;
import artofillusion.ObjectPreviewCanvas;
import artofillusion.Scene;
import artofillusion.SplineMesh;
import artofillusion.UndoRecord;
import artofillusion.Vec3;
import java.awt.Button;
import java.awt.Checkbox;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.List;
import java.awt.Panel;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Vector;

public class SkinDialog
extends Dialog
implements ActionListener,
ItemListener {
    LayoutWindow window;
    List curveList;
    Checkbox reverseBox;
    Button upButton;
    Button downButton;
    Button okButton;
    Button cancelButton;
    ObjectPreviewCanvas preview;
    ObjectInfo[] curve;
    boolean[] reverse;
    private static int counter = 1;

    public SkinDialog(LayoutWindow window, Vector curves) {
        super((Frame)window, "Skin", true);
        this.window = window;
        this.curve = new ObjectInfo[curves.size()];
        this.reverse = new boolean[curves.size()];
        Scene scene = window.getScene();
        this.setLayout(new GridBagLayout());
        GridBagConstraints gc = new GridBagConstraints();
        gc.fill = 1;
        gc.gridx = 0;
        gc.gridheight = 4;
        this.curveList = new List();
        this.add((Component)this.curveList, gc);
        int i = 0;
        while (i < curves.size()) {
            this.curve[i] = (ObjectInfo)curves.elementAt(i);
            this.curveList.add(this.curve[i].name);
            ++i;
        }
        this.curveList.select(0);
        this.curveList.addItemListener(this);
        gc.gridx = 1;
        gc.gridheight = 1;
        this.upButton = new Button("Move Up");
        this.add((Component)this.upButton, gc);
        this.upButton.addActionListener(this);
        this.downButton = new Button("Move Down");
        this.add((Component)this.downButton, gc);
        this.downButton.addActionListener(this);
        this.reverseBox = new Checkbox("Reverse Direction");
        this.add((Component)this.reverseBox, gc);
        this.reverseBox.addItemListener(this);
        gc.gridx = 2;
        gc.gridheight = 4;
        gc.fill = 1;
        gc.weighty = 1.0;
        gc.weightx = 1.0;
        this.preview = new ObjectPreviewCanvas(null);
        this.add((Component)this.preview, gc);
        this.preview.setPreferredSize(150, 150);
        gc.gridx = 0;
        gc.gridwidth = 3;
        gc.weighty = 0.0;
        gc.weightx = 0.0;
        Panel p = new Panel();
        this.okButton = new Button("OK");
        p.add(this.okButton);
        this.okButton.addActionListener(this);
        this.cancelButton = new Button("Cancel");
        p.add(this.cancelButton);
        this.cancelButton.addActionListener(this);
        this.add((Component)p, gc);
        this.makeObject();
        this.pack();
        this.updateComponents();
        this.show();
    }

    public void itemStateChanged(ItemEvent e) {
        if (e.getSource() == this.reverseBox) {
            this.reverse[this.curveList.getSelectedIndex()] = this.reverseBox.getState();
        }
        this.makeObject();
        this.updateComponents();
    }

    private void updateComponents() {
        int which = this.curveList.getSelectedIndex();
        this.upButton.setEnabled(which > 0);
        this.downButton.setEnabled(which < this.curve.length - 1);
        this.reverseBox.setState(this.reverse[which]);
    }

    public void actionPerformed(ActionEvent e) {
        if (this.okButton == e.getSource()) {
            this.window.addObject(this.preview.getObject().object, new CoordinateSystem(new Vec3(), Vec3.vz(), Vec3.vy()), "Skinned Object " + counter++, null);
            Vector obj = this.window.getScene().getObjects();
            this.window.setSelection(obj.size() - 1);
            this.window.setUndoRecord(new UndoRecord((EditingWindow)this.window, false, 5, new Object[]{new Integer(obj.size() - 1)}));
            this.window.updateImage();
            this.dispose();
        } else if (this.upButton == e.getSource()) {
            int which = this.curveList.getSelectedIndex();
            ObjectInfo swap1 = this.curve[which];
            this.curve[which] = this.curve[which - 1];
            this.curve[which - 1] = swap1;
            boolean swap2 = this.reverse[which];
            this.reverse[which] = this.reverse[which - 1];
            this.reverse[which - 1] = swap2;
            String swap3 = this.curveList.getItem(which);
            this.curveList.remove(which);
            this.curveList.add(swap3, which - 1);
            this.curveList.select(which - 1);
            this.makeObject();
            this.updateComponents();
        } else if (this.downButton == e.getSource()) {
            int which = this.curveList.getSelectedIndex();
            ObjectInfo swap1 = this.curve[which];
            this.curve[which] = this.curve[which + 1];
            this.curve[which + 1] = swap1;
            boolean swap2 = this.reverse[which];
            this.reverse[which] = this.reverse[which + 1];
            this.reverse[which + 1] = swap2;
            String swap3 = this.curveList.getItem(which);
            this.curveList.remove(which);
            this.curveList.add(swap3, which + 1);
            this.curveList.select(which + 1);
            this.makeObject();
            this.updateComponents();
        } else {
            this.dispose();
        }
    }

    private void makeObject() {
        Vec3[][] v = new Vec3[this.curve.length][];
        Vec3 center = new Vec3();
        float[] us = new float[this.curve.length];
        float[] vs = new float[((Curve)this.curve[0].object).getVertices().length];
        int smoothMethod = 2;
        boolean closed = false;
        int i = 0;
        while (i < this.curve.length) {
            Curve cv = (Curve)this.curve[i].object;
            MeshVertex[] vert = cv.getVertices();
            v[i] = new Vec3[vert.length];
            float[] smooth = cv.getSmoothness();
            if (cv.getSmoothingMethod() > smoothMethod) {
                smoothMethod = cv.getSmoothingMethod();
            }
            closed |= cv.isClosed();
            int j = 0;
            while (j < vert.length) {
                int k = this.reverse[i] ? vert.length - j - 1 : j;
                v[i][j] = this.curve[i].coords.fromLocal().times(vert[k].r);
                center.add(v[i][j]);
                if (cv.getSmoothingMethod() != 0) {
                    int n = j;
                    vs[n] = vs[n] + smooth[k];
                }
                ++j;
            }
            us[i] = 1.0f;
            ++i;
        }
        int i2 = 0;
        while (i2 < vs.length) {
            int n = i2++;
            vs[n] = vs[n] / (float)this.curve.length;
        }
        center.scale(1.0 / (double)(v.length * v[0].length));
        int i3 = 0;
        while (i3 < v.length) {
            int j = 0;
            while (j < v[i3].length) {
                v[i3][j].subtract(center);
                ++j;
            }
            ++i3;
        }
        SplineMesh mesh = new SplineMesh((Vec3[][])v, us, vs, smoothMethod, false, closed);
        mesh.setTexture(this.window.getScene().getDefaultTexture());
        mesh.setTextureMapping(mesh.getTexture().getDefaultMapping());
        mesh.makeRightSideOut();
        this.preview.setObject((Object3D)mesh);
        this.preview.updateImage();
        this.preview.repaint();
    }
}

