/*
 * Decompiled with CFR 0.152.
 */
package artofillusion.tools;

import artofillusion.Curve;
import artofillusion.LayoutWindow;
import artofillusion.ModellingTool;
import artofillusion.ObjectInfo;
import artofillusion.Scene;
import artofillusion.tools.SkinDialog;
import artofillusion.ui.MessageDialog;
import java.awt.Frame;
import java.util.Vector;

public class SkinTool
implements ModellingTool {
    public String getName() {
        return "Skin...";
    }

    public void commandSelected(LayoutWindow window) {
        Scene scene = window.getScene();
        int[] selection = scene.getSelection();
        Vector objects = scene.getObjects();
        Vector<ObjectInfo> curves = new Vector<ObjectInfo>();
        int i = 0;
        while (i < selection.length) {
            ObjectInfo obj = (ObjectInfo)objects.elementAt(selection[i]);
            if (obj.object instanceof Curve) {
                curves.addElement(obj);
            }
            ++i;
        }
        if (curves.size() < 2) {
            new MessageDialog((Frame)window, new String[]{"You must select two or more curves to create a skin across."});
            return;
        }
        Curve c = (Curve)((ObjectInfo)curves.elementAt((int)0)).object;
        int i2 = 1;
        while (i2 < curves.size()) {
            Curve c2 = (Curve)((ObjectInfo)curves.elementAt((int)i2)).object;
            if (c2.getVertices().length != c.getVertices().length) {
                new MessageDialog((Frame)window, new String[]{"All the curves must have the same number of points."});
                return;
            }
            if (c2.isClosed() != c.isClosed()) {
                new MessageDialog((Frame)window, new String[]{"You cannot create a skin between a closed curve and an open one."});
                return;
            }
            if (c2.getSmoothingMethod() != c.getSmoothingMethod() && c.getSmoothingMethod() != 0 && c2.getSmoothingMethod() != 0) {
                new MessageDialog((Frame)window, new String[]{"You cannot create a skin between an interpolating curve", "and an approximating one."});
                return;
            }
            ++i2;
        }
        new SkinDialog(window, curves);
    }
}

