/*
 * Decompiled with CFR 0.152.
 */
package artofillusion.raytracer;

import artofillusion.BoundingBox;
import artofillusion.Mat4;
import artofillusion.MaterialMapping;
import artofillusion.RGBColor;
import artofillusion.RenderingMesh;
import artofillusion.RenderingTriangle;
import artofillusion.TextureSpec;
import artofillusion.Vec2;
import artofillusion.Vec3;
import artofillusion.raytracer.RTObject;
import artofillusion.raytracer.Ray;

public class RTTriangle
implements RTObject {
    RenderingTriangle tri;
    Vec3 vert1;
    Vec3 vert2;
    Vec3 vert3;
    Vec3 trueNorm;
    Vec3 norm1;
    Vec3 norm2;
    Vec3 norm3;
    Vec3 ri;
    Vec3 bumpGrad;
    double d;
    double t;
    double u;
    double v;
    double w;
    double time;
    Vec2 edge2d1;
    Vec2 edge2d2;
    int dropAxis;
    int lastRay;
    boolean interpNormals;
    boolean bumpMapped;
    boolean lastRayResult;
    Mat4 toLocal;
    Mat4 fromLocal;
    MaterialMapping material;
    public static final double TOL = 1.0E-12;

    public RTTriangle(RenderingMesh mesh, int which, Mat4 fromLocal, Mat4 toLocal, MaterialMapping material, Vec3[] vert, Vec3[] norm, double time) {
        this.tri = mesh.triangle[which];
        this.vert1 = vert[this.tri.v1];
        this.vert2 = vert[this.tri.v2];
        this.vert3 = vert[this.tri.v3];
        this.trueNorm = fromLocal.timesDirection(mesh.faceNorm[which]);
        this.fromLocal = fromLocal;
        this.toLocal = toLocal;
        this.time = time;
        boolean bl = this.interpNormals = this.tri.n1 != this.tri.n2 || this.tri.n1 != this.tri.n3;
        if (this.interpNormals) {
            this.norm1 = norm[this.tri.n1];
            this.norm2 = norm[this.tri.n2];
            this.norm3 = norm[this.tri.n3];
            int i = 0;
            if (this.trueNorm.dot(this.norm1) < 0.0) {
                ++i;
            }
            if (this.trueNorm.dot(this.norm2) < 0.0) {
                ++i;
            }
            if (this.trueNorm.dot(this.norm3) < 0.0) {
                ++i;
            }
            if (i > 1) {
                this.trueNorm.scale(-1.0);
            }
        }
        this.d = -this.trueNorm.dot(this.vert1);
        this.dropAxis = Math.abs(this.trueNorm.y) > Math.abs(this.trueNorm.x) ? (Math.abs(this.trueNorm.z) > Math.abs(this.trueNorm.y) ? 2 : 1) : (Math.abs(this.trueNorm.z) > Math.abs(this.trueNorm.x) ? 2 : 0);
        switch (this.dropAxis) {
            case 0: {
                this.edge2d1 = new Vec2(this.vert1.y - this.vert2.y, this.vert1.z - this.vert2.z);
                this.edge2d2 = new Vec2(this.vert1.y - this.vert3.y, this.vert1.z - this.vert3.z);
                break;
            }
            case 1: {
                this.edge2d1 = new Vec2(this.vert1.x - this.vert2.x, this.vert1.z - this.vert2.z);
                this.edge2d2 = new Vec2(this.vert1.x - this.vert3.x, this.vert1.z - this.vert3.z);
                break;
            }
            default: {
                this.edge2d1 = new Vec2(this.vert1.x - this.vert2.x, this.vert1.y - this.vert2.y);
                this.edge2d2 = new Vec2(this.vert1.x - this.vert3.x, this.vert1.y - this.vert3.y);
            }
        }
        double denom = 1.0 / this.edge2d1.cross(this.edge2d2);
        this.edge2d1.scale(denom);
        this.edge2d2.scale(denom);
        this.bumpMapped = this.tri.mapping.getTexture().bumpMapped();
        this.ri = new Vec3();
        this.lastRay = -1;
        this.material = material;
    }

    public final MaterialMapping getMaterialMapping() {
        return this.material;
    }

    public boolean intersects(Ray r) {
        double vy;
        double vx;
        Vec3 orig = r.getOrigin();
        Vec3 dir = r.getDirection();
        if (this.lastRay == r.getID()) {
            return this.lastRayResult;
        }
        this.lastRay = r.getID();
        double vd = this.trueNorm.dot(dir);
        if (vd == 0.0) {
            this.lastRayResult = false;
            return false;
        }
        double v0 = -(this.trueNorm.dot(orig) + this.d);
        this.t = v0 / vd;
        if (this.t < 1.0E-12) {
            this.lastRayResult = false;
            return false;
        }
        this.ri.set(orig.x + dir.x * this.t, orig.y + dir.y * this.t, orig.z + dir.z * this.t);
        switch (this.dropAxis) {
            case 0: {
                vx = this.ri.y - this.vert1.y;
                vy = this.ri.z - this.vert1.z;
                break;
            }
            case 1: {
                vx = this.ri.x - this.vert1.x;
                vy = this.ri.z - this.vert1.z;
                break;
            }
            default: {
                vx = this.ri.x - this.vert1.x;
                vy = this.ri.y - this.vert1.y;
            }
        }
        this.v = this.edge2d2.x * vy - this.edge2d2.y * vx;
        if (this.v < -1.0E-12 || this.v > 1.000000000001) {
            this.lastRayResult = false;
            return false;
        }
        this.w = vx * this.edge2d1.y - vy * this.edge2d1.x;
        if (this.w < -1.0E-12 || this.w > 1.000000000001) {
            this.lastRayResult = false;
            return false;
        }
        this.u = 1.0 - this.v - this.w;
        if (this.u < -1.0E-12 || this.u > 1.000000000001) {
            this.lastRayResult = false;
            return false;
        }
        this.lastRayResult = true;
        return true;
    }

    public int numIntersections() {
        return 1;
    }

    public final void intersectionPoint(int n, Vec3 p) {
        p.set(this.ri);
    }

    public final double intersectionDist(int n) {
        return this.t;
    }

    public void intersectionNormal(Vec3 n) {
        if (!this.interpNormals) {
            n.set(this.trueNorm);
        } else {
            n.x = this.u * this.norm1.x + this.v * this.norm2.x + this.w * this.norm3.x;
            n.y = this.u * this.norm1.y + this.v * this.norm2.y + this.w * this.norm3.y;
            n.z = this.u * this.norm1.z + this.v * this.norm2.z + this.w * this.norm3.z;
            n.normalize();
        }
        if (this.bumpMapped) {
            n.scale(this.bumpGrad.dot(n) + 1.0);
            n.subtract(this.bumpGrad);
            n.normalize();
        }
    }

    public void trueNormal(Vec3 n) {
        n.set(this.trueNorm);
    }

    public void intersectionTexture(TextureSpec spec, boolean front, double size) {
        this.tri.getTextureSpec(spec, front, this.u, this.v, this.w, size, this.time);
        if (this.bumpMapped) {
            this.bumpGrad = spec.bumpGrad;
            this.fromLocal.transformDirection(this.bumpGrad);
        }
    }

    public void intersectionTransparency(int n, RGBColor trans, boolean front, double size) {
        this.tri.getTransparency(trans, front, this.u, this.v, this.w, size, this.time);
    }

    public BoundingBox getBounds() {
        double maxz;
        double maxy;
        double maxx;
        double minx = maxx = this.vert1.x;
        double miny = maxy = this.vert1.y;
        double minz = maxz = this.vert1.z;
        if (this.vert2.x < minx) {
            minx = this.vert2.x;
        }
        if (this.vert2.x > maxx) {
            maxx = this.vert2.x;
        }
        if (this.vert2.y < miny) {
            miny = this.vert2.y;
        }
        if (this.vert2.y > maxy) {
            maxy = this.vert2.y;
        }
        if (this.vert2.z < minz) {
            minz = this.vert2.z;
        }
        if (this.vert2.z > maxz) {
            maxz = this.vert2.z;
        }
        if (this.vert3.x < minx) {
            minx = this.vert3.x;
        }
        if (this.vert3.x > maxx) {
            maxx = this.vert3.x;
        }
        if (this.vert3.y < miny) {
            miny = this.vert3.y;
        }
        if (this.vert3.y > maxy) {
            maxy = this.vert3.y;
        }
        if (this.vert3.z < minz) {
            minz = this.vert3.z;
        }
        if (this.vert3.z > maxz) {
            maxz = this.vert3.z;
        }
        return new BoundingBox(minx, maxx, miny, maxy, minz, maxz);
    }

    public boolean intersectsBox(BoundingBox bb) {
        if (bb.contains(this.vert1) || bb.contains(this.vert2) || bb.contains(this.vert3)) {
            return true;
        }
        if (this.edgeIntersectsBox(this.vert1, this.vert2, bb) || this.edgeIntersectsBox(this.vert2, this.vert3, bb) || this.edgeIntersectsBox(this.vert3, this.vert1, bb)) {
            return true;
        }
        Ray r = new Ray();
        Vec3 orig = r.getOrigin();
        Vec3 dir = r.getDirection();
        orig.set(bb.minx, bb.miny, bb.minz);
        dir.set(bb.maxx - bb.minx, bb.maxy - bb.miny, bb.maxz - bb.minz);
        double len = dir.length();
        dir.scale(1.0 / len);
        r.newID();
        if (this.intersects(r) && this.intersectionDist(0) < len) {
            return true;
        }
        orig.set(bb.maxx, bb.miny, bb.minz);
        dir.set(bb.minx - bb.maxx, bb.maxy - bb.miny, bb.maxz - bb.minz);
        len = dir.length();
        dir.scale(1.0 / len);
        r.newID();
        if (this.intersects(r) && this.intersectionDist(0) < len) {
            return true;
        }
        orig.set(bb.minx, bb.maxy, bb.minz);
        dir.set(bb.maxx - bb.minx, bb.miny - bb.maxy, bb.maxz - bb.minz);
        len = dir.length();
        dir.scale(1.0 / len);
        r.newID();
        if (this.intersects(r) && this.intersectionDist(0) < len) {
            return true;
        }
        orig.set(bb.minx, bb.miny, bb.maxz);
        dir.set(bb.maxx - bb.minx, bb.maxy - bb.miny, bb.minz - bb.maxz);
        len = dir.length();
        dir.scale(1.0 / len);
        r.newID();
        return this.intersects(r) && this.intersectionDist(0) < len;
    }

    boolean edgeIntersectsBox(Vec3 p1, Vec3 p2, BoundingBox bb) {
        double t2;
        double t1;
        double mint = -1.7976931348623157E308;
        double maxt = Double.MAX_VALUE;
        Vec3 dir = p2.minus(p1);
        double len = dir.length();
        dir.scale(1.0 / len);
        if (dir.x == 0.0) {
            if (p1.x < bb.minx || p1.x > bb.maxx) {
                return false;
            }
        } else {
            t1 = (bb.minx - p1.x) / dir.x;
            t2 = (bb.maxx - p1.x) / dir.x;
            if (t1 < t2) {
                if (t1 > mint) {
                    mint = t1;
                }
                if (t2 < maxt) {
                    maxt = t2;
                }
            } else {
                if (t2 > mint) {
                    mint = t2;
                }
                if (t1 < maxt) {
                    maxt = t1;
                }
            }
            if (mint > maxt || mint > len || maxt < 0.0) {
                return false;
            }
        }
        if (dir.y == 0.0) {
            if (p1.y < bb.miny || p1.y > bb.maxy) {
                return false;
            }
        } else {
            t1 = (bb.miny - p1.y) / dir.y;
            t2 = (bb.maxy - p1.y) / dir.y;
            if (t1 < t2) {
                if (t1 > mint) {
                    mint = t1;
                }
                if (t2 < maxt) {
                    maxt = t2;
                }
            } else {
                if (t2 > mint) {
                    mint = t2;
                }
                if (t1 < maxt) {
                    maxt = t1;
                }
            }
            if (mint > maxt || mint > len || maxt < 0.0) {
                return false;
            }
        }
        if (dir.z == 0.0) {
            if (p1.z < bb.minz || p1.z > bb.maxz) {
                return false;
            }
        } else {
            t1 = (bb.minz - p1.z) / dir.z;
            t2 = (bb.maxz - p1.z) / dir.z;
            if (t1 < t2) {
                if (t1 > mint) {
                    mint = t1;
                }
                if (t2 < maxt) {
                    maxt = t2;
                }
            } else {
                if (t2 > mint) {
                    mint = t2;
                }
                if (t1 < maxt) {
                    maxt = t1;
                }
            }
            if (mint > maxt || mint > len || maxt < 0.0) {
                return false;
            }
        }
        return true;
    }

    public Mat4 toLocal() {
        return this.toLocal;
    }
}

