/*
 * Decompiled with CFR 0.152.
 */
package artofillusion.raytracer;

import artofillusion.BoundingBox;
import artofillusion.Camera;
import artofillusion.Cylinder;
import artofillusion.DirectionalLight;
import artofillusion.Light;
import artofillusion.Mat4;
import artofillusion.MaterialMapping;
import artofillusion.MaterialSpec;
import artofillusion.Object3D;
import artofillusion.ObjectInfo;
import artofillusion.PointLight;
import artofillusion.RGBColor;
import artofillusion.RenderingMesh;
import artofillusion.RenderingTriangle;
import artofillusion.Scene;
import artofillusion.Sphere;
import artofillusion.SpotLight;
import artofillusion.Texture;
import artofillusion.TextureMapping;
import artofillusion.TextureSpec;
import artofillusion.TriangleMesh;
import artofillusion.UniformMaterialMapping;
import artofillusion.Vec3;
import artofillusion.raytracer.OctreeNode;
import artofillusion.raytracer.RTCylinder;
import artofillusion.raytracer.RTDisplacedTriangle;
import artofillusion.raytracer.RTEllipsoid;
import artofillusion.raytracer.RTObject;
import artofillusion.raytracer.RTSphere;
import artofillusion.raytracer.RTTriangle;
import artofillusion.raytracer.Ray;
import artofillusion.ui.PanelDialog;
import artofillusion.ui.ValueField;
import java.awt.Button;
import java.awt.Checkbox;
import java.awt.Choice;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Label;
import java.awt.Panel;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.image.ImageObserver;
import java.awt.image.MemoryImageSource;
import java.util.Vector;

public class Raytracer
implements Runnable {
    RTObject[] sceneObject;
    ObjectInfo[] light;
    OctreeNode rootNode;
    OctreeNode cameraNode;
    OctreeNode[] lightNode;
    Panel configPanel;
    Checkbox aliasBox;
    Checkbox depthBox;
    Checkbox glossBox;
    Checkbox shadowBox;
    Checkbox diffuseBox;
    Checkbox transparentBox;
    Checkbox adaptiveBox;
    Choice maxRaysChoice;
    Choice minRaysChoice;
    ValueField errorField;
    ValueField rayDepthField;
    ValueField treeDepthField;
    ValueField rayCutoffField;
    ValueField smoothField;
    ValueField stepSizeField;
    int[] pixel;
    int width;
    int height;
    int maxRayDepth;
    int maxTreeDepth;
    int minRays;
    int maxRays;
    MemoryImageSource imageSource;
    Scene theScene;
    Camera theCamera;
    ImageObserver observer;
    Image img;
    Thread renderThread;
    Ray[] ray;
    RGBColor[] color;
    RGBColor[] rayIntensity;
    RGBColor tempColor;
    RGBColor tempColor2;
    RGBColor ambColor;
    RGBColor envColor;
    RGBColor fogColor;
    double[] transparency;
    TextureMapping envMapping;
    int envMode;
    Intersection intersect;
    MaterialIntersection[] matChange;
    TextureSpec[] surfSpec;
    MaterialSpec matSpec;
    Vec3[] pos;
    Vec3[] normal;
    Vec3[] trueNormal;
    Vec3 hvec;
    Vec3 vvec;
    Vec3 center;
    Vec3 viewpoint;
    double time;
    double smoothing;
    double smoothScale;
    double depthOfField;
    double focalDist;
    double fogDist;
    double surfaceError;
    double stepSize;
    float minRayIntensity = 0.01f;
    boolean fog;
    boolean antialias;
    boolean depth;
    boolean gloss;
    boolean penumbra;
    boolean traceDiffuse;
    boolean transparentBackground;
    boolean adaptive;
    public static final double TOL = 1.0E-12;
    public static final double COLOR_THRESH_ABS = 0.0078125;
    public static final double COLOR_THRESH_REL = 0.05;
    public static final int[] distrib1 = new int[]{0, 3, 1, 2, 1, 2, 0, 3, 2, 0, 3, 1, 3, 1, 2, 0};
    public static final int[] distrib2 = new int[]{0, 1, 2, 3, 3, 0, 1, 2, 1, 2, 3, 0, 0, 1, 2, 3};

    public synchronized void renderScene(Scene theScene, Camera theCamera, ImageObserver obs, double depthOfField, double focalDist) {
        Dimension dim = theCamera.getSize();
        this.observer = obs;
        this.theScene = theScene;
        this.theCamera = theCamera;
        this.depthOfField = depthOfField;
        this.focalDist = focalDist;
        this.time = theScene.getTime();
        if (this.pixel == null || this.width != dim.width || this.height != dim.height) {
            this.width = dim.width;
            this.height = dim.height;
            this.pixel = new int[this.width * this.height];
            this.imageSource = new MemoryImageSource(this.width, this.height, this.pixel, 0, this.width);
            this.imageSource.setAnimated(true);
            this.img = Toolkit.getDefaultToolkit().createImage(this.imageSource);
        }
        this.ray = new Ray[this.maxRayDepth + 1];
        this.color = new RGBColor[this.maxRayDepth + 1];
        this.transparency = new double[this.maxRayDepth + 1];
        this.rayIntensity = new RGBColor[this.maxRayDepth + 1];
        this.surfSpec = new TextureSpec[this.maxRayDepth + 1];
        this.pos = new Vec3[this.maxRayDepth + 1];
        this.normal = new Vec3[this.maxRayDepth + 1];
        this.trueNormal = new Vec3[this.maxRayDepth + 1];
        int i = 0;
        while (i < this.maxRayDepth + 1) {
            this.ray[i] = new Ray();
            this.color[i] = new RGBColor(0.0f, 0.0f, 0.0f);
            this.rayIntensity[i] = new RGBColor(0.0f, 0.0f, 0.0f);
            this.surfSpec[i] = new TextureSpec();
            this.pos[i] = new Vec3();
            this.normal[i] = new Vec3();
            this.trueNormal[i] = new Vec3();
            ++i;
        }
        this.matSpec = new MaterialSpec();
        this.intersect = new Intersection();
        this.tempColor = new RGBColor(0.0f, 0.0f, 0.0f);
        this.tempColor2 = new RGBColor(0.0f, 0.0f, 0.0f);
        this.matChange = new MaterialIntersection[64];
        int i2 = 0;
        while (i2 < this.matChange.length) {
            this.matChange[i2] = new MaterialIntersection();
            ++i2;
        }
        this.renderThread = new Thread(this);
        this.renderThread.start();
    }

    public synchronized void cancelRendering(Scene sc) {
        Thread t = this.renderThread;
        if (this.theScene != sc) {
            return;
        }
        this.renderThread = null;
        if (t == null) {
            return;
        }
        try {
            while (t.isAlive()) {
                Thread.sleep(100L);
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        this.finish();
    }

    public Panel getConfigPanel() {
        if (this.configPanel == null) {
            GridBagConstraints c = new GridBagConstraints();
            this.configPanel = new Panel();
            this.configPanel.setLayout(new GridBagLayout());
            c.gridx = 0;
            c.anchor = 13;
            this.configPanel.add((Component)new Label("Surface Accuracy:"), c);
            c.gridx = 1;
            c.anchor = 17;
            this.errorField = new ValueField(0.02, 3, 6);
            this.configPanel.add((Component)this.errorField);
            c.gridx = 0;
            c.gridwidth = 2;
            c.fill = 2;
            c.anchor = 13;
            c.insets = new Insets(0, 0, 0, 5);
            this.aliasBox = new Checkbox("Antialiasing", false);
            this.configPanel.add((Component)this.aliasBox, c);
            this.depthBox = new Checkbox("Depth of Field", false);
            this.configPanel.add((Component)this.depthBox, c);
            this.glossBox = new Checkbox("Gloss/Translucency", false);
            this.configPanel.add((Component)this.glossBox, c);
            this.shadowBox = new Checkbox("Soft Shadows", false);
            this.configPanel.add((Component)this.shadowBox, c);
            this.diffuseBox = new Checkbox("Global Illumination", false);
            this.configPanel.add((Component)this.diffuseBox, c);
            this.transparentBox = new Checkbox("Transparent Background", false);
            this.configPanel.add((Component)this.transparentBox, c);
            c.gridwidth = 1;
            this.configPanel.add((Component)new Label("Min Rays/Pixel:"), c);
            this.configPanel.add((Component)new Label("Max Rays/Pixel:"), c);
            c.gridx = 1;
            this.minRaysChoice = new Choice();
            this.configPanel.add((Component)this.minRaysChoice, c);
            this.maxRaysChoice = new Choice();
            this.configPanel.add((Component)this.maxRaysChoice, c);
            this.minRaysChoice.add("1");
            this.maxRaysChoice.add("1");
            int i = 4;
            while (i < 512) {
                this.minRaysChoice.add(Integer.toString(i));
                this.maxRaysChoice.add(Integer.toString(i));
                i *= 2;
            }
            this.minRaysChoice.select(0);
            this.maxRaysChoice.select(1);
            this.minRaysChoice.setEnabled(false);
            this.maxRaysChoice.setEnabled(false);
            c.gridx = 0;
            c.gridwidth = 2;
            c.anchor = 10;
            Button b = new Button("Advanced...");
            this.configPanel.add((Component)b, c);
            this.rayDepthField = new ValueField(8.0, 7);
            this.rayCutoffField = new ValueField(0.01, 1);
            this.treeDepthField = new ValueField(6.0, 7);
            this.smoothField = new ValueField(1.0, 1);
            this.stepSizeField = new ValueField(1.0, 3);
            this.adaptiveBox = new Checkbox("Reduce Accuracy for Distant Objects", true);
            b.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    Container parent = Raytracer.this.configPanel.getParent();
                    while (!(parent instanceof Frame)) {
                        parent = parent.getParent();
                    }
                    Raytracer.this.showAdvancedWindow((Frame)parent);
                }
            });
            ItemListener listener = new ItemListener(){

                public void itemStateChanged(ItemEvent e) {
                    boolean state1 = Raytracer.this.depthBox.getState() || Raytracer.this.glossBox.getState() || Raytracer.this.shadowBox.getState() || Raytracer.this.diffuseBox.getState();
                    boolean state2 = Raytracer.this.aliasBox.getState() || state1;
                    Raytracer.this.minRaysChoice.setEnabled(state2);
                    Raytracer.this.maxRaysChoice.setEnabled(state2);
                    if (state1 && Raytracer.this.minRaysChoice.getSelectedIndex() == 0) {
                        Raytracer.this.minRaysChoice.select(1);
                    }
                    if (state1 && Raytracer.this.maxRaysChoice.getSelectedIndex() == 0) {
                        Raytracer.this.maxRaysChoice.select(1);
                    }
                    if (Raytracer.this.minRaysChoice.getSelectedIndex() > Raytracer.this.maxRaysChoice.getSelectedIndex()) {
                        if (e.getSource() == Raytracer.this.maxRaysChoice) {
                            Raytracer.this.minRaysChoice.select(Raytracer.this.maxRaysChoice.getSelectedIndex());
                        } else {
                            Raytracer.this.maxRaysChoice.select(Raytracer.this.minRaysChoice.getSelectedIndex());
                        }
                    }
                }
            };
            this.aliasBox.addItemListener(listener);
            this.depthBox.addItemListener(listener);
            this.glossBox.addItemListener(listener);
            this.shadowBox.addItemListener(listener);
            this.diffuseBox.addItemListener(listener);
            this.minRaysChoice.addItemListener(listener);
            this.maxRaysChoice.addItemListener(listener);
        }
        return this.configPanel;
    }

    private void showAdvancedWindow(Frame parent) {
        Panel p = new Panel();
        GridBagConstraints c = new GridBagConstraints();
        p.setLayout(new GridBagLayout());
        c.gridx = 0;
        c.anchor = 13;
        c.insets = new Insets(0, 0, 0, 5);
        p.add((Component)new Label("Max Ray Tree Depth:"), c);
        p.add((Component)new Label("Min Ray Intensity:"), c);
        p.add((Component)new Label("Max Octree Depth:"), c);
        p.add((Component)new Label("Texture Smoothing:"), c);
        p.add((Component)new Label("Material Step Size:"), c);
        c.gridx = 1;
        c.fill = 2;
        p.add((Component)this.rayDepthField, c);
        p.add((Component)this.rayCutoffField, c);
        p.add((Component)this.treeDepthField, c);
        p.add((Component)this.smoothField, c);
        p.add((Component)this.stepSizeField, c);
        c.gridx = 0;
        c.gridwidth = 2;
        c.anchor = 10;
        p.add((Component)this.adaptiveBox, c);
        PanelDialog dlg = new PanelDialog(parent, "Advanced Options", p);
        if (dlg.clickedOk()) {
            this.maxRayDepth = (int)this.rayDepthField.getValue();
            this.minRayIntensity = (float)this.rayCutoffField.getValue();
            this.maxTreeDepth = (int)this.treeDepthField.getValue();
            this.smoothing = this.smoothField.getValue();
            this.stepSize = this.stepSizeField.getValue();
            this.adaptive = this.adaptiveBox.getState();
        } else {
            this.rayDepthField.setValue((double)this.maxRayDepth);
            this.rayCutoffField.setValue((double)this.minRayIntensity);
            this.treeDepthField.setValue((double)this.maxTreeDepth);
            this.smoothField.setValue(this.smoothing);
            this.stepSizeField.setValue(this.stepSize);
            this.adaptiveBox.setState(this.adaptive);
        }
    }

    public boolean recordConfiguraton() {
        this.maxRayDepth = (int)this.rayDepthField.getValue();
        this.minRayIntensity = (float)this.rayCutoffField.getValue();
        this.maxTreeDepth = (int)this.treeDepthField.getValue();
        this.smoothing = this.smoothField.getValue();
        this.stepSize = this.stepSizeField.getValue();
        this.adaptive = this.adaptiveBox.getState();
        this.surfaceError = this.errorField.getValue();
        this.antialias = this.aliasBox.getState();
        this.depth = this.depthBox.getState();
        this.gloss = this.glossBox.getState();
        this.penumbra = this.shadowBox.getState();
        this.traceDiffuse = this.diffuseBox.getState();
        this.transparentBackground = this.transparentBox.getState();
        this.minRays = Integer.parseInt(this.minRaysChoice.getSelectedItem());
        this.maxRays = Integer.parseInt(this.maxRaysChoice.getSelectedItem());
        if (!(this.antialias || this.depth || this.gloss || this.penumbra || this.traceDiffuse)) {
            this.maxRays = 1;
            this.minRays = 1;
        }
        return true;
    }

    public void configurePreview() {
        this.maxRayDepth = 6;
        this.minRayIntensity = 0.02f;
        this.maxTreeDepth = 8;
        this.transparentBackground = false;
        this.traceDiffuse = false;
        this.penumbra = false;
        this.gloss = false;
        this.depth = false;
        this.antialias = false;
        this.maxRays = 1;
        this.minRays = 1;
        this.smoothing = 1.0;
        this.stepSize = 1.0;
        this.adaptive = true;
        this.surfaceError = 0.02;
    }

    void buildScene(Scene theScene, Camera theCamera) {
        Vector obj = new Vector();
        Vector lt = new Vector();
        Vector objects = theScene.getObjects();
        Vec3 orig = theCamera.getCameraCoordinates().getOrigin();
        double distToScreen = theCamera.getDistToScreen();
        Thread thisThread = Thread.currentThread();
        int i = 0;
        while (i < objects.size()) {
            ObjectInfo info = (ObjectInfo)objects.elementAt(i);
            if (info.visible) {
                this.addObject(obj, lt, info, orig, distToScreen, info.coords.toLocal(), info.coords.fromLocal());
            }
            if (this.renderThread != thisThread) {
                return;
            }
            ++i;
        }
        this.sceneObject = new RTObject[obj.size()];
        i = 0;
        while (i < this.sceneObject.length) {
            this.sceneObject[i] = (RTObject)obj.elementAt(i);
            ++i;
        }
        this.light = new ObjectInfo[lt.size()];
        i = 0;
        while (i < this.light.length) {
            this.light[i] = (ObjectInfo)lt.elementAt(i);
            ++i;
        }
        this.ambColor = theScene.getAmbientColor();
        this.envColor = theScene.getEnvironmentColor();
        this.envMapping = theScene.getEnvironmentMapping();
        this.envMode = theScene.getEnvironmentMode();
        this.fogColor = theScene.getFogColor();
        this.fog = theScene.getFogState();
        this.fogDist = theScene.getFogDistance();
    }

    void addObject(Vector obj, Vector lt, ObjectInfo info, Vec3 orig, double distToScreen, Mat4 toLocal, Mat4 fromLocal) {
        RenderingTriangle tri;
        double dist;
        Thread thisThread = Thread.currentThread();
        Object3D theObject = info.object;
        boolean displaced = false;
        if (this.renderThread != thisThread) {
            return;
        }
        if (theObject instanceof Light) {
            lt.addElement(info);
            return;
        }
        double tol = this.adaptive ? ((dist = theObject.getBounds().distanceToPoint(toLocal.times(orig))) < distToScreen ? this.surfaceError : this.surfaceError * dist / distToScreen) : this.surfaceError;
        Texture tex = theObject.getTexture();
        if (tex != null && tex.displacementMapped()) {
            displaced = true;
            if (theObject.canConvertToTriangleMesh() != 0) {
                TriangleMesh tm = theObject.convertToTriangleMesh(tol);
                tm.setTexture(tex);
                tm.setTextureMapping(theObject.getTextureMapping().duplicate());
                tm.setMaterial(theObject.getMaterial());
                if (theObject.getMaterialMapping() != null) {
                    tm.setMaterialMapping(theObject.getMaterialMapping().duplicate());
                }
                theObject = tm;
            }
        }
        if (theObject instanceof Sphere) {
            Vec3 rad = ((Sphere)theObject).getRadii();
            if (rad.x == rad.y && rad.x == rad.z) {
                obj.addElement(new RTSphere((Sphere)theObject, fromLocal, toLocal, this.time, info.texParamValue));
                return;
            }
            obj.addElement(new RTEllipsoid((Sphere)theObject, fromLocal, toLocal, this.time, info.texParamValue));
            return;
        }
        if (theObject instanceof Cylinder) {
            obj.addElement(new RTCylinder((Cylinder)theObject, fromLocal, toLocal, this.time, info.texParamValue));
            return;
        }
        RenderingMesh mesh = theObject.getRenderingMesh(tol, false, info);
        if (mesh == null) {
            return;
        }
        RenderingTriangle[] t = mesh.triangle;
        Vec3[] vert = new Vec3[mesh.vert.length];
        Vec3[] norm = new Vec3[mesh.norm.length];
        int i = 0;
        while (i < vert.length) {
            vert[i] = fromLocal.times(mesh.vert[i]);
            ++i;
        }
        i = 0;
        while (i < norm.length) {
            if (mesh.norm[i] != null) {
                norm[i] = fromLocal.timesDirection(mesh.norm[i]);
            }
            ++i;
        }
        if (displaced) {
            i = 0;
            while (i < t.length) {
                tri = mesh.triangle[i];
                if (!(vert[tri.v1].equals(vert[tri.v2]) || vert[tri.v1].equals(vert[tri.v3]) || vert[tri.v2].equals(vert[tri.v3]))) {
                    RTObject dt = new RTDisplacedTriangle(mesh, i, fromLocal, toLocal, theObject.getMaterialMapping(), vert, norm, tol, this.time).getTrueObject();
                    obj.addElement(dt);
                    if (this.adaptive && dt instanceof RTDisplacedTriangle) {
                        dist = dt.getBounds().distanceToPoint(orig);
                        if (dist < distToScreen) {
                            ((RTDisplacedTriangle)dt).setTolerance(this.surfaceError);
                        } else {
                            ((RTDisplacedTriangle)dt).setTolerance(this.surfaceError * dist / distToScreen);
                        }
                    }
                    if (this.renderThread != thisThread) {
                        return;
                    }
                }
                ++i;
            }
        } else {
            i = 0;
            while (i < t.length) {
                tri = mesh.triangle[i];
                if (!(vert[tri.v1].equals(vert[tri.v2]) || vert[tri.v1].equals(vert[tri.v3]) || vert[tri.v2].equals(vert[tri.v3]))) {
                    obj.addElement(new RTTriangle(mesh, i, fromLocal, toLocal, theObject.getMaterialMapping(), vert, norm, this.time));
                }
                ++i;
            }
        }
    }

    void buildTree() {
        BoundingBox[] objBounds = new BoundingBox[this.sceneObject.length];
        double minz = Double.MAX_VALUE;
        double miny = Double.MAX_VALUE;
        double minx = Double.MAX_VALUE;
        double maxz = -1.7976931348623157E308;
        double maxy = -1.7976931348623157E308;
        double maxx = -1.7976931348623157E308;
        int i = 0;
        while (i < this.sceneObject.length) {
            objBounds[i] = this.sceneObject[i].getBounds();
            if (objBounds[i].minx < minx) {
                minx = objBounds[i].minx;
            }
            if (objBounds[i].maxx > maxx) {
                maxx = objBounds[i].maxx;
            }
            if (objBounds[i].miny < miny) {
                miny = objBounds[i].miny;
            }
            if (objBounds[i].maxy > maxy) {
                maxy = objBounds[i].maxy;
            }
            if (objBounds[i].minz < minz) {
                minz = objBounds[i].minz;
            }
            if (objBounds[i].maxz > maxz) {
                maxz = objBounds[i].maxz;
            }
            ++i;
        }
        BoundingBox sceneBounds = new BoundingBox(minx -= 1.0E-12, maxx += 1.0E-12, miny -= 1.0E-12, maxy += 1.0E-12, minz -= 1.0E-12, maxz += 1.0E-12);
        this.rootNode = new OctreeNode(sceneBounds, this.sceneObject, objBounds, null, 0, this.maxTreeDepth);
        this.cameraNode = this.rootNode.findNode(this.theCamera.getCameraCoordinates().getOrigin());
        this.lightNode = new OctreeNode[this.light.length];
        i = 0;
        while (i < this.light.length) {
            this.lightNode[i] = this.light[i].object instanceof DirectionalLight ? null : this.rootNode.findNode(this.light[i].coords.getOrigin());
            ++i;
        }
    }

    public void run() {
        int k2;
        int j2;
        int lastUpdated = 0;
        int[][] raysSent = new int[2][this.width];
        int[][] raysNeeded = new int[2][this.width];
        RGBColor col = this.color[0];
        RGBColor[][] pixelColor = new RGBColor[2][this.width];
        RGBColor[] rayColor = new RGBColor[11];
        double[][] pixelTrans = new double[2][this.width];
        double[] rayTrans = new double[11];
        long updateTime = System.currentTimeMillis();
        Thread thisThread = Thread.currentThread();
        boolean done = false;
        boolean[][] needsMore = new boolean[2][this.width];
        this.buildScene(this.theScene, this.theCamera);
        if (this.renderThread != thisThread) {
            return;
        }
        this.buildTree();
        int i = 0;
        while (i < rayColor.length) {
            rayColor[i] = new RGBColor(0.0f, 0.0f, 0.0f);
            ++i;
        }
        i = 0;
        while (i < this.width) {
            pixelColor[0][i] = new RGBColor(0.0f, 0.0f, 0.0f);
            pixelColor[1][i] = new RGBColor(0.0f, 0.0f, 0.0f);
            ++i;
        }
        i = 0;
        while (i < this.pixel.length) {
            this.pixel[i] = 0;
            ++i;
        }
        this.viewpoint = this.theCamera.getCameraCoordinates().getOrigin();
        Point p = new Point(this.width / 2, this.height / 2);
        this.center = this.theCamera.convertScreenToWorld(p, this.focalDist);
        ++p.x;
        this.hvec = this.theCamera.convertScreenToWorld(p, this.focalDist).minus(this.center);
        --p.x;
        ++p.y;
        this.vvec = this.theCamera.convertScreenToWorld(p, this.focalDist).minus(this.center);
        --p.y;
        this.smoothScale = this.smoothing * this.hvec.length() / this.focalDist;
        if (this.minRays == this.maxRays) {
            i = 0;
            while (i < this.height) {
                int j2 = 0;
                while (j2 < this.width) {
                    rayColor[0].setRGB(0.0f, 0.0f, 0.0f);
                    rayTrans[0] = 0.0;
                    int k2 = 0;
                    while (k2 < this.minRays) {
                        this.spawnEyeRay(j2, i, k2);
                        rayColor[0].add(col);
                        rayTrans[0] = rayTrans[0] + this.transparency[0];
                        ++k2;
                    }
                    rayColor[0].scale(1.0 / (double)this.minRays);
                    rayTrans[0] = rayTrans[0] / (double)this.minRays;
                    this.pixel[i * this.width + j2] = this.calcARGB(rayColor[0], rayTrans[0]);
                    if (this.renderThread != thisThread) {
                        return;
                    }
                    ++j2;
                }
                if (System.currentTimeMillis() - updateTime > 5000L) {
                    this.imageSource.newPixels();
                    this.observer.imageUpdate(this.img, 8, 0, lastUpdated, this.width, i);
                    lastUpdated = i;
                    updateTime = System.currentTimeMillis();
                }
                ++i;
            }
            this.imageSource.newPixels();
            this.finish();
            return;
        }
        if (this.minRays == 1) {
            i = 0;
            while (i < 2) {
                j2 = 0;
                while (j2 < this.width) {
                    this.spawnEyeRay(j2, i, 0);
                    pixelColor[i][j2].copy(rayColor[0]);
                    pixelTrans[i][j2] = this.transparency[0];
                    raysNeeded[i][j2] = 1;
                    raysSent[i][j2] = 1;
                    needsMore[i][j2] = false;
                    if (this.renderThread != thisThread) {
                        return;
                    }
                    ++j2;
                }
                ++i;
            }
            j2 = 0;
            while (j2 < this.width) {
                if (this.colorsDifferent(pixelColor[0][j2], pixelColor[1][j2], pixelTrans[0][j2], pixelTrans[1][j2])) {
                    needsMore[1][j2] = true;
                    needsMore[0][j2] = true;
                }
                ++j2;
            }
            j2 = 0;
            while (j2 < this.width - 1) {
                if (this.colorsDifferent(pixelColor[0][j2], pixelColor[0][j2 + 1], pixelTrans[0][j2], pixelTrans[0][j2 + 1])) {
                    needsMore[0][j2 + 1] = true;
                    needsMore[0][j2] = true;
                }
                if (this.colorsDifferent(pixelColor[1][j2], pixelColor[1][j2 + 1], pixelTrans[1][j2], pixelTrans[1][j2 + 1])) {
                    needsMore[1][j2 + 1] = true;
                    needsMore[1][j2] = true;
                }
                ++j2;
            }
        } else {
            i = 0;
            while (i < 2) {
                j2 = 0;
                while (j2 < this.width) {
                    int n = this.minRays;
                    raysNeeded[i][j2] = n;
                    raysSent[i][j2] = n;
                    rayColor[0].setRGB(0.0f, 0.0f, 0.0f);
                    rayColor[1].setRGB(0.0f, 0.0f, 0.0f);
                    rayTrans[1] = 0.0;
                    rayTrans[0] = 0.0;
                    k2 = 0;
                    while (k2 < this.minRays) {
                        this.spawnEyeRay(j2, i, k2);
                        if (k2 < this.minRays / 2) {
                            rayColor[0].add(col);
                            rayTrans[0] = rayTrans[0] + this.transparency[0];
                        } else {
                            rayColor[1].add(col);
                            rayTrans[1] = rayTrans[1] + this.transparency[0];
                        }
                        ++k2;
                    }
                    rayColor[0].scale(2.0 / (double)this.minRays);
                    rayColor[1].scale(2.0 / (double)this.minRays);
                    rayTrans[0] = rayTrans[0] * (2.0 / (double)this.minRays);
                    rayTrans[1] = rayTrans[1] * (2.0 / (double)this.minRays);
                    if (this.colorsDifferent(rayColor[0], rayColor[1], rayTrans[0], rayTrans[1])) {
                        raysNeeded[i][j2] = this.minRays * 2;
                        needsMore[(i + 1) % 2][j2] = true;
                        needsMore[i][j2] = true;
                        if (j2 > 0) {
                            needsMore[i][j2 - 1] = true;
                        }
                        if (j2 < this.width - 1) {
                            needsMore[i][j2 + 1] = true;
                        }
                    }
                    pixelColor[i][j2].copy(rayColor[0]);
                    pixelColor[i][j2].add(rayColor[1]);
                    pixelColor[i][j2].scale(0.5);
                    pixelTrans[i][j2] = 0.5 * (rayTrans[0] + rayTrans[1]);
                    if (this.renderThread != thisThread) {
                        return;
                    }
                    ++j2;
                }
                ++i;
            }
        }
        i = 0;
        while (true) {
            int count = this.minRays * 2;
            while (count <= this.maxRays && !done) {
                int m = 0;
                while (m < 2) {
                    j2 = 0;
                    while (j2 < this.width) {
                        if (needsMore[(i + m) % 2][j2] && raysSent[(i + m) % 2][j2] < count) {
                            rayColor[0].copy(pixelColor[(i + m) % 2][j2]);
                            rayColor[0].scale((float)raysSent[(i + m) % 2][j2]);
                            rayTrans[0] = (double)raysSent[(i + m) % 2][j2] * pixelTrans[(i + m) % 2][j2];
                            rayColor[1].setRGB(0.0f, 0.0f, 0.0f);
                            rayTrans[1] = 0.0;
                            k2 = raysSent[(i + m) % 2][j2];
                            while (k2 < count) {
                                this.spawnEyeRay(j2, i + m, k2);
                                if (k2 < count / 2) {
                                    rayColor[0].add(col);
                                    rayTrans[0] = rayTrans[0] + this.transparency[0];
                                } else {
                                    rayColor[1].add(col);
                                    rayTrans[1] = rayTrans[1] + this.transparency[0];
                                }
                                ++k2;
                            }
                            rayColor[0].scale(2.0 / (double)count);
                            rayColor[1].scale(2.0 / (double)count);
                            rayTrans[0] = rayTrans[0] * (2.0 / (double)count);
                            rayTrans[1] = rayTrans[1] * (2.0 / (double)count);
                            if (raysNeeded[(i + m) % 2][j2] <= count && this.colorsDifferent(rayColor[0], rayColor[1], rayTrans[0], rayTrans[1])) {
                                raysNeeded[(i + m) % 2][j2] = 2 * count;
                            }
                            raysSent[(i + m) % 2][j2] = count;
                            needsMore[(i + m) % 2][j2] = false;
                            pixelColor[(i + m) % 2][j2].copy(rayColor[0]);
                            pixelColor[(i + m) % 2][j2].add(rayColor[1]);
                            pixelColor[(i + m) % 2][j2].scale(0.5);
                            pixelTrans[(i + m) % 2][j2] = 0.5 * (rayTrans[0] + rayTrans[1]);
                            if (this.renderThread != thisThread) {
                                return;
                            }
                        }
                        ++j2;
                    }
                    ++m;
                }
                done = true;
                m = 0;
                while (m < 2) {
                    j2 = 0;
                    while (j2 < this.width) {
                        if (raysNeeded[(i + m) % 2][j2] > count) {
                            done = false;
                            needsMore[(i + m + 1) % 2][j2] = true;
                            needsMore[(i + m) % 2][j2] = true;
                            if (j2 > 0) {
                                needsMore[(i + m) % 2][j2 - 1] = true;
                            }
                            if (j2 < this.width - 1) {
                                needsMore[(i + m) % 2][j2 + 1] = true;
                            }
                        }
                        ++j2;
                    }
                    ++m;
                }
                count *= 2;
            }
            j2 = 0;
            while (j2 < this.width) {
                this.pixel[i * this.width + j2] = this.calcARGB(pixelColor[i % 2][j2], pixelTrans[i % 2][j2]);
                ++j2;
            }
            if (System.currentTimeMillis() - updateTime > 5000L) {
                this.imageSource.newPixels();
                this.observer.imageUpdate(this.img, 8, 0, lastUpdated, this.width, i);
                lastUpdated = i;
                updateTime = System.currentTimeMillis();
            }
            if (i == this.height - 2) break;
            j2 = 0;
            while (j2 < this.width) {
                int n = this.minRays;
                raysNeeded[(i + 1) % 2][j2] = n;
                raysSent[(i + 1) % 2][j2] = n;
                needsMore[(i + 1) % 2][j2] = raysNeeded[i % 2][j2] > this.minRays;
                rayColor[0].setRGB(0.0f, 0.0f, 0.0f);
                rayColor[1].setRGB(0.0f, 0.0f, 0.0f);
                rayTrans[1] = 0.0;
                rayTrans[0] = 0.0;
                k2 = 0;
                while (k2 < this.minRays) {
                    this.spawnEyeRay(j2, i + 1, k2);
                    if (k2 < this.minRays / 2) {
                        rayColor[0].add(col);
                        rayTrans[0] = rayTrans[0] + this.transparency[0];
                    } else {
                        rayColor[1].add(col);
                        rayTrans[1] = rayTrans[1] + this.transparency[0];
                    }
                    ++k2;
                }
                rayColor[0].scale(2.0 / (double)this.minRays);
                rayColor[1].scale(2.0 / (double)this.minRays);
                rayTrans[0] = rayTrans[0] * (2.0 / (double)this.minRays);
                rayTrans[1] = rayTrans[1] * (2.0 / (double)this.minRays);
                if (this.colorsDifferent(rayColor[0], rayColor[1], rayTrans[0], rayTrans[1])) {
                    raysNeeded[(i + 1) % 2][j2] = this.minRays * 2;
                    needsMore[(i + 1) % 2][j2] = true;
                    needsMore[i % 2][j2] = true;
                    if (j2 > 0) {
                        needsMore[(i + 1) % 2][j2 - 1] = true;
                    }
                    if (j2 < this.width - 1) {
                        needsMore[(i + 1) % 2][j2 + 1] = true;
                    }
                }
                pixelColor[(i + 1) % 2][j2].copy(rayColor[0]);
                pixelColor[(i + 1) % 2][j2].add(rayColor[1]);
                pixelColor[(i + 1) % 2][j2].scale(0.5);
                pixelTrans[(i + 1) % 2][j2] = 0.5 * (rayTrans[0] + rayTrans[1]);
                if (this.renderThread != thisThread) {
                    return;
                }
                ++j2;
            }
            done = false;
            ++i;
        }
        ++i;
        j2 = 0;
        while (j2 < this.width) {
            this.pixel[i * this.width + j2] = this.calcARGB(pixelColor[i % 2][j2], pixelTrans[i % 2][j2]);
            ++j2;
        }
        this.imageSource.newPixels();
        this.finish();
    }

    private void finish() {
        this.sceneObject = null;
        this.light = null;
        this.rootNode = null;
        this.cameraNode = null;
        this.lightNode = null;
        this.theScene = null;
        this.theCamera = null;
        this.envMapping = null;
        this.renderThread = null;
        this.intersect = null;
        this.matChange = null;
        ImageObserver obs = this.observer;
        this.observer = null;
        if (obs != null) {
            obs.imageUpdate(this.img, 32, 0, 0, this.width, this.height);
        }
        System.gc();
    }

    private int calcARGB(RGBColor color, double t) {
        if (!this.transparentBackground || t <= 0.0) {
            return color.getARGB();
        }
        if (t >= 1.0) {
            return 0;
        }
        double scale = 255.0 / (1.0 - t);
        int a = (int)(255.0 * (1.0 - t));
        int r = (int)((double)color.getRed() * scale);
        int g = (int)((double)color.getGreen() * scale);
        int b = (int)((double)color.getBlue() * scale);
        if (r < 0) {
            r = 0;
        }
        if (r > 255) {
            r = 255;
        }
        if (g < 0) {
            g = 0;
        }
        if (g > 255) {
            g = 255;
        }
        if (b < 0) {
            b = 0;
        }
        if (b > 255) {
            b = 255;
        }
        return (a << 24) + (r << 16) + (g << 8) + b;
    }

    boolean colorsDifferent(RGBColor col1, RGBColor col2, double trans1, double trans2) {
        double sum = col1.getRed() + col2.getRed();
        double diff = Math.abs(col1.getRed() - col2.getRed());
        if (diff >= 0.0078125 && diff >= 0.05 * sum) {
            return true;
        }
        sum = col1.getGreen() + col2.getGreen();
        diff = Math.abs(col1.getGreen() - col2.getGreen());
        if (diff >= 0.0078125 && diff >= 0.05 * sum) {
            return true;
        }
        sum = col1.getBlue() + col2.getBlue();
        diff = Math.abs(col1.getBlue() - col2.getBlue());
        if (diff >= 0.0078125 && diff >= 0.05 * sum) {
            return true;
        }
        if (!this.transparentBackground) {
            return false;
        }
        sum = trans1 + trans2;
        diff = Math.abs(trans1 - trans2);
        return diff >= 0.0078125 && diff >= 0.05 * sum;
    }

    void spawnEyeRay(int i, int j, int number) {
        Vec3 orig = this.ray[0].getOrigin();
        Vec3 dir = this.ray[0].getDirection();
        int quadrant = number % 4;
        double h = (double)i - (double)this.width / 2.0 + 0.5;
        double v = (double)j - (double)this.height / 2.0 + 0.5;
        if (this.antialias) {
            h += Math.random() / 2.0;
            v += Math.random() / 2.0;
            if (quadrant == 1 || quadrant == 3) {
                h += 0.5;
            }
            if (quadrant == 2 || quadrant == 3) {
                v += 0.5;
            }
        }
        orig.set(this.viewpoint);
        if (this.depth) {
            double angle = (Math.random() + (double)distrib1[number % 16]) * Math.PI * 0.5;
            double radius = (Math.random() + (double)distrib2[number % 16]) * 0.25 * 0.01 * (double)this.height * this.focalDist / this.depthOfField;
            double dh = radius * Math.cos(angle);
            double dv = radius * Math.sin(angle);
            orig.x += dh * this.hvec.x + dv * this.vvec.x;
            orig.y += dh * this.hvec.y + dv * this.vvec.y;
            orig.z += dh * this.hvec.z + dv * this.vvec.z;
        }
        this.rayIntensity[0].setRGB(1.0f, 1.0f, 1.0f);
        dir.x = this.center.x + h * this.hvec.x + v * this.vvec.x - orig.x;
        dir.y = this.center.y + h * this.hvec.y + v * this.vvec.y - orig.y;
        dir.z = this.center.z + h * this.hvec.z + v * this.vvec.z - orig.z;
        dir.normalize();
        this.ray[0].newID();
        if (this.cameraNode != null) {
            this.spawnRay(0, this.cameraNode, null, null, null, null, null, number, 0.0, true);
        } else {
            OctreeNode node = this.rootNode.findFirstNode(this.ray[0]);
            if (node == null) {
                if (this.transparentBackground) {
                    this.transparency[0] = 1.0;
                    this.color[0].setRGB(0.0f, 0.0f, 0.0f);
                    return;
                }
                if (this.envMode == 0) {
                    this.color[0].copy(this.envColor);
                    return;
                }
                this.envMapping.getTextureSpec(this.ray[0].direction, this.surfSpec[0], true, this.smoothScale, this.time, null);
                if (this.envMode == 1) {
                    this.color[0].copy(this.surfSpec[0].diffuse);
                } else {
                    this.color[0].copy(this.surfSpec[0].emissive);
                }
                return;
            }
            this.spawnRay(0, node, null, null, null, null, null, number, 0.0, true);
        }
    }

    void spawnRay(int treeDepth, OctreeNode node, RTObject first, MaterialMapping currentMaterial, MaterialMapping prevMaterial, Mat4 currentMatTrans, Mat4 prevMatTrans, int rayNumber, double totalDist, boolean transmitted) {
        OctreeNode nextNode;
        RTObject second = null;
        double beta = 0.0;
        float fract = 0.0f;
        Vec3 intersectionPoint = this.pos[treeDepth];
        Vec3 norm = this.normal[treeDepth];
        Vec3 trueNorm = this.trueNormal[treeDepth];
        boolean totalReflect = false;
        Ray r = this.ray[treeDepth];
        TextureSpec spec = this.surfSpec[treeDepth];
        Mat4 oldMatTrans = null;
        this.transparency[treeDepth] = 0.0;
        if (first != null && first.intersects(r)) {
            first.intersectionPoint(0, intersectionPoint);
            nextNode = this.rootNode.findNode(intersectionPoint);
        } else {
            nextNode = this.traceRay(r, node);
            if (nextNode == null) {
                if (transmitted && this.transparentBackground) {
                    this.color[treeDepth].setRGB(0.0f, 0.0f, 0.0f);
                    this.transparency[treeDepth] = Math.min(Math.min(this.rayIntensity[treeDepth].getRed(), this.rayIntensity[treeDepth].getGreen()), this.rayIntensity[treeDepth].getBlue());
                    return;
                }
                if (this.envMode == 0) {
                    this.color[treeDepth].copy(this.envColor);
                    this.color[treeDepth].multiply(this.rayIntensity[treeDepth]);
                    return;
                }
                this.envMapping.getTextureSpec(r.direction, spec, true, this.smoothScale, this.time, null);
                if (this.envMode == 1) {
                    this.color[treeDepth].copy(spec.diffuse);
                } else {
                    this.color[treeDepth].copy(spec.emissive);
                }
                this.color[treeDepth].multiply(this.rayIntensity[treeDepth]);
                return;
            }
            first = this.intersect.first;
            second = this.intersect.second;
            first.intersectionPoint(0, intersectionPoint);
        }
        double dist = first.intersectionDist(0);
        totalDist += dist;
        first.trueNormal(trueNorm);
        double truedot = trueNorm.dot(r.getDirection());
        if (truedot > 0.0) {
            first.intersectionTexture(spec, false, totalDist * this.smoothScale * 3.0 / (2.0 + truedot));
        } else {
            first.intersectionTexture(spec, true, totalDist * this.smoothScale * 3.0 / (2.0 - truedot));
        }
        first.intersectionNormal(norm);
        this.getDirectLight(intersectionPoint, norm, truedot < 0.0, r.getDirection(), treeDepth, nextNode, rayNumber, totalDist, currentMaterial, prevMaterial, currentMatTrans, prevMatTrans);
        if (currentMaterial != null) {
            this.propagateRay(r, node, dist, currentMaterial, prevMaterial, currentMatTrans, prevMatTrans, this.tempColor, this.rayIntensity[treeDepth], treeDepth, totalDist);
            this.color[treeDepth].multiply(this.rayIntensity[treeDepth]);
            this.color[treeDepth].add(this.tempColor);
        } else if (this.fog) {
            fract = (float)Math.exp(-dist / this.fogDist);
            this.rayIntensity[treeDepth].scale(fract);
            this.color[treeDepth].multiply(this.rayIntensity[treeDepth]);
            this.tempColor.copy(this.fogColor);
            this.tempColor.scale(1.0f - fract);
            this.color[treeDepth].add(this.tempColor);
        } else {
            this.color[treeDepth].multiply(this.rayIntensity[treeDepth]);
        }
        if (treeDepth < this.maxRayDepth - 1) {
            double d;
            Vec3 temp;
            double dot = norm.dot(r.getDirection());
            RGBColor col = this.rayIntensity[treeDepth + 1];
            col.copy(this.rayIntensity[treeDepth]);
            col.multiply(spec.transparent);
            if (col.getRed() > this.minRayIntensity || col.getGreen() > this.minRayIntensity || col.getBlue() > this.minRayIntensity) {
                double n;
                MaterialMapping oldMaterial;
                Mat4 nextMatTrans;
                MaterialMapping nextMaterial;
                this.ray[treeDepth + 1].getOrigin().set(intersectionPoint);
                temp = this.ray[treeDepth + 1].getDirection();
                if (first.getMaterialMapping() == null) {
                    temp.set(r.getDirection());
                    nextMaterial = currentMaterial;
                    nextMatTrans = currentMatTrans;
                    oldMaterial = prevMaterial;
                    oldMatTrans = prevMatTrans;
                } else if (dot < 0.0) {
                    nextMaterial = first.getMaterialMapping();
                    nextMatTrans = first.toLocal();
                    oldMaterial = currentMaterial;
                    oldMatTrans = currentMatTrans;
                    n = currentMaterial == null ? nextMaterial.indexOfRefraction() / 1.0 : nextMaterial.indexOfRefraction() / currentMaterial.indexOfRefraction();
                    beta = -(dot + Math.sqrt(n * n - 1.0 + dot * dot));
                    temp.set(norm);
                    temp.scale(beta);
                    temp.add(r.getDirection());
                    temp.scale(1.0 / n);
                } else {
                    if (currentMaterial == first.getMaterialMapping()) {
                        nextMaterial = prevMaterial;
                        nextMatTrans = prevMatTrans;
                        oldMaterial = null;
                        n = nextMaterial == null ? 1.0 / currentMaterial.indexOfRefraction() : nextMaterial.indexOfRefraction() / currentMaterial.indexOfRefraction();
                    } else {
                        nextMaterial = currentMaterial;
                        nextMatTrans = currentMatTrans;
                        if (prevMaterial == first.getMaterialMapping()) {
                            oldMaterial = null;
                        } else {
                            oldMaterial = prevMaterial;
                            oldMatTrans = prevMatTrans;
                        }
                        n = 1.0;
                    }
                    beta = dot - Math.sqrt(n * n - 1.0 + dot * dot);
                    temp.set(norm);
                    temp.scale(-beta);
                    temp.add(r.getDirection());
                    temp.scale(1.0 / n);
                }
                if (Double.isNaN(beta)) {
                    totalReflect = true;
                } else {
                    d = temp.dot(trueNorm) * (truedot > 0.0 ? 1.0 : -1.0);
                    if (d < 0.0) {
                        temp.x -= (d += 1.0E-12) * trueNorm.x;
                        temp.y -= d * trueNorm.y;
                        temp.z -= d * trueNorm.z;
                        temp.normalize();
                    }
                    this.ray[treeDepth + 1].newID();
                    if (this.gloss) {
                        this.randomizeDirection(temp, norm, spec.cloudiness, rayNumber + treeDepth + 1);
                    }
                    this.spawnRay(treeDepth + 1, nextNode, second, nextMaterial, oldMaterial, nextMatTrans, oldMatTrans, rayNumber, totalDist, transmitted);
                    this.color[treeDepth].add(this.color[treeDepth + 1]);
                    if (transmitted && this.transparentBackground) {
                        this.transparency[treeDepth] = this.transparency[treeDepth + 1];
                    }
                }
            }
            col.copy(spec.specular);
            if (totalReflect) {
                col.add(spec.transparent);
            }
            col.multiply(this.rayIntensity[treeDepth]);
            if (totalReflect || col.getRed() > this.minRayIntensity || col.getGreen() > this.minRayIntensity || col.getBlue() > this.minRayIntensity) {
                temp = this.ray[treeDepth + 1].getDirection();
                temp.set(norm);
                temp.scale(-2.0 * dot);
                temp.add(r.getDirection());
                d = temp.dot(trueNorm) * (truedot > 0.0 ? 1.0 : -1.0);
                if (d >= 0.0) {
                    temp.x += (d += 1.0E-12) * trueNorm.x;
                    temp.y += d * trueNorm.y;
                    temp.z += d * trueNorm.z;
                    temp.normalize();
                }
                this.ray[treeDepth + 1].getOrigin().set(intersectionPoint);
                this.ray[treeDepth + 1].newID();
                if (this.gloss) {
                    this.randomizeDirection(temp, norm, spec.roughness, rayNumber + treeDepth + 1);
                }
                this.spawnRay(treeDepth + 1, nextNode, null, currentMaterial, prevMaterial, currentMatTrans, prevMatTrans, rayNumber, totalDist, false);
                this.color[treeDepth].add(this.color[treeDepth + 1]);
            }
            if (this.traceDiffuse) {
                col.copy(spec.diffuse);
                col.multiply(this.rayIntensity[treeDepth]);
                col.scale(0.5f);
                if (col.getRed() > this.minRayIntensity || col.getGreen() > this.minRayIntensity || col.getBlue() > this.minRayIntensity) {
                    temp = this.ray[treeDepth + 1].getDirection();
                    do {
                        temp.set(0.0, 0.0, 0.0);
                        this.randomizePoint(temp, 1.0, rayNumber + treeDepth + 1);
                        temp.normalize();
                        d = temp.dot(trueNorm) * (truedot > 0.0 ? 1.0 : -1.0);
                    } while (Math.random() > (d < 0.0 ? -d : d));
                    if (d > 0.0) {
                        temp.scale(-1.0);
                    }
                    this.ray[treeDepth + 1].getOrigin().set(intersectionPoint);
                    this.ray[treeDepth + 1].newID();
                    this.spawnRay(treeDepth + 1, nextNode, null, currentMaterial, prevMaterial, currentMatTrans, prevMatTrans, rayNumber, totalDist, false);
                    this.color[treeDepth].add(this.color[treeDepth + 1]);
                }
            }
        }
    }

    void getDirectLight(Vec3 pos, Vec3 normal, boolean front, Vec3 viewDir, int treeDepth, OctreeNode node, int rayNumber, double totalDist, MaterialMapping currentMaterial, MaterialMapping prevMaterial, Mat4 currentMatTrans, Mat4 prevMatTrans) {
        RGBColor lightColor = this.color[treeDepth + 1];
        RGBColor finalColor = this.color[treeDepth];
        TextureSpec spec = this.surfSpec[treeDepth];
        Ray r = this.ray[treeDepth + 1];
        double distToLight = 0.0;
        double fatt = 0.0;
        finalColor.copy(this.ambColor);
        finalColor.multiply(spec.diffuse);
        finalColor.add(spec.emissive);
        r.getOrigin().set(pos);
        Vec3 dir = r.getDirection();
        double sign = front ? 1.0 : -1.0;
        boolean specular = (double)spec.specular.getRed() != 0.0 || (double)spec.specular.getGreen() != 0.0 || (double)spec.specular.getBlue() != 0.0;
        int i = this.light.length - 1;
        while (i >= 0) {
            block13: {
                double dot;
                Light lt;
                block11: {
                    block12: {
                        Vec3 lightPos;
                        block10: {
                            lt = (Light)this.light[i].object;
                            lightPos = this.light[i].coords.getOrigin();
                            if (!(lt instanceof PointLight)) break block10;
                            dir.set(lightPos);
                            if (this.penumbra) {
                                this.randomizePoint(dir, ((PointLight)lt).getRadius(), rayNumber + treeDepth + 1);
                            }
                            dir.subtract(pos);
                            distToLight = dir.length();
                            dir.normalize();
                            break block11;
                        }
                        if (!(lt instanceof SpotLight)) break block12;
                        dir.set(lightPos);
                        if (this.penumbra) {
                            this.randomizePoint(dir, ((SpotLight)lt).getRadius(), rayNumber + treeDepth + 1);
                        }
                        dir.subtract(pos);
                        distToLight = dir.length();
                        dir.normalize();
                        fatt = -dir.dot(this.light[i].coords.getZDirection());
                        if (!(fatt < ((SpotLight)lt).getAngleCosine())) break block11;
                        break block13;
                    }
                    if (lt instanceof DirectionalLight) {
                        dir.set(this.light[i].coords.getZDirection());
                        dir.scale(-1.0);
                        distToLight = Double.MAX_VALUE;
                    }
                }
                r.newID();
                if (lt.isAmbient()) {
                    lt.getLight(lightColor, (float)distToLight);
                    dot = 1.0;
                } else {
                    dot = sign * dir.dot(normal);
                }
                if (dot > 0.0 && (lt.isAmbient() || this.traceLightRay(r, lt, treeDepth + 1, node, this.lightNode[i], distToLight, totalDist, currentMaterial, prevMaterial, currentMatTrans, prevMatTrans))) {
                    this.tempColor.copy(lightColor);
                    this.tempColor.multiply(spec.diffuse);
                    this.tempColor.scale(dot);
                    if (lt instanceof SpotLight) {
                        this.tempColor.scale(Math.pow(fatt, ((SpotLight)lt).getExponent()));
                    }
                    finalColor.add(this.tempColor);
                    if (specular) {
                        dir.subtract(viewDir);
                        dir.normalize();
                        dot = sign * dir.dot(normal);
                        if (dot > 0.0) {
                            this.tempColor.copy(lightColor);
                            this.tempColor.multiply(spec.specular);
                            this.tempColor.scale(Math.pow(dot, (1.0 - spec.roughness) * 128.0 + 1.0));
                            finalColor.add(this.tempColor);
                        }
                    }
                }
            }
            --i;
        }
    }

    OctreeNode traceRay(Ray r, OctreeNode node) {
        RTObject first = null;
        RTObject second = null;
        double firstDist = Double.MAX_VALUE;
        double secondDist = Double.MAX_VALUE;
        Vec3 intersectionPoint = this.pos[this.maxRayDepth];
        while (first == null) {
            RTObject[] obj = node.getObjects();
            int i = obj.length - 1;
            while (i >= 0) {
                if (obj[i].intersects(r)) {
                    obj[i].intersectionPoint(0, intersectionPoint);
                    if (node.getBounds().contains(intersectionPoint)) {
                        double dist = obj[i].intersectionDist(0);
                        if (dist < firstDist) {
                            secondDist = firstDist;
                            second = first;
                            firstDist = dist;
                            first = obj[i];
                        } else if (dist < secondDist) {
                            secondDist = dist;
                            second = obj[i];
                        }
                    }
                }
                --i;
            }
            if (first != null || (node = node.findNextNode(r)) != null) continue;
            return null;
        }
        this.intersect.first = first;
        this.intersect.dist = firstDist;
        if (secondDist - firstDist < 1.0E-12) {
            this.intersect.second = second;
        }
        return node;
    }

    boolean traceLightRay(Ray r, Light lt, int treeDepth, OctreeNode node, OctreeNode endNode, double distToLight, double totalDist, MaterialMapping currentMaterial, MaterialMapping prevMaterial, Mat4 currentMatTrans, Mat4 prevMatTrans) {
        double dist;
        int i;
        RGBColor lightColor = this.color[treeDepth];
        RGBColor transColor = this.surfSpec[treeDepth].transparent;
        Vec3 intersectionPoint = this.pos[this.maxRayDepth];
        Vec3 norm = this.normal[this.maxRayDepth];
        Vec3 trueNorm = this.trueNormal[this.maxRayDepth];
        int matCount = 0;
        lt.getLight(lightColor, (float)distToLight);
        do {
            RTObject[] obj = node.getObjects();
            i = obj.length - 1;
            while (i >= 0) {
                if (obj[i].intersects(r)) {
                    int j = 0;
                    while (true) {
                        if ((dist = obj[i].intersectionDist(j)) < distToLight) {
                            obj[i].trueNormal(trueNorm);
                            boolean front = trueNorm.dot(r.getDirection()) > 0.0;
                            obj[i].intersectionTransparency(j, transColor, front, (totalDist + dist) * this.smoothScale);
                            lightColor.multiply(transColor);
                            if (lightColor.getRed() < this.minRayIntensity && lightColor.getGreen() < this.minRayIntensity && lightColor.getBlue() < this.minRayIntensity) {
                                return false;
                            }
                            MaterialMapping mat = obj[i].getMaterialMapping();
                            if (mat != null && mat.castsShadows()) {
                                obj[i].intersectionPoint(j, intersectionPoint);
                                if (node.getBounds().contains(intersectionPoint)) {
                                    this.matChange[matCount].mat = mat;
                                    this.matChange[matCount].toLocal = obj[i].toLocal();
                                    this.matChange[matCount].dist = dist;
                                    this.matChange[matCount].node = node;
                                    if (j == 0) {
                                        obj[i].trueNormal(norm);
                                        this.matChange[matCount].entered = norm.dot(r.direction) < 0.0;
                                    } else {
                                        this.matChange[matCount].entered = !this.matChange[matCount - 1].entered;
                                    }
                                    ++matCount;
                                }
                            }
                        }
                        if (j >= obj[i].numIntersections() - 1) break;
                        ++j;
                    }
                }
                --i;
            }
        } while (node != endNode && (node = node.findNextNode(r)) != null);
        if (currentMaterial == null && matCount == 0) {
            return true;
        }
        this.sortMaterialList(matCount);
        this.matChange[matCount++].dist = distToLight;
        dist = 0.0;
        i = 0;
        while (i < matCount) {
            if (currentMaterial != null && currentMaterial.castsShadows()) {
                this.propagateLightRay(r, node, dist, this.matChange[i].dist, currentMaterial, lightColor, currentMatTrans, totalDist);
                if (lightColor.getRed() < this.minRayIntensity && lightColor.getGreen() < this.minRayIntensity && lightColor.getBlue() < this.minRayIntensity) {
                    return false;
                }
            }
            if (this.matChange[i].entered) {
                if (this.matChange[i].mat != currentMaterial) {
                    prevMaterial = currentMaterial;
                    prevMatTrans = currentMatTrans;
                    currentMaterial = this.matChange[i].mat;
                    currentMatTrans = this.matChange[i].toLocal;
                }
            } else if (this.matChange[i].mat == currentMaterial) {
                currentMaterial = prevMaterial;
                currentMatTrans = prevMatTrans;
                prevMaterial = null;
            } else if (this.matChange[i].mat == prevMaterial) {
                prevMaterial = null;
            }
            node = this.matChange[i].node;
            dist = this.matChange[i].dist;
            ++i;
        }
        return true;
    }

    void propagateRay(Ray r, OctreeNode node, double dist, MaterialMapping material, MaterialMapping prevMaterial, Mat4 currentMatTrans, Mat4 prevMatTrans, RGBColor emitted, RGBColor filter, int treeDepth, double totalDist) {
        float be;
        float ge;
        float re;
        boolean scattering = material.isScattering();
        float rf = filter.getRed();
        float gf = filter.getGreen();
        float bf = filter.getBlue();
        if (material instanceof UniformMaterialMapping && !scattering) {
            material.getMaterialSpec(r.origin, this.matSpec, 0.0, this.time);
            RGBColor trans = this.matSpec.transparency;
            RGBColor blend = this.matSpec.color;
            float d = (float)dist;
            float rs = trans.getRed() == 1.0f ? 1.0f : (float)Math.pow(trans.getRed(), d);
            float gs = trans.getGreen() == 1.0f ? 1.0f : (float)Math.pow(trans.getGreen(), d);
            float bs = trans.getBlue() == 1.0f ? 1.0f : (float)Math.pow(trans.getBlue(), d);
            re = blend.getRed() * rf * (1.0f - rs);
            ge = blend.getGreen() * gf * (1.0f - gs);
            be = blend.getBlue() * bf * (1.0f - bs);
            rf *= rs;
            gf *= gs;
            bf *= bs;
        } else {
            Vec3 v = this.ray[treeDepth + 1].origin;
            Vec3 origin = r.origin;
            Vec3 direction = r.direction;
            double x = 0.0;
            double distToScreen = this.theCamera.getDistToScreen();
            v.set(origin);
            currentMatTrans.transform(v);
            double origx = v.x;
            double origy = v.y;
            double origz = v.z;
            v.set(direction);
            currentMatTrans.transformDirection(v);
            double dirx = v.x;
            double diry = v.y;
            double dirz = v.z;
            be = 0.0f;
            ge = 0.0f;
            re = 0.0f;
            double step = this.stepSize * material.getStepSize();
            do {
                double newx;
                double dx = this.antialias ? step * (0.75 + Math.random() * 0.25) : step;
                if (this.adaptive && totalDist > distToScreen) {
                    dx *= totalDist / distToScreen;
                }
                if ((newx = x + dx) > dist) {
                    dx = dist - x;
                    x = dist;
                } else {
                    x = newx;
                }
                totalDist += dx;
                v.set(origx + dirx * x, origy + diry * x, origz + dirz * x);
                material.getMaterialSpec(v, this.matSpec, dx, this.time);
                RGBColor trans = this.matSpec.transparency;
                RGBColor blend = this.matSpec.color;
                float rs = trans.getRed() == 1.0f ? 1.0f : (float)Math.pow(trans.getRed(), dx);
                float gs = trans.getGreen() == 1.0f ? 1.0f : (float)Math.pow(trans.getGreen(), dx);
                float bs = trans.getBlue() == 1.0f ? 1.0f : (float)Math.pow(trans.getBlue(), dx);
                re += blend.getRed() * rf * (1.0f - rs);
                ge += blend.getGreen() * gf * (1.0f - gs);
                be += blend.getBlue() * bf * (1.0f - bs);
                if (scattering) {
                    while (!node.contains(v)) {
                        OctreeNode nextNode = node.findNextNode(r);
                        if (nextNode == null) break;
                        node = nextNode;
                    }
                    this.rayIntensity[treeDepth + 1].setRGB(rf * (float)dx, gf * (float)dx, bf * (float)dx);
                    this.rayIntensity[treeDepth + 1].multiply(this.matSpec.scattering);
                    if (this.rayIntensity[treeDepth + 1].getRed() > this.minRayIntensity || this.rayIntensity[treeDepth + 1].getGreen() > this.minRayIntensity || this.rayIntensity[treeDepth + 1].getBlue() > this.minRayIntensity) {
                        v.set(origin.x + direction.x * x, origin.y + direction.y * x, origin.z + direction.z * x);
                        this.getScatteredLight(treeDepth + 1, node, this.matSpec.eccentricity, totalDist, material, prevMaterial, currentMatTrans, prevMatTrans);
                        re += this.color[treeDepth + 1].getRed();
                        ge += this.color[treeDepth + 1].getGreen();
                        be += this.color[treeDepth + 1].getBlue();
                    }
                }
                rf *= rs;
                gf *= gs;
                bf *= bs;
                if (!(rf < this.minRayIntensity) || !(gf < this.minRayIntensity) || !(bf < this.minRayIntensity)) continue;
                bf = 0.0f;
                gf = 0.0f;
                rf = 0.0f;
                break;
            } while (x < dist);
        }
        emitted.setRGB(re, ge, be);
        filter.setRGB(rf, gf, bf);
    }

    void propagateLightRay(Ray r, OctreeNode node, double startDist, double endDist, MaterialMapping material, RGBColor filter, Mat4 toLocal, double totalDist) {
        float rf = filter.getRed();
        float gf = filter.getGreen();
        float bf = filter.getBlue();
        if (material instanceof UniformMaterialMapping) {
            material.getMaterialSpec(r.origin, this.matSpec, 0.0, this.time);
            RGBColor trans = this.matSpec.transparency;
            float d = (float)(endDist - startDist);
            if (trans.getRed() != 1.0f) {
                rf *= (float)Math.pow(trans.getRed(), d);
            }
            if (trans.getGreen() != 1.0f) {
                gf *= (float)Math.pow(trans.getGreen(), d);
            }
            if (trans.getBlue() != 1.0f) {
                bf *= (float)Math.pow(trans.getBlue(), d);
            }
        } else {
            Vec3 v = this.ray[this.maxRayDepth].origin;
            double x = startDist;
            double distToScreen = this.theCamera.getDistToScreen();
            v.set(r.origin);
            toLocal.transform(v);
            double origx = v.x;
            double origy = v.y;
            double origz = v.z;
            v.set(r.direction);
            toLocal.transformDirection(v);
            double dirx = v.x;
            double diry = v.y;
            double dirz = v.z;
            double step = this.stepSize * material.getStepSize();
            do {
                double newx;
                double dx = this.antialias ? step * (0.75 + Math.random() * 0.25) : step;
                if (this.adaptive && totalDist > distToScreen) {
                    dx *= totalDist / distToScreen;
                }
                if ((newx = x + dx) > endDist) {
                    dx = endDist - x;
                    x = endDist;
                } else {
                    x = newx;
                }
                totalDist += dx;
                v.set(origx + dirx * x, origy + diry * x, origz + dirz * x);
                material.getMaterialSpec(v, this.matSpec, dx, this.time);
                RGBColor trans = this.matSpec.transparency;
                if (trans.getRed() != 1.0f) {
                    rf *= (float)Math.pow(trans.getRed(), dx);
                }
                if (trans.getGreen() != 1.0f) {
                    gf *= (float)Math.pow(trans.getGreen(), dx);
                }
                if (trans.getBlue() != 1.0f) {
                    bf *= (float)Math.pow(trans.getBlue(), dx);
                }
                if (!(rf < this.minRayIntensity) || !(gf < this.minRayIntensity) || !(bf < this.minRayIntensity)) continue;
                bf = 0.0f;
                gf = 0.0f;
                rf = 0.0f;
                break;
            } while (x < endDist);
        }
        filter.setRGB(rf, gf, bf);
    }

    void getScatteredLight(int treeDepth, OctreeNode node, double eccentricity, double totalDist, MaterialMapping currentMaterial, MaterialMapping prevMaterial, Mat4 currentMatTrans, Mat4 prevMatTrans) {
        RGBColor filter = this.rayIntensity[treeDepth];
        Ray r = this.ray[treeDepth];
        Vec3 pos = r.origin;
        Vec3 viewDir = this.ray[treeDepth - 1].direction;
        double distToLight = 0.0;
        double fatt = 0.0;
        double ec2 = eccentricity * eccentricity;
        this.tempColor2.setRGB(0.0f, 0.0f, 0.0f);
        Vec3 dir = r.getDirection();
        int i = this.light.length - 1;
        while (i >= 0) {
            block9: {
                Light lt;
                block7: {
                    block8: {
                        Vec3 lightPos;
                        block6: {
                            lt = (Light)this.light[i].object;
                            lightPos = this.light[i].coords.getOrigin();
                            if (!(lt instanceof PointLight)) break block6;
                            dir.set(lightPos);
                            dir.subtract(pos);
                            distToLight = dir.length();
                            dir.normalize();
                            break block7;
                        }
                        if (!(lt instanceof SpotLight)) break block8;
                        dir.set(lightPos);
                        dir.subtract(pos);
                        distToLight = dir.length();
                        dir.normalize();
                        fatt = -dir.dot(this.light[i].coords.getZDirection());
                        if (!(fatt < ((SpotLight)lt).getAngleCosine())) break block7;
                        break block9;
                    }
                    if (lt instanceof DirectionalLight) {
                        dir.set(this.light[i].coords.getZDirection());
                        dir.scale(-1.0);
                        distToLight = Double.MAX_VALUE;
                    }
                }
                r.newID();
                if (lt.isAmbient()) {
                    lt.getLight(this.color[treeDepth], (float)distToLight);
                }
                if (lt.isAmbient() || this.traceLightRay(r, lt, treeDepth, node, this.lightNode[i], distToLight, totalDist, currentMaterial, prevMaterial, currentMatTrans, prevMatTrans)) {
                    this.tempColor.copy(this.color[treeDepth]);
                    this.tempColor.multiply(filter);
                    if (lt instanceof SpotLight) {
                        this.tempColor.scale(Math.pow(fatt, ((SpotLight)lt).getExponent()));
                    }
                    if (eccentricity != 0.0 && !lt.isAmbient()) {
                        double dot = dir.dot(viewDir);
                        fatt = (1.0 - ec2) / Math.pow(1.0 + ec2 + 2.0 * eccentricity * dot, 1.5);
                        this.tempColor.scale(fatt);
                    }
                    this.tempColor2.add(this.tempColor);
                }
            }
            --i;
        }
        this.color[treeDepth].copy(this.tempColor2);
    }

    void randomizePoint(Vec3 pos, double size, int number) {
        double z;
        double y;
        double x;
        if (size == 0.0) {
            return;
        }
        while ((x = Math.random()) * x + (y = Math.random()) * y + (z = Math.random()) * z > 1.0) {
        }
        x *= size;
        y *= size;
        z *= size;
        int d = distrib1[number % 16];
        if (d < 2) {
            x *= -1.0;
        }
        if (d == 1 || d == 2) {
            y *= -1.0;
        }
        if (distrib2[number % 16] % 2 == 0) {
            z *= -1.0;
        }
        pos.x += x;
        pos.y += y;
        pos.z += z;
    }

    void randomizeDirection(Vec3 dir, Vec3 norm, double roughness, int number) {
        double z;
        double y;
        double x;
        if (roughness == 0.0) {
            return;
        }
        while ((x = Math.random()) * x + (y = Math.random()) * y + (z = Math.random()) * z > 1.0) {
        }
        double scale = Math.pow(roughness, 1.7) * 0.5;
        x *= scale;
        y *= scale;
        z *= scale;
        int d = distrib1[number % 16];
        if (d < 2) {
            x *= -1.0;
        }
        if (d == 1 || d == 2) {
            y *= -1.0;
        }
        if (distrib2[number % 16] % 2 == 0) {
            z *= -1.0;
        }
        double dot1 = dir.dot(norm);
        dir.x += x;
        dir.y += y;
        dir.z += z;
        double dot2 = 2.0 * dir.dot(norm);
        if (dot1 < 0.0 && dot2 > 0.0) {
            dir.x -= dot2 * norm.x;
            dir.y -= dot2 * norm.y;
            dir.z -= dot2 * norm.z;
        } else if (dot1 > 0.0 && dot2 < 0.0) {
            dir.x += dot2 * norm.x;
            dir.y += dot2 * norm.y;
            dir.z += dot2 * norm.z;
        }
        dir.normalize();
    }

    void sortMaterialList(int count) {
        int i = 0;
        while (i < count) {
            boolean done = true;
            int j = i + 1;
            while (j < count) {
                if (this.matChange[j].dist < this.matChange[i].dist) {
                    MaterialIntersection temp = this.matChange[i];
                    this.matChange[i] = this.matChange[j];
                    this.matChange[j] = temp;
                    done = false;
                }
                ++j;
            }
            if (done) {
                return;
            }
            ++i;
        }
    }

    class MaterialIntersection {
        MaterialMapping mat;
        Mat4 toLocal;
        double dist;
        boolean entered;
        OctreeNode node;
    }

    class Intersection {
        RTObject first;
        RTObject second;
        double dist;
    }
}

