/*
 * Decompiled with CFR 0.152.
 */
package artofillusion.translators;

import artofillusion.CoordinateSystem;
import artofillusion.DirectionalLight;
import artofillusion.ModellingApp;
import artofillusion.Object3D;
import artofillusion.ObjectInfo;
import artofillusion.RGBColor;
import artofillusion.Scene;
import artofillusion.SceneCamera;
import artofillusion.TriangleMesh;
import artofillusion.Vec3;
import artofillusion.animation.PositionTrack;
import artofillusion.animation.RotationTrack;
import artofillusion.animation.Track;
import artofillusion.ui.MessageDialog;
import java.awt.FileDialog;
import java.awt.Frame;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.Vector;

public class OBJImporter {
    /*
     * WARNING - void declaration
     */
    public static void importFile(Frame parent) {
        FileDialog fd = new FileDialog(parent, "Import OBJ Fie", 0);
        if (ModellingApp.currentDirectory != null) {
            fd.setDirectory(ModellingApp.currentDirectory);
        }
        fd.show();
        if (fd.getFile() == null) {
            return;
        }
        File f = new File(fd.getDirectory(), fd.getFile());
        ModellingApp.currentDirectory = fd.getDirectory();
        String objName = fd.getFile();
        if (objName.lastIndexOf(46) > 0) {
            objName = objName.substring(0, objName.lastIndexOf(46));
        }
        Scene theScene = new Scene();
        CoordinateSystem coords = new CoordinateSystem(new Vec3(0.0, 0.0, 20.0), new Vec3(0.0, 0.0, -1.0), Vec3.vy());
        ObjectInfo info = new ObjectInfo((Object3D)new SceneCamera(), coords, "Camera 1");
        info.addTrack((Track)new PositionTrack(info), 0);
        info.addTrack((Track)new RotationTrack(info), 1);
        theScene.addObject(info, null);
        info = new ObjectInfo((Object3D)new DirectionalLight(new RGBColor(1.0f, 1.0f, 1.0f), 0.8f), coords.duplicate(), "Light 1");
        info.addTrack((Track)new PositionTrack(info), 0);
        info.addTrack((Track)new RotationTrack(info), 1);
        theScene.addObject(info, null);
        Hashtable<String, Vector> groupTable = new Hashtable<String, Vector>();
        Vector<Vec3> vertex = new Vector<Vec3>();
        Vector<Vec3> normal = new Vector<Vec3>();
        Vector[] face = new Vector[]{new Vector()};
        groupTable.put("default", face[0]);
        int lineno = 0;
        int smoothingGroup = -1;
        VertexInfo[] vertIndex = new VertexInfo[3];
        double[] val = new double[3];
        BufferedReader in = null;
        try {
            String s;
            in = new BufferedReader(new FileReader(f));
            while ((s = in.readLine()) != null) {
                int i;
                String[] fields;
                void var15_16;
                ++lineno;
                if (var15_16.startsWith("#") || (fields = OBJImporter.breakLine((String)var15_16)).length == 0) continue;
                if ("v".equals(fields[0]) && fields.length == 4) {
                    i = 0;
                    while (i < 3) {
                        try {
                            val[i] = new Double(fields[i + 1]);
                        }
                        catch (NumberFormatException ex) {
                            throw new Exception("Illegal value '" + fields[i + 1] + "' found in line " + lineno + ".");
                        }
                        ++i;
                    }
                    vertex.addElement(new Vec3(val[0], val[1], val[2]));
                }
                if ("vn".equals(fields[0]) && fields.length == 4) {
                    i = 0;
                    while (i < 3) {
                        try {
                            val[i] = new Double(fields[i + 1]);
                        }
                        catch (NumberFormatException ex) {
                            throw new Exception("Illegal value '" + fields[i + 1] + "' found in line " + lineno + ".");
                        }
                        ++i;
                    }
                    normal.addElement(new Vec3(val[0], val[1], val[2]));
                    continue;
                }
                if ("f".equals(fields[0])) {
                    if (vertIndex.length != fields.length - 1) {
                        vertIndex = new VertexInfo[fields.length - 1];
                    }
                    i = 0;
                    while (i < vertIndex.length) {
                        vertIndex[i] = OBJImporter.parseVertexSpec(fields[i + 1], vertex, normal, lineno);
                        ++i;
                    }
                    int i2 = 0;
                    while (i2 < face.length) {
                        if (fields.length == 4) {
                            face[i2].addElement(new FaceInfo(vertIndex[0], vertIndex[1], vertIndex[2], smoothingGroup));
                        } else if (fields.length == 5) {
                            face[i2].addElement(new FaceInfo(vertIndex[0], vertIndex[1], vertIndex[2], smoothingGroup));
                            face[i2].addElement(new FaceInfo(vertIndex[2], vertIndex[3], vertIndex[0], smoothingGroup));
                        } else if (fields.length > 5) {
                            int step = 1;
                            while (2 * step < vertIndex.length) {
                                int start = 0;
                                while (start + 2 * step < vertIndex.length) {
                                    face[i2].addElement(new FaceInfo(vertIndex[start], vertIndex[start + step], vertIndex[start + 2 * step], smoothingGroup));
                                    start += 2 * step;
                                }
                                if (start + step < vertIndex.length) {
                                    face[i2].addElement(new FaceInfo(vertIndex[start], vertIndex[start + step], vertIndex[0], smoothingGroup));
                                }
                                step *= 2;
                            }
                        }
                        ++i2;
                    }
                    continue;
                }
                if ("s".equals(fields[0])) {
                    if (fields.length == 1 || "off".equalsIgnoreCase(fields[1])) {
                        smoothingGroup = 0;
                        continue;
                    }
                    try {
                        smoothingGroup = Integer.parseInt(fields[1]);
                        continue;
                    }
                    catch (NumberFormatException ex) {
                        throw new Exception("Illegal value '" + fields[1] + "' found in line " + lineno + ".");
                    }
                }
                if (!"g".equals(fields[0])) continue;
                face = new Vector[fields.length - 1];
                i = 0;
                while (i < face.length) {
                    face[i] = (Vector)groupTable.get(fields[i + 1]);
                    if (face[i] == null) {
                        face[i] = new Vector();
                        groupTable.put(fields[i + 1], face[i]);
                    }
                    ++i;
                }
            }
            Enumeration enumeration = groupTable.keys();
            while (enumeration.hasMoreElements()) {
                String group = (String)enumeration.nextElement();
                Vector groupFaces = (Vector)groupTable.get(group);
                if (groupFaces.size() == 0) continue;
                int[] realIndex = new int[vertex.size()];
                int i = 0;
                while (i < realIndex.length) {
                    realIndex[i] = -1;
                    ++i;
                }
                int[][] fc = new int[groupFaces.size()][];
                int numVert = 0;
                int i3 = 0;
                while (i3 < fc.length) {
                    FaceInfo fi = (FaceInfo)groupFaces.elementAt(i3);
                    int j = 0;
                    while (j < 3) {
                        if (realIndex[fi.getVertex((int)j).vert] == -1) {
                            realIndex[fi.getVertex((int)j).vert] = numVert++;
                        }
                        ++j;
                    }
                    fc[i3] = new int[]{realIndex[fi.v1.vert], realIndex[fi.v2.vert], realIndex[fi.v3.vert]};
                    ++i3;
                }
                Vec3[] vert = new Vec3[numVert];
                Vec3 center = new Vec3();
                int i4 = 0;
                while (i4 < realIndex.length) {
                    if (realIndex[i4] > -1) {
                        vert[realIndex[i4]] = (Vec3)vertex.elementAt(i4);
                        center.add(vert[realIndex[i4]]);
                    }
                    ++i4;
                }
                center.scale(1.0 / (double)vert.length);
                int i5 = 0;
                while (i5 < vert.length) {
                    vert[i5] = vert[i5].minus(center);
                    ++i5;
                }
                coords = new CoordinateSystem(center, Vec3.vz(), Vec3.vy());
                info = new ObjectInfo((Object3D)new TriangleMesh(vert, (int[][])fc), coords, "default".equals(group) ? objName : group);
                info.setTexture(theScene.getDefaultTexture(), theScene.getDefaultTexture().getDefaultMapping());
                info.addTrack((Track)new PositionTrack(info), 0);
                info.addTrack((Track)new RotationTrack(info), 1);
                TriangleMesh.Edge[] edge = ((TriangleMesh)info.object).getEdges();
                int i6 = 0;
                while (i6 < edge.length) {
                    if (edge[i6].f2 != -1) {
                        FaceInfo f1 = (FaceInfo)groupFaces.elementAt(edge[i6].f1);
                        FaceInfo f2 = (FaceInfo)groupFaces.elementAt(edge[i6].f2);
                        if (f1.smoothingGroup == 0 || f1.smoothingGroup != f2.smoothingGroup) {
                            edge[i6].smoothness = 0.0f;
                        } else {
                            int j = 0;
                            while (j < 3) {
                                int k = 0;
                                while (k < 3) {
                                    if (f1.getVertex((int)j).vert == f2.getVertex((int)k).vert) {
                                        int n1 = f1.getVertex((int)j).norm;
                                        int n2 = f2.getVertex((int)k).norm;
                                        if (n1 == n2 || !(((Vec3)normal.elementAt(n1)).distance((Vec3)normal.elementAt(n2)) > 1.0E-10)) break;
                                        edge[i6].smoothness = 0.0f;
                                        break;
                                    }
                                    ++k;
                                }
                                ++j;
                            }
                        }
                    }
                    ++i6;
                }
                theScene.addObject(info, null);
            }
        }
        catch (Exception ex) {
            try {
                in.close();
            }
            catch (Exception ex2) {
                // empty catch block
            }
            new MessageDialog(parent, new String[]{"An error occurred while reading the file:", ex.getMessage()});
            return;
        }
        ModellingApp.newWindow((Scene)theScene);
    }

    private static String[] breakLine(String line) {
        StringTokenizer st = new StringTokenizer(line);
        Vector<String> v = new Vector<String>();
        while (st.hasMoreTokens()) {
            v.addElement(st.nextToken());
        }
        Object[] result = new String[v.size()];
        v.copyInto(result);
        return result;
    }

    private static VertexInfo parseVertexSpec(String spec, Vector vertex, Vector normal, int lineno) throws Exception {
        int index;
        VertexInfo info = new VertexInfo();
        int slash = spec.indexOf(47);
        String realspec = spec;
        if (slash > -1) {
            realspec = spec.substring(0, slash);
        }
        try {
            index = Integer.parseInt(realspec);
        }
        catch (NumberFormatException ex) {
            throw new Exception("Illegal value '" + spec + "' found in line " + lineno + ".");
        }
        index = index < 0 ? (index += vertex.size()) : --index;
        if (index < 0 || index >= vertex.size()) {
            throw new Exception("Illegal value '" + spec + "' found in line " + lineno + ".");
        }
        info.vert = index;
        int lastSlash = spec.lastIndexOf(47);
        if (lastSlash > slash && lastSlash < spec.length() - 1) {
            realspec = spec.substring(lastSlash + 1);
            try {
                index = Integer.parseInt(realspec);
            }
            catch (NumberFormatException ex) {
                throw new Exception("Illegal value '" + spec + "' found in line " + lineno + ".");
            }
            index = index < 0 ? (index += vertex.size()) : --index;
            if (index < 0 || index >= normal.size()) {
                throw new Exception("Illegal value '" + spec + "' found in line " + lineno + ".");
            }
            info.norm = index;
        }
        return info;
    }

    private static class FaceInfo {
        public VertexInfo v1;
        public VertexInfo v2;
        public VertexInfo v3;
        public int smoothingGroup;

        public FaceInfo(VertexInfo v1, VertexInfo v2, VertexInfo v3, int smoothingGroup) {
            this.v1 = v1;
            this.v2 = v2;
            this.v3 = v3;
            this.smoothingGroup = smoothingGroup;
        }

        public VertexInfo getVertex(int which) {
            switch (which) {
                case 0: {
                    return this.v1;
                }
                case 1: {
                    return this.v2;
                }
            }
            return this.v3;
        }
    }

    private static class VertexInfo {
        public int vert;
        public int norm;

        private VertexInfo() {
        }
    }
}

