/*
 * Decompiled with CFR 0.152.
 */
package artofillusion.translators;

import artofillusion.CoordinateSystem;
import artofillusion.Cube;
import artofillusion.Curve;
import artofillusion.Cylinder;
import artofillusion.DirectionalLight;
import artofillusion.Light;
import artofillusion.MeshVertex;
import artofillusion.ModellingApp;
import artofillusion.Object3D;
import artofillusion.ObjectInfo;
import artofillusion.PointLight;
import artofillusion.RGBColor;
import artofillusion.RenderingMesh;
import artofillusion.RenderingTriangle;
import artofillusion.Scene;
import artofillusion.SceneCamera;
import artofillusion.Sphere;
import artofillusion.SpotLight;
import artofillusion.Texture;
import artofillusion.TextureSpec;
import artofillusion.TriangleMesh;
import artofillusion.Vec3;
import artofillusion.WireframeMesh;
import artofillusion.ui.ComponentsDialog;
import artofillusion.ui.MessageDialog;
import artofillusion.ui.ValueField;
import java.awt.Checkbox;
import java.awt.Choice;
import java.awt.Component;
import java.awt.FileDialog;
import java.awt.Frame;
import java.awt.Label;
import java.io.BufferedOutputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.Date;
import java.util.Vector;
import java.util.zip.GZIPOutputStream;

public class VRMLExporter {
    public static void exportFile(Frame parent, Scene theScene) {
        ValueField errorField = new ValueField(0.05, 3);
        Choice exportChoice = new Choice();
        Checkbox compressBox = new Checkbox("Compress Output File", true);
        Checkbox smoothBox = new Checkbox("Subdivide Smooth Meshes", true);
        exportChoice.add("Export Whole Scene");
        exportChoice.add("Selected Objects Only");
        ComponentsDialog dlg = theScene.getSelection().length > 0 ? new ComponentsDialog(parent, "Export to VRML File:", new Component[]{exportChoice, new Label("Maximum Surface Error:"), errorField, compressBox, smoothBox}, new String[]{"", "", "", "", ""}) : new ComponentsDialog(parent, "Export to VRML File:", new Component[]{new Label("Maximum Surface Error:"), errorField, compressBox, smoothBox}, new String[]{"", "", "", ""});
        if (!dlg.clickedOk()) {
            return;
        }
        FileDialog fd = new FileDialog(parent, "Export as VRML", 1);
        String sep = System.getProperty("file.separator");
        if (compressBox.getState()) {
            fd.setFile("Untitled.wrz");
        } else {
            fd.setFile("Untitled.wrl");
        }
        if (ModellingApp.currentDirectory != null) {
            fd.setDirectory(ModellingApp.currentDirectory);
        }
        fd.show();
        if (fd.getFile() == null) {
            return;
        }
        String path = fd.getDirectory().endsWith(sep) ? fd.getDirectory() + fd.getFile() : fd.getDirectory() + sep + fd.getFile();
        ModellingApp.currentDirectory = fd.getDirectory();
        try {
            FileOutputStream fos = new FileOutputStream(path);
            BufferedOutputStream bos = new BufferedOutputStream(fos);
            if (compressBox.getState()) {
                GZIPOutputStream gos = new GZIPOutputStream(bos);
                VRMLExporter.writeScene(theScene, gos, exportChoice.getSelectedIndex() == 0, errorField.getValue(), smoothBox.getState());
                gos.close();
            } else {
                VRMLExporter.writeScene(theScene, bos, exportChoice.getSelectedIndex() == 0, errorField.getValue(), smoothBox.getState());
            }
            bos.close();
            fos.close();
        }
        catch (IOException ex) {
            new MessageDialog(parent, new String[]{"An error occurred while exporting the scene.", ex.getMessage()});
        }
    }

    static void writeScene(Scene theScene, OutputStream os, boolean wholeScene, double tol, boolean smooth) {
        PrintWriter out = new PrintWriter(os);
        int[] selected = theScene.getSelection();
        Vector objects = theScene.getObjects();
        VRMLExporter.write("#VRML V2.0 utf8", out, 0);
        VRMLExporter.write("#Produced by Art of Illusion, " + new Date().toString(), out, 0);
        if (wholeScene) {
            VRMLExporter.write("NavigationInfo {", out, 0);
            VRMLExporter.write("headlight FALSE", out, 1);
            VRMLExporter.write("}", out, 0);
            RGBColor color = theScene.getEnvironmentColor();
            VRMLExporter.write("Background {", out, 0);
            VRMLExporter.write("skyColor " + color.getRed() + " " + color.getGreen() + " " + color.getBlue(), out, 1);
            VRMLExporter.write("}", out, 0);
            color = theScene.getAmbientColor();
            VRMLExporter.write("PointLight {", out, 0);
            VRMLExporter.write("color " + color.getRed() + " " + color.getGreen() + " " + color.getBlue(), out, 1);
            VRMLExporter.write("intensity 0", out, 1);
            VRMLExporter.write("ambientIntensity 1", out, 1);
            VRMLExporter.write("radius 1e15", out, 1);
            VRMLExporter.write("}", out, 0);
            if (theScene.getFogState()) {
                color = theScene.getFogColor();
                VRMLExporter.write("Fog {", out, 0);
                VRMLExporter.write("color " + color.getRed() + " " + color.getGreen() + " " + color.getBlue(), out, 1);
                VRMLExporter.write("fogType \"EXPONENTIAL\"", out, 1);
                VRMLExporter.write("visibilityRange " + 2.0 * theScene.getFogDistance(), out, 1);
                VRMLExporter.write("}", out, 0);
            }
        }
        if (wholeScene) {
            int i = 0;
            while (i < objects.size()) {
                VRMLExporter.writeObject((ObjectInfo)objects.elementAt(i), out, tol, smooth, 0, theScene);
                ++i;
            }
        } else {
            int i = 0;
            while (i < selected.length) {
                VRMLExporter.writeObject((ObjectInfo)objects.elementAt(selected[i]), out, tol, smooth, 0, theScene);
                ++i;
            }
        }
        out.flush();
    }

    static void write(String str, PrintWriter out, int indent) {
        int i = 0;
        while (i < indent) {
            out.print(" ");
            ++i;
        }
        out.print(str);
        out.print("\r\n");
    }

    static void writeObject(ObjectInfo info, PrintWriter out, double tol, boolean smooth, int indent, Scene theScene) {
        CoordinateSystem coords = info.coords;
        Object3D obj = info.object;
        Vec3 orig = coords.getOrigin();
        Vec3 size = obj.getBounds().getSize();
        Vec3 axis = new Vec3(0.0, 0.0, 0.0);
        double[] rot = new double[4];
        double ratio = 0.0;
        double[] pos = new double[3];
        double[] scale = new double[3];
        if (obj instanceof SceneCamera) {
            coords = coords.duplicate();
            coords.setOrientation(info.coords.getZDirection().times(-1.0), info.coords.getUpDirection().times(1.0));
        }
        rot[3] = coords.getAxisAngleRotation(axis);
        pos[0] = (double)Math.round(orig.x * 1000000.0) / 1000000.0;
        pos[1] = (double)Math.round(orig.y * 1000000.0) / 1000000.0;
        pos[2] = (double)Math.round(orig.z * 1000000.0) / 1000000.0;
        scale[0] = (double)Math.round(size.x * 1000000.0) / 1000000.0;
        scale[1] = (double)Math.round(size.y * 1000000.0) / 1000000.0;
        scale[2] = (double)Math.round(size.z * 1000000.0) / 1000000.0;
        rot[0] = (double)Math.round(axis.x * 1000000.0) / 1000000.0;
        rot[1] = (double)Math.round(axis.y * 1000000.0) / 1000000.0;
        rot[2] = (double)Math.round(axis.z * 1000000.0) / 1000000.0;
        rot[3] = (double)Math.round(rot[3] * 1000000.0) / 1000000.0;
        if (obj instanceof DirectionalLight) {
            RGBColor color = ((Light)obj).getColor();
            Vec3 dir = coords.getZDirection();
            VRMLExporter.write("DirectionalLight {", out, indent);
            VRMLExporter.write("direction " + dir.x + " " + dir.y + " " + dir.z, out, indent + 1);
            VRMLExporter.write("color " + color.getRed() + " " + color.getGreen() + " " + color.getBlue(), out, indent + 1);
            VRMLExporter.write("intensity " + ((Light)obj).getIntensity(), out, indent + 1);
            VRMLExporter.write("}", out, indent);
            return;
        }
        if (obj instanceof SpotLight) {
            RGBColor color = ((Light)obj).getColor();
            float decay = ((Light)obj).getDecayRate();
            boolean ambient = ((Light)obj).isAmbient();
            Vec3 dir = coords.getZDirection();
            double inner = Math.acos(Math.pow(0.9, 1.0 / ((SpotLight)obj).getExponent()));
            double outer = Math.acos(Math.pow(0.1, 1.0 / ((SpotLight)obj).getExponent()));
            double cutoff = ((SpotLight)obj).getAngle() / 2.0;
            if (cutoff < outer) {
                outer = cutoff;
            }
            VRMLExporter.write("SpotLight {", out, indent);
            VRMLExporter.write("location " + pos[0] + " " + pos[1] + " " + pos[2], out, indent + 1);
            VRMLExporter.write("direction " + dir.x + " " + dir.y + " " + dir.z, out, indent + 1);
            VRMLExporter.write("cutOffAngle " + outer, out, indent + 1);
            if (inner < outer) {
                VRMLExporter.write("beamWidth " + inner, out, indent + 1);
            }
            VRMLExporter.write("color " + color.getRed() + " " + color.getGreen() + " " + color.getBlue(), out, indent + 1);
            if (ambient) {
                VRMLExporter.write("ambientIntensity " + ((Light)obj).getIntensity(), out, indent + 1);
                VRMLExporter.write("intensity 0", out, indent + 1);
            } else {
                VRMLExporter.write("intensity " + ((Light)obj).getIntensity(), out, indent + 1);
            }
            VRMLExporter.write("attenuation 1 " + decay + " " + decay * decay, out, indent + 1);
            VRMLExporter.write("}", out, indent);
            return;
        }
        if (obj instanceof PointLight) {
            RGBColor color = ((Light)obj).getColor();
            float decay = ((Light)obj).getDecayRate();
            boolean ambient = ((Light)obj).isAmbient();
            VRMLExporter.write("PointLight {", out, indent);
            VRMLExporter.write("location " + pos[0] + " " + pos[1] + " " + pos[2], out, indent + 1);
            VRMLExporter.write("color " + color.getRed() + " " + color.getGreen() + " " + color.getBlue(), out, indent + 1);
            if (ambient) {
                VRMLExporter.write("ambientIntensity " + ((Light)obj).getIntensity(), out, indent + 1);
                VRMLExporter.write("intensity 0", out, indent + 1);
            } else {
                VRMLExporter.write("intensity " + ((Light)obj).getIntensity(), out, indent + 1);
            }
            VRMLExporter.write("attenuation 1 " + decay + " " + decay * decay, out, indent + 1);
            VRMLExporter.write("}", out, indent);
            return;
        }
        if (obj instanceof SceneCamera) {
            VRMLExporter.write("Viewpoint {", out, indent);
            VRMLExporter.write("position " + pos[0] + " " + pos[1] + " " + pos[2], out, indent + 1);
            VRMLExporter.write("orientation " + rot[0] + " " + rot[1] + " " + rot[2] + " " + rot[3], out, indent + 1);
            VRMLExporter.write("fieldOfView " + ((SceneCamera)obj).getFieldOfView() * Math.PI / 180.0, out, indent + 1);
            VRMLExporter.write("description \"" + info.name + "\"", out, indent + 1);
            VRMLExporter.write("}", out, indent);
            return;
        }
        VRMLExporter.write("Transform {", out, indent);
        VRMLExporter.write("translation " + pos[0] + " " + pos[1] + " " + pos[2], out, indent + 1);
        VRMLExporter.write("rotation " + rot[0] + " " + rot[1] + " " + rot[2] + " " + rot[3], out, indent + 1);
        if (obj instanceof Cylinder) {
            ratio = ((Cylinder)obj).getRatio();
        }
        if (obj instanceof Sphere || obj instanceof Cylinder && (ratio == 0.0 || ratio == 1.0)) {
            VRMLExporter.write("scale " + scale[0] / 2.0 + " " + scale[1] / 2.0 + " " + scale[2] / 2.0, out, indent + 1);
        }
        VRMLExporter.write("children [", out, indent + 1);
        if (obj instanceof Cube) {
            VRMLExporter.write("Shape {", out, indent + 2);
            VRMLExporter.writeTexture(info, out, indent + 3, theScene);
            VRMLExporter.write("geometry Box {", out, indent + 3);
            VRMLExporter.write("size " + scale[0] + " " + scale[1] + " " + scale[2], out, indent + 4);
            VRMLExporter.write("}", out, indent + 3);
            VRMLExporter.write("}", out, indent + 2);
        } else if (obj instanceof Cylinder && ratio == 1.0) {
            VRMLExporter.write("Shape {", out, indent + 2);
            VRMLExporter.writeTexture(info, out, indent + 3, theScene);
            VRMLExporter.write("geometry Cylinder {}", out, indent + 3);
            VRMLExporter.write("}", out, indent + 2);
        } else if (obj instanceof Cylinder && ratio == 0.0) {
            VRMLExporter.write("Shape {", out, indent + 2);
            VRMLExporter.writeTexture(info, out, indent + 3, theScene);
            VRMLExporter.write("geometry Cone {}", out, indent + 3);
            VRMLExporter.write("}", out, indent + 2);
        } else if (obj instanceof Sphere) {
            VRMLExporter.write("Shape {", out, indent + 2);
            VRMLExporter.writeTexture(info, out, indent + 3, theScene);
            VRMLExporter.write("geometry Sphere {", out, indent + 3);
            VRMLExporter.write("}", out, indent + 3);
            VRMLExporter.write("}", out, indent + 2);
        } else if (obj instanceof Curve) {
            WireframeMesh mesh = obj.getWireframeMesh();
            if (mesh != null) {
                Vec3[] vert = mesh.vert;
                VRMLExporter.write("Shape {", out, indent + 2);
                VRMLExporter.write("geometry IndexedLineSet {", out, indent + 3);
                VRMLExporter.write("coord Coordinate { point [", out, indent + 4);
                int i = 0;
                while (i < vert.length) {
                    pos[0] = (double)Math.round(vert[i].x * 1000000.0) / 1000000.0;
                    pos[1] = (double)Math.round(vert[i].y * 1000000.0) / 1000000.0;
                    pos[2] = (double)Math.round(vert[i].z * 1000000.0) / 1000000.0;
                    VRMLExporter.write(pos[0] + " " + pos[1] + " " + pos[2] + ",", out, indent + 5);
                    ++i;
                }
                VRMLExporter.write("] }", out, indent + 4);
                VRMLExporter.write("coordIndex [", out, indent + 4);
                int i2 = 0;
                while (i2 < vert.length - 1) {
                    VRMLExporter.write(i2 + ",", out, indent + 5);
                    ++i2;
                }
                if (obj.isClosed()) {
                    VRMLExporter.write(vert.length - 1 + ", 0, -1", out, indent + 5);
                } else {
                    VRMLExporter.write(vert.length - 1 + ", -1", out, indent + 5);
                }
                VRMLExporter.write("]", out, indent + 4);
                VRMLExporter.write("}", out, indent + 3);
                VRMLExporter.write("}", out, indent + 2);
            }
        } else if (obj instanceof TriangleMesh && !smooth) {
            MeshVertex[] vert = ((TriangleMesh)obj).getVertices();
            TriangleMesh.Face[] face = ((TriangleMesh)obj).getFaces();
            VRMLExporter.write("Shape {", out, indent + 2);
            VRMLExporter.writeTexture(info, out, indent + 3, theScene);
            VRMLExporter.write("geometry IndexedFaceSet {", out, indent + 3);
            if (obj.isClosed()) {
                VRMLExporter.write("solid TRUE", out, indent + 4);
            } else {
                VRMLExporter.write("solid FALSE", out, indent + 4);
            }
            VRMLExporter.write("coord Coordinate { point [", out, indent + 4);
            int i = 0;
            while (i < vert.length) {
                pos[0] = (double)Math.round(vert[i].r.x * 1000000.0) / 1000000.0;
                pos[1] = (double)Math.round(vert[i].r.y * 1000000.0) / 1000000.0;
                pos[2] = (double)Math.round(vert[i].r.z * 1000000.0) / 1000000.0;
                VRMLExporter.write(pos[0] + " " + pos[1] + " " + pos[2] + ",", out, indent + 5);
                ++i;
            }
            VRMLExporter.write("] }", out, indent + 4);
            VRMLExporter.write("coordIndex [", out, indent + 4);
            int i3 = 0;
            while (i3 < face.length) {
                VRMLExporter.write(face[i3].v1 + ", " + face[i3].v2 + ", " + face[i3].v3 + ", -1,", out, indent + 5);
                ++i3;
            }
            VRMLExporter.write("]", out, indent + 4);
            VRMLExporter.write("}", out, indent + 3);
            VRMLExporter.write("}", out, indent + 2);
        } else {
            RenderingMesh mesh = obj.getRenderingMesh(tol, false, info);
            if (mesh != null) {
                Vec3[] vert = mesh.vert;
                Vec3[] norm = mesh.norm;
                RenderingTriangle[] tri = mesh.triangle;
                VRMLExporter.write("Shape {", out, indent + 2);
                VRMLExporter.writeTexture(info, out, indent + 3, theScene);
                VRMLExporter.write("geometry IndexedFaceSet {", out, indent + 3);
                if (obj.isClosed()) {
                    VRMLExporter.write("solid TRUE", out, indent + 4);
                } else {
                    VRMLExporter.write("solid FALSE", out, indent + 4);
                }
                VRMLExporter.write("coord Coordinate { point [", out, indent + 4);
                int i = 0;
                while (i < vert.length) {
                    pos[0] = (double)Math.round(vert[i].x * 1000000.0) / 1000000.0;
                    pos[1] = (double)Math.round(vert[i].y * 1000000.0) / 1000000.0;
                    pos[2] = (double)Math.round(vert[i].z * 1000000.0) / 1000000.0;
                    VRMLExporter.write(pos[0] + " " + pos[1] + " " + pos[2] + ",", out, indent + 5);
                    ++i;
                }
                VRMLExporter.write("] }", out, indent + 4);
                VRMLExporter.write("coordIndex [", out, indent + 4);
                int i4 = 0;
                while (i4 < tri.length) {
                    VRMLExporter.write(tri[i4].v1 + ", " + tri[i4].v2 + ", " + tri[i4].v3 + ", -1,", out, indent + 5);
                    ++i4;
                }
                VRMLExporter.write("]", out, indent + 4);
                VRMLExporter.write("normal Normal { vector [", out, indent + 4);
                int i5 = 0;
                while (i5 < norm.length) {
                    pos[0] = (double)Math.round(norm[i5].x * 1000000.0) / 1000000.0;
                    pos[1] = (double)Math.round(norm[i5].y * 1000000.0) / 1000000.0;
                    pos[2] = (double)Math.round(norm[i5].z * 1000000.0) / 1000000.0;
                    VRMLExporter.write(pos[0] + " " + pos[1] + " " + pos[2] + ",", out, indent + 5);
                    ++i5;
                }
                VRMLExporter.write("] }", out, indent + 4);
                VRMLExporter.write("normalIndex [", out, indent + 4);
                int i6 = 0;
                while (i6 < tri.length) {
                    VRMLExporter.write(tri[i6].n1 + ", " + tri[i6].n2 + ", " + tri[i6].n3 + ", -1,", out, indent + 5);
                    ++i6;
                }
                VRMLExporter.write("]", out, indent + 4);
                VRMLExporter.write("}", out, indent + 3);
                VRMLExporter.write("}", out, indent + 2);
            }
        }
        VRMLExporter.write("]", out, indent + 1);
        VRMLExporter.write("}", out, indent);
    }

    static void writeTexture(ObjectInfo info, PrintWriter out, int indent, Scene theScene) {
        Texture tex = info.object.getTexture();
        if (tex == null) {
            return;
        }
        TextureSpec spec = new TextureSpec();
        tex.getAverageSpec(spec, theScene.getTime(), info.texParamValue);
        VRMLExporter.write("appearance Appearance {", out, indent);
        VRMLExporter.write("material Material {", out, indent + 1);
        VRMLExporter.write("diffuseColor " + spec.diffuse.getRed() + " " + spec.diffuse.getGreen() + " " + spec.diffuse.getBlue(), out, indent + 2);
        VRMLExporter.write("emissiveColor " + spec.emissive.getRed() + " " + spec.emissive.getGreen() + " " + spec.emissive.getBlue(), out, indent + 2);
        VRMLExporter.write("specularColor " + spec.specular.getRed() + " " + spec.specular.getGreen() + " " + spec.specular.getBlue(), out, indent + 2);
        VRMLExporter.write("shininess " + (1.0 - spec.roughness), out, indent + 2);
        VRMLExporter.write("transparency " + Math.max(spec.transparent.getRed(), Math.max(spec.transparent.getGreen(), spec.transparent.getBlue())), out, indent + 2);
        VRMLExporter.write("ambientIntensity 1", out, indent + 2);
        VRMLExporter.write("}", out, indent + 1);
        VRMLExporter.write("}", out, indent);
    }
}

