/*
 * Decompiled with CFR 0.152.
 */
package artofillusion.osspecific;

import artofillusion.EditingTool;
import artofillusion.EditingWindow;
import artofillusion.ModellingApp;
import artofillusion.Plugin;
import artofillusion.Scene;
import artofillusion.UndoRecord;
import java.awt.Component;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Menu;
import java.awt.MenuBar;
import java.awt.MenuItem;
import java.awt.MenuShortcut;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Hashtable;

public class MacOSPlugin
implements Plugin {
    private boolean isMacOS;
    private boolean isMacOSX;

    public void processMessage(int message, Object[] args) {
        if (message == 0) {
            String mrj = (String)((Hashtable)System.getProperties()).get("mrj.version");
            if (mrj == null) {
                return;
            }
            this.isMacOS = true;
            if (!mrj.startsWith("2.")) {
                this.isMacOSX = true;
            }
            ModellingApp.addWindow((EditingWindow)new MacMenuBarWindow());
            if (this.isMacOSX) {
                ModellingApp.defaultFont = new Font("Application", 0, 11);
            }
        }
        if (!this.isMacOS) {
            return;
        }
    }

    private class MacMenuBarWindow
    extends Frame
    implements EditingWindow,
    ActionListener {
        public MacMenuBarWindow() {
            MenuBar menubar = new MenuBar();
            this.setMenuBar(menubar);
            Menu file = new Menu("File");
            menubar.add(file);
            MenuItem item = new MenuItem("New", new MenuShortcut(78));
            file.add(item);
            item.setActionCommand("new");
            item.addActionListener(this);
            item = new MenuItem("Open...", new MenuShortcut(79));
            file.add(item);
            item.setActionCommand("open");
            item.addActionListener(this);
            item = new MenuItem("Quit", new MenuShortcut(81));
            file.add(item);
            item.setActionCommand("quit");
            item.addActionListener(this);
            ((Component)this).setBounds(-1000, -1000, 1, 1);
            this.show();
        }

        public void setTool(EditingTool tool) {
        }

        public void setHelpText(String text) {
        }

        public Frame getFrame() {
            return this;
        }

        public void updateImage() {
        }

        public void updateMenus() {
        }

        public void setUndoRecord(UndoRecord command) {
        }

        public Scene getScene() {
            return null;
        }

        public boolean confirmClose() {
            this.dispose();
            return true;
        }

        public void actionPerformed(ActionEvent ev) {
            String command = ev.getActionCommand();
            if (command.equals("new")) {
                ModellingApp.newWindow();
            } else if (command.equals("open")) {
                ModellingApp.openScene((Frame)this);
            } else if (command.equals("quit")) {
                ModellingApp.quit();
            }
        }
    }
}

