/*
 * Decompiled with CFR 0.152.
 */
package artofillusion.translators;

import artofillusion.ModellingApp;
import artofillusion.Scene;
import artofillusion.math.Mat4;
import artofillusion.math.Vec2;
import artofillusion.math.Vec3;
import artofillusion.object.Mesh;
import artofillusion.object.MeshVertex;
import artofillusion.object.ObjectInfo;
import artofillusion.object.TriangleMesh;
import artofillusion.texture.Mapping2D;
import artofillusion.texture.TextureSpec;
import artofillusion.translators.TextureImageExporter;
import artofillusion.translators.TextureImageInfo;
import artofillusion.ui.ComponentsDialog;
import artofillusion.ui.MessageDialog;
import artofillusion.ui.ValueField;
import artofillusion.ui.ValueSlider;
import java.awt.Checkbox;
import java.awt.Choice;
import java.awt.Component;
import java.awt.FileDialog;
import java.awt.Frame;
import java.awt.Label;
import java.awt.Window;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.PrintWriter;
import java.text.NumberFormat;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Locale;

public class OBJExporter {
    public static void exportFile(Frame parent, Scene theScene) {
        ValueField errorField = new ValueField(0.05, 3);
        final ValueField widthField = new ValueField(200.0, 7);
        final ValueField heightField = new ValueField(200.0, 7);
        final ValueSlider qualitySlider = new ValueSlider(0.0, 1.0, 100, 0.5);
        Choice exportChoice = new Choice();
        final Checkbox mtlBox = new Checkbox("Write textures to .mtl file", false);
        exportChoice.add("Export Whole Scene");
        exportChoice.add("Selected Objects Only");
        ItemListener il = new ItemListener(){

            public void itemStateChanged(ItemEvent ev) {
                widthField.setEnabled(mtlBox.getState());
                heightField.setEnabled(mtlBox.getState());
                qualitySlider.setEnabled(mtlBox.getState());
            }
        };
        il.itemStateChanged(null);
        mtlBox.addItemListener(il);
        ComponentsDialog dlg = theScene.getSelection().length > 0 ? new ComponentsDialog((Window)parent, "Export to Wavefront .obj File:", new Component[]{exportChoice, errorField, mtlBox, new Label("Image Size for Textures:"), widthField, heightField, qualitySlider}, new String[]{null, "Maximum Surface Error", null, null, "Width", "Height", "Image Quality"}) : new ComponentsDialog((Window)parent, "Export to Wavefront .obj File:", new Component[]{errorField, mtlBox, new Label("Image Size for Textures:"), widthField, heightField, qualitySlider}, new String[]{"Maximum Surface Error", null, null, "Width", "Height", "Image Quality"});
        if (!dlg.clickedOk()) {
            return;
        }
        FileDialog fd = new FileDialog(parent, "Export as OBJ", 1);
        fd.setFile("Untitled.obj");
        if (ModellingApp.currentDirectory != null) {
            fd.setDirectory(ModellingApp.currentDirectory);
        }
        fd.show();
        if (fd.getFile() == null) {
            return;
        }
        File dir = new File(fd.getDirectory());
        String name = fd.getFile();
        File f = new File(dir, name);
        String baseName = name.endsWith(".obj") ? name.substring(0, name.length() - 4) : name;
        ModellingApp.currentDirectory = fd.getDirectory();
        try {
            PrintWriter out;
            TextureImageExporter textureExporter = null;
            String mtlFilename = null;
            if (mtlBox.getState()) {
                textureExporter = new TextureImageExporter(dir, baseName, (int)(100.0 * qualitySlider.getValue()), 21, (int)widthField.getValue(), (int)heightField.getValue());
                mtlFilename = baseName + ".mtl";
                out = new PrintWriter(new BufferedWriter(new FileWriter(new File(dir, mtlFilename))));
                OBJExporter.writeTextures(theScene, out, exportChoice.getSelectedIndex() == 0, textureExporter);
                out.close();
                textureExporter.saveImages();
            }
            out = new PrintWriter(new BufferedWriter(new FileWriter(f)));
            OBJExporter.writeScene(theScene, out, exportChoice.getSelectedIndex() == 0, errorField.getValue(), textureExporter, mtlFilename);
            out.close();
        }
        catch (Exception ex) {
            ex.printStackTrace();
            new MessageDialog((Window)parent, new String[]{"An error occurred while exporting the scene.", ex.getMessage()});
        }
    }

    private static void writeScene(Scene theScene, PrintWriter out, boolean wholeScene, double tol, TextureImageExporter textureExporter, String mtlFilename) {
        out.println("#Produced by Art of Illusion 1.4, " + new Date().toString());
        if (mtlFilename != null) {
            out.println("mtllib " + mtlFilename);
        }
        int numVert = 0;
        int numNorm = 0;
        Hashtable<String, String> groupNames = new Hashtable<String, String>();
        NumberFormat nf = NumberFormat.getNumberInstance(Locale.US);
        nf.setMaximumFractionDigits(5);
        int i = 0;
        while (i < theScene.getNumObjects()) {
            TriangleMesh mesh;
            ObjectInfo info = theScene.getObject(i);
            if ((wholeScene || info.selected) && (mesh = info.object.convertToTriangleMesh(tol)) != null) {
                String baseName;
                String name = baseName = info.name.replace(' ', '_');
                int append = 1;
                while (groupNames.get(name) != null) {
                    name = baseName + "_" + append++;
                }
                groupNames.put(name, "");
                out.println("g " + name);
                TextureImageInfo ti = null;
                if (textureExporter != null && (ti = textureExporter.getTextureInfo(info.object.getTexture())) != null) {
                    out.println("usemtl " + ti.name);
                }
                Mat4 trans = info.coords.fromLocal();
                MeshVertex[] vert = mesh.getVertices();
                int j = 0;
                while (j < vert.length) {
                    Vec3 v = trans.times(vert[j].r);
                    out.println("v " + nf.format(v.x) + " " + nf.format(v.y) + " " + nf.format(v.z));
                    ++j;
                }
                Vec3[] norm = mesh.getNormals();
                int j2 = 0;
                while (j2 < norm.length) {
                    if (norm[j2] == null) {
                        out.println("vn 1 0 0");
                    } else {
                        Vec3 v = trans.timesDirection(norm[j2]);
                        out.println("vn " + nf.format(v.x) + " " + nf.format(v.y) + " " + nf.format(v.z));
                    }
                    ++j2;
                }
                TriangleMesh.Face[] face = mesh.getFaces();
                if (ti != null && mesh.getTextureMapping() instanceof Mapping2D) {
                    Vec2[] coords = ((Mapping2D)mesh.getTextureMapping()).findTextureCoordinates((Mesh)mesh, info.texParam);
                    double uscale = ti.maxu == ti.minu ? 1.0 : 1.0 / (ti.maxu - ti.minu);
                    double vscale = ti.maxv == ti.minv ? 1.0 : 1.0 / (ti.maxv - ti.minv);
                    int j3 = 0;
                    while (j3 < coords.length) {
                        double u = (coords[j3].x - ti.minu) * uscale;
                        double v = (coords[j3].y - ti.minv) * vscale;
                        out.println("vt " + nf.format(u) + " " + nf.format(v));
                        ++j3;
                    }
                    int j4 = 0;
                    while (j4 < face.length) {
                        out.println("f " + (face[j4].v1 + numVert + 1) + "/" + (face[j4].v1 + numVert + 1) + "/" + (face[j4].v1 + numNorm + 1) + " " + (face[j4].v2 + numVert + 1) + "/" + (face[j4].v2 + numVert + 1) + "/" + (face[j4].v2 + numNorm + 1) + " " + (face[j4].v3 + numVert + 1) + "/" + (face[j4].v3 + numVert + 1) + "/" + (face[j4].v3 + numNorm + 1));
                        ++j4;
                    }
                } else {
                    int j5 = 0;
                    while (j5 < face.length) {
                        out.println("f " + (face[j5].v1 + numVert + 1) + "//" + (face[j5].v1 + numNorm + 1) + " " + (face[j5].v2 + numVert + 1) + "//" + (face[j5].v2 + numNorm + 1) + " " + (face[j5].v3 + numVert + 1) + "//" + (face[j5].v3 + numNorm + 1));
                        ++j5;
                    }
                }
                numVert += vert.length;
                numNorm += norm.length;
            }
            ++i;
        }
    }

    private static void writeTextures(Scene theScene, PrintWriter out, boolean wholeScene, TextureImageExporter textureExporter) {
        int i = 0;
        while (i < theScene.getNumObjects()) {
            ObjectInfo info = theScene.getObject(i);
            if (wholeScene || info.selected) {
                textureExporter.addObject(info);
            }
            ++i;
        }
        out.println("#Produced by Art of Illusion 1.4, " + new Date().toString());
        Enumeration enumeration = textureExporter.getTextures();
        Hashtable<String, TextureImageInfo> names = new Hashtable<String, TextureImageInfo>();
        TextureSpec spec = new TextureSpec();
        NumberFormat nf = NumberFormat.getNumberInstance(Locale.US);
        nf.setMaximumFractionDigits(5);
        while (enumeration.hasMoreElements()) {
            TextureImageInfo info = (TextureImageInfo)enumeration.nextElement();
            String baseName = info.texture.getName().replace(' ', '_');
            if (names.get(baseName) == null) {
                info.name = baseName;
            } else {
                int i2 = 1;
                while (names.get(baseName + i2) != null) {
                    ++i2;
                }
                info.name = baseName + i2;
            }
            names.put(info.name, info);
            out.println("newmtl " + info.name);
            info.texture.getAverageSpec(spec, 0.0, info.paramValue);
            if (info.diffuseFilename == null) {
                out.println("Kd " + nf.format(spec.diffuse.getRed()) + " " + nf.format(spec.diffuse.getGreen()) + " " + nf.format(spec.diffuse.getBlue()));
            } else {
                out.println("Kd 1 1 1");
                out.println("map_Kd " + info.diffuseFilename);
            }
            if (info.hilightFilename == null) {
                out.println("Ks " + nf.format(spec.hilight.getRed()) + " " + nf.format(spec.hilight.getGreen()) + " " + nf.format(spec.hilight.getBlue()));
            } else {
                out.println("Ks 1 1 1");
                out.println("map_Ks " + info.hilightFilename);
            }
            if (info.emissiveFilename == null) {
                out.println("Ka " + nf.format(spec.emissive.getRed()) + " " + nf.format(spec.emissive.getGreen()) + " " + nf.format(spec.emissive.getBlue()));
            } else {
                out.println("Ka 1 1 1");
                out.println("map_Ka " + info.emissiveFilename);
            }
            if (info.hilightFilename == null && spec.hilight.getRed() == 0.0f && spec.hilight.getGreen() == 0.0f && spec.hilight.getBlue() == 0.0f) {
                out.println("illum 1");
                continue;
            }
            out.println("illum 2");
            out.println("Ns " + (int)((1.0 - spec.roughness) * 128.0 + 1.0));
        }
    }
}

