/*
 * Decompiled with CFR 0.152.
 */
package artofillusion.translators;

import artofillusion.ModellingApp;
import artofillusion.Scene;
import artofillusion.WireframeMesh;
import artofillusion.math.CoordinateSystem;
import artofillusion.math.RGBColor;
import artofillusion.math.Vec2;
import artofillusion.math.Vec3;
import artofillusion.object.Cube;
import artofillusion.object.Curve;
import artofillusion.object.Cylinder;
import artofillusion.object.DirectionalLight;
import artofillusion.object.Light;
import artofillusion.object.Mesh;
import artofillusion.object.MeshVertex;
import artofillusion.object.Object3D;
import artofillusion.object.ObjectCollection;
import artofillusion.object.ObjectInfo;
import artofillusion.object.PointLight;
import artofillusion.object.SceneCamera;
import artofillusion.object.Sphere;
import artofillusion.object.SpotLight;
import artofillusion.object.TriangleMesh;
import artofillusion.texture.Mapping2D;
import artofillusion.texture.Texture;
import artofillusion.texture.TextureSpec;
import artofillusion.translators.TextureImageExporter;
import artofillusion.translators.TextureImageInfo;
import artofillusion.ui.ComponentsDialog;
import artofillusion.ui.MessageDialog;
import artofillusion.ui.ValueField;
import artofillusion.ui.ValueSlider;
import java.awt.Checkbox;
import java.awt.Choice;
import java.awt.Component;
import java.awt.FileDialog;
import java.awt.Frame;
import java.awt.Label;
import java.awt.Window;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.Date;
import java.util.Enumeration;
import java.util.zip.GZIPOutputStream;

public class VRMLExporter {
    public static void exportFile(Frame parent, Scene theScene) {
        ValueField errorField = new ValueField(0.05, 3);
        final ValueField widthField = new ValueField(200.0, 7);
        final ValueField heightField = new ValueField(200.0, 7);
        final ValueSlider qualitySlider = new ValueSlider(0.0, 1.0, 100, 0.5);
        Choice exportChoice = new Choice();
        final Checkbox texBox = new Checkbox("Create Image Files for Textures", false);
        Checkbox compressBox = new Checkbox("Compress Output File", true);
        Checkbox smoothBox = new Checkbox("Subdivide Smooth Meshes", true);
        exportChoice.add("Export Whole Scene");
        exportChoice.add("Selected Objects Only");
        ItemListener il = new ItemListener(){

            public void itemStateChanged(ItemEvent ev) {
                widthField.setEnabled(texBox.getState());
                heightField.setEnabled(texBox.getState());
                qualitySlider.setEnabled(texBox.getState());
            }
        };
        il.itemStateChanged(null);
        texBox.addItemListener(il);
        ComponentsDialog dlg = theScene.getSelection().length > 0 ? new ComponentsDialog((Window)parent, "Export to VRML File:", new Component[]{exportChoice, errorField, compressBox, smoothBox, texBox, new Label("Image Size for Textures:"), widthField, heightField, qualitySlider}, new String[]{null, "Maximum Surface Error:", null, null, null, null, "Width", "Height", "Image Quality"}) : new ComponentsDialog((Window)parent, "Export to VRML File:", new Component[]{errorField, compressBox, smoothBox, texBox, new Label("Image Size for Textures:"), widthField, heightField, qualitySlider}, new String[]{"Maximum Surface Error:", null, null, null, null, "Width", "Height", "Image Quality"});
        if (!dlg.clickedOk()) {
            return;
        }
        FileDialog fd = new FileDialog(parent, "Export as VRML", 1);
        if (compressBox.getState()) {
            fd.setFile("Untitled.wrz");
        } else {
            fd.setFile("Untitled.wrl");
        }
        if (ModellingApp.currentDirectory != null) {
            fd.setDirectory(ModellingApp.currentDirectory);
        }
        fd.show();
        if (fd.getFile() == null) {
            return;
        }
        File dir = new File(fd.getDirectory());
        String name = fd.getFile();
        File f = new File(dir, name);
        String baseName = name.endsWith(".wrl") || name.endsWith(".wrz") ? name.substring(0, name.length() - 4) : name;
        ModellingApp.currentDirectory = fd.getDirectory();
        try {
            TextureImageExporter textureExporter = null;
            if (texBox.getState()) {
                textureExporter = new TextureImageExporter(dir, baseName, (int)(100.0 * qualitySlider.getValue()), 1, (int)widthField.getValue(), (int)heightField.getValue());
                boolean wholeScene = exportChoice.getSelectedIndex() == 0;
                int i = 0;
                while (i < theScene.getNumObjects()) {
                    ObjectInfo info = theScene.getObject(i);
                    if (wholeScene || info.selected) {
                        textureExporter.addObject(info);
                    }
                    ++i;
                }
                textureExporter.saveImages();
            }
            FilterOutputStream out = new BufferedOutputStream(new FileOutputStream(f));
            if (compressBox.getState()) {
                out = new GZIPOutputStream(out);
            }
            VRMLExporter.writeScene(theScene, out, exportChoice.getSelectedIndex() == 0, errorField.getValue(), smoothBox.getState(), textureExporter);
            ((OutputStream)out).close();
        }
        catch (Exception ex) {
            new MessageDialog((Window)parent, new String[]{"An error occurred while exporting the scene.", ex.getMessage()});
        }
    }

    private static void writeScene(Scene theScene, OutputStream os, boolean wholeScene, double tol, boolean smooth, TextureImageExporter textureExporter) {
        PrintWriter out = new PrintWriter(os);
        int[] selected = theScene.getSelection();
        VRMLExporter.write("#VRML V2.0 utf8", out, 0);
        VRMLExporter.write("#Produced by Art of Illusion, " + new Date().toString(), out, 0);
        if (wholeScene) {
            VRMLExporter.write("NavigationInfo {", out, 0);
            VRMLExporter.write("headlight FALSE", out, 1);
            VRMLExporter.write("}", out, 0);
            RGBColor color = theScene.getEnvironmentColor();
            VRMLExporter.write("Background {", out, 0);
            VRMLExporter.write("skyColor " + color.getRed() + " " + color.getGreen() + " " + color.getBlue(), out, 1);
            VRMLExporter.write("}", out, 0);
            color = theScene.getAmbientColor();
            VRMLExporter.write("PointLight {", out, 0);
            VRMLExporter.write("color " + color.getRed() + " " + color.getGreen() + " " + color.getBlue(), out, 1);
            VRMLExporter.write("intensity 0", out, 1);
            VRMLExporter.write("ambientIntensity 1", out, 1);
            VRMLExporter.write("radius 1e15", out, 1);
            VRMLExporter.write("}", out, 0);
            if (theScene.getFogState()) {
                color = theScene.getFogColor();
                VRMLExporter.write("Fog {", out, 0);
                VRMLExporter.write("color " + color.getRed() + " " + color.getGreen() + " " + color.getBlue(), out, 1);
                VRMLExporter.write("fogType \"EXPONENTIAL\"", out, 1);
                VRMLExporter.write("visibilityRange " + 2.0 * theScene.getFogDistance(), out, 1);
                VRMLExporter.write("}", out, 0);
            }
        }
        if (wholeScene) {
            int i = 0;
            while (i < theScene.getNumObjects()) {
                VRMLExporter.writeObject(theScene.getObject(i), out, tol, smooth, 0, theScene, textureExporter);
                ++i;
            }
        } else {
            int i = 0;
            while (i < selected.length) {
                VRMLExporter.writeObject(theScene.getObject(selected[i]), out, tol, smooth, 0, theScene, textureExporter);
                ++i;
            }
        }
        out.flush();
    }

    private static void write(String str, PrintWriter out, int indent) {
        int i = 0;
        while (i < indent) {
            out.print(" ");
            ++i;
        }
        out.print(str);
        out.print("\r\n");
    }

    private static void writeObject(ObjectInfo info, PrintWriter out, double tol, boolean smooth, int indent, Scene theScene, TextureImageExporter textureExporter) {
        boolean hasTexture;
        CoordinateSystem coords = info.coords;
        Object3D obj = info.object;
        Vec3 orig = coords.getOrigin();
        Vec3 size = info.getBounds().getSize();
        Vec3 axis = new Vec3(0.0, 0.0, 0.0);
        double[] rot = new double[4];
        double ratio = 0.0;
        double[] pos = new double[3];
        double[] scale = new double[3];
        if (obj instanceof SceneCamera) {
            coords = coords.duplicate();
            coords.setOrientation(info.coords.getZDirection().times(-1.0), info.coords.getUpDirection().times(1.0));
        }
        rot[3] = coords.getAxisAngleRotation(axis);
        pos[0] = (double)Math.round(orig.x * 1000000.0) / 1000000.0;
        pos[1] = (double)Math.round(orig.y * 1000000.0) / 1000000.0;
        pos[2] = (double)Math.round(orig.z * 1000000.0) / 1000000.0;
        scale[0] = (double)Math.round(size.x * 1000000.0) / 1000000.0;
        scale[1] = (double)Math.round(size.y * 1000000.0) / 1000000.0;
        scale[2] = (double)Math.round(size.z * 1000000.0) / 1000000.0;
        rot[0] = (double)Math.round(axis.x * 1000000.0) / 1000000.0;
        rot[1] = (double)Math.round(axis.y * 1000000.0) / 1000000.0;
        rot[2] = (double)Math.round(axis.z * 1000000.0) / 1000000.0;
        rot[3] = (double)Math.round(rot[3] * 1000000.0) / 1000000.0;
        if (obj instanceof DirectionalLight) {
            RGBColor color = ((Light)obj).getColor();
            Vec3 dir = coords.getZDirection();
            VRMLExporter.write("DirectionalLight {", out, indent);
            VRMLExporter.write("direction " + dir.x + " " + dir.y + " " + dir.z, out, indent + 1);
            VRMLExporter.write("color " + color.getRed() + " " + color.getGreen() + " " + color.getBlue(), out, indent + 1);
            VRMLExporter.write("intensity " + ((Light)obj).getIntensity(), out, indent + 1);
            VRMLExporter.write("}", out, indent);
            return;
        }
        if (obj instanceof SpotLight) {
            RGBColor color = ((Light)obj).getColor();
            float decay = ((Light)obj).getDecayRate();
            boolean ambient = ((Light)obj).isAmbient();
            Vec3 dir = coords.getZDirection();
            double inner = Math.acos(Math.pow(0.9, 1.0 / ((SpotLight)obj).getExponent()));
            double outer = Math.acos(Math.pow(0.1, 1.0 / ((SpotLight)obj).getExponent()));
            double cutoff = ((SpotLight)obj).getAngle() / 2.0;
            if (cutoff < outer) {
                outer = cutoff;
            }
            VRMLExporter.write("SpotLight {", out, indent);
            VRMLExporter.write("location " + pos[0] + " " + pos[1] + " " + pos[2], out, indent + 1);
            VRMLExporter.write("direction " + dir.x + " " + dir.y + " " + dir.z, out, indent + 1);
            VRMLExporter.write("cutOffAngle " + outer, out, indent + 1);
            if (inner < outer) {
                VRMLExporter.write("beamWidth " + inner, out, indent + 1);
            }
            VRMLExporter.write("color " + color.getRed() + " " + color.getGreen() + " " + color.getBlue(), out, indent + 1);
            if (ambient) {
                VRMLExporter.write("ambientIntensity " + ((Light)obj).getIntensity(), out, indent + 1);
                VRMLExporter.write("intensity 0", out, indent + 1);
            } else {
                VRMLExporter.write("intensity " + ((Light)obj).getIntensity(), out, indent + 1);
            }
            VRMLExporter.write("attenuation 1 " + decay + " " + decay * decay, out, indent + 1);
            VRMLExporter.write("}", out, indent);
            return;
        }
        if (obj instanceof PointLight) {
            RGBColor color = ((Light)obj).getColor();
            float decay = ((Light)obj).getDecayRate();
            boolean ambient = ((Light)obj).isAmbient();
            VRMLExporter.write("PointLight {", out, indent);
            VRMLExporter.write("location " + pos[0] + " " + pos[1] + " " + pos[2], out, indent + 1);
            VRMLExporter.write("color " + color.getRed() + " " + color.getGreen() + " " + color.getBlue(), out, indent + 1);
            if (ambient) {
                VRMLExporter.write("ambientIntensity " + ((Light)obj).getIntensity(), out, indent + 1);
                VRMLExporter.write("intensity 0", out, indent + 1);
            } else {
                VRMLExporter.write("intensity " + ((Light)obj).getIntensity(), out, indent + 1);
            }
            VRMLExporter.write("attenuation 1 " + decay + " " + decay * decay, out, indent + 1);
            VRMLExporter.write("}", out, indent);
            return;
        }
        if (obj instanceof SceneCamera) {
            VRMLExporter.write("Viewpoint {", out, indent);
            VRMLExporter.write("position " + pos[0] + " " + pos[1] + " " + pos[2], out, indent + 1);
            VRMLExporter.write("orientation " + rot[0] + " " + rot[1] + " " + rot[2] + " " + rot[3], out, indent + 1);
            VRMLExporter.write("fieldOfView " + ((SceneCamera)obj).getFieldOfView() * Math.PI / 180.0, out, indent + 1);
            VRMLExporter.write("description \"" + info.name + "\"", out, indent + 1);
            VRMLExporter.write("}", out, indent);
            return;
        }
        VRMLExporter.write("Transform {", out, indent);
        VRMLExporter.write("translation " + pos[0] + " " + pos[1] + " " + pos[2], out, indent + 1);
        VRMLExporter.write("rotation " + rot[0] + " " + rot[1] + " " + rot[2] + " " + rot[3], out, indent + 1);
        if (obj instanceof Cylinder) {
            ratio = ((Cylinder)obj).getRatio();
        }
        if (obj instanceof Sphere || obj instanceof Cylinder && (ratio == 0.0 || ratio == 1.0)) {
            VRMLExporter.write("scale " + scale[0] / 2.0 + " " + scale[1] / 2.0 + " " + scale[2] / 2.0, out, indent + 1);
        }
        VRMLExporter.write("children [", out, indent + 1);
        TextureImageInfo ti = textureExporter == null ? null : textureExporter.getTextureInfo(obj.getTexture());
        boolean bl = hasTexture = ti != null && ti.diffuseFilename != null;
        if (obj instanceof Cube && !hasTexture) {
            VRMLExporter.write("Shape {", out, indent + 2);
            VRMLExporter.writeTexture(info, out, indent + 3, theScene, textureExporter);
            VRMLExporter.write("geometry Box {", out, indent + 3);
            VRMLExporter.write("size " + scale[0] + " " + scale[1] + " " + scale[2], out, indent + 4);
            VRMLExporter.write("}", out, indent + 3);
            VRMLExporter.write("}", out, indent + 2);
        } else if (obj instanceof Cylinder && ratio == 1.0 && !hasTexture) {
            VRMLExporter.write("Shape {", out, indent + 2);
            VRMLExporter.writeTexture(info, out, indent + 3, theScene, textureExporter);
            VRMLExporter.write("geometry Cylinder {}", out, indent + 3);
            VRMLExporter.write("}", out, indent + 2);
        } else if (obj instanceof Cylinder && ratio == 0.0 && !hasTexture) {
            VRMLExporter.write("Shape {", out, indent + 2);
            VRMLExporter.writeTexture(info, out, indent + 3, theScene, textureExporter);
            VRMLExporter.write("geometry Cone {}", out, indent + 3);
            VRMLExporter.write("}", out, indent + 2);
        } else if (obj instanceof Sphere && !hasTexture) {
            VRMLExporter.write("Shape {", out, indent + 2);
            VRMLExporter.writeTexture(info, out, indent + 3, theScene, textureExporter);
            VRMLExporter.write("geometry Sphere {", out, indent + 3);
            VRMLExporter.write("}", out, indent + 3);
            VRMLExporter.write("}", out, indent + 2);
        } else if (obj instanceof Curve) {
            WireframeMesh mesh = obj.getWireframeMesh();
            if (mesh != null) {
                Vec3[] vert = mesh.vert;
                VRMLExporter.write("Shape {", out, indent + 2);
                VRMLExporter.write("geometry IndexedLineSet {", out, indent + 3);
                VRMLExporter.write("coord Coordinate { point [", out, indent + 4);
                int i = 0;
                while (i < vert.length) {
                    pos[0] = (double)Math.round(vert[i].x * 1000000.0) / 1000000.0;
                    pos[1] = (double)Math.round(vert[i].y * 1000000.0) / 1000000.0;
                    pos[2] = (double)Math.round(vert[i].z * 1000000.0) / 1000000.0;
                    VRMLExporter.write(pos[0] + " " + pos[1] + " " + pos[2] + ",", out, indent + 5);
                    ++i;
                }
                VRMLExporter.write("] }", out, indent + 4);
                VRMLExporter.write("coordIndex [", out, indent + 4);
                int i2 = 0;
                while (i2 < vert.length - 1) {
                    VRMLExporter.write(i2 + ",", out, indent + 5);
                    ++i2;
                }
                if (obj.isClosed()) {
                    VRMLExporter.write(vert.length - 1 + ", 0, -1", out, indent + 5);
                } else {
                    VRMLExporter.write(vert.length - 1 + ", -1", out, indent + 5);
                }
                VRMLExporter.write("]", out, indent + 4);
                VRMLExporter.write("}", out, indent + 3);
                VRMLExporter.write("}", out, indent + 2);
            }
        } else if (obj instanceof TriangleMesh && !smooth) {
            VRMLExporter.writeMesh((TriangleMesh)obj, info, out, indent + 2, theScene, textureExporter, false);
        } else if (obj instanceof ObjectCollection) {
            Enumeration enumeration = ((ObjectCollection)obj).getObjects(info, false, theScene);
            while (enumeration.hasMoreElements()) {
                VRMLExporter.writeObject((ObjectInfo)enumeration.nextElement(), out, tol, smooth, indent + 2, theScene, textureExporter);
            }
        } else {
            TriangleMesh mesh = info.object.convertToTriangleMesh(tol);
            if (mesh != null) {
                VRMLExporter.writeMesh(mesh, info, out, indent + 2, theScene, textureExporter, true);
            }
        }
        VRMLExporter.write("]", out, indent + 1);
        VRMLExporter.write("}", out, indent);
    }

    private static void writeMesh(TriangleMesh mesh, ObjectInfo info, PrintWriter out, int indent, Scene theScene, TextureImageExporter textureExporter, boolean includeNormals) {
        TextureImageInfo ti;
        MeshVertex[] vert = mesh.getVertices();
        TriangleMesh.Face[] face = mesh.getFaces();
        double[] pos = new double[3];
        VRMLExporter.write("Shape {", out, indent);
        VRMLExporter.writeTexture(info, out, indent + 1, theScene, textureExporter);
        VRMLExporter.write("geometry IndexedFaceSet {", out, indent + 1);
        if (info.object.isClosed()) {
            VRMLExporter.write("solid TRUE", out, indent + 2);
        } else {
            VRMLExporter.write("solid FALSE", out, indent + 2);
        }
        VRMLExporter.write("coord Coordinate { point [", out, indent + 2);
        int i = 0;
        while (i < vert.length) {
            pos[0] = (double)Math.round(vert[i].r.x * 1000000.0) / 1000000.0;
            pos[1] = (double)Math.round(vert[i].r.y * 1000000.0) / 1000000.0;
            pos[2] = (double)Math.round(vert[i].r.z * 1000000.0) / 1000000.0;
            VRMLExporter.write(pos[0] + " " + pos[1] + " " + pos[2] + ",", out, indent + 3);
            ++i;
        }
        VRMLExporter.write("] }", out, indent + 2);
        VRMLExporter.write("coordIndex [", out, indent + 2);
        int i2 = 0;
        while (i2 < face.length) {
            VRMLExporter.write(face[i2].v1 + ", " + face[i2].v2 + ", " + face[i2].v3 + ", -1,", out, indent + 3);
            ++i2;
        }
        VRMLExporter.write("]", out, indent + 2);
        if (includeNormals) {
            Vec3[] norm = mesh.getNormals();
            VRMLExporter.write("normal Normal { vector [", out, indent + 2);
            int i3 = 0;
            while (i3 < norm.length) {
                if (norm[i3] == null) {
                    VRMLExporter.write("1 0 0,", out, indent + 3);
                } else {
                    pos[0] = (double)Math.round(norm[i3].x * 1000000.0) / 1000000.0;
                    pos[1] = (double)Math.round(norm[i3].y * 1000000.0) / 1000000.0;
                    pos[2] = (double)Math.round(norm[i3].z * 1000000.0) / 1000000.0;
                    VRMLExporter.write(pos[0] + " " + pos[1] + " " + pos[2] + ",", out, indent + 3);
                }
                ++i3;
            }
            VRMLExporter.write("] }", out, indent + 2);
            VRMLExporter.write("normalIndex [", out, indent + 2);
            int i4 = 0;
            while (i4 < face.length) {
                VRMLExporter.write(face[i4].v1 + ", " + face[i4].v2 + ", " + face[i4].v3 + ", -1,", out, indent + 3);
                ++i4;
            }
            VRMLExporter.write("]", out, indent + 2);
        }
        TextureImageInfo textureImageInfo = ti = textureExporter == null ? null : textureExporter.getTextureInfo(mesh.getTexture());
        if (ti != null && mesh.getTextureMapping() instanceof Mapping2D) {
            Vec2[] coords = ((Mapping2D)mesh.getTextureMapping()).findTextureCoordinates((Mesh)mesh, info.texParam);
            double uscale = ti.maxu == ti.minu ? 1.0 : 1.0 / (ti.maxu - ti.minu);
            double vscale = ti.maxv == ti.minv ? 1.0 : 1.0 / (ti.maxv - ti.minv);
            VRMLExporter.write("texCoord TextureCoordinate { point [", out, indent + 2);
            int i5 = 0;
            while (i5 < coords.length) {
                pos[0] = (coords[i5].x - ti.minu) * uscale;
                pos[1] = (coords[i5].y - ti.minv) * vscale;
                pos[0] = (double)Math.round(pos[0] * 1000000.0) / 1000000.0;
                pos[1] = (double)Math.round(pos[1] * 1000000.0) / 1000000.0;
                VRMLExporter.write(pos[0] + " " + pos[1] + ",", out, indent + 3);
                ++i5;
            }
            VRMLExporter.write("] }", out, indent + 2);
            VRMLExporter.write("texCoordIndex [", out, indent + 2);
            int i6 = 0;
            while (i6 < face.length) {
                VRMLExporter.write(face[i6].v1 + ", " + face[i6].v2 + ", " + face[i6].v3 + ", -1,", out, indent + 3);
                ++i6;
            }
            VRMLExporter.write("]", out, indent + 2);
        }
        VRMLExporter.write("}", out, indent + 1);
        VRMLExporter.write("}", out, indent);
    }

    private static void writeTexture(ObjectInfo info, PrintWriter out, int indent, Scene theScene, TextureImageExporter textureExporter) {
        Texture tex = info.object.getTexture();
        if (tex == null) {
            return;
        }
        TextureImageInfo ti = textureExporter == null ? null : textureExporter.getTextureInfo(tex);
        boolean hasMap = ti != null && ti.diffuseFilename != null;
        TextureSpec spec = new TextureSpec();
        tex.getAverageSpec(spec, theScene.getTime(), info.texParamValue);
        VRMLExporter.write("appearance Appearance {", out, indent);
        VRMLExporter.write("material Material {", out, indent + 1);
        if (hasMap) {
            VRMLExporter.write("diffuseColor 1 1 1", out, indent + 2);
        } else {
            VRMLExporter.write("diffuseColor " + spec.diffuse.getRed() + " " + spec.diffuse.getGreen() + " " + spec.diffuse.getBlue(), out, indent + 2);
        }
        VRMLExporter.write("emissiveColor " + spec.emissive.getRed() + " " + spec.emissive.getGreen() + " " + spec.emissive.getBlue(), out, indent + 2);
        VRMLExporter.write("specularColor " + spec.specular.getRed() + " " + spec.specular.getGreen() + " " + spec.specular.getBlue(), out, indent + 2);
        VRMLExporter.write("shininess " + (1.0 - spec.roughness), out, indent + 2);
        VRMLExporter.write("transparency " + Math.max(spec.transparent.getRed(), Math.max(spec.transparent.getGreen(), spec.transparent.getBlue())), out, indent + 2);
        VRMLExporter.write("ambientIntensity 1", out, indent + 2);
        VRMLExporter.write("}", out, indent + 1);
        if (hasMap) {
            VRMLExporter.write("texture ImageTexture {", out, indent + 1);
            VRMLExporter.write("url \"" + ti.diffuseFilename + "\"", out, indent + 2);
            VRMLExporter.write("}", out, indent + 1);
        }
        VRMLExporter.write("}", out, indent);
    }
}

