/*
 * Decompiled with CFR 0.152.
 */
package artofillusion.raytracer;

import artofillusion.math.BoundingBox;
import artofillusion.math.Vec3;
import artofillusion.raytracer.RTObject;
import artofillusion.raytracer.Ray;

public class OctreeNode {
    OctreeNode parent;
    OctreeNode[] child;
    RTObject[] obj;
    boolean terminal;
    boolean divided;
    BoundingBox bounds;
    BoundingBox[] objBounds;
    double midx;
    double midy;
    double midz;
    int depth;
    static final int CELLS = 32;
    static Vec3 nextPos = new Vec3();
    static int[] leftCount = new int[34];
    static int[] rightCount = new int[34];
    static int maxDepth;

    public OctreeNode(BoundingBox nodeBounds, RTObject[] tri, BoundingBox[] bb, OctreeNode parentNode, int treeDepth, int maxDepth) {
        boolean[] inside = new boolean[tri.length];
        this.parent = parentNode;
        this.bounds = nodeBounds;
        this.depth = treeDepth;
        OctreeNode.maxDepth = maxDepth;
        int i = 0;
        int count = 0;
        while (i < tri.length) {
            if (bb[i].intersects(this.bounds) && tri[i].intersectsBox(this.bounds)) {
                inside[i] = true;
                ++count;
            }
            ++i;
        }
        this.obj = new RTObject[count];
        this.objBounds = new BoundingBox[count];
        count = 0;
        i = 0;
        while (i < tri.length) {
            if (inside[i]) {
                this.obj[count] = tri[i];
                this.objBounds[count++] = bb[i];
            }
            ++i;
        }
    }

    void subdivide() {
        this.divided = true;
        if (this.obj.length > 4 && this.depth < maxDepth - 1) {
            boolean splitz;
            this.findMidpoints(this.objBounds);
            boolean splitx = this.midx != this.bounds.maxx;
            boolean splity = this.midy != this.bounds.maxy;
            boolean bl = splitz = this.midz != this.bounds.maxz;
            if (!(splitx || splity || splitz)) {
                this.terminal = true;
                this.objBounds = null;
                return;
            }
            this.child = new OctreeNode[8];
            this.child[0] = new OctreeNode(new BoundingBox(this.bounds.minx, this.midx, this.bounds.miny, this.midy, this.bounds.minz, this.midz), this.obj, this.objBounds, this, this.depth + 1, maxDepth);
            if (splitz) {
                this.child[1] = new OctreeNode(new BoundingBox(this.bounds.minx, this.midx, this.bounds.miny, this.midy, this.bounds.maxz, this.midz), this.obj, this.objBounds, this, this.depth + 1, maxDepth);
            }
            if (splity) {
                this.child[2] = new OctreeNode(new BoundingBox(this.bounds.minx, this.midx, this.bounds.maxy, this.midy, this.bounds.minz, this.midz), this.obj, this.objBounds, this, this.depth + 1, maxDepth);
                if (splitz) {
                    this.child[3] = new OctreeNode(new BoundingBox(this.bounds.minx, this.midx, this.bounds.maxy, this.midy, this.bounds.maxz, this.midz), this.obj, this.objBounds, this, this.depth + 1, maxDepth);
                }
            }
            if (splitx) {
                this.child[4] = new OctreeNode(new BoundingBox(this.bounds.maxx, this.midx, this.bounds.miny, this.midy, this.bounds.minz, this.midz), this.obj, this.objBounds, this, this.depth + 1, maxDepth);
                if (splitz) {
                    this.child[5] = new OctreeNode(new BoundingBox(this.bounds.maxx, this.midx, this.bounds.miny, this.midy, this.bounds.maxz, this.midz), this.obj, this.objBounds, this, this.depth + 1, maxDepth);
                }
                if (splity) {
                    this.child[6] = new OctreeNode(new BoundingBox(this.bounds.maxx, this.midx, this.bounds.maxy, this.midy, this.bounds.minz, this.midz), this.obj, this.objBounds, this, this.depth + 1, maxDepth);
                    if (splitz) {
                        this.child[7] = new OctreeNode(new BoundingBox(this.bounds.maxx, this.midx, this.bounds.maxy, this.midy, this.bounds.maxz, this.midz), this.obj, this.objBounds, this, this.depth + 1, maxDepth);
                    }
                }
            }
            this.obj = null;
        } else {
            this.terminal = true;
        }
        this.objBounds = null;
    }

    public RTObject[] getObjects() {
        return this.obj;
    }

    public BoundingBox getBounds() {
        return this.bounds;
    }

    public OctreeNode findNode(Vec3 pos) {
        if (!this.bounds.contains(pos)) {
            return null;
        }
        OctreeNode current = this;
        if (!this.divided) {
            this.subdivide();
        }
        while (!current.terminal) {
            current = pos.x > current.midx ? (pos.y > current.midy ? (pos.z > current.midz ? current.child[7] : current.child[6]) : (pos.z > current.midz ? current.child[5] : current.child[4])) : (pos.y > current.midy ? (pos.z > current.midz ? current.child[3] : current.child[2]) : (pos.z > current.midz ? current.child[1] : current.child[0]));
            if (current.divided) continue;
            current.subdivide();
        }
        return current;
    }

    public OctreeNode findNextNode(Ray r) {
        double t2;
        double t1;
        double maxt = Double.MAX_VALUE;
        Vec3 orig = r.getOrigin();
        Vec3 dir = r.getDirection();
        if (this.parent == null) {
            return null;
        }
        if (dir.x != 0.0) {
            t1 = (this.bounds.minx - orig.x) / dir.x;
            t2 = (this.bounds.maxx - orig.x) / dir.x;
            if (t1 < t2) {
                if (t2 < maxt) {
                    maxt = t2;
                }
            } else if (t1 < maxt) {
                maxt = t1;
            }
        }
        if (dir.y != 0.0) {
            t1 = (this.bounds.miny - orig.y) / dir.y;
            t2 = (this.bounds.maxy - orig.y) / dir.y;
            if (t1 < t2) {
                if (t2 < maxt) {
                    maxt = t2;
                }
            } else if (t1 < maxt) {
                maxt = t1;
            }
        }
        if (dir.z != 0.0) {
            t1 = (this.bounds.minz - orig.z) / dir.z;
            t2 = (this.bounds.maxz - orig.z) / dir.z;
            if (t1 < t2) {
                if (t2 < maxt) {
                    maxt = t2;
                }
            } else if (t1 < maxt) {
                maxt = t1;
            }
        }
        nextPos.set(orig.x + dir.x * maxt, orig.y + dir.y * maxt, orig.z + dir.z * maxt);
        OctreeNode.nextPos.x = OctreeNode.nextPos.x + (dir.x > 0.0 ? 1.0E-12 : -1.0E-12);
        OctreeNode.nextPos.y = OctreeNode.nextPos.y + (dir.y > 0.0 ? 1.0E-12 : -1.0E-12);
        OctreeNode.nextPos.z = OctreeNode.nextPos.z + (dir.z > 0.0 ? 1.0E-12 : -1.0E-12);
        OctreeNode current = this.parent;
        while (!current.bounds.contains(nextPos)) {
            current = current.parent;
            if (current != null) continue;
            return null;
        }
        while (!current.terminal) {
            current = OctreeNode.nextPos.x > current.midx ? (OctreeNode.nextPos.y > current.midy ? (OctreeNode.nextPos.z > current.midz ? current.child[7] : current.child[6]) : (OctreeNode.nextPos.z > current.midz ? current.child[5] : current.child[4])) : (OctreeNode.nextPos.y > current.midy ? (OctreeNode.nextPos.z > current.midz ? current.child[3] : current.child[2]) : (OctreeNode.nextPos.z > current.midz ? current.child[1] : current.child[0]));
            if (current.divided) continue;
            current.subdivide();
        }
        return current;
    }

    public OctreeNode findFirstNode(Ray r) {
        double t2;
        double t1;
        double mint = -1.7976931348623157E308;
        double maxt = Double.MAX_VALUE;
        Vec3 orig = r.getOrigin();
        Vec3 dir = r.getDirection();
        if (dir.x == 0.0) {
            if (orig.x < this.bounds.minx || orig.x > this.bounds.maxx) {
                return null;
            }
        } else {
            t1 = (this.bounds.minx - orig.x) / dir.x;
            t2 = (this.bounds.maxx - orig.x) / dir.x;
            if (t1 < t2) {
                if (t1 > mint) {
                    mint = t1;
                }
                if (t2 < maxt) {
                    maxt = t2;
                }
            } else {
                if (t2 > mint) {
                    mint = t2;
                }
                if (t1 < maxt) {
                    maxt = t1;
                }
            }
            if (mint > maxt || maxt < 0.0) {
                return null;
            }
        }
        if (dir.y == 0.0) {
            if (orig.y < this.bounds.miny || orig.y > this.bounds.maxy) {
                return null;
            }
        } else {
            t1 = (this.bounds.miny - orig.y) / dir.y;
            t2 = (this.bounds.maxy - orig.y) / dir.y;
            if (t1 < t2) {
                if (t1 > mint) {
                    mint = t1;
                }
                if (t2 < maxt) {
                    maxt = t2;
                }
            } else {
                if (t2 > mint) {
                    mint = t2;
                }
                if (t1 < maxt) {
                    maxt = t1;
                }
            }
            if (mint > maxt || maxt < 0.0) {
                return null;
            }
        }
        if (dir.z == 0.0) {
            if (orig.z < this.bounds.minz || orig.z > this.bounds.maxz) {
                return null;
            }
        } else {
            t1 = (this.bounds.minz - orig.z) / dir.z;
            t2 = (this.bounds.maxz - orig.z) / dir.z;
            if (t1 < t2) {
                if (t1 > mint) {
                    mint = t1;
                }
                if (t2 < maxt) {
                    maxt = t2;
                }
            } else {
                if (t2 > mint) {
                    mint = t2;
                }
                if (t1 < maxt) {
                    maxt = t1;
                }
            }
            if (mint > maxt || maxt < 0.0) {
                return null;
            }
        }
        nextPos.set(orig.x + dir.x * (mint += 1.0E-12), orig.y + dir.y * mint, orig.z + dir.z * mint);
        return this.findNode(nextPos);
    }

    void findMidpoints(BoundingBox[] objBounds) {
        double cost;
        int j;
        double minCost;
        int numToRight;
        int numToLeft;
        double width;
        double max;
        double min;
        int i;
        Vec3 size = this.bounds.getSize();
        double cutoff = size.x > size.y ? (size.x > size.z ? Math.max(size.y, size.z) : size.x) : (size.y > size.z ? Math.max(size.x, size.z) : size.y);
        cutoff *= 0.1;
        if (size.x > cutoff) {
            i = 0;
            while (i < 34) {
                OctreeNode.rightCount[i] = 0;
                OctreeNode.leftCount[i] = 0;
                ++i;
            }
            min = this.bounds.minx;
            max = this.bounds.maxx;
            width = (max - min) / 32.0;
            i = 0;
            while (i < objBounds.length) {
                if (objBounds[i].minx <= min) {
                    leftCount[0] = leftCount[0] + 1;
                } else {
                    int n = (int)((objBounds[i].minx - min) / width) + 1;
                    leftCount[n] = leftCount[n] + 1;
                }
                if (objBounds[i].maxx < max) {
                    int n = (int)((objBounds[i].maxx - min) / width) + 1;
                    rightCount[n] = rightCount[n] + 1;
                }
                ++i;
            }
            numToLeft = 0;
            numToRight = objBounds.length;
            minCost = numToRight * 29;
            j = -1;
            i = 0;
            while (i < 32) {
                cost = (numToLeft += leftCount[i]) * i + (numToRight -= rightCount[i]) * (32 - i);
                if (cost < minCost) {
                    minCost = cost;
                    j = i;
                }
                ++i;
            }
            this.midx = j == -1 ? max : min + (double)j * width;
        } else {
            this.midx = this.bounds.maxx;
        }
        if (size.y > cutoff) {
            i = 0;
            while (i < 34) {
                OctreeNode.rightCount[i] = 0;
                OctreeNode.leftCount[i] = 0;
                ++i;
            }
            min = this.bounds.miny;
            max = this.bounds.maxy;
            width = (max - min) / 32.0;
            i = 0;
            while (i < objBounds.length) {
                if (objBounds[i].miny <= min) {
                    leftCount[0] = leftCount[0] + 1;
                } else {
                    int n = (int)((objBounds[i].miny - min) / width) + 1;
                    leftCount[n] = leftCount[n] + 1;
                }
                if (objBounds[i].maxy < max) {
                    int n = (int)((objBounds[i].maxy - min) / width) + 1;
                    rightCount[n] = rightCount[n] + 1;
                }
                ++i;
            }
            numToLeft = 0;
            numToRight = objBounds.length;
            minCost = numToRight * 29;
            j = -1;
            i = 0;
            while (i < 32) {
                cost = (numToLeft += leftCount[i]) * i + (numToRight -= rightCount[i]) * (32 - i);
                if (cost < minCost) {
                    minCost = cost;
                    j = i;
                }
                ++i;
            }
            this.midy = j == -1 ? max : min + (double)j * width;
        } else {
            this.midy = this.bounds.maxy;
        }
        if (size.z > cutoff) {
            i = 0;
            while (i < 34) {
                OctreeNode.rightCount[i] = 0;
                OctreeNode.leftCount[i] = 0;
                ++i;
            }
            min = this.bounds.minz;
            max = this.bounds.maxz;
            width = (max - min) / 32.0;
            i = 0;
            while (i < objBounds.length) {
                if (objBounds[i].minz <= min) {
                    leftCount[0] = leftCount[0] + 1;
                } else {
                    int n = (int)((objBounds[i].minz - min) / width) + 1;
                    leftCount[n] = leftCount[n] + 1;
                }
                if (objBounds[i].maxz < max) {
                    int n = (int)((objBounds[i].maxz - min) / width) + 1;
                    rightCount[n] = rightCount[n] + 1;
                }
                ++i;
            }
            numToLeft = 0;
            numToRight = objBounds.length;
            minCost = numToRight * 29;
            j = -1;
            i = 0;
            while (i < 32) {
                cost = (numToLeft += leftCount[i]) * i + (numToRight -= rightCount[i]) * (32 - i);
                if (cost < minCost) {
                    minCost = cost;
                    j = i;
                }
                ++i;
            }
            this.midz = j == -1 ? max : min + (double)j * width;
        } else {
            this.midz = this.bounds.maxz;
        }
    }

    public boolean contains(Vec3 p) {
        return this.bounds.contains(p);
    }
}

