/*
 * Decompiled with CFR 0.152.
 */
package artofillusion.raytracer;

import artofillusion.math.RGBColor;

public class PixelInfo {
    public float red;
    public float green;
    public float blue;
    public float transparency;
    public int raysSent;
    public boolean needsMore = true;
    public boolean converged;

    public final void clear() {
        this.transparency = 0.0f;
        this.blue = 0.0f;
        this.green = 0.0f;
        this.red = 0.0f;
        this.raysSent = 0;
        this.needsMore = true;
    }

    public final void copy(PixelInfo info) {
        this.red = info.red;
        this.green = info.green;
        this.blue = info.blue;
        this.transparency = info.transparency;
        this.raysSent = info.raysSent;
        this.needsMore = info.needsMore;
        this.converged = info.converged;
    }

    public final void add(RGBColor col, float t) {
        this.red += col.getRed();
        this.green += col.getGreen();
        this.blue += col.getBlue();
        this.transparency += t;
        ++this.raysSent;
    }

    public final void add(PixelInfo info) {
        this.red += info.red;
        this.green += info.green;
        this.blue += info.blue;
        this.transparency += info.transparency;
        this.raysSent += info.raysSent;
    }

    public final boolean matches(PixelInfo info, float maxAbsDiff, float maxRelDiff) {
        float scale1 = 1.0f / (float)this.raysSent;
        float scale2 = 1.0f / (float)info.raysSent;
        if (this.valuesDifferent(this.red * scale1, info.red * scale2, maxAbsDiff, maxRelDiff)) {
            return false;
        }
        if (this.valuesDifferent(this.green * scale1, info.green * scale2, maxAbsDiff, maxRelDiff)) {
            return false;
        }
        if (this.valuesDifferent(this.blue * scale1, info.blue * scale2, maxAbsDiff, maxRelDiff)) {
            return false;
        }
        return !this.valuesDifferent(this.transparency * scale1, info.transparency * scale2, maxAbsDiff, maxRelDiff);
    }

    private final boolean valuesDifferent(float val1, float val2, float maxAbsDiff, float maxRelDiff) {
        float diff = val1 - val2;
        if (diff < 0.0f) {
            diff = -diff;
        }
        if (diff < maxAbsDiff) {
            return false;
        }
        float sum = val1 + val2;
        return diff >= maxRelDiff * sum;
    }

    public final int calcARGB() {
        float ninv = 1.0f / (float)this.raysSent;
        float t = this.transparency * ninv;
        if (t >= 1.0f) {
            return 0;
        }
        float scale = ninv * 255.0f / (1.0f - t);
        int a = (int)(255.0f * (1.0f - t));
        int r = (int)(this.red * scale);
        int g = (int)(this.green * scale);
        int b = (int)(this.blue * scale);
        if (r < 0) {
            r = 0;
        }
        if (r > 255) {
            r = 255;
        }
        if (g < 0) {
            g = 0;
        }
        if (g > 255) {
            g = 255;
        }
        if (b < 0) {
            b = 0;
        }
        if (b > 255) {
            b = 255;
        }
        return (a << 24) + (r << 16) + (g << 8) + b;
    }
}

