/*
 * Decompiled with CFR 0.152.
 */
package artofillusion.raytracer;

import artofillusion.RenderingMesh;
import artofillusion.RenderingTriangle;
import artofillusion.material.MaterialMapping;
import artofillusion.math.BoundingBox;
import artofillusion.math.Mat4;
import artofillusion.math.RGBColor;
import artofillusion.math.Vec2;
import artofillusion.math.Vec3;
import artofillusion.raytracer.RTObject;
import artofillusion.raytracer.RTTriangle;
import artofillusion.raytracer.Ray;
import artofillusion.texture.TextureSpec;

public class RTDisplacedTriangle
implements RTObject {
    RenderingTriangle tri;
    BoundingBox bounds;
    BoundingBox bounds2;
    Vec3 vert1;
    Vec3 vert2;
    Vec3 vert3;
    Vec3 trueNorm;
    Vec3 norm1;
    Vec3 norm2;
    Vec3 norm3;
    Vec3 interp;
    Vec3[] rint;
    Vec3 bumpGrad;
    Vec3 orig;
    Vec3 dir;
    Vec3 v1;
    Vec3 v2;
    Vec3 n1;
    Vec3 n2;
    Vec3 n3;
    Vec3 temp1;
    Vec3 temp2;
    Vec3 temp3;
    Vec3 temp4;
    Vec2 dn1;
    Vec2 dn2;
    double t;
    double u;
    double v;
    double w;
    double h;
    double minheight;
    double maxheight;
    double tol;
    double[] intersection;
    double mint;
    double maxt;
    double[] tint;
    double[] uint;
    double[] vint;
    double[] wint;
    double minscale;
    double maxscale;
    double time;
    int lastRay;
    int intersections;
    Ray ray;
    boolean interpNormals;
    boolean bumpMapped;
    boolean lastRayResult;
    boolean initialized;
    Mat4 toLocal;
    Mat4 fromLocal;
    Mat4 trans;
    MaterialMapping material;
    RTObject trueObject;

    public RTDisplacedTriangle(RenderingMesh mesh, int which, Mat4 fromLocal, Mat4 toLocal, MaterialMapping material, Vec3[] vert, Vec3[] norm, double tol, double time) {
        this.tri = mesh.triangle[which];
        this.vert1 = vert[this.tri.v1];
        this.vert2 = vert[this.tri.v2];
        this.vert3 = vert[this.tri.v3];
        this.trueNorm = fromLocal.timesDirection(mesh.faceNorm[which]);
        this.fromLocal = fromLocal;
        this.toLocal = toLocal;
        this.tol = tol;
        this.time = time;
        this.norm1 = norm[this.tri.n1];
        this.norm2 = norm[this.tri.n2];
        this.norm3 = norm[this.tri.n3];
        int i = 0;
        if (this.trueNorm.dot(this.norm1) < 0.0) {
            ++i;
        }
        if (this.trueNorm.dot(this.norm2) < 0.0) {
            ++i;
        }
        if (this.trueNorm.dot(this.norm3) < 0.0) {
            ++i;
        }
        if (i > 1) {
            this.trueNorm.scale(-1.0);
        }
        this.minheight = Double.MAX_VALUE;
        this.maxheight = -1.7976931348623157E308;
        this.bounds = new BoundingBox(0.0, 0.0, 0.0, 0.0, 0.0, 0.0);
        this.bounds.minz = Double.MAX_VALUE;
        this.bounds.miny = Double.MAX_VALUE;
        this.bounds.minx = Double.MAX_VALUE;
        this.bounds.maxz = -1.7976931348623157E308;
        this.bounds.maxy = -1.7976931348623157E308;
        this.bounds.maxx = -1.7976931348623157E308;
        double d = 2.0 * Math.max(Math.max(this.vert1.minus(this.vert2).length2(), this.vert1.minus(this.vert3).length2()), this.vert2.minus(this.vert3).length2());
        int divisions = (int)Math.ceil(Math.sqrt(d) / tol);
        Vec3 temp = new Vec3();
        d = 1.0 / (double)divisions;
        i = 0;
        while (i <= divisions) {
            int j = 0;
            while (j <= divisions - i) {
                this.u = (double)i * d;
                this.v = (double)j * d;
                this.w = (double)(divisions - i - j) * d;
                double disp = this.tri.getDisplacement(this.u, this.v, this.w, tol, time);
                temp.set(this.u * this.norm1.x + this.v * this.norm2.x + this.w * this.norm3.x, this.u * this.norm1.y + this.v * this.norm2.y + this.w * this.norm3.y, this.u * this.norm1.z + this.v * this.norm2.z + this.w * this.norm3.z);
                temp.normalize();
                double h = disp / temp.dot(this.trueNorm);
                if (h < this.minheight) {
                    this.minheight = h;
                }
                if (h > this.maxheight) {
                    this.maxheight = h;
                }
                temp.set(this.u * this.vert1.x + this.v * this.vert2.x + this.w * this.vert3.x + disp * temp.x, this.u * this.vert1.y + this.v * this.vert2.y + this.w * this.vert3.y + disp * temp.y, this.u * this.vert1.z + this.v * this.vert2.z + this.w * this.vert3.z + disp * temp.z);
                if (temp.x < this.bounds.minx) {
                    this.bounds.minx = temp.x;
                }
                if (temp.x > this.bounds.maxx) {
                    this.bounds.maxx = temp.x;
                }
                if (temp.y < this.bounds.miny) {
                    this.bounds.miny = temp.y;
                }
                if (temp.y > this.bounds.maxy) {
                    this.bounds.maxy = temp.y;
                }
                if (temp.z < this.bounds.minz) {
                    this.bounds.minz = temp.z;
                }
                if (temp.z > this.bounds.maxz) {
                    this.bounds.maxz = temp.z;
                }
                ++j;
            }
            ++i;
        }
        this.bounds.outset(0.5 * tol);
        this.bumpMapped = this.tri.mapping.getTexture().bumpMapped();
        this.lastRay = -1;
        this.material = material;
        this.trueObject = this.minheight == 0.0 && this.maxheight == 0.0 ? new RTTriangle(mesh, which, fromLocal, toLocal, material, vert, norm, time) : this;
    }

    public RTObject getTrueObject() {
        return this.trueObject;
    }

    public void setTolerance(double tol) {
        this.tol = tol;
    }

    private void init() {
        this.trans = Mat4.viewTransform((Vec3)this.vert3, (Vec3)this.trueNorm, (Vec3)this.vert2.minus(this.vert3));
        this.v1 = this.trans.times(this.vert1);
        this.v2 = this.trans.times(this.vert2);
        this.n1 = this.trans.timesDirection(this.norm1);
        this.n2 = this.trans.timesDirection(this.norm2);
        this.n3 = this.trans.timesDirection(this.norm3);
        Vec3[] pos = new Vec3[]{new Vec3(this.v1.x + this.n1.x * this.minheight, this.v1.y + this.n1.y * this.minheight, this.n1.z * this.minheight), new Vec3(this.v1.x + this.n1.x * this.maxheight, this.v1.y + this.n1.y * this.maxheight, this.n1.z * this.maxheight), new Vec3(this.n2.x * this.minheight, this.v2.y + this.n2.y * this.minheight, this.n2.z * this.minheight), new Vec3(this.n2.x * this.maxheight, this.v2.y + this.n2.y * this.maxheight, this.n2.z * this.maxheight), new Vec3(this.n3.x * this.minheight, this.n3.y * this.minheight, this.n3.z * this.minheight), new Vec3(this.n3.x * this.maxheight, this.n3.y * this.maxheight, this.n3.z * this.maxheight)};
        this.bounds2 = new BoundingBox(pos[0].x, pos[0].x, pos[0].y, pos[0].y, pos[0].z, pos[0].z);
        int i = 1;
        while (i < 6) {
            if (pos[i].x < this.bounds2.minx) {
                this.bounds2.minx = pos[i].x;
            }
            if (pos[i].x > this.bounds2.maxx) {
                this.bounds2.maxx = pos[i].x;
            }
            if (pos[i].y < this.bounds2.miny) {
                this.bounds2.miny = pos[i].y;
            }
            if (pos[i].y > this.bounds2.maxy) {
                this.bounds2.maxy = pos[i].y;
            }
            if (pos[i].z < this.bounds2.minz) {
                this.bounds2.minz = pos[i].z;
            }
            if (pos[i].z > this.bounds2.maxz) {
                this.bounds2.maxz = pos[i].z;
            }
            ++i;
        }
        this.bounds2.outset(0.5 * this.tol);
        this.dn1 = new Vec2(this.n1.x - this.n3.x, this.n1.y - this.n3.y);
        this.dn2 = new Vec2(this.n2.x - this.n3.x, this.n2.y - this.n3.y);
        this.minscale = 1.0 / Math.max(Math.max(this.n1.z, this.n2.z), this.n3.z);
        this.maxscale = 1.0 / Math.min(Math.min(this.n1.z, this.n2.z), this.n3.z);
        this.intersection = new double[4];
        this.interp = new Vec3();
        this.rint = new Vec3[]{new Vec3()};
        this.orig = new Vec3();
        this.dir = new Vec3();
        this.temp1 = new Vec3();
        this.temp2 = new Vec3();
        this.temp3 = new Vec3();
        this.temp4 = new Vec3();
        this.tint = new double[1];
        this.uint = new double[1];
        this.vint = new double[1];
        this.wint = new double[1];
        this.initialized = true;
    }

    public final MaterialMapping getMaterialMapping() {
        return this.material;
    }

    public boolean intersects(Ray r) {
        double prevt;
        if (this.lastRay == r.getID()) {
            return this.lastRayResult;
        }
        this.lastRay = r.getID();
        if (!this.rayIntersectsBounds(r.origin, r.direction, this.bounds)) {
            this.lastRayResult = false;
            return false;
        }
        double mint1 = this.mint;
        double maxt1 = this.maxt;
        if (!this.initialized) {
            this.init();
        }
        this.orig.set(r.origin);
        this.dir.set(r.direction);
        this.trans.transform(this.orig);
        this.trans.transformDirection(this.dir);
        if (!this.rayIntersectsBounds(this.orig, this.dir, this.bounds2)) {
            this.lastRayResult = false;
            return false;
        }
        if (mint1 > this.mint) {
            this.mint = mint1;
        }
        if (maxt1 < this.maxt) {
            this.maxt = maxt1;
        }
        if (this.mint < 0.0) {
            this.mint = 0.0;
        }
        double x = this.orig.x + this.maxt * this.dir.x;
        double y = this.orig.y + this.maxt * this.dir.y;
        double z = this.orig.z + this.maxt * this.dir.z;
        this.calcCoords(x, y, z);
        double lastu = this.u;
        double lastv = this.v;
        double lastw = this.w;
        x = this.orig.x + this.mint * this.dir.x;
        y = this.orig.y + this.mint * this.dir.y;
        z = this.orig.z + this.mint * this.dir.z;
        this.calcCoords(x, y, z);
        if (this.u < 0.0 && lastu < 0.0 || this.u > 1.0 && lastu > 1.0 || this.v < 0.0 && lastv < 0.0 || this.v > 1.0 && lastv > 1.0 || this.w < 0.0 && lastw < 0.0 || this.w > 1.0 && lastw > 1.0) {
            this.lastRayResult = false;
            return false;
        }
        this.temp1.set(this.u * this.n1.x + this.v * this.n2.x + this.w * this.n3.x, this.u * this.n1.y + this.v * this.n2.y + this.w * this.n3.y, this.u * this.n1.z + this.v * this.n2.z + this.w * this.n3.z);
        double disp = this.tri.getDisplacement(this.u, this.v, this.w, this.tol, this.time);
        double height = disp * this.temp1.z / this.temp1.length();
        double prevDelta = z - height;
        boolean above = z > height;
        boolean wasOutsideU = this.u < 0.0 || this.u > 1.0;
        boolean wasOutsideV = this.v < 0.0 || this.v > 1.0;
        boolean wasOutsideW = this.w < 0.0 || this.w > 1.0;
        this.t = prevt = this.mint;
        this.intersections = -1;
        this.tint[0] = Double.MAX_VALUE;
        while (this.t < this.maxt) {
            boolean outsideW;
            this.t += this.tol;
            if (this.t >= this.maxt) {
                this.t = this.maxt;
                x = this.orig.x + this.t * this.dir.x;
                y = this.orig.y + this.t * this.dir.y;
                z = this.orig.z + this.t * this.dir.z;
                this.u = lastu;
                this.v = lastv;
                this.w = lastw;
            } else {
                x = this.orig.x + this.t * this.dir.x;
                y = this.orig.y + this.t * this.dir.y;
                z = this.orig.z + this.t * this.dir.z;
                this.calcCoords(x, y, z);
            }
            disp = this.tri.getDisplacement(this.u, this.v, this.w, this.tol, this.time);
            this.temp1.set(this.u * this.n1.x + this.v * this.n2.x + this.w * this.n3.x, this.u * this.n1.y + this.v * this.n2.y + this.w * this.n3.y, this.u * this.n1.z + this.v * this.n2.z + this.w * this.n3.z);
            height = disp * this.temp1.z / this.temp1.length();
            boolean outsideU = this.u < 0.0 || this.u > 1.0;
            boolean outsideV = this.v < 0.0 || this.v > 1.0;
            boolean bl = outsideW = this.w < 0.0 || this.w > 1.0;
            if (outsideU && wasOutsideU || outsideV && wasOutsideV || outsideW && wasOutsideW) {
                above = z > height;
                prevDelta = z - height;
                prevt = this.t;
                wasOutsideU = outsideU;
                wasOutsideV = outsideV;
                wasOutsideW = outsideW;
                continue;
            }
            if (above && z <= height || !above && z >= height) {
                double truet = this.t - (this.t - prevt) * (z - height) / (z - height - prevDelta);
                if (truet <= this.tol) {
                    above = z > height;
                    prevDelta = z - height;
                    prevt = this.t;
                    wasOutsideU = outsideU;
                    wasOutsideV = outsideV;
                    wasOutsideW = outsideW;
                    continue;
                }
                x = this.orig.x + truet * this.dir.x;
                y = this.orig.y + truet * this.dir.y;
                z = this.orig.z + truet * this.dir.z;
                this.calcCoords(x, y, z);
                this.tint[0] = truet;
                this.uint[0] = this.u;
                this.vint[0] = this.v;
                this.wint[0] = this.w;
                break;
            }
            prevDelta = z - height;
            above = z > height;
            prevt = this.t;
            wasOutsideU = outsideU;
            wasOutsideV = outsideV;
            wasOutsideW = outsideW;
        }
        if (this.tint[0] == Double.MAX_VALUE) {
            this.lastRayResult = false;
            return false;
        }
        Vec3 ri = this.rint[0];
        disp = this.tri.getDisplacement(this.u, this.v, this.w, this.tol, this.time);
        ri.set(r.origin.x + this.tint[0] * r.direction.x, r.origin.y + this.tint[0] * r.direction.y, r.origin.z + this.tint[0] * r.direction.z);
        double dhdu = (this.tri.getDisplacement(this.u + 1.0E-5, this.v, this.w - 1.0E-5, this.tol, this.time) - disp) * 100000.0;
        double dhdv = (this.tri.getDisplacement(this.u, this.v + 1.0E-5, this.w - 1.0E-5, this.tol, this.time) - disp) * 100000.0;
        this.interp.set(this.u * this.norm1.x + this.v * this.norm2.x + this.w * this.norm3.x, this.u * this.norm1.y + this.v * this.norm2.y + this.w * this.norm3.y, this.u * this.norm1.z + this.v * this.norm2.z + this.w * this.norm3.z);
        this.interp.normalize();
        this.temp1.set(this.vert1.x + disp * this.norm1.x, this.vert1.y + disp * this.norm1.y, this.vert1.z + disp * this.norm1.z);
        this.temp2.set(this.vert2.x + disp * this.norm2.x, this.vert2.y + disp * this.norm2.y, this.vert2.z + disp * this.norm2.z);
        this.temp3.set(this.vert3.x + disp * this.norm3.x, this.vert3.y + disp * this.norm3.y, this.vert3.z + disp * this.norm3.z);
        this.temp1.set(this.temp1.x - this.temp3.x, this.temp1.y - this.temp3.y, this.temp1.z - this.temp3.z);
        this.temp2.set(this.temp3.x - this.temp2.x, this.temp3.y - this.temp2.y, this.temp3.z - this.temp2.z);
        this.temp3.set(this.temp1.y * this.interp.z - this.temp1.z * this.interp.y, this.temp1.z * this.interp.x - this.temp1.x * this.interp.z, this.temp1.x * this.interp.y - this.temp1.y * this.interp.x);
        this.temp4.set(this.temp2.y * this.interp.z - this.temp2.z * this.interp.y, this.temp2.z * this.interp.x - this.temp2.x * this.interp.z, this.temp2.x * this.interp.y - this.temp2.y * this.interp.x);
        this.temp3.scale(-1.0 / this.temp3.dot(this.temp2));
        this.temp4.scale(1.0 / this.temp4.dot(this.temp1));
        this.temp1.set(dhdu * this.temp4.x + dhdv * this.temp3.x, dhdu * this.temp4.y + dhdv * this.temp3.y, dhdu * this.temp4.z + dhdv * this.temp3.z);
        this.interp.scale(this.temp1.dot(this.interp) + 1.0);
        this.interp.subtract(this.temp1);
        this.interp.normalize();
        this.ray = r;
        this.lastRayResult = true;
        return true;
    }

    private final void calcCoords(double x, double y, double z) {
        double dmax = z * this.maxscale;
        double dmin = z * this.minscale;
        this.guessCoords(x, y, dmax);
        double ua = this.u;
        double va = this.v;
        double wa = this.w;
        double zmax = dmax * (this.u * this.n1.z + this.v * this.n2.z + this.w * this.n3.z);
        this.guessCoords(x, y, dmin);
        double ub = this.u;
        double vb = this.v;
        double wb = this.w;
        double zmin = dmin * (this.u * this.n1.z + this.v * this.n2.z + this.w * this.n3.z);
        if (zmax == zmin) {
            return;
        }
        double fract = (z - zmin) / (zmax - zmin);
        double fract2 = 1.0 - fract;
        this.u = fract * ua + fract2 * this.u;
        this.v = fract * va + fract2 * this.v;
        this.w = fract * wa + fract2 * this.w;
    }

    private final void guessCoords(double x, double y, double disp) {
        double a = this.v1.x + disp * this.dn1.x;
        double b = disp * this.dn2.x;
        double c = x - disp * this.n3.x;
        double e = this.v1.y + disp * this.dn1.y;
        double f = this.v2.y + disp * this.dn2.y;
        double g = y - disp * this.n3.y;
        double m = 1.0 / (a * f - b * e);
        this.u = (c * f - b * g) * m;
        this.v = (a * g - c * e) * m;
        this.w = 1.0 - this.u - this.v;
    }

    private final void findAllIntersections() {
        double x = this.orig.x + this.t * this.dir.x;
        double y = this.orig.y + this.t * this.dir.y;
        double z = this.orig.z + this.t * this.dir.z;
        this.temp1.set(this.u * this.n1.x + this.v * this.n2.x + this.w * this.n3.x, this.u * this.n1.y + this.v * this.n2.y + this.w * this.n3.y, this.u * this.n1.z + this.v * this.n2.z + this.w * this.n3.z);
        double disp = this.tri.getDisplacement(this.u, this.v, this.w, this.tol, this.time);
        double height = disp * this.temp1.z / this.temp1.length();
        double prevDelta = z - height;
        double prevt = this.t;
        boolean above = z > height;
        boolean wasOutsideU = this.u < 0.0 || this.u > 1.0;
        boolean wasOutsideV = this.v < 0.0 || this.v > 1.0;
        boolean wasOutsideW = this.w < 0.0 || this.w > 1.0;
        this.intersections = 1;
        while (this.t < this.maxt) {
            boolean outsideW;
            this.t += this.tol;
            if (this.t >= this.maxt) {
                this.t = this.maxt;
            }
            x = this.orig.x + this.t * this.dir.x;
            y = this.orig.y + this.t * this.dir.y;
            z = this.orig.z + this.t * this.dir.z;
            this.calcCoords(x, y, z);
            disp = this.tri.getDisplacement(this.u, this.v, this.w, this.tol, this.time);
            this.temp1.set(this.u * this.n1.x + this.v * this.n2.x + this.w * this.n3.x, this.u * this.n1.y + this.v * this.n2.y + this.w * this.n3.y, this.u * this.n1.z + this.v * this.n2.z + this.w * this.n3.z);
            height = disp * this.temp1.z / this.temp1.length();
            boolean outsideU = this.u < 0.0 || this.u > 1.0;
            boolean outsideV = this.v < 0.0 || this.v > 1.0;
            boolean bl = outsideW = this.w < 0.0 || this.w > 1.0;
            if (outsideU && wasOutsideU || outsideV && wasOutsideV || outsideW && wasOutsideW) {
                above = z > height;
                prevDelta = z - height;
                prevt = this.t;
                wasOutsideU = outsideU;
                wasOutsideV = outsideV;
                wasOutsideW = outsideW;
                continue;
            }
            if (above && z <= height || !above && z >= height) {
                if (this.intersections == this.tint.length) {
                    double[] newt = new double[this.intersections * 2];
                    double[] newu = new double[this.intersections * 2];
                    double[] newv = new double[this.intersections * 2];
                    double[] neww = new double[this.intersections * 2];
                    Vec3[] newr = new Vec3[this.intersections * 2];
                    int j = 0;
                    while (j < this.tint.length) {
                        newt[j] = this.tint[j];
                        newu[j] = this.uint[j];
                        newv[j] = this.vint[j];
                        neww[j] = this.wint[j];
                        newr[j] = this.rint[j];
                        ++j;
                    }
                    int j2 = this.tint.length;
                    while (j2 < newt.length) {
                        newr[j2] = new Vec3();
                        ++j2;
                    }
                    this.tint = newt;
                    this.uint = newu;
                    this.vint = newv;
                    this.wint = neww;
                    this.rint = newr;
                }
                double oldz = z;
                double truet = this.t - (this.t - prevt) * (z - height) / (z - height - prevDelta);
                x = this.orig.x + truet * this.dir.x;
                y = this.orig.y + truet * this.dir.y;
                z = this.orig.z + truet * this.dir.z;
                this.calcCoords(x, y, z);
                this.tint[this.intersections] = truet;
                this.uint[this.intersections] = this.u;
                this.vint[this.intersections] = this.v;
                this.wint[this.intersections] = this.w;
                this.rint[this.intersections].set(this.ray.origin.x + truet * this.ray.direction.x, this.ray.origin.y + truet * this.ray.direction.y, this.ray.origin.z + truet * this.ray.direction.z);
                ++this.intersections;
                z = oldz;
            }
            prevDelta = z - height;
            above = z > height;
            prevt = this.t;
            wasOutsideU = outsideU;
            wasOutsideV = outsideV;
            wasOutsideW = outsideW;
        }
    }

    public int numIntersections() {
        if (this.intersections == -1) {
            this.findAllIntersections();
        }
        return this.intersections;
    }

    public final void intersectionPoint(int n, Vec3 p) {
        p.set(this.rint[n]);
    }

    public final double intersectionDist(int n) {
        return this.tint[n];
    }

    public void intersectionNormal(Vec3 n) {
        n.set(this.interp);
        if (this.bumpMapped) {
            n.scale(this.bumpGrad.dot(n) + 1.0);
            n.subtract(this.bumpGrad);
            n.normalize();
        }
    }

    public void trueNormal(Vec3 n) {
        n.set(this.interp);
    }

    public void intersectionTexture(TextureSpec spec, boolean front, double size) {
        this.tri.getTextureSpec(spec, front, this.uint[0], this.vint[0], this.wint[0], size, this.time);
        if (this.bumpMapped) {
            this.bumpGrad = spec.bumpGrad;
            this.fromLocal.transformDirection(this.bumpGrad);
        }
    }

    public void intersectionTransparency(int n, RGBColor trans, boolean front, double size) {
        this.tri.getTransparency(trans, front, this.uint[n], this.vint[n], this.wint[n], size, this.time);
    }

    public BoundingBox getBounds() {
        return this.bounds;
    }

    public boolean intersectsBox(BoundingBox bb) {
        return bb.intersects(this.bounds);
    }

    boolean rayIntersectsBounds(Vec3 origin, Vec3 direction, BoundingBox bb) {
        double t2;
        double t1;
        this.mint = -1.7976931348623157E308;
        this.maxt = Double.MAX_VALUE;
        if (direction.x == 0.0) {
            if (origin.x < bb.minx || origin.x > bb.maxx) {
                return false;
            }
        } else {
            t1 = (bb.minx - origin.x) / direction.x;
            t2 = (bb.maxx - origin.x) / direction.x;
            if (t1 < t2) {
                if (t1 > this.mint) {
                    this.mint = t1;
                }
                if (t2 < this.maxt) {
                    this.maxt = t2;
                }
            } else {
                if (t2 > this.mint) {
                    this.mint = t2;
                }
                if (t1 < this.maxt) {
                    this.maxt = t1;
                }
            }
            if (this.mint > this.maxt || this.maxt < 0.0) {
                return false;
            }
        }
        if (direction.y == 0.0) {
            if (origin.y < bb.miny || origin.y > bb.maxy) {
                return false;
            }
        } else {
            t1 = (bb.miny - origin.y) / direction.y;
            t2 = (bb.maxy - origin.y) / direction.y;
            if (t1 < t2) {
                if (t1 > this.mint) {
                    this.mint = t1;
                }
                if (t2 < this.maxt) {
                    this.maxt = t2;
                }
            } else {
                if (t2 > this.mint) {
                    this.mint = t2;
                }
                if (t1 < this.maxt) {
                    this.maxt = t1;
                }
            }
            if (this.mint > this.maxt || this.maxt < 0.0) {
                return false;
            }
        }
        if (direction.z == 0.0) {
            if (origin.z < bb.minz || origin.z > bb.maxz) {
                return false;
            }
        } else {
            t1 = (bb.minz - origin.z) / direction.z;
            t2 = (bb.maxz - origin.z) / direction.z;
            if (t1 < t2) {
                if (t1 > this.mint) {
                    this.mint = t1;
                }
                if (t2 < this.maxt) {
                    this.maxt = t2;
                }
            } else {
                if (t2 > this.mint) {
                    this.mint = t2;
                }
                if (t1 < this.maxt) {
                    this.maxt = t1;
                }
            }
            if (this.mint > this.maxt || this.maxt < 0.0) {
                return false;
            }
        }
        return true;
    }

    public Mat4 toLocal() {
        return this.toLocal;
    }
}

