/*
 * Decompiled with CFR 0.152.
 */
package artofillusion;

import artofillusion.ModellingApp;
import artofillusion.ObjectPreviewCanvas;
import artofillusion.Scene;
import artofillusion.object.CSGModeller;
import artofillusion.object.CSGObject;
import artofillusion.object.TriangleMesh;
import artofillusion.ui.EditingWindow;
import artofillusion.ui.Translate;
import java.awt.Button;
import java.awt.Choice;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Label;
import java.awt.Panel;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;

public class CSGDialog
extends Dialog
implements ActionListener,
ItemListener {
    CSGObject theObject;
    CSGModeller modeller;
    Choice opChoice;
    Button okButton;
    Button cancelButton;
    ObjectPreviewCanvas preview;
    int[] operation;
    boolean ok;
    private static int counter = 1;

    public CSGDialog(EditingWindow window, CSGObject obj) {
        super((Frame)((Object)window), "Boolean", true);
        this.theObject = obj;
        Scene scene = window.getScene();
        this.setLayout(new GridBagLayout());
        GridBagConstraints gc = new GridBagConstraints();
        gc.anchor = 17;
        gc.gridx = 0;
        this.add((Component)new Label("Operation:"), gc);
        this.opChoice = new Choice();
        this.add((Component)this.opChoice, gc);
        int i = 0;
        this.operation = new int[4];
        if (obj.getObject1().object.isClosed() && obj.getObject2().object.isClosed()) {
            this.opChoice.add("Union");
            this.operation[i++] = 0;
        }
        this.opChoice.add("Intersection");
        this.operation[i++] = 1;
        if (obj.getObject2().object.isClosed()) {
            this.opChoice.add("First - Second");
            this.operation[i++] = 2;
        }
        if (obj.getObject1().object.isClosed()) {
            this.opChoice.add("Second - First");
            this.operation[i++] = 3;
        }
        int j = 0;
        while (j < i) {
            if (obj.getOperation() == this.operation[j]) {
                this.opChoice.select(j);
            }
            ++j;
        }
        this.opChoice.addItemListener(this);
        gc.gridx = 0;
        gc.fill = 1;
        gc.weighty = 1.0;
        gc.weightx = 1.0;
        this.preview = new ObjectPreviewCanvas(null);
        this.add((Component)this.preview, gc);
        this.preview.setPreferredSize(200, 200);
        gc.gridwidth = 2;
        gc.weighty = 0.0;
        gc.weightx = 0.0;
        Panel p = new Panel();
        this.okButton = Translate.button("ok", this);
        p.add(this.okButton);
        this.cancelButton = Translate.button("cancel", this);
        p.add(this.cancelButton);
        this.add((Component)p, gc);
        this.makePreview();
        this.pack();
        this.show();
    }

    public void itemStateChanged(ItemEvent e) {
        this.makePreview();
    }

    public void actionPerformed(ActionEvent e) {
        if (this.okButton == e.getSource()) {
            this.theObject.setOperation(this.operation[this.opChoice.getSelectedIndex()]);
            this.ok = true;
        }
        this.dispose();
    }

    private void makePreview() {
        if (this.modeller == null) {
            double tol = ModellingApp.getPreferences().getInteractiveSurfaceError();
            TriangleMesh mesh1 = this.theObject.getObject1().object.convertToTriangleMesh(tol);
            TriangleMesh mesh2 = this.theObject.getObject2().object.convertToTriangleMesh(tol);
            this.modeller = new CSGModeller(mesh1, mesh2, this.theObject.getObject1().coords, this.theObject.getObject2().coords);
        }
        this.preview.setObject(this.modeller.getMesh(this.operation[this.opChoice.getSelectedIndex()]));
        this.preview.updateImage();
        this.preview.repaint();
    }

    public boolean clickedOk() {
        return this.ok;
    }
}

