/*
 * Decompiled with CFR 0.152.
 */
package artofillusion;

import artofillusion.CSGDialog;
import artofillusion.Callback;
import artofillusion.Camera;
import artofillusion.ModellingApp;
import artofillusion.MoveObjectTool;
import artofillusion.MoveViewTool;
import artofillusion.Renderer;
import artofillusion.RenderingDialog;
import artofillusion.RotateObjectTool;
import artofillusion.RotateViewTool;
import artofillusion.ScaleObjectTool;
import artofillusion.Scene;
import artofillusion.SceneViewer;
import artofillusion.TransformDialog;
import artofillusion.UndoRecord;
import artofillusion.ViewerCanvas;
import artofillusion.math.BoundingBox;
import artofillusion.math.CoordinateSystem;
import artofillusion.math.Mat4;
import artofillusion.math.RGBColor;
import artofillusion.math.Vec3;
import artofillusion.object.CSGObject;
import artofillusion.object.DirectionalLight;
import artofillusion.object.Object3D;
import artofillusion.object.ObjectInfo;
import artofillusion.object.TriangleMesh;
import artofillusion.ui.ComponentsDialog;
import artofillusion.ui.EditingTool;
import artofillusion.ui.EditingWindow;
import artofillusion.ui.EntriesDialog;
import artofillusion.ui.MessageDialog;
import artofillusion.ui.ToolPalette;
import artofillusion.ui.Translate;
import artofillusion.ui.ValueField;
import java.awt.BorderLayout;
import java.awt.CheckboxMenuItem;
import java.awt.Choice;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Label;
import java.awt.Menu;
import java.awt.MenuBar;
import java.awt.MenuItem;
import java.awt.Panel;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;

public class CSGEditorWindow
extends Frame
implements EditingWindow,
KeyListener,
ActionListener,
ItemListener {
    EditingWindow parentWindow;
    SceneViewer theView;
    EditingTool defaultTool;
    EditingTool currentTool;
    Label helpText;
    CSGObject oldObject;
    CSGObject theObject;
    UndoRecord undo;
    ToolPalette tools;
    MenuBar menubar;
    Menu editMenu;
    Menu objectMenu;
    MenuItem undoItem;
    MenuItem[] objectMenuItem;
    CheckboxMenuItem[] displayItem;
    Scene theScene;
    Callback onClose;

    public CSGEditorWindow(EditingWindow parent, String title, CSGObject obj, Callback onClose) {
        super(title);
        this.parentWindow = parent;
        this.oldObject = obj;
        this.theObject = (CSGObject)obj.duplicate();
        this.onClose = onClose;
        this.theScene = new Scene();
        this.theScene.addObject(obj.getObject1().object.duplicate(), obj.getObject1().coords.duplicate(), obj.getObject1().name, null);
        this.theScene.addObject(obj.getObject2().object.duplicate(), obj.getObject2().coords.duplicate(), obj.getObject2().name, null);
        this.helpText = new Label();
        this.add((Component)this.helpText, "South");
        Panel p1 = new Panel();
        this.add((Component)p1, "Center");
        p1.setLayout(new BorderLayout());
        Panel p2 = new Panel();
        p1.add((Component)p2, "North");
        p2.setLayout(new BorderLayout());
        Panel p3 = new Panel();
        p2.add((Component)p3, "West");
        this.theView = new SceneViewer(this.theScene, p3, this);
        p1.add((Component)this.theView, "Center");
        p3 = new Panel();
        p2.add((Component)p3, "East");
        p3.add(Translate.button("ok", this));
        p3.add(Translate.button("cancel", this));
        Panel p4 = new Panel();
        this.add((Component)p4, "West");
        p4.setLayout(new BorderLayout());
        this.tools = new ToolPalette(1, 5);
        p4.add((Component)this.tools, "North");
        this.defaultTool = new MoveObjectTool(this);
        this.tools.addTool(this.defaultTool);
        this.tools.addTool(new RotateObjectTool(this));
        this.tools.addTool(new ScaleObjectTool(this));
        MoveViewTool metaTool = new MoveViewTool(this);
        this.tools.addTool(metaTool);
        RotateViewTool altTool = new RotateViewTool(this);
        this.tools.addTool(altTool);
        this.tools.selectTool(this.defaultTool);
        this.theView.setMetaTool(metaTool);
        this.theView.setAltTool(altTool);
        this.helpText.setBackground(ModellingApp.APP_BACKGROUND_COLOR);
        p2.setBackground(ModellingApp.APP_BACKGROUND_COLOR);
        p3.setBackground(ModellingApp.APP_BACKGROUND_COLOR);
        p4.setBackground(ModellingApp.APP_BACKGROUND_COLOR);
        this.menubar = new MenuBar();
        this.setMenuBar(this.menubar);
        this.createEditMenu();
        this.createObjectMenu();
        this.recursivelyAddListeners(this);
        this.pack();
        Dimension d1 = Toolkit.getDefaultToolkit().getScreenSize();
        Dimension d2 = new Dimension(d1.width * 2 / 3, d1.height * 2 / 3);
        ((Component)this).setSize(d2);
        ((Component)this).setLocation((d1.width - d2.width) / 2, (d1.height - d2.height) / 2);
        this.tools.requestFocus();
        this.updateMenus();
        this.show();
    }

    void createEditMenu() {
        this.editMenu = Translate.menu("edit");
        this.menubar.add(this.editMenu);
        this.undoItem = Translate.menuItem("undo", this);
        this.editMenu.add(this.undoItem);
        this.undoItem.setEnabled(false);
        this.editMenu.addSeparator();
        this.editMenu.add(Translate.menuItem("selectAll", this));
        this.editMenu.add(Translate.menuItem("properties", this));
    }

    void createObjectMenu() {
        this.objectMenu = Translate.menu("object");
        this.menubar.add(this.objectMenu);
        this.objectMenuItem = new MenuItem[5];
        this.objectMenuItem[0] = Translate.menuItem("editObject", this);
        this.objectMenu.add(this.objectMenuItem[0]);
        this.objectMenuItem[1] = Translate.menuItem("objectLayout", this);
        this.objectMenu.add(this.objectMenuItem[1]);
        this.objectMenuItem[2] = Translate.menuItem("transformObject", this);
        this.objectMenu.add(this.objectMenuItem[2]);
        this.objectMenuItem[3] = Translate.menuItem("alignObjects", this);
        this.objectMenu.add(this.objectMenuItem[3]);
        this.objectMenu.add(Translate.menuItem("centerObjects", this));
        this.objectMenuItem[4] = Translate.menuItem("convertToTriangle", this);
        this.objectMenu.add(this.objectMenuItem[4]);
        this.objectMenu.addSeparator();
        if (ModellingApp.getPreferences().getObjectPreviewRenderer() != null) {
            this.objectMenu.add(Translate.menuItem("renderPreview", this));
        }
        Menu displayMenu = Translate.menu("displayMode");
        this.objectMenu.add(displayMenu);
        this.displayItem = new CheckboxMenuItem[3];
        this.displayItem[0] = Translate.checkboxMenuItem("wireframeDisplay", this, this.theView.getRenderMode() == 0);
        displayMenu.add(this.displayItem[0]);
        this.displayItem[1] = Translate.checkboxMenuItem("shadedDisplay", this, this.theView.getRenderMode() == 1);
        displayMenu.add(this.displayItem[1]);
        this.displayItem[2] = Translate.checkboxMenuItem("smoothDisplay", this, this.theView.getRenderMode() == 2);
        displayMenu.add(this.displayItem[2]);
    }

    void recursivelyAddListeners(Component c) {
        c.addKeyListener(this);
        if (c instanceof Container) {
            Component[] children = ((Container)c).getComponents();
            int i = 0;
            while (i < children.length) {
                this.recursivelyAddListeners(children[i]);
                ++i;
            }
        }
    }

    public boolean confirmClose() {
        return true;
    }

    public void setTool(EditingTool tool) {
        this.theView.setTool(tool);
        this.currentTool = tool;
    }

    public void setHelpText(String text) {
        this.helpText.setText(text);
    }

    public Frame getFrame() {
        return this;
    }

    public void updateImage() {
        this.theView.updateImage();
        this.theView.repaint();
    }

    public void updateMenus() {
        int[] selected = this.theScene.getSelection();
        this.objectMenuItem[0].setEnabled(selected.length == 1);
        this.objectMenuItem[1].setEnabled(selected.length > 0);
        this.objectMenuItem[2].setEnabled(selected.length > 0);
        this.objectMenuItem[3].setEnabled(selected.length > 0);
        this.objectMenuItem[4].setEnabled(selected.length == 1);
    }

    public void setUndoRecord(UndoRecord command) {
        this.undo = command;
        this.undoItem.setEnabled(true);
        if (this.undo.isRedo()) {
            this.undoItem.setLabel(Translate.text("menu.redo"));
        } else {
            this.undoItem.setLabel(Translate.text("menu.undo"));
        }
        this.updateMenus();
    }

    public Scene getScene() {
        return this.theScene;
    }

    public ViewerCanvas getView() {
        return this.theView;
    }

    public void keyPressed(KeyEvent e) {
        int code = e.getKeyCode();
        if (e.isShiftDown() && (code == 37 || code == 39 || code == 38 || code == 40)) {
            this.tools.keyPressed(e);
        } else {
            this.currentTool.keyPressed(e, this.theView);
        }
    }

    public void keyReleased(KeyEvent e) {
    }

    public void keyTyped(KeyEvent e) {
    }

    public void actionPerformed(ActionEvent e) {
        String command = e.getActionCommand();
        this.setCursor(Cursor.getPredefinedCursor(3));
        if (command.equals("ok")) {
            this.updateFromScene();
            this.oldObject.copyObject(this.theObject);
            this.theObject = null;
            this.oldObject = null;
            this.theScene = null;
            this.dispose();
            this.onClose.execute();
            this.parentWindow.updateImage();
            this.parentWindow.updateMenus();
        } else if (command.equals("cancel")) {
            this.theObject = null;
            this.oldObject = null;
            this.theScene = null;
            this.dispose();
        } else if (command.equals("undo")) {
            this.undoCommand();
        } else if (command.equals("selectAll")) {
            this.selectAllCommand();
        } else if (command.equals("properties")) {
            this.propertiesCommand();
        } else if (command.equals("editObject")) {
            this.editObjectCommand();
        } else if (command.equals("objectLayout")) {
            this.objectLayoutCommand();
        } else if (command.equals("transformObject")) {
            this.transformObjectCommand();
        } else if (command.equals("alignObjects")) {
            this.alignObjectsCommand();
        } else if (command.equals("centerObjects")) {
            this.centerObjectsCommand();
        } else if (command.equals("convertToTriangle")) {
            this.convertToTriangleCommand();
        } else if (command.equals("renderPreview")) {
            this.renderPreviewCommand();
        }
        this.setCursor(Cursor.getDefaultCursor());
    }

    public void itemStateChanged(ItemEvent e) {
        Object source = e.getSource();
        int i = 0;
        while (i < this.displayItem.length) {
            this.displayItem[i].setState(source == this.displayItem[i]);
            ++i;
        }
        if (source == this.displayItem[0]) {
            this.theView.setRenderMode(0);
        } else if (source == this.displayItem[1]) {
            this.theView.setRenderMode(1);
        } else if (source == this.displayItem[2]) {
            this.theView.setRenderMode(2);
        }
        this.updateImage();
    }

    private void updateFromScene() {
        this.theObject.setComponentObjects(this.theScene.getObject(0), this.theScene.getObject(1));
    }

    void undoCommand() {
        if (this.undo == null) {
            return;
        }
        this.setUndoRecord(this.undo.execute());
        this.updateImage();
        this.updateMenus();
    }

    void selectAllCommand() {
        this.theScene.setSelection(new int[]{0, 1});
        this.updateImage();
        this.updateMenus();
    }

    void propertiesCommand() {
        this.updateFromScene();
        CSGDialog cSGDialog = new CSGDialog(this, this.theObject);
    }

    void editObjectCommand() {
        int[] sel = this.theScene.getSelection();
        if (sel.length != 1) {
            return;
        }
        Object3D obj = this.theScene.getObject((int)sel[0]).object;
        if (obj.editable()) {
            this.setUndoRecord(new UndoRecord(this, false, 0, new Object[]{obj, obj.duplicate()}));
            obj.edit(this, this.theScene.getObject(sel[0]), null);
        }
    }

    void objectLayoutCommand() {
        int[] sel = this.theScene.getSelection();
        Object3D[] obj = new Object3D[sel.length];
        CoordinateSystem[] coords = new CoordinateSystem[sel.length];
        if (sel.length == 0) {
            return;
        }
        this.setUndoRecord(new UndoRecord(this, false));
        int i = 0;
        while (i < sel.length) {
            obj[i] = this.theScene.getObject((int)sel[i]).object;
            coords[i] = this.theScene.getObject((int)sel[i]).coords;
            this.undo.addCommand(0, new Object[]{obj[i], obj[i].duplicate()});
            this.undo.addCommand(1, new Object[]{coords[i], coords[i].duplicate()});
            ++i;
        }
        if (sel.length == 1) {
            Vec3 orig = coords[0].getOrigin();
            double[] angles = coords[0].getRotationAngles();
            Vec3 size = this.theScene.getObject(sel[0]).getBounds().getSize();
            TransformDialog dlg = new TransformDialog(this, "Layout for '" + this.theScene.getObject((int)sel[0]).name + "'", new double[]{orig.x, orig.y, orig.z, angles[0], angles[1], angles[2], size.x, size.y, size.z}, false, false);
            double[] values = dlg.getValues();
            if (!Double.isNaN(values[0])) {
                orig.x = values[0];
            }
            if (!Double.isNaN(values[1])) {
                orig.y = values[1];
            }
            if (!Double.isNaN(values[2])) {
                orig.z = values[2];
            }
            if (!Double.isNaN(values[3])) {
                angles[0] = values[3];
            }
            if (!Double.isNaN(values[4])) {
                angles[1] = values[4];
            }
            if (!Double.isNaN(values[5])) {
                angles[2] = values[5];
            }
            if (!Double.isNaN(values[6])) {
                size.x = values[6];
            }
            if (!Double.isNaN(values[7])) {
                size.y = values[7];
            }
            if (!Double.isNaN(values[8])) {
                size.z = values[8];
            }
            coords[0].setOrigin(orig);
            coords[0].setOrientation(angles[0], angles[1], angles[2]);
            obj[0].setSize(size.x, size.y, size.z);
        } else {
            TransformDialog dlg = new TransformDialog((Frame)this, "Layout for Selected Objects", false, false);
            double[] values = dlg.getValues();
            i = 0;
            while (i < sel.length) {
                Vec3 orig = coords[i].getOrigin();
                double[] angles = coords[i].getRotationAngles();
                Vec3 size = this.theScene.getObject(sel[i]).getBounds().getSize();
                if (!Double.isNaN(values[0])) {
                    orig.x = values[0];
                }
                if (!Double.isNaN(values[1])) {
                    orig.y = values[1];
                }
                if (!Double.isNaN(values[2])) {
                    orig.z = values[2];
                }
                if (!Double.isNaN(values[3])) {
                    angles[0] = values[3];
                }
                if (!Double.isNaN(values[4])) {
                    angles[1] = values[4];
                }
                if (!Double.isNaN(values[5])) {
                    angles[2] = values[5];
                }
                if (!Double.isNaN(values[6])) {
                    size.x = values[6];
                }
                if (!Double.isNaN(values[7])) {
                    size.y = values[7];
                }
                if (!Double.isNaN(values[8])) {
                    size.z = values[8];
                }
                coords[i].setOrigin(orig);
                coords[i].setOrientation(angles[0], angles[1], angles[2]);
                obj[i].setSize(size.x, size.y, size.z);
                ++i;
            }
        }
        this.updateImage();
    }

    void transformObjectCommand() {
        int[] sel = this.theScene.getSelection();
        if (sel.length == 0) {
            return;
        }
        TransformDialog dlg = sel.length == 1 ? new TransformDialog(this, "Transform '" + this.theScene.getObject((int)sel[0]).name + "'", new double[]{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 1.0, 1.0}, true, true) : new TransformDialog(this, "Transform Selected Objects", new double[]{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 1.0, 1.0}, true, true);
        double[] values = dlg.getValues();
        this.setUndoRecord(new UndoRecord(this, false));
        int i = 0;
        while (i < sel.length) {
            Object3D obj = this.theScene.getObject((int)sel[i]).object;
            CoordinateSystem coords = this.theScene.getObject((int)sel[i]).coords;
            this.undo.addCommand(0, new Object[]{obj, obj.duplicate()});
            this.undo.addCommand(1, new Object[]{coords, coords.duplicate()});
            Vec3 orig = coords.getOrigin();
            Vec3 size = obj.getBounds().getSize();
            if (!Double.isNaN(values[0])) {
                orig.x += values[0];
            }
            if (!Double.isNaN(values[1])) {
                orig.y += values[1];
            }
            if (!Double.isNaN(values[2])) {
                orig.z += values[2];
            }
            Mat4 m = Mat4.identity();
            if (!Double.isNaN(values[3])) {
                m = m.times(Mat4.xrotation(values[3] * Math.PI / 180.0));
            }
            if (!Double.isNaN(values[4])) {
                m = m.times(Mat4.yrotation(values[4] * Math.PI / 180.0));
            }
            if (!Double.isNaN(values[5])) {
                m = m.times(Mat4.zrotation(values[5] * Math.PI / 180.0));
            }
            if (!Double.isNaN(values[6])) {
                size.x *= values[6];
            }
            if (!Double.isNaN(values[7])) {
                size.y *= values[7];
            }
            if (!Double.isNaN(values[8])) {
                size.z *= values[8];
            }
            coords.setOrigin(orig);
            coords.transformAxes(m);
            obj.setSize(size.x, size.y, size.z);
            ++i;
        }
        this.updateImage();
    }

    void alignObjectsCommand() {
        Vec3 orig;
        Vec3 center;
        BoundingBox bounds;
        CoordinateSystem coords;
        Object3D obj;
        int[] sel = this.theScene.getSelection();
        Panel px = new Panel();
        Panel py = new Panel();
        Panel pz = new Panel();
        if (sel.length == 0) {
            return;
        }
        Choice xchoice = new Choice();
        px.add(xchoice);
        xchoice.add("Do not align");
        xchoice.add("Right");
        xchoice.add("Center");
        xchoice.add("Left");
        xchoice.add("Origin");
        px.add(new Label("align to"));
        ValueField vfx = new ValueField(Double.NaN, 0, 5);
        px.add(vfx);
        Choice ychoice = new Choice();
        py.add(ychoice);
        ychoice.add("Do not align");
        ychoice.add("Top");
        ychoice.add("Center");
        ychoice.add("Bottom");
        ychoice.add("Origin");
        py.add(new Label("align to"));
        ValueField vfy = new ValueField(Double.NaN, 0, 5);
        py.add(vfy);
        Choice zchoice = new Choice();
        pz.add(zchoice);
        zchoice.add("Do not align");
        zchoice.add("Front");
        zchoice.add("Center");
        zchoice.add("Back");
        zchoice.add("Origin");
        pz.add(new Label("align to"));
        ValueField vfz = new ValueField(Double.NaN, 0, 5);
        pz.add(vfz);
        ComponentsDialog dlg = new ComponentsDialog((Window)this, "Align to which point:", new Component[]{px, py, pz}, new String[]{"X", "Y", "Z"});
        if (!dlg.clickedOk()) {
            return;
        }
        this.setUndoRecord(new UndoRecord(this, false));
        Vec3 alignTo = new Vec3();
        int i = 0;
        while (i < sel.length) {
            obj = this.theScene.getObject((int)sel[i]).object;
            coords = this.theScene.getObject((int)sel[i]).coords;
            bounds = obj.getBounds();
            bounds = bounds.transformAndOutset(coords.fromLocal());
            center = bounds.getCenter();
            orig = coords.getOrigin();
            if (!Double.isNaN(vfx.getValue())) {
                alignTo.x += vfx.getValue();
            } else if (xchoice.getSelectedIndex() == 1) {
                alignTo.x += bounds.maxx;
            } else if (xchoice.getSelectedIndex() == 2) {
                alignTo.x += center.x;
            } else if (xchoice.getSelectedIndex() == 3) {
                alignTo.x += bounds.minx;
            } else if (xchoice.getSelectedIndex() == 4) {
                alignTo.x += orig.x;
            }
            if (!Double.isNaN(vfy.getValue())) {
                alignTo.y += vfy.getValue();
            } else if (ychoice.getSelectedIndex() == 1) {
                alignTo.y += bounds.maxy;
            } else if (ychoice.getSelectedIndex() == 2) {
                alignTo.y += center.y;
            } else if (ychoice.getSelectedIndex() == 3) {
                alignTo.y += bounds.miny;
            } else if (ychoice.getSelectedIndex() == 4) {
                alignTo.y += orig.y;
            }
            if (!Double.isNaN(vfz.getValue())) {
                alignTo.z += vfz.getValue();
            } else if (zchoice.getSelectedIndex() == 1) {
                alignTo.z += bounds.maxz;
            } else if (zchoice.getSelectedIndex() == 2) {
                alignTo.z += center.z;
            } else if (zchoice.getSelectedIndex() == 3) {
                alignTo.z += bounds.minz;
            } else if (zchoice.getSelectedIndex() == 4) {
                alignTo.z += orig.z;
            }
            ++i;
        }
        alignTo.scale(1.0 / (double)sel.length);
        i = 0;
        while (i < sel.length) {
            obj = this.theScene.getObject((int)sel[i]).object;
            coords = this.theScene.getObject((int)sel[i]).coords;
            bounds = obj.getBounds();
            bounds = bounds.transformAndOutset(coords.fromLocal());
            center = bounds.getCenter();
            orig = coords.getOrigin();
            this.undo.addCommand(1, new Object[]{coords, coords.duplicate()});
            if (xchoice.getSelectedIndex() == 1) {
                orig.x += alignTo.x - bounds.maxx;
            } else if (xchoice.getSelectedIndex() == 2) {
                orig.x += alignTo.x - center.x;
            } else if (xchoice.getSelectedIndex() == 3) {
                orig.x += alignTo.x - bounds.minx;
            } else if (xchoice.getSelectedIndex() == 4) {
                orig.x += alignTo.x - orig.x;
            }
            if (ychoice.getSelectedIndex() == 1) {
                orig.y += alignTo.y - bounds.maxy;
            } else if (ychoice.getSelectedIndex() == 2) {
                orig.y += alignTo.y - center.y;
            } else if (ychoice.getSelectedIndex() == 3) {
                orig.y += alignTo.y - bounds.miny;
            } else if (ychoice.getSelectedIndex() == 4) {
                orig.y += alignTo.y - orig.y;
            }
            if (zchoice.getSelectedIndex() == 1) {
                orig.z += alignTo.z - bounds.maxz;
            } else if (zchoice.getSelectedIndex() == 2) {
                orig.z += alignTo.z - center.z;
            } else if (zchoice.getSelectedIndex() == 3) {
                orig.z += alignTo.z - bounds.minz;
            } else if (zchoice.getSelectedIndex() == 4) {
                orig.z += alignTo.z - orig.z;
            }
            coords.setOrigin(orig);
            ++i;
        }
        this.updateImage();
    }

    void centerObjectsCommand() {
        BoundingBox bounds = null;
        int i = 0;
        while (i < this.theScene.getNumObjects()) {
            ObjectInfo info = this.theScene.getObject(i);
            BoundingBox b = info.getBounds().transformAndOutset(info.coords.fromLocal());
            bounds = bounds == null ? b : bounds.merge(b);
            ++i;
        }
        Vec3 center = bounds.getCenter();
        this.setUndoRecord(new UndoRecord(this, false));
        int i2 = 0;
        while (i2 < this.theScene.getNumObjects()) {
            ObjectInfo info = this.theScene.getObject(i2);
            this.undo.addCommand(1, new Object[]{info.coords, info.coords.duplicate()});
            info.coords.setOrigin(info.coords.getOrigin().minus(center));
            ++i2;
        }
        this.updateImage();
    }

    void convertToTriangleCommand() {
        TriangleMesh mesh;
        int[] sel = this.theScene.getSelection();
        if (sel.length != 1) {
            return;
        }
        ObjectInfo info = this.theScene.getObject(sel[0]);
        Object3D obj = info.object;
        if (obj.canConvertToTriangleMesh() == 0) {
            return;
        }
        this.setUndoRecord(new UndoRecord(this, false, 2, new Object[]{info, info.duplicate()}));
        if (obj.canConvertToTriangleMesh() == 1) {
            mesh = obj.convertToTriangleMesh(0.0);
        } else {
            double tol;
            EntriesDialog dlg = new EntriesDialog((Window)this, "Specify tolerance for triangle mesh:", new String[]{"Max Error"}, new String[]{"0.1"});
            String[] val = dlg.getEntries();
            if (val == null) {
                return;
            }
            try {
                tol = Double.valueOf(val[0]);
            }
            catch (NumberFormatException ex) {
                new MessageDialog((Window)this, "Illegal entry for error tolerance.");
                return;
            }
            if (tol < 0.0) {
                new MessageDialog((Window)this, "Error tolerance cannot be negative.");
                return;
            }
            mesh = obj.convertToTriangleMesh(tol);
        }
        if (mesh == null) {
            new MessageDialog((Window)this, "Unable to triangulate object.");
            return;
        }
        mesh.setTexture(obj.getTexture());
        ((Object3D)mesh).setTextureMapping(obj.getTextureMapping());
        mesh.setMaterial(obj.getMaterial());
        mesh.setMaterialMapping(obj.getMaterialMapping());
        this.theScene.getObject((int)sel[0]).object = mesh;
        this.theView.updateImage();
        this.updateMenus();
    }

    public void renderPreviewCommand() {
        Scene sc = new Scene();
        Camera theCamera = this.theView.getCamera();
        Container parent = this;
        double dist = theCamera.getDistToScreen();
        Renderer rend = ModellingApp.getPreferences().getObjectPreviewRenderer();
        if (rend == null) {
            return;
        }
        this.updateFromScene();
        sc.addObject(new DirectionalLight(new RGBColor(1.0f, 1.0f, 1.0f), 0.8f), theCamera.getCameraCoordinates(), "", null);
        sc.addObject(this.theObject, new CoordinateSystem(new Vec3(), Vec3.vz(), Vec3.vy()), "", null);
        while (!(parent instanceof Frame)) {
            parent = parent.getParent();
        }
        this.theView.adjustCamera(true);
        rend.configurePreview();
        new RenderingDialog((Frame)parent, rend, sc, theCamera, dist / 2.0, dist);
    }
}

