/*
 * Decompiled with CFR 0.152.
 */
package artofillusion;

import artofillusion.Camera;
import artofillusion.LayoutWindow;
import artofillusion.Scene;
import artofillusion.UndoRecord;
import artofillusion.ViewerCanvas;
import artofillusion.animation.PositionTrack;
import artofillusion.animation.RotationTrack;
import artofillusion.math.CoordinateSystem;
import artofillusion.math.Vec3;
import artofillusion.object.Curve;
import artofillusion.object.Object3D;
import artofillusion.object.ObjectInfo;
import artofillusion.object.TriangleMesh;
import artofillusion.ui.ComponentsDialog;
import artofillusion.ui.EditingTool;
import artofillusion.ui.EditingWindow;
import artofillusion.ui.MessageDialog;
import artofillusion.ui.Translate;
import artofillusion.ui.ValueField;
import java.awt.Choice;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Point;
import java.awt.Window;
import java.awt.event.MouseEvent;

public class CreatePolygonTool
extends EditingTool {
    static Image icon;
    static Image selectedIcon;
    static int counter;
    static int sides;
    static int shape;
    Point clickPoint;
    Point[] points;
    boolean dragged;
    double[] sine;
    double[] cosine;
    double minsine;
    double maxsine;
    double mincosine;
    double maxcosine;

    public CreatePolygonTool(EditingWindow fr) {
        super(fr);
        icon = this.loadImage("polygon.gif");
        selectedIcon = this.loadImage("selected/polygon.gif");
        this.tabulateSines();
    }

    public void activate() {
        super.activate();
        this.setHelpText();
    }

    private void setHelpText() {
        String type = shape == 0 ? "polygon" : (shape == 2 ? "interpolatingCurve" : "approximatingCurve");
        this.theWindow.setHelpText(Translate.text("createPolygonTool.helpText", Integer.toString(sides), Translate.text("createPolygonTool." + type)));
    }

    public int whichClicks() {
        return 0;
    }

    public Image getIcon() {
        return icon;
    }

    public Image getSelectedIcon() {
        return selectedIcon;
    }

    void tabulateSines() {
        this.sine = new double[sides];
        this.cosine = new double[sides];
        this.mincosine = 1.0;
        this.minsine = 1.0;
        this.maxcosine = -1.0;
        this.maxsine = -1.0;
        int i = 0;
        while (i < sides) {
            this.sine[i] = Math.sin(((double)i + 0.5) * 2.0 * Math.PI / (double)sides);
            this.sine[i] = 1.0E-10 * (double)Math.round(this.sine[i] * 1.0E10);
            this.cosine[i] = Math.cos(((double)i + 0.5) * 2.0 * Math.PI / (double)sides);
            this.cosine[i] = 1.0E-10 * (double)Math.round(this.cosine[i] * 1.0E10);
            if (this.sine[i] < this.minsine) {
                this.minsine = this.sine[i];
            }
            if (this.sine[i] > this.maxsine) {
                this.maxsine = this.sine[i];
            }
            if (this.cosine[i] < this.mincosine) {
                this.mincosine = this.cosine[i];
            }
            if (this.cosine[i] > this.maxcosine) {
                this.maxcosine = this.cosine[i];
            }
            ++i;
        }
    }

    public void mousePressed(MouseEvent e, ViewerCanvas view) {
        this.clickPoint = e.getPoint();
        this.dragged = false;
    }

    public void mouseDragged(MouseEvent e, ViewerCanvas view) {
        int i;
        Graphics g = view.getGraphics();
        g.setXORMode(Color.white);
        if (this.dragged) {
            i = 0;
            while (i < this.points.length - 1) {
                g.drawLine(this.points[i].x, this.points[i].y, this.points[i + 1].x, this.points[i + 1].y);
                ++i;
            }
            g.drawLine(this.points[i].x, this.points[i].y, this.points[0].x, this.points[0].y);
        }
        this.dragged = true;
        this.findPoints(e.getPoint(), e.isShiftDown());
        i = 0;
        while (i < this.points.length - 1) {
            g.drawLine(this.points[i].x, this.points[i].y, this.points[i + 1].x, this.points[i + 1].y);
            ++i;
        }
        g.drawLine(this.points[i].x, this.points[i].y, this.points[0].x, this.points[0].y);
        g.dispose();
    }

    public void mouseReleased(MouseEvent e, ViewerCanvas view) {
        Object3D obj;
        int i;
        Vec3[] vertex;
        Scene theScene = ((LayoutWindow)this.theFrame).getScene();
        Camera cam = view.getCamera();
        Point dragPoint = e.getPoint();
        float[] s = null;
        this.findPoints(dragPoint, e.isShiftDown());
        int centerx = (int)((double)(dragPoint.x + this.clickPoint.x) / 2.0);
        int centery = (int)((double)(dragPoint.y + this.clickPoint.y) / 2.0);
        if (e.isControlDown()) {
            vertex = new Vec3[this.points.length + 1];
            vertex[this.points.length] = new Vec3();
        } else {
            vertex = new Vec3[this.points.length];
            s = new float[this.points.length];
            i = 0;
            while (i < this.points.length) {
                s[i] = 1.0f;
                ++i;
            }
        }
        Vec3 orig = cam.convertScreenToWorld(new Point(centerx, centery), 20.0, false);
        Vec3 temp = cam.convertScreenToWorld(new Point(1 + centerx, centery), 20.0, false);
        double scale = temp.minus(orig).length();
        i = 0;
        while (i < this.points.length) {
            vertex[i] = new Vec3(scale * (double)(this.points[i].x - centerx), -scale * (double)(this.points[i].y - centery), 0.0);
            ++i;
        }
        Vec3 ydir = cam.getViewToWorld().timesDirection(Vec3.vy());
        Vec3 zdir = cam.getViewToWorld().timesDirection(new Vec3(0.0, 0.0, -1.0));
        CoordinateSystem coords = new CoordinateSystem(orig, zdir, ydir);
        if (e.isControlDown()) {
            int[][] faces = new int[sides][];
            faces[0] = new int[]{sides - 1, 0, sides};
            i = 1;
            while (i < sides) {
                faces[i] = new int[]{i - 1, i, sides};
                ++i;
            }
            obj = new TriangleMesh(vertex, (int[][])faces);
            obj.setTexture(theScene.getDefaultTexture());
            obj.setTextureMapping(theScene.getDefaultTexture().getDefaultMapping());
            ((TriangleMesh)obj).setSmoothingMethod(shape);
        } else {
            obj = new Curve(vertex, s, shape, true);
        }
        ObjectInfo info = new ObjectInfo(obj, coords, "Polygon " + counter++);
        info.addTrack(new PositionTrack(info), 0);
        info.addTrack(new RotationTrack(info), 1);
        UndoRecord undo = new UndoRecord(this.theWindow, false);
        ((LayoutWindow)this.theFrame).addObject(info, undo);
        this.theWindow.setUndoRecord(undo);
        ((LayoutWindow)this.theFrame).setSelection(((LayoutWindow)this.theFrame).getScene().getNumObjects() - 1);
        this.points = null;
        this.theWindow.updateImage();
    }

    void findPoints(Point dragPoint, boolean shiftDown) {
        int w = dragPoint.x - this.clickPoint.x;
        int h = dragPoint.y - this.clickPoint.y;
        if (shiftDown) {
            w = h = Math.max(w, h);
        }
        double xscale = Math.abs((double)w / (this.maxsine - this.minsine));
        double yscale = Math.abs((double)h / (this.maxcosine - this.mincosine));
        double centerx = w > 0 ? (double)this.clickPoint.x - this.minsine * xscale : (double)this.clickPoint.x - this.maxsine * xscale;
        double centery = h > 0 ? (double)this.clickPoint.y - this.mincosine * yscale : (double)this.clickPoint.y - this.maxcosine * yscale;
        if (this.points == null || this.points.length != sides) {
            this.points = new Point[sides];
        }
        int i = 0;
        while (i < sides) {
            this.points[i] = new Point((int)(centerx + this.sine[i] * xscale), (int)(centery + this.cosine[i] * yscale));
            ++i;
        }
    }

    public void iconDoubleClicked() {
        ValueField sidesField = new ValueField((double)sides, 5);
        Choice shapeChoice = new Choice();
        shapeChoice.add("Angled");
        shapeChoice.add("Interpolating");
        shapeChoice.add("Approximating");
        if (shape == 0) {
            shapeChoice.select(0);
        } else if (shape == 2) {
            shapeChoice.select(1);
        } else {
            shapeChoice.select(2);
        }
        ComponentsDialog dlg = new ComponentsDialog((Window)this.theFrame, "Enter number of sides:", new Component[]{sidesField, shapeChoice}, new String[]{"Sides", "Shape"});
        if (!dlg.clickedOk()) {
            return;
        }
        int i = (int)sidesField.getValue();
        if (i < 3) {
            new MessageDialog((Window)this.theFrame, "Number of sides cannot be less than three.");
            return;
        }
        sides = i;
        i = shapeChoice.getSelectedIndex();
        shape = i == 0 ? 0 : (i == 1 ? 2 : 3);
        this.tabulateSines();
        this.setHelpText();
    }

    static {
        counter = 1;
        sides = 3;
        shape = 0;
    }
}

