/*
 * Decompiled with CFR 0.152.
 */
package artofillusion;

import artofillusion.Camera;
import artofillusion.MeshEditorWindow;
import artofillusion.MeshViewer;
import artofillusion.WireframeMesh;
import artofillusion.math.Vec2;
import artofillusion.math.Vec3;
import artofillusion.object.Curve;
import artofillusion.object.Mesh;
import artofillusion.object.MeshVertex;
import artofillusion.object.Object3D;
import artofillusion.object.ObjectInfo;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Panel;
import java.awt.Point;
import java.awt.event.MouseEvent;

public class CurveViewer
extends MeshViewer {
    boolean[] selected;
    boolean draggingSelectionBox;
    boolean dragging;
    int[] selectionDistance;
    int maxDistance;
    int deselect;

    public CurveViewer(ObjectInfo obj, Panel p) {
        super(obj, p);
        this.selected = new boolean[((Curve)obj.object).getVertices().length];
        this.findSelectionDistance();
    }

    protected void drawObject(Graphics g) {
        Color col;
        if (!this.showMesh) {
            return;
        }
        MeshVertex[] v = ((Mesh)((Object)this.theObject)).getVertices();
        if (this.renderMode == 0) {
            Object3D.draw(g, this.theCamera, this.objInfo.getWireframePreview(), this.objInfo.getBounds());
        } else {
            WireframeMesh wireframe = this.theObject.getWireframeMesh();
            Point[] screenVert = new Point[wireframe.vert.length];
            double[] screenZ = new double[wireframe.vert.length];
            Vec2[] pos = new Vec2[wireframe.vert.length];
            int i = 0;
            while (i < wireframe.vert.length) {
                pos[i] = this.theCamera.getObjectToScreen().timesXY(wireframe.vert[i]);
                screenVert[i] = new Point((int)pos[i].x, (int)pos[i].y);
                screenZ[i] = this.theCamera.getObjectToView().timesZ(wireframe.vert[i]);
                ++i;
            }
            int col2 = Color.black.getRGB();
            int i2 = 0;
            while (i2 < wireframe.from.length) {
                this.renderLine(pos[wireframe.from[i2]], screenZ[wireframe.from[i2]], pos[wireframe.to[i2]], screenZ[wireframe.to[i2]], this.theCamera, col2);
                ++i2;
            }
        }
        int i = 0;
        while (i < v.length) {
            if (!this.selected[i] && this.theCamera.getObjectToView().timesZ(v[i].r) > this.theCamera.getClipDistance()) {
                Vec2 p = this.theCamera.getObjectToScreen().timesXY(v[i].r);
                if (this.renderMode == 0) {
                    g.fillRect((int)p.x - 2, (int)p.y - 2, 5, 5);
                } else {
                    double z = this.theCamera.getObjectToView().timesZ(v[i].r);
                    this.renderBox((int)p.x - 2, (int)p.y - 2, 5, 5, z, Color.black);
                }
            }
            ++i;
        }
        Color color = col = this.currentTool.hilightSelection() ? Color.magenta : Color.black;
        if (g != null) {
            g.setColor(col);
        }
        int i3 = 0;
        while (i3 < v.length) {
            if (this.selected[i3] && this.theCamera.getObjectToView().timesZ(v[i3].r) > this.theCamera.getClipDistance()) {
                Vec2 p = this.theCamera.getObjectToScreen().timesXY(v[i3].r);
                if (this.renderMode == 0) {
                    g.fillRect((int)p.x - 2, (int)p.y - 2, 5, 5);
                } else {
                    double z = this.theCamera.getObjectToView().timesZ(v[i3].r);
                    this.renderBox((int)p.x - 2, (int)p.y - 2, 5, 5, z, col);
                }
            }
            ++i3;
        }
    }

    public void drawDraggedSelection(Graphics g, Camera cam, Vec3[] v) {
        MeshVertex[] vert = ((Curve)this.theObject).getVertices();
        int i = 1;
        while (i < vert.length) {
            cam.drawClippedLine(g, v[i - 1], v[i]);
            Vec2 p = cam.getObjectToScreen().timesXY(v[i]);
            g.fillRect((int)p.x - 2, (int)p.y - 2, 5, 5);
            ++i;
        }
        if (((Curve)this.theObject).isClosed()) {
            cam.drawClippedLine(g, v[i - 1], v[0]);
        }
    }

    public boolean[] getSelection() {
        return this.selected;
    }

    public void setSelection(boolean[] sel) {
        this.selected = sel;
        this.findSelectionDistance();
        this.currentTool.getWindow().updateMenus();
        this.updateImage();
        this.repaint();
    }

    public int[] getSelectionDistance() {
        if (this.maxDistance != MeshEditorWindow.getTensionDistance()) {
            this.findSelectionDistance();
        }
        return this.selectionDistance;
    }

    void findSelectionDistance() {
        Curve theCurve = (Curve)this.theObject;
        int[] dist = new int[theCurve.getVertices().length];
        this.maxDistance = MeshEditorWindow.getTensionDistance();
        int i = 0;
        while (i < dist.length) {
            dist[i] = this.selected[i] ? 0 : -1;
            ++i;
        }
        i = 0;
        while (i < this.maxDistance) {
            int j = 0;
            while (j < dist.length - 1) {
                if (dist[j] == -1 && dist[j + 1] == i) {
                    dist[j] = i + 1;
                }
                ++j;
            }
            j = 1;
            while (j < dist.length) {
                if (dist[j] == -1 && dist[j - 1] == i) {
                    dist[j] = i + 1;
                }
                ++j;
            }
            if (theCurve.isClosed()) {
                if (dist[0] == -1 && dist[dist.length - 1] == i) {
                    dist[0] = i + 1;
                }
                if (dist[0] == i && dist[dist.length - 1] == -1) {
                    dist[dist.length - 1] = i + 1;
                }
            }
            ++i;
        }
        this.selectionDistance = dist;
    }

    public void setMesh(Mesh mesh) {
        Curve obj = (Curve)mesh;
        this.setObject(obj);
        if (this.selected.length != obj.getVertices().length) {
            this.selected = new boolean[obj.getVertices().length];
        }
        this.findSelectionDistance();
        this.currentTool.getWindow().updateMenus();
    }

    public void mousePressed(MouseEvent e) {
        int y;
        int x;
        Vec2 pos;
        MeshVertex[] v = ((Curve)this.theObject).getVertices();
        this.requestFocus();
        this.sentClick = true;
        this.deselect = -1;
        this.dragging = false;
        this.clickPoint = e.getPoint();
        this.activeTool = this.metaTool != null && e.isMetaDown() ? this.metaTool : (this.altTool != null && e.isAltDown() ? this.altTool : this.currentTool);
        if (this.activeTool.whichClicks() == 0) {
            this.activeTool.mousePressed(e, this);
            this.dragging = true;
            return;
        }
        Point p = e.getPoint();
        int i = 0;
        while (i < v.length) {
            if (this.selected[i]) {
                pos = this.theCamera.getObjectToScreen().timesXY(v[i].r);
                x = (int)pos.x;
                y = (int)pos.y;
                if (x >= p.x - 2 && x <= p.x + 2 && y >= p.y - 2 && y <= p.y + 2) break;
            }
            ++i;
        }
        if (i < v.length) {
            if (e.isShiftDown()) {
                this.deselect = i;
            }
            this.activeTool.mousePressedOnHandle(e, this, 0, i);
            return;
        }
        int j = -1;
        double nearest = Double.MAX_VALUE;
        i = 0;
        while (i < v.length) {
            double z;
            pos = this.theCamera.getObjectToScreen().timesXY(v[i].r);
            x = (int)pos.x;
            y = (int)pos.y;
            if (x >= p.x - 2 && x <= p.x + 2 && y >= p.y - 2 && y <= p.y + 2 && (z = this.theCamera.getObjectToView().timesZ(v[i].r)) > 0.0 && z < nearest) {
                nearest = z;
                j = i;
            }
            ++i;
        }
        if (j > -1) {
            if (!e.isShiftDown()) {
                i = 0;
                while (i < this.selected.length) {
                    this.selected[i] = false;
                    ++i;
                }
            }
            this.selected[j] = true;
            this.findSelectionDistance();
            this.activeTool.getWindow().updateMenus();
            if (e.isShiftDown()) {
                this.sentClick = false;
                this.updateImage();
                this.repaint();
            } else {
                this.activeTool.mousePressedOnHandle(e, this, 0, j);
            }
            return;
        }
        this.draggingSelectionBox = true;
        this.beginDraggingSelection(p, false);
        this.sentClick = false;
    }

    public void mouseDragged(MouseEvent e) {
        if (!this.dragging) {
            Point p = e.getPoint();
            if (Math.abs(p.x - this.clickPoint.x) < 2 && Math.abs(p.y - this.clickPoint.y) < 2) {
                return;
            }
        }
        this.dragging = true;
        this.deselect = -1;
        super.mouseDragged(e);
    }

    public void mouseReleased(MouseEvent e) {
        int i;
        MeshVertex[] v = ((Curve)this.theObject).getVertices();
        this.moveToGrid(e);
        this.endDraggingSelection();
        if (this.draggingSelectionBox && !e.isShiftDown() && !e.isControlDown()) {
            i = 0;
            while (i < this.selected.length) {
                this.selected[i] = false;
                ++i;
            }
        }
        if (this.selectBounds != null) {
            boolean newsel = !e.isControlDown();
            i = 0;
            while (i < v.length) {
                Vec2 pos = this.theCamera.getObjectToScreen().timesXY(v[i].r);
                int x = (int)pos.x;
                int y = (int)pos.y;
                if (this.selectionRegionContains(new Point(x, y))) {
                    this.selected[i] = newsel;
                }
                ++i;
            }
        }
        this.draggingSelectionBox = false;
        this.draggingBox = false;
        if (this.sentClick) {
            if (!this.dragging) {
                Point p = e.getPoint();
                e.translatePoint(this.clickPoint.x - p.x, this.clickPoint.y - p.y);
            }
            this.activeTool.mouseReleased(e, this);
        }
        if (this.deselect > -1) {
            this.selected[this.deselect] = false;
        }
        this.findSelectionDistance();
        this.activeTool.getWindow().updateMenus();
        this.updateImage();
        this.repaint();
    }
}

