/*
 * Decompiled with CFR 0.152.
 */
package artofillusion;

import artofillusion.Callback;
import artofillusion.CreateCameraTool;
import artofillusion.CreateCubeTool;
import artofillusion.CreateCurveTool;
import artofillusion.CreateCylinderTool;
import artofillusion.CreateLightTool;
import artofillusion.CreatePolygonTool;
import artofillusion.CreateSphereTool;
import artofillusion.CreateSplineMeshTool;
import artofillusion.ModellingApp;
import artofillusion.ModellingTool;
import artofillusion.MoveObjectTool;
import artofillusion.MoveViewTool;
import artofillusion.ObjectMaterialDialog;
import artofillusion.ObjectTextureDialog;
import artofillusion.PreferencesWindow;
import artofillusion.RenderSetupDialog;
import artofillusion.RotateObjectTool;
import artofillusion.RotateViewTool;
import artofillusion.ScaleObjectTool;
import artofillusion.Scene;
import artofillusion.SceneViewer;
import artofillusion.TransformDialog;
import artofillusion.Translator;
import artofillusion.UndoRecord;
import artofillusion.ViewerCanvas;
import artofillusion.animation.AnimationPreviewer;
import artofillusion.animation.EditKeyframesDialog;
import artofillusion.animation.Joint;
import artofillusion.animation.ObjectRef;
import artofillusion.animation.PathFromCurveDialog;
import artofillusion.animation.PoseTrack;
import artofillusion.animation.PositionTrack;
import artofillusion.animation.RotationTrack;
import artofillusion.animation.Score;
import artofillusion.animation.Skeleton;
import artofillusion.animation.Track;
import artofillusion.image.ImagesDialog;
import artofillusion.math.BoundingBox;
import artofillusion.math.CoordinateSystem;
import artofillusion.math.Mat4;
import artofillusion.math.RGBColor;
import artofillusion.math.Vec3;
import artofillusion.object.Cube;
import artofillusion.object.Curve;
import artofillusion.object.Cylinder;
import artofillusion.object.DirectionalLight;
import artofillusion.object.NullObject;
import artofillusion.object.Object3D;
import artofillusion.object.ObjectInfo;
import artofillusion.object.PointLight;
import artofillusion.object.SceneCamera;
import artofillusion.object.Sphere;
import artofillusion.object.SpotLight;
import artofillusion.script.ExecuteScriptWindow;
import artofillusion.script.ScriptRunner;
import artofillusion.script.ScriptedObject;
import artofillusion.script.ToolScript;
import artofillusion.texture.Texture;
import artofillusion.texture.TextureMapping;
import artofillusion.ui.AutoScroller;
import artofillusion.ui.ColorChooser;
import artofillusion.ui.ComponentsDialog;
import artofillusion.ui.DividedPanel;
import artofillusion.ui.EditingTool;
import artofillusion.ui.EditingWindow;
import artofillusion.ui.EntriesDialog;
import artofillusion.ui.MessageDialog;
import artofillusion.ui.ObjectTreeElement;
import artofillusion.ui.PopupMenuManager;
import artofillusion.ui.ShortLabel;
import artofillusion.ui.ToolPalette;
import artofillusion.ui.Translate;
import artofillusion.ui.TreeAdapter;
import artofillusion.ui.TreeElement;
import artofillusion.ui.TreeEvent;
import artofillusion.ui.TreeList;
import artofillusion.ui.ValueField;
import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.CardLayout;
import java.awt.Checkbox;
import java.awt.CheckboxMenuItem;
import java.awt.Choice;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FileDialog;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Label;
import java.awt.Menu;
import java.awt.MenuBar;
import java.awt.MenuContainer;
import java.awt.MenuItem;
import java.awt.Panel;
import java.awt.PopupMenu;
import java.awt.ScrollPane;
import java.awt.TextComponent;
import java.awt.TextField;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.IOException;
import java.text.NumberFormat;

public class LayoutWindow
extends Frame
implements EditingWindow,
ItemListener,
KeyListener,
ActionListener,
PopupMenuManager {
    SceneViewer[] theView;
    Panel[] viewPanel;
    Panel viewsContainer;
    DividedPanel div1;
    DividedPanel div2;
    ScrollPane itemTreeScroller;
    Score theScore;
    ToolPalette tools;
    EditingTool defaultTool;
    EditingTool currentTool;
    Panel toolsPanel;
    Label helpText;
    Label timeLabel;
    Label frameLabel;
    TreeList itemTree;
    Scene theScene;
    MenuBar menubar;
    Menu fileMenu;
    Menu editMenu;
    Menu objectMenu;
    Menu createMenu;
    Menu toolsMenu;
    Menu scriptMenu;
    Menu animationMenu;
    Menu editKeyframeMenu;
    Menu sceneMenu;
    Menu addTrackMenu;
    Menu positionTrackMenu;
    Menu rotationTrackMenu;
    Menu distortionMenu;
    MenuItem[] fileMenuItem;
    MenuItem[] editMenuItem;
    MenuItem[] objectMenuItem;
    MenuItem[] toolsMenuItem;
    MenuItem[] animationMenuItem;
    MenuItem[] sceneMenuItem;
    MenuItem[] popupMenuItem;
    CheckboxMenuItem[] displayItem;
    PopupMenu popupMenu;
    UndoRecord undo;
    int numViewsShown;
    int currentView;
    boolean modified;
    boolean scoreHidden;
    boolean listHidden;
    static /* synthetic */ Class class$artofillusion$animation$PoseTrack;
    static /* synthetic */ Class class$artofillusion$animation$ConstraintTrack;
    static /* synthetic */ Class class$artofillusion$animation$VisibilityTrack;
    static /* synthetic */ Class class$artofillusion$animation$TextureTrack;
    static /* synthetic */ Class class$artofillusion$animation$PositionTrack;
    static /* synthetic */ Class class$artofillusion$animation$ProceduralPositionTrack;
    static /* synthetic */ Class class$artofillusion$animation$RotationTrack;
    static /* synthetic */ Class class$artofillusion$animation$ProceduralRotationTrack;
    static /* synthetic */ Class class$artofillusion$animation$distortion$BendTrack;
    static /* synthetic */ Class class$artofillusion$animation$distortion$CustomDistortionTrack;
    static /* synthetic */ Class class$artofillusion$animation$distortion$ScaleTrack;
    static /* synthetic */ Class class$artofillusion$animation$distortion$ShatterTrack;
    static /* synthetic */ Class class$artofillusion$animation$distortion$TwistTrack;

    public LayoutWindow(Scene s) {
        super(s.getName() == null ? "Untitled" : s.getName());
        Panel p;
        this.theScene = s;
        this.helpText = new Label();
        this.createItemList();
        this.theView = new SceneViewer[4];
        this.viewPanel = new Panel[4];
        MouseAdapter listen = new MouseAdapter(){

            public void mousePressed(MouseEvent ev) {
                int i = 0;
                while (i < LayoutWindow.this.theView.length) {
                    if (LayoutWindow.this.currentView != i && ev.getSource() == LayoutWindow.this.theView[i]) {
                        LayoutWindow.this.theView[LayoutWindow.this.currentView].setDrawFocus(false);
                        LayoutWindow.this.theView[i].setDrawFocus(true);
                        LayoutWindow.this.displayItem[0].setState(LayoutWindow.this.theView[i].getRenderMode() == 0);
                        LayoutWindow.this.displayItem[1].setState(LayoutWindow.this.theView[i].getRenderMode() == 1);
                        LayoutWindow.this.displayItem[2].setState(LayoutWindow.this.theView[i].getRenderMode() == 2);
                        LayoutWindow.this.currentView = i;
                        LayoutWindow.this.updateImage();
                    }
                    ++i;
                }
            }
        };
        int i = 0;
        while (i < 4) {
            this.viewPanel[i] = new Panel();
            this.viewPanel[i].setLayout(new BorderLayout());
            p = new Panel();
            this.viewPanel[i].add((Component)p, "North");
            this.theView[i] = new SceneViewer(this.theScene, p, this);
            this.viewPanel[i].add((Component)this.theView[i], "Center");
            this.theView[i].setGrid(this.theScene.gridSpacing, this.theScene.gridSubdivisions, this.theScene.showGrid, this.theScene.snapToGrid);
            this.theView[i].addMouseListener(listen);
            ++i;
        }
        this.theView[1].selectOrientation(2);
        this.theView[2].selectOrientation(4);
        this.theView[3].selectOrientation(6);
        this.theView[3].setPerspective(true);
        this.theView[this.currentView].setDrawFocus(true);
        this.viewsContainer = new Panel();
        this.viewsContainer.setLayout(new GridBagLayout());
        this.div1 = new DividedPanel(this.viewsContainer, this.itemTreeScroller, 1.0f, 0.0f, false);
        this.div1.setLiveValidate(false, true);
        p = new Panel();
        p.setLayout(new BorderLayout());
        p.add((Component)this.div1, "Center");
        p.add((Component)this.helpText, "South");
        this.theScore = new Score(this);
        this.div2 = new DividedPanel(p, this.theScore, 3.0f, 1.0f, true);
        this.div2.setLiveValidate(false, true);
        this.add((Component)this.div2, "Center");
        this.div2.setBackground(ModellingApp.APP_BACKGROUND_COLOR);
        this.itemTreeScroller.setBackground(Color.white);
        this.numViewsShown = 1;
        this.tools = new ToolPalette(2, 7);
        this.defaultTool = new MoveObjectTool(this);
        this.tools.addTool(this.defaultTool);
        this.tools.addTool(new RotateObjectTool(this));
        this.tools.addTool(new ScaleObjectTool(this));
        this.tools.addTool(new CreateCubeTool(this));
        this.tools.addTool(new CreateSphereTool(this));
        this.tools.addTool(new CreateCylinderTool(this));
        this.tools.addTool(new CreateSplineMeshTool(this));
        this.tools.addTool(new CreatePolygonTool(this));
        this.tools.addTool(new CreateCameraTool(this));
        this.tools.addTool(new CreateLightTool(this));
        this.tools.addTool(new CreateCurveTool(this, 2));
        this.tools.addTool(new CreateCurveTool(this, 3));
        MoveViewTool metaTool = new MoveViewTool(this);
        this.tools.addTool(metaTool);
        RotateViewTool altTool = new RotateViewTool(this);
        this.tools.addTool(altTool);
        this.tools.selectTool(this.defaultTool);
        int i2 = 0;
        while (i2 < this.theView.length) {
            this.theView[i2].setMetaTool(metaTool);
            this.theView[i2].setAltTool(altTool);
            ++i2;
        }
        altTool.setUseSelectionCenter(true);
        this.toolsPanel = new Panel();
        this.toolsPanel.setLayout(new GridBagLayout());
        GridBagConstraints gc = new GridBagConstraints();
        gc.gridx = 0;
        gc.anchor = 11;
        this.toolsPanel.add((Component)this.tools, gc);
        gc.fill = 2;
        gc.weighty = 1.0;
        gc.anchor = 15;
        this.toolsPanel.add((Component)new ShortLabel(Translate.text("Time") + ':', 1), gc);
        gc.weighty = 0.0;
        this.timeLabel = new ShortLabel("0.0", 1);
        this.toolsPanel.add((Component)this.timeLabel, gc);
        this.toolsPanel.add((Component)new ShortLabel(Translate.text("Frame") + ':', 1), gc);
        this.frameLabel = new ShortLabel("0", 1);
        this.toolsPanel.add((Component)this.frameLabel, gc);
        this.menubar = new MenuBar();
        this.setMenuBar(this.menubar);
        this.createFileMenu();
        this.createEditMenu();
        this.createObjectMenu();
        this.createToolsMenu();
        this.createAnimationMenu();
        this.createSceneMenu();
        this.createPopupMenu();
        this.toggleViewsCommand();
        this.recursivelyAddListeners(this);
        this.addWindowListener(new WindowAdapter(){

            public void windowActivated(WindowEvent e) {
                LayoutWindow.this.updateMenus();
            }

            public void windowClosing(WindowEvent e) {
                ModellingApp.closeWindow(LayoutWindow.this);
            }
        });
        this.itemTree.setPopupMenuManager(this);
        if (ModellingApp.defaultFont != null) {
            this.setFont(ModellingApp.defaultFont);
        }
        this.pack();
        this.scoreHidden = true;
        this.div2.setHidden(false, true);
        Dimension screenDim = Toolkit.getDefaultToolkit().getScreenSize();
        ((Component)this).setSize(screenDim.width, screenDim.height - 20);
        this.tools.requestFocus();
        this.updateMenus();
    }

    private void createItemList() {
        this.itemTree = new TreeList(this);
        this.itemTree.setPreferredSize(130, 100);
        this.itemTree.addTreeListener(new TreeAdapter(){

            public void elementsMoved(TreeEvent e) {
                LayoutWindow.this.theScore.rebuildList();
            }

            public void elementDoubleClicked(TreeEvent e) {
                LayoutWindow.this.editObjectCommand();
            }
        });
        this.itemTree.setUpdateEnabled(false);
        int i = 0;
        while (i < this.theScene.getNumObjects()) {
            ObjectInfo info = this.theScene.getObject(i);
            if (info.parent == null) {
                this.itemTree.addElement(new ObjectTreeElement(info, this.itemTree));
            }
            ++i;
        }
        this.itemTree.setUpdateEnabled(true);
        ScrollPane sp = new ScrollPane();
        sp.add(this.itemTree);
        sp.getVAdjustable().setUnitIncrement(10);
        this.itemTree.addItemListener(this);
        new AutoScroller(this.itemTree, sp, 0, 10);
        this.itemTreeScroller = sp;
    }

    public void rebuildItemList() {
        boolean[] expanded = new boolean[this.theScene.getNumObjects()];
        boolean[] selected = new boolean[this.theScene.getNumObjects()];
        int i = 0;
        while (i < this.theScene.getNumObjects()) {
            ObjectInfo info = this.theScene.getObject(i);
            TreeElement el = this.itemTree.findElement(info);
            if (el != null) {
                expanded[i] = el.isExpanded();
                selected[i] = el.isSelected();
            }
            ++i;
        }
        this.itemTree.setUpdateEnabled(false);
        this.itemTree.removeAllElements();
        int i2 = 0;
        while (i2 < this.theScene.getNumObjects()) {
            ObjectInfo info = this.theScene.getObject(i2);
            if (info.parent == null) {
                this.itemTree.addElement(new ObjectTreeElement(info, this.itemTree));
            }
            ++i2;
        }
        int i3 = 0;
        while (i3 < this.theScene.getNumObjects()) {
            ObjectInfo info = this.theScene.getObject(i3);
            TreeElement el = this.itemTree.findElement(info);
            if (el != null) {
                el.setExpanded(expanded[i3]);
                el.setSelected(selected[i3]);
            }
            ++i3;
        }
        this.itemTree.setUpdateEnabled(true);
        this.theScore.rebuildList();
    }

    private void createFileMenu() {
        Translator[] trans = ModellingApp.getTranslators();
        this.fileMenu = Translate.menu("file");
        this.menubar.add(this.fileMenu);
        Menu importMenu = Translate.menu("import");
        Menu exportMenu = Translate.menu("export");
        this.fileMenuItem = new MenuItem[1];
        this.fileMenu.add(Translate.menuItem("new", this));
        this.fileMenu.add(Translate.menuItem("open", this));
        this.fileMenu.add(Translate.menuItem("close", this));
        this.fileMenu.addSeparator();
        int i = 0;
        while (i < trans.length) {
            MenuItem item;
            if (trans[i].canImport()) {
                item = new MenuItem(trans[i].getName());
                importMenu.add(item);
                item.setActionCommand("import");
                item.addActionListener(this);
            }
            if (trans[i].canExport()) {
                item = new MenuItem(trans[i].getName());
                exportMenu.add(item);
                item.setActionCommand("export");
                item.addActionListener(this);
            }
            ++i;
        }
        if (importMenu.getItemCount() > 0) {
            this.fileMenu.add(importMenu);
        }
        if (exportMenu.getItemCount() > 0) {
            this.fileMenu.add(exportMenu);
        }
        if (importMenu.getItemCount() > 0 || exportMenu.getItemCount() > 0) {
            this.fileMenu.addSeparator();
        }
        this.fileMenuItem[0] = Translate.menuItem("save", this);
        this.fileMenu.add(this.fileMenuItem[0]);
        this.fileMenu.add(Translate.menuItem("saveas", this));
        this.fileMenu.addSeparator();
        this.fileMenu.add(Translate.menuItem("quit", this));
    }

    private void createEditMenu() {
        this.editMenu = Translate.menu("edit");
        this.menubar.add(this.editMenu);
        this.editMenuItem = new MenuItem[8];
        this.editMenuItem[0] = Translate.menuItem("undo", this);
        this.editMenu.add(this.editMenuItem[0]);
        this.editMenuItem[0].setEnabled(false);
        this.editMenu.addSeparator();
        this.editMenuItem[1] = Translate.menuItem("cut", this);
        this.editMenu.add(this.editMenuItem[1]);
        this.editMenuItem[2] = Translate.menuItem("copy", this);
        this.editMenu.add(this.editMenuItem[2]);
        this.editMenuItem[3] = Translate.menuItem("paste", this);
        this.editMenu.add(this.editMenuItem[3]);
        this.editMenuItem[4] = Translate.menuItem("clear", this);
        this.editMenu.add(this.editMenuItem[4]);
        this.editMenuItem[5] = Translate.menuItem("selectChildren", this);
        this.editMenu.add(this.editMenuItem[5]);
        this.editMenu.add(Translate.menuItem("selectAll", this));
        this.editMenu.addSeparator();
        this.editMenuItem[6] = Translate.menuItem("duplicate", this);
        this.editMenu.add(this.editMenuItem[6]);
        this.editMenuItem[7] = Translate.menuItem("sever", this);
        this.editMenu.add(this.editMenuItem[7]);
        this.editMenu.addSeparator();
        this.editMenu.add(Translate.menuItem("preferences", this));
    }

    private void createObjectMenu() {
        this.objectMenu = Translate.menu("object");
        this.menubar.add(this.objectMenu);
        this.objectMenuItem = new MenuItem[10];
        this.objectMenuItem[0] = Translate.menuItem("editObject", this);
        this.objectMenu.add(this.objectMenuItem[0]);
        this.objectMenuItem[1] = Translate.menuItem("objectLayout", this);
        this.objectMenu.add(this.objectMenuItem[1]);
        this.objectMenuItem[2] = Translate.menuItem("transformObject", this);
        this.objectMenu.add(this.objectMenuItem[2]);
        this.objectMenuItem[3] = Translate.menuItem("alignObjects", this);
        this.objectMenu.add(this.objectMenuItem[3]);
        this.objectMenuItem[4] = Translate.menuItem("setTexture", this);
        this.objectMenu.add(this.objectMenuItem[4]);
        this.objectMenuItem[5] = Translate.menuItem("setMaterial", this);
        this.objectMenu.add(this.objectMenuItem[5]);
        this.objectMenuItem[6] = Translate.menuItem("renameObject", this);
        this.objectMenu.add(this.objectMenuItem[6]);
        this.objectMenuItem[7] = Translate.menuItem("convertToTriangle", this);
        this.objectMenu.add(this.objectMenuItem[7]);
        this.objectMenu.addSeparator();
        this.objectMenuItem[8] = Translate.menuItem("hideSelection", this);
        this.objectMenu.add(this.objectMenuItem[8]);
        this.objectMenuItem[9] = Translate.menuItem("showSelection", this);
        this.objectMenu.add(this.objectMenuItem[9]);
        this.objectMenu.add(Translate.menuItem("showAll", this));
        this.objectMenu.addSeparator();
        this.createMenu = Translate.menu("createPrimitive");
        this.objectMenu.add(this.createMenu);
        this.createMenu.add(Translate.menuItem("cube", this));
        this.createMenu.add(Translate.menuItem("sphere", this));
        this.createMenu.add(Translate.menuItem("cylinder", this));
        this.createMenu.add(Translate.menuItem("cone", this));
        this.createMenu.add(Translate.menuItem("pointLight", this));
        this.createMenu.add(Translate.menuItem("directionalLight", this));
        this.createMenu.add(Translate.menuItem("spotLight", this));
        this.createMenu.add(Translate.menuItem("camera", this));
        this.createMenu.add(Translate.menuItem("null", this));
    }

    private void createToolsMenu() {
        ModellingTool[] tools = ModellingApp.getModellingTools();
        this.toolsMenu = Translate.menu("tools");
        this.menubar.add(this.toolsMenu);
        this.toolsMenuItem = new MenuItem[tools.length];
        int i = 0;
        while (i < tools.length) {
            MenuItem item = new MenuItem(tools[i].getName());
            this.toolsMenu.add(item);
            item.setActionCommand("modellingTool");
            item.addActionListener(this);
            this.toolsMenuItem[i] = item;
            ++i;
        }
        this.toolsMenu.addSeparator();
        this.toolsMenu.add(Translate.menuItem("createScriptObject", this));
        this.toolsMenu.add(Translate.menuItem("editScript", this));
        this.scriptMenu = Translate.menu("scripts");
        this.toolsMenu.add(this.scriptMenu);
        this.rebuildScriptsMenu();
    }

    public void rebuildScriptsMenu() {
        this.scriptMenu.removeAll();
        this.addScriptsToMenu(this.scriptMenu, new File(ModellingApp.TOOL_SCRIPT_DIRECTORY));
    }

    private void addScriptsToMenu(Menu menu, File dir2) {
        String[] files = dir2.list();
        if (files == null) {
            return;
        }
        int i = 0;
        while (i < files.length) {
            File f = new File(dir2, files[i]);
            if (f.isDirectory()) {
                Menu m = new Menu(files[i]);
                menu.add(m);
                this.addScriptsToMenu(m, f);
            } else if (files[i].endsWith(".bsh") && files[i].length() > 4) {
                MenuItem item = new MenuItem(files[i].substring(0, files[i].length() - 4));
                item.setActionCommand(f.getAbsolutePath());
                item.addActionListener(this);
                menu.add(item);
            }
            ++i;
        }
    }

    private void createAnimationMenu() {
        this.animationMenu = Translate.menu("animation");
        this.menubar.add(this.animationMenu);
        this.animationMenuItem = new MenuItem[13];
        this.animationMenuItem[0] = Translate.menuItem("showScore", this);
        this.animationMenu.add(this.animationMenuItem[0]);
        this.animationMenu.add(Translate.menuItem("previewAnimation", this));
        this.animationMenu.addSeparator();
        this.animationMenu.add(Translate.menuItem("forwardFrame", this));
        this.animationMenu.add(Translate.menuItem("backFrame", this));
        this.animationMenu.add(Translate.menuItem("jumpToTime", this));
        this.animationMenu.addSeparator();
        this.animationMenuItem[1] = Translate.menuItem("editKeyframe", this);
        this.animationMenu.add(this.animationMenuItem[1]);
        this.animationMenuItem[2] = Translate.menuItem("deleteSelectedKeyframes", this);
        this.animationMenu.add(this.animationMenuItem[2]);
        this.editKeyframeMenu = Translate.menu("bulkEditKeyframes");
        this.animationMenu.add(this.editKeyframeMenu);
        this.editKeyframeMenu.add(Translate.menuItem("moveKeyframes", this));
        this.editKeyframeMenu.add(Translate.menuItem("copyKeyframes", this));
        this.editKeyframeMenu.add(Translate.menuItem("rescaleKeyframes", this));
        this.editKeyframeMenu.add(Translate.menuItem("loopKeyframes", this));
        this.editKeyframeMenu.add(Translate.menuItem("deleteKeyframes", this));
        this.animationMenuItem[3] = Translate.menuItem("keyframe", this);
        this.animationMenu.add(this.animationMenuItem[3]);
        this.animationMenuItem[4] = Translate.menuItem("keyframeModified", this);
        this.animationMenu.add(this.animationMenuItem[4]);
        this.animationMenu.addSeparator();
        this.animationMenuItem[5] = Translate.menuItem("editTrack", this);
        this.animationMenu.add(this.animationMenuItem[5]);
        this.addTrackMenu = Translate.menu("addTrack");
        this.animationMenu.add(this.addTrackMenu);
        this.positionTrackMenu = Translate.menu("positionTrack");
        this.addTrackMenu.add(this.positionTrackMenu);
        this.positionTrackMenu.add(Translate.menuItem("xyzOneTrack", this));
        this.positionTrackMenu.add(Translate.menuItem("xyzThreeTracks", this));
        this.positionTrackMenu.add(Translate.menuItem("proceduralTrack", this));
        this.rotationTrackMenu = Translate.menu("rotationTrack");
        this.addTrackMenu.add(this.rotationTrackMenu);
        this.rotationTrackMenu.add(Translate.menuItem("xyzOneTrack", this));
        this.rotationTrackMenu.add(Translate.menuItem("xyzThreeTracks", this));
        this.rotationTrackMenu.add(Translate.menuItem("quaternionTrack", this));
        this.rotationTrackMenu.add(Translate.menuItem("proceduralTrack", this));
        this.addTrackMenu.add(Translate.menuItem("poseTrack", this));
        this.distortionMenu = Translate.menu("distortionTrack");
        this.addTrackMenu.add(this.distortionMenu);
        this.distortionMenu.add(Translate.menuItem("bendDistortion", this));
        this.distortionMenu.add(Translate.menuItem("customDistortion", this));
        this.distortionMenu.add(Translate.menuItem("scaleDistortion", this));
        this.distortionMenu.add(Translate.menuItem("shatterDistortion", this));
        this.distortionMenu.add(Translate.menuItem("twistDistortion", this));
        this.addTrackMenu.add(Translate.menuItem("constraintTrack", this));
        this.addTrackMenu.add(Translate.menuItem("visibilityTrack", this));
        this.addTrackMenu.add(Translate.menuItem("textureTrack", this));
        this.animationMenuItem[6] = Translate.menuItem("duplicateTracks", this);
        this.animationMenu.add(this.animationMenuItem[6]);
        this.animationMenuItem[7] = Translate.menuItem("deleteTracks", this);
        this.animationMenu.add(this.animationMenuItem[7]);
        this.animationMenuItem[8] = Translate.menuItem("selectAllTracks", this);
        this.animationMenu.add(this.animationMenuItem[8]);
        this.animationMenuItem[9] = Translate.menuItem("enableTracks", this);
        this.animationMenu.add(this.animationMenuItem[9]);
        this.animationMenuItem[10] = Translate.menuItem("disableTracks", this);
        this.animationMenu.add(this.animationMenuItem[10]);
        this.animationMenuItem[11] = Translate.menuItem("pathFromCurve", this);
        this.animationMenu.add(this.animationMenuItem[11]);
        this.animationMenuItem[12] = Translate.menuItem("bindToParent", this);
        this.animationMenu.add(this.animationMenuItem[12]);
    }

    private void createSceneMenu() {
        this.sceneMenu = Translate.menu("scene");
        this.menubar.add(this.sceneMenu);
        this.sceneMenuItem = new MenuItem[4];
        this.sceneMenu.add(Translate.menuItem("renderScene", this));
        this.sceneMenu.add(Translate.menuItem("renderImmediately", this));
        this.sceneMenu.addSeparator();
        Menu displayMenu = Translate.menu("displayMode");
        this.sceneMenu.add(displayMenu);
        this.displayItem = new CheckboxMenuItem[3];
        this.displayItem[0] = Translate.checkboxMenuItem("wireframeDisplay", this, this.theView[0].getRenderMode() == 0);
        displayMenu.add(this.displayItem[0]);
        this.displayItem[1] = Translate.checkboxMenuItem("shadedDisplay", this, this.theView[0].getRenderMode() == 1);
        displayMenu.add(this.displayItem[1]);
        this.displayItem[2] = Translate.checkboxMenuItem("smoothDisplay", this, this.theView[0].getRenderMode() == 2);
        displayMenu.add(this.displayItem[2]);
        this.sceneMenuItem[0] = Translate.menuItem("fourViews", this);
        this.sceneMenu.add(this.sceneMenuItem[0]);
        this.sceneMenuItem[1] = Translate.menuItem("hideObjectList", this);
        this.sceneMenu.add(this.sceneMenuItem[1]);
        this.sceneMenu.add(Translate.menuItem("grid", this));
        this.sceneMenuItem[2] = Translate.menuItem("showTemplate", this);
        this.sceneMenu.add(this.sceneMenuItem[2]);
        this.sceneMenu.add(Translate.menuItem("setTemplate", this));
        this.sceneMenu.addSeparator();
        this.sceneMenuItem[3] = Translate.menuItem("frameSelection", this);
        this.sceneMenu.add(this.sceneMenuItem[3]);
        this.sceneMenu.add(Translate.menuItem("frameScene", this));
        this.sceneMenu.addSeparator();
        this.sceneMenu.add(Translate.menuItem("textures", this));
        this.sceneMenu.add(Translate.menuItem("materials", this));
        this.sceneMenu.add(Translate.menuItem("images", this));
        this.sceneMenu.add(Translate.menuItem("environment", this));
    }

    private void createPopupMenu() {
        this.popupMenu = new PopupMenu();
        this.popupMenuItem = new MenuItem[12];
        this.popupMenuItem[0] = Translate.menuItem("editObject", this, null);
        this.popupMenu.add(this.popupMenuItem[0]);
        this.popupMenuItem[1] = Translate.menuItem("objectLayout", this, null);
        this.popupMenu.add(this.popupMenuItem[1]);
        this.popupMenuItem[2] = Translate.menuItem("setTexture", this, null);
        this.popupMenu.add(this.popupMenuItem[2]);
        this.popupMenuItem[3] = Translate.menuItem("setMaterial", this, null);
        this.popupMenu.add(this.popupMenuItem[3]);
        this.popupMenuItem[4] = Translate.menuItem("renameObject", this, null);
        this.popupMenu.add(this.popupMenuItem[4]);
        this.popupMenuItem[5] = Translate.menuItem("convertToTriangle", this, null);
        this.popupMenu.add(this.popupMenuItem[5]);
        this.popupMenuItem[6] = Translate.menuItem("selectChildren", this, null);
        this.popupMenu.add(this.popupMenuItem[6]);
        this.popupMenu.addSeparator();
        this.popupMenuItem[7] = Translate.menuItem("hideSelection", this, null);
        this.popupMenu.add(this.popupMenuItem[7]);
        this.popupMenuItem[8] = Translate.menuItem("showSelection", this, null);
        this.popupMenu.add(this.popupMenuItem[8]);
        this.popupMenu.addSeparator();
        this.popupMenuItem[9] = Translate.menuItem("cut", this, null);
        this.popupMenu.add(this.popupMenuItem[9]);
        this.popupMenuItem[10] = Translate.menuItem("copy", this, null);
        this.popupMenu.add(this.popupMenuItem[10]);
        this.popupMenuItem[11] = Translate.menuItem("clear", this, null);
        this.popupMenu.add(this.popupMenuItem[11]);
        this.add(this.popupMenu);
    }

    public void showPopupMenu(Component c, int x, int y) {
        Object3D obj;
        Object[] sel = this.itemTree.getSelectedObjects();
        boolean canSetTexture = sel.length > 0;
        boolean canSetMaterial = canSetTexture;
        boolean canConvert = canSetTexture;
        boolean hasChildren = false;
        boolean canShow = false;
        boolean canHide = false;
        int i = 0;
        while (i < sel.length) {
            ObjectInfo info = (ObjectInfo)sel[i];
            obj = info.object;
            if (obj.canConvertToTriangleMesh() == 0) {
                canConvert = false;
            }
            if (!obj.canSetTexture()) {
                canSetTexture = false;
            }
            if (!obj.canSetMaterial()) {
                canSetMaterial = false;
            }
            if (info.children.length > 0) {
                hasChildren = true;
            }
            if (info.visible) {
                canHide = true;
            } else {
                canShow = true;
            }
            ++i;
        }
        if (sel.length == 0) {
            int i2 = 0;
            while (i2 < this.popupMenuItem.length) {
                this.popupMenuItem[i2].setEnabled(false);
                ++i2;
            }
        } else {
            obj = ((ObjectInfo)sel[0]).object;
            this.popupMenuItem[0].setEnabled(sel.length == 1 && obj.editable());
            this.popupMenuItem[1].setEnabled(true);
            this.popupMenuItem[2].setEnabled(canSetTexture);
            this.popupMenuItem[3].setEnabled(canSetMaterial);
            this.popupMenuItem[4].setEnabled(sel.length == 1);
            this.popupMenuItem[5].setEnabled(canConvert);
            this.popupMenuItem[6].setEnabled(sel.length == 1 && hasChildren);
            this.popupMenuItem[7].setEnabled(canHide);
            this.popupMenuItem[8].setEnabled(canShow);
            this.popupMenuItem[9].setEnabled(sel.length > 0);
            this.popupMenuItem[10].setEnabled(sel.length > 0);
            this.popupMenuItem[11].setEnabled(sel.length > 0);
        }
        this.popupMenu.show(c, x, y);
    }

    private void recursivelyAddListeners(Component c) {
        if (!(c instanceof TextComponent)) {
            c.addKeyListener(this);
        }
        if (c instanceof Container) {
            Component[] children = ((Container)c).getComponents();
            int i = 0;
            while (i < children.length) {
                this.recursivelyAddListeners(children[i]);
                ++i;
            }
        }
    }

    public void setWaitCursor() {
        this.recursivelySetCursor(this, Cursor.getDefaultCursor(), Cursor.getPredefinedCursor(3));
    }

    public void clearWaitCursor() {
        this.recursivelySetCursor(this, Cursor.getPredefinedCursor(3), Cursor.getDefaultCursor());
    }

    private void recursivelySetCursor(Component c, Cursor oldcursor, Cursor newcursor) {
        Cursor curs = c.getCursor();
        if (curs == oldcursor) {
            c.setCursor(newcursor);
        }
        if (c instanceof Container) {
            Container cont = (Container)c;
            int i = 0;
            while (i < cont.getComponentCount()) {
                this.recursivelySetCursor(cont.getComponent(i), oldcursor, newcursor);
                ++i;
            }
        }
    }

    public Dimension getMinimumSize() {
        return new Dimension(100, 100);
    }

    public boolean confirmClose() {
        if (this.modified) {
            MessageDialog dlg;
            String name = this.theScene.getName();
            if (name == null) {
                name = "Untitled";
            }
            if ((dlg = new MessageDialog((Window)this, Translate.text("checkSaveChanges", name), new String[]{"Save", "Don't Save", "Cancel"})).getChoice() == 0) {
                this.saveCommand();
                if (this.modified) {
                    return false;
                }
            }
            if (dlg.getChoice() == 2) {
                return false;
            }
        }
        this.dispose();
        return true;
    }

    public void setTool(EditingTool tool) {
        int i = 0;
        while (i < this.theView.length) {
            this.theView[i].setTool(tool);
            ++i;
        }
        this.currentTool = tool;
    }

    public void setHelpText(String text) {
        this.helpText.setText(text);
    }

    public Frame getFrame() {
        return this;
    }

    public void updateImage() {
        if (this.numViewsShown == 1) {
            this.theView[this.currentView].copyOrientationFromCamera();
            this.theView[this.currentView].updateImage();
            this.theView[this.currentView].repaint();
        } else {
            int i = 0;
            while (i < this.numViewsShown) {
                this.theView[i].copyOrientationFromCamera();
                this.theView[i].updateImage();
                this.theView[i].repaint();
                ++i;
            }
        }
    }

    public void updateMenus() {
        Object3D obj;
        Object[] sel = this.itemTree.getSelectedObjects();
        int numSelObjects = sel.length;
        Track[] selTrack = this.theScore.getSelectedTracks();
        int numSelTracks = selTrack.length;
        int numSelKeyframes = this.theScore.getSelectedKeyframes().length;
        boolean canSetTexture = numSelObjects > 0;
        boolean canSetMaterial = canSetTexture;
        boolean canConvert = canSetTexture;
        boolean hasParent = false;
        boolean hasChildren = false;
        boolean disable = false;
        boolean enable = false;
        boolean noncurve = false;
        boolean curve = false;
        int i = 0;
        while (i < numSelObjects) {
            ObjectInfo info = (ObjectInfo)sel[i];
            obj = info.object;
            if (obj instanceof Curve) {
                curve = true;
            } else {
                noncurve = true;
            }
            if (obj.canConvertToTriangleMesh() == 0) {
                canConvert = false;
            }
            if (!obj.canSetTexture()) {
                canSetTexture = false;
            }
            if (!obj.canSetMaterial()) {
                canSetMaterial = false;
            }
            if (info.children.length > 0) {
                hasChildren = true;
            }
            if (info.parent != null) {
                hasParent = true;
            }
            ++i;
        }
        i = 0;
        while (i < numSelTracks) {
            if (selTrack[i].isEnabled()) {
                disable = true;
            } else {
                enable = true;
            }
            ++i;
        }
        this.fileMenuItem[0].setEnabled(this.modified);
        this.editMenuItem[1].setEnabled(numSelObjects > 0);
        this.editMenuItem[2].setEnabled(numSelObjects > 0);
        this.editMenuItem[3].setEnabled(ModellingApp.getClipboardSize() > 0);
        this.editMenuItem[4].setEnabled(numSelObjects > 0);
        this.editMenuItem[5].setEnabled(hasChildren);
        this.editMenuItem[6].setEnabled(numSelObjects > 0);
        this.editMenuItem[7].setEnabled(numSelObjects > 0);
        if (numSelObjects == 0) {
            i = 0;
            while (i < this.objectMenuItem.length) {
                this.objectMenuItem[i].setEnabled(false);
                ++i;
            }
        } else {
            obj = ((ObjectInfo)sel[0]).object;
            this.objectMenuItem[0].setEnabled(numSelObjects == 1 && obj.editable());
            this.objectMenuItem[1].setEnabled(true);
            this.objectMenuItem[2].setEnabled(true);
            this.objectMenuItem[3].setEnabled(numSelObjects > 0);
            this.objectMenuItem[4].setEnabled(canSetTexture);
            this.objectMenuItem[5].setEnabled(canSetMaterial);
            this.objectMenuItem[6].setEnabled(sel.length == 1);
            this.objectMenuItem[7].setEnabled(canConvert && sel.length == 1);
            this.objectMenuItem[8].setEnabled(true);
            this.objectMenuItem[9].setEnabled(true);
        }
        this.animationMenuItem[1].setEnabled(numSelKeyframes == 1);
        this.animationMenuItem[2].setEnabled(numSelKeyframes > 0);
        this.animationMenuItem[3].setEnabled(numSelTracks > 0);
        this.animationMenuItem[4].setEnabled(numSelObjects > 0);
        this.animationMenuItem[5].setEnabled(numSelTracks == 1);
        this.animationMenuItem[6].setEnabled(numSelTracks > 0);
        this.animationMenuItem[7].setEnabled(numSelTracks > 0);
        this.animationMenuItem[8].setEnabled(numSelObjects > 0);
        this.animationMenuItem[9].setEnabled(enable);
        this.animationMenuItem[10].setEnabled(disable);
        this.animationMenuItem[11].setEnabled(curve && noncurve);
        this.animationMenuItem[12].setEnabled(hasParent);
        this.addTrackMenu.setEnabled(numSelObjects > 0);
        this.distortionMenu.setEnabled(sel.length > 0);
        this.sceneMenuItem[2].setEnabled(this.theView[0].getTemplateImage() != null);
        this.sceneMenuItem[3].setEnabled(sel.length > 0);
    }

    public void setUndoRecord(UndoRecord command) {
        this.undo = command;
        this.editMenuItem[0].setEnabled(true);
        if (this.undo.isRedo()) {
            this.editMenuItem[0].setLabel(Translate.text("menu.redo"));
        } else {
            this.editMenuItem[0].setLabel(Translate.text("menu.undo"));
        }
        this.modified = true;
        this.updateMenus();
    }

    public void setModified() {
        this.modified = true;
    }

    public void addObject(Object3D obj, CoordinateSystem coords, String name, UndoRecord undo) {
        this.addObject(new ObjectInfo(obj, coords, name), undo);
    }

    public void addObject(ObjectInfo info, UndoRecord undo) {
        this.theScene.addObject(info, undo);
        this.itemTree.addElement(new ObjectTreeElement(info, this.itemTree));
        int i = 0;
        while (i < this.theView.length) {
            this.theView[i].rebuildCameraList();
            ++i;
        }
        this.theScore.rebuildList();
    }

    public void addObject(ObjectInfo info, int index, UndoRecord undo) {
        this.theScene.addObject(info, index, undo);
        this.itemTree.addElement(new ObjectTreeElement(info, this.itemTree), index);
        int i = 0;
        while (i < this.theView.length) {
            this.theView[i].rebuildCameraList();
            ++i;
        }
        this.theScore.rebuildList();
    }

    public void removeObject(int which, UndoRecord undo) {
        this.itemTree.removeObject(this.theScene.getObject(which));
        this.theScene.removeObject(which, undo);
        int i = 0;
        while (i < this.theView.length) {
            this.theView[i].rebuildCameraList();
            ++i;
        }
        this.theScore.rebuildList();
    }

    public void setObjectName(int which, String name) {
        ObjectInfo info = this.theScene.getObject(which);
        this.setUndoRecord(new UndoRecord(this, false, 6, new Object[]{new Integer(which), info.name}));
        info.name = name;
        this.itemTree.repaint();
        int i = 0;
        while (i < this.theView.length) {
            this.theView[i].rebuildCameraList();
            ++i;
        }
        this.theScore.rebuildList();
    }

    public void setTime(double time) {
        this.theScene.setTime(time);
        this.theScore.setTime(time);
        NumberFormat nf = NumberFormat.getNumberInstance();
        nf.setMaximumFractionDigits(3);
        this.timeLabel.setText(nf.format(time));
        this.frameLabel.setText(Integer.toString((int)Math.round(time * (double)this.theScene.getFramesPerSecond())));
        this.theScore.repaint();
        this.itemTree.repaint();
        this.updateImage();
    }

    public Scene getScene() {
        return this.theScene;
    }

    public ViewerCanvas getView() {
        return this.theView[this.currentView];
    }

    public Score getScore() {
        return this.theScore;
    }

    public void setObjectListVisible(boolean visible) {
        this.listHidden = !visible;
        this.div1.setHidden(false, this.listHidden);
        this.sceneMenuItem[1].setLabel(Translate.text(this.listHidden ? "menu.showObjectList" : "menu.hideObjectList"));
    }

    public void setScoreVisible(boolean visible) {
        this.scoreHidden = !visible;
        this.div2.setHidden(false, this.scoreHidden);
        this.animationMenuItem[0].setLabel(Translate.text(this.scoreHidden ? "menu.showScore" : "menu.hideScore"));
    }

    public void setSplitView(boolean split) {
        if (this.numViewsShown == 1 == split) {
            this.toggleViewsCommand();
        }
    }

    public void itemStateChanged(ItemEvent e) {
        Object source = e.getSource();
        if (source instanceof CheckboxMenuItem) {
            if (source == this.displayItem[0]) {
                this.theView[this.currentView].setRenderMode(0);
            } else if (source == this.displayItem[1]) {
                this.theView[this.currentView].setRenderMode(1);
            } else if (source == this.displayItem[2]) {
                this.theView[this.currentView].setRenderMode(2);
            }
            int i = 0;
            while (i < this.displayItem.length) {
                this.displayItem[i].setState(source == this.displayItem[i]);
                ++i;
            }
            this.updateImage();
        } else {
            Object[] sel = this.itemTree.getSelectedObjects();
            int[] which = new int[sel.length];
            int i = 0;
            while (i < sel.length) {
                which[i] = this.theScene.indexOf((ObjectInfo)sel[i]);
                ++i;
            }
            this.setSelection(which);
            if (this.currentTool.whichClicks() == 0) {
                this.tools.selectTool(this.defaultTool);
            } else {
                this.updateImage();
            }
        }
    }

    public void keyPressed(KeyEvent e) {
        int code = e.getKeyCode();
        if (code == 8 || code == 127) {
            this.clearCommand();
        } else if (e.isShiftDown() && (code == 37 || code == 39 || code == 38 || code == 40)) {
            this.tools.keyPressed(e);
        } else {
            this.currentTool.keyPressed(e, this.theView[this.currentView]);
        }
    }

    public void keyReleased(KeyEvent e) {
    }

    public void keyTyped(KeyEvent e) {
    }

    public void setSelection(int which) {
        this.itemTree.setUpdateEnabled(false);
        this.clearSelection();
        this.theScene.setSelection(which);
        this.itemTree.setSelected(this.theScene.getObject(which), true);
        this.itemTree.setUpdateEnabled(true);
        this.theScore.rebuildList();
        this.updateMenus();
    }

    public void setSelection(int[] which) {
        this.itemTree.setUpdateEnabled(false);
        this.clearSelection();
        this.theScene.setSelection(which);
        int i = 0;
        while (i < which.length) {
            this.itemTree.setSelected(this.theScene.getObject(which[i]), true);
            ++i;
        }
        this.itemTree.setUpdateEnabled(true);
        this.theScore.rebuildList();
        this.updateMenus();
    }

    public void addToSelection(int which) {
        this.theScene.addToSelection(which);
        this.itemTree.setSelected(this.theScene.getObject(which), true);
        this.theScore.rebuildList();
        this.updateMenus();
    }

    public void clearSelection() {
        this.theScene.clearSelection();
        this.itemTree.deselectAll();
        this.theScore.rebuildList();
        this.updateMenus();
    }

    public void removeFromSelection(int which) {
        this.theScene.removeFromSelection(which);
        this.itemTree.setSelected(this.theScene.getObject(which), false);
        this.theScore.rebuildList();
        this.updateMenus();
    }

    public void actionPerformed(ActionEvent e) {
        String command = e.getActionCommand();
        Object src = e.getSource();
        MenuContainer menu = src instanceof MenuItem ? ((MenuItem)src).getParent() : null;
        this.setWaitCursor();
        if (menu == this.fileMenu) {
            if (command.equals("new")) {
                ModellingApp.newWindow();
            }
            if (command.equals("open")) {
                ModellingApp.openScene(this);
            } else if (command.equals("close")) {
                ModellingApp.closeWindow(this);
            }
            if (command.equals("save")) {
                this.saveCommand();
            }
            if (command.equals("saveas")) {
                this.saveAsCommand();
            } else if (command.equals("quit")) {
                ModellingApp.quit();
            }
        } else if (command.equals("import")) {
            this.importCommand(((MenuItem)e.getSource()).getLabel());
        } else if (command.equals("export")) {
            this.exportCommand(((MenuItem)e.getSource()).getLabel());
        } else if (menu == this.editMenu) {
            if (command.equals("undo")) {
                this.undoCommand();
            } else if (command.equals("cut")) {
                this.cutCommand();
            } else if (command.equals("copy")) {
                this.copyCommand();
            } else if (command.equals("paste")) {
                this.pasteCommand();
            } else if (command.equals("clear")) {
                this.clearCommand();
            } else if (command.equals("selectChildren")) {
                this.setSelection(this.theScene.getSelectionWithChildren());
                this.updateImage();
            } else if (command.equals("selectAll")) {
                this.selectAllCommand();
            } else if (command.equals("duplicate")) {
                this.duplicateCommand();
            } else if (command.equals("sever")) {
                this.severCommand();
            } else if (command.equals("preferences")) {
                new PreferencesWindow(this);
            }
        } else if (menu == this.objectMenu) {
            if (command.equals("editObject")) {
                this.editObjectCommand();
            } else if (command.equals("objectLayout")) {
                this.objectLayoutCommand();
            } else if (command.equals("transformObject")) {
                this.transformObjectCommand();
            } else if (command.equals("alignObjects")) {
                this.alignObjectsCommand();
            } else if (command.equals("setTexture")) {
                this.setTextureCommand();
            } else if (command.equals("setMaterial")) {
                this.setMaterialCommand();
            } else if (command.equals("renameObject")) {
                this.renameObjectCommand();
            } else if (command.equals("convertToTriangle")) {
                this.convertToTriangleCommand();
            } else if (command.equals("hideSelection")) {
                this.setObjectVisibility(false, true);
            } else if (command.equals("showSelection")) {
                this.setObjectVisibility(true, true);
            } else if (command.equals("showAll")) {
                this.setObjectVisibility(true, false);
            }
        } else if (menu == this.createMenu) {
            this.createObjectCommand(command);
        } else if (command.equals("modellingTool")) {
            this.modellingToolCommand(e.getSource());
        } else if (menu == this.toolsMenu) {
            if (command.equals("createScriptObject")) {
                this.createScriptObjectCommand();
            } else if (command.equals("editScript")) {
                new ExecuteScriptWindow(this);
            }
        } else if (menu == this.animationMenu || menu == this.theScore.getPopupMenu()) {
            if (command.equals("showScore")) {
                this.setScoreVisible(this.scoreHidden);
            } else if (command.equals("previewAnimation")) {
                new AnimationPreviewer(this);
            } else if (command.equals("forwardFrame")) {
                double t = this.theScene.getTime() + 1.0 / (double)this.theScene.getFramesPerSecond();
                this.setTime(t);
            } else if (command.equals("backFrame")) {
                double t = this.theScene.getTime() - 1.0 / (double)this.theScene.getFramesPerSecond();
                this.setTime(t);
            } else if (command.equals("jumpToTime")) {
                this.jumpToTimeCommand();
            } else if (command.equals("editKeyframe")) {
                this.theScore.editSelectedKeyframe();
            } else if (command.equals("deleteSelectedKeyframes")) {
                this.theScore.deleteSelectedKeyframes();
            } else if (command.equals("editTrack")) {
                this.theScore.editSelectedTrack();
            } else if (command.equals("keyframe")) {
                this.theScore.keyframeSelectedTracks();
            } else if (command.equals("keyframeModified")) {
                this.theScore.keyframeModifiedTracks();
            } else if (command.equals("duplicateTracks")) {
                this.theScore.duplicateSelectedTracks();
            } else if (command.equals("deleteTracks")) {
                this.theScore.deleteSelectedTracks();
            } else if (command.equals("selectAllTracks")) {
                this.theScore.selectAllTracks();
            } else if (command.equals("enableTracks")) {
                this.theScore.setTracksEnabled(true);
            } else if (command.equals("disableTracks")) {
                this.theScore.setTracksEnabled(false);
            } else if (command.equals("pathFromCurve")) {
                new PathFromCurveDialog(this, this.itemTree.getSelectedObjects());
            } else if (command.equals("bindToParent")) {
                this.bindToParentCommand();
            }
        } else if (menu == this.editKeyframeMenu) {
            if (command.equals("moveKeyframes")) {
                new EditKeyframesDialog(this, 0);
            } else if (command.equals("copyKeyframes")) {
                new EditKeyframesDialog(this, 1);
            } else if (command.equals("rescaleKeyframes")) {
                new EditKeyframesDialog(this, 2);
            } else if (command.equals("loopKeyframes")) {
                new EditKeyframesDialog(this, 3);
            } else if (command.equals("deleteKeyframes")) {
                new EditKeyframesDialog(this, 4);
            }
        } else if (menu == this.addTrackMenu) {
            if (command.equals("poseTrack")) {
                this.theScore.addTrack(this.itemTree.getSelectedObjects(), class$artofillusion$animation$PoseTrack == null ? (class$artofillusion$animation$PoseTrack = LayoutWindow.class$("artofillusion.animation.PoseTrack")) : class$artofillusion$animation$PoseTrack, null, true);
            } else if (command.equals("constraintTrack")) {
                this.theScore.addTrack(this.itemTree.getSelectedObjects(), class$artofillusion$animation$ConstraintTrack == null ? (class$artofillusion$animation$ConstraintTrack = LayoutWindow.class$("artofillusion.animation.ConstraintTrack")) : class$artofillusion$animation$ConstraintTrack, null, true);
            } else if (command.equals("visibilityTrack")) {
                this.theScore.addTrack(this.itemTree.getSelectedObjects(), class$artofillusion$animation$VisibilityTrack == null ? (class$artofillusion$animation$VisibilityTrack = LayoutWindow.class$("artofillusion.animation.VisibilityTrack")) : class$artofillusion$animation$VisibilityTrack, null, true);
            } else if (command.equals("textureTrack")) {
                this.theScore.addTrack(this.itemTree.getSelectedObjects(), class$artofillusion$animation$TextureTrack == null ? (class$artofillusion$animation$TextureTrack = LayoutWindow.class$("artofillusion.animation.TextureTrack")) : class$artofillusion$animation$TextureTrack, null, true);
            }
        } else if (menu == this.positionTrackMenu) {
            if (command.equals("xyzOneTrack")) {
                this.theScore.addTrack(this.itemTree.getSelectedObjects(), class$artofillusion$animation$PositionTrack == null ? (class$artofillusion$animation$PositionTrack = LayoutWindow.class$("artofillusion.animation.PositionTrack")) : class$artofillusion$animation$PositionTrack, null, true);
            } else if (command.equals("xyzThreeTracks")) {
                this.theScore.addTrack(this.itemTree.getSelectedObjects(), class$artofillusion$animation$PositionTrack == null ? (class$artofillusion$animation$PositionTrack = LayoutWindow.class$("artofillusion.animation.PositionTrack")) : class$artofillusion$animation$PositionTrack, new Object[]{"Z Position", Boolean.FALSE, Boolean.FALSE, Boolean.TRUE}, true);
                this.theScore.addTrack(this.itemTree.getSelectedObjects(), class$artofillusion$animation$PositionTrack == null ? (class$artofillusion$animation$PositionTrack = LayoutWindow.class$("artofillusion.animation.PositionTrack")) : class$artofillusion$animation$PositionTrack, new Object[]{"Y Position", Boolean.FALSE, Boolean.TRUE, Boolean.FALSE}, false);
                this.theScore.addTrack(this.itemTree.getSelectedObjects(), class$artofillusion$animation$PositionTrack == null ? (class$artofillusion$animation$PositionTrack = LayoutWindow.class$("artofillusion.animation.PositionTrack")) : class$artofillusion$animation$PositionTrack, new Object[]{"X Position", Boolean.TRUE, Boolean.FALSE, Boolean.FALSE}, false);
            } else if (command.equals("proceduralTrack")) {
                this.theScore.addTrack(this.itemTree.getSelectedObjects(), class$artofillusion$animation$ProceduralPositionTrack == null ? (class$artofillusion$animation$ProceduralPositionTrack = LayoutWindow.class$("artofillusion.animation.ProceduralPositionTrack")) : class$artofillusion$animation$ProceduralPositionTrack, null, true);
            }
        } else if (menu == this.rotationTrackMenu) {
            if (command.equals("xyzOneTrack")) {
                this.theScore.addTrack(this.itemTree.getSelectedObjects(), class$artofillusion$animation$RotationTrack == null ? (class$artofillusion$animation$RotationTrack = LayoutWindow.class$("artofillusion.animation.RotationTrack")) : class$artofillusion$animation$RotationTrack, new Object[]{"Rotation", Boolean.FALSE, Boolean.TRUE, Boolean.TRUE, Boolean.TRUE}, true);
            } else if (command.equals("xyzThreeTracks")) {
                this.theScore.addTrack(this.itemTree.getSelectedObjects(), class$artofillusion$animation$RotationTrack == null ? (class$artofillusion$animation$RotationTrack = LayoutWindow.class$("artofillusion.animation.RotationTrack")) : class$artofillusion$animation$RotationTrack, new Object[]{"Z Rotation", Boolean.FALSE, Boolean.FALSE, Boolean.FALSE, Boolean.TRUE}, true);
                this.theScore.addTrack(this.itemTree.getSelectedObjects(), class$artofillusion$animation$RotationTrack == null ? (class$artofillusion$animation$RotationTrack = LayoutWindow.class$("artofillusion.animation.RotationTrack")) : class$artofillusion$animation$RotationTrack, new Object[]{"Y Rotation", Boolean.FALSE, Boolean.FALSE, Boolean.TRUE, Boolean.FALSE}, false);
                this.theScore.addTrack(this.itemTree.getSelectedObjects(), class$artofillusion$animation$RotationTrack == null ? (class$artofillusion$animation$RotationTrack = LayoutWindow.class$("artofillusion.animation.RotationTrack")) : class$artofillusion$animation$RotationTrack, new Object[]{"X Rotation", Boolean.FALSE, Boolean.TRUE, Boolean.FALSE, Boolean.FALSE}, false);
            } else if (command.equals("quaternionTrack")) {
                this.theScore.addTrack(this.itemTree.getSelectedObjects(), class$artofillusion$animation$RotationTrack == null ? (class$artofillusion$animation$RotationTrack = LayoutWindow.class$("artofillusion.animation.RotationTrack")) : class$artofillusion$animation$RotationTrack, new Object[]{"Rotation", Boolean.TRUE, Boolean.TRUE, Boolean.TRUE, Boolean.TRUE}, true);
            } else if (command.equals("proceduralTrack")) {
                this.theScore.addTrack(this.itemTree.getSelectedObjects(), class$artofillusion$animation$ProceduralRotationTrack == null ? (class$artofillusion$animation$ProceduralRotationTrack = LayoutWindow.class$("artofillusion.animation.ProceduralRotationTrack")) : class$artofillusion$animation$ProceduralRotationTrack, null, true);
            }
        } else if (menu == this.distortionMenu) {
            if (command.equals("bendDistortion")) {
                this.theScore.addTrack(this.itemTree.getSelectedObjects(), class$artofillusion$animation$distortion$BendTrack == null ? (class$artofillusion$animation$distortion$BendTrack = LayoutWindow.class$("artofillusion.animation.distortion.BendTrack")) : class$artofillusion$animation$distortion$BendTrack, null, true);
            }
            if (command.equals("customDistortion")) {
                this.theScore.addTrack(this.itemTree.getSelectedObjects(), class$artofillusion$animation$distortion$CustomDistortionTrack == null ? (class$artofillusion$animation$distortion$CustomDistortionTrack = LayoutWindow.class$("artofillusion.animation.distortion.CustomDistortionTrack")) : class$artofillusion$animation$distortion$CustomDistortionTrack, null, true);
            }
            if (command.equals("scaleDistortion")) {
                this.theScore.addTrack(this.itemTree.getSelectedObjects(), class$artofillusion$animation$distortion$ScaleTrack == null ? (class$artofillusion$animation$distortion$ScaleTrack = LayoutWindow.class$("artofillusion.animation.distortion.ScaleTrack")) : class$artofillusion$animation$distortion$ScaleTrack, null, true);
            }
            if (command.equals("shatterDistortion")) {
                this.theScore.addTrack(this.itemTree.getSelectedObjects(), class$artofillusion$animation$distortion$ShatterTrack == null ? (class$artofillusion$animation$distortion$ShatterTrack = LayoutWindow.class$("artofillusion.animation.distortion.ShatterTrack")) : class$artofillusion$animation$distortion$ShatterTrack, null, true);
            }
            if (command.equals("twistDistortion")) {
                this.theScore.addTrack(this.itemTree.getSelectedObjects(), class$artofillusion$animation$distortion$TwistTrack == null ? (class$artofillusion$animation$distortion$TwistTrack = LayoutWindow.class$("artofillusion.animation.distortion.TwistTrack")) : class$artofillusion$animation$distortion$TwistTrack, null, true);
            }
        } else if (menu == this.sceneMenu) {
            if (command.equals("renderScene")) {
                new RenderSetupDialog((Frame)this, this.theScene);
            } else if (command.equals("renderImmediately")) {
                RenderSetupDialog.renderImmediately(this, this.theScene);
            } else if (command.equals("fourViews")) {
                this.toggleViewsCommand();
            } else if (command.equals("hideObjectList")) {
                this.setObjectListVisible(this.listHidden);
            } else if (command.equals("showTemplate")) {
                boolean wasShown = this.theView[0].getTemplateShown();
                this.sceneMenuItem[2].setLabel(Translate.text(wasShown ? "menu.showTemplate" : "menu.hideTemplate"));
                int i = 0;
                while (i < this.theView.length) {
                    this.theView[i].setShowTemplate(!wasShown);
                    ++i;
                }
                this.updateImage();
            } else if (command.equals("setTemplate")) {
                this.setTemplateCommand();
            } else if (command.equals("grid")) {
                this.setGridCommand();
            } else if (command.equals("frameSelection")) {
                this.frameWithCameraCommand(true);
            } else if (command.equals("frameScene")) {
                this.frameWithCameraCommand(false);
            } else if (command.equals("textures")) {
                this.texturesCommand();
            } else if (command.equals("materials")) {
                this.materialsCommand();
            } else if (command.equals("images")) {
                new ImagesDialog((Frame)this, this.theScene, null);
            } else if (command.equals("environment")) {
                this.environmentCommand();
            }
        } else if (menu == this.popupMenu) {
            if (command.equals("editObject")) {
                this.editObjectCommand();
            } else if (command.equals("objectLayout")) {
                this.objectLayoutCommand();
            } else if (command.equals("setTexture")) {
                this.setTextureCommand();
            } else if (command.equals("setMaterial")) {
                this.setMaterialCommand();
            } else if (command.equals("renameObject")) {
                this.renameObjectCommand();
            } else if (command.equals("convertToTriangle")) {
                this.convertToTriangleCommand();
            } else if (command.equals("selectChildren")) {
                this.setSelection(this.theScene.getSelectionWithChildren());
                this.updateImage();
            } else if (command.equals("hideSelection")) {
                this.setObjectVisibility(false, true);
            } else if (command.equals("showSelection")) {
                this.setObjectVisibility(true, true);
            } else if (command.equals("cut")) {
                this.cutCommand();
            } else if (command.equals("copy")) {
                this.copyCommand();
            } else if (command.equals("clear")) {
                this.clearCommand();
            }
        } else if (command.endsWith(".bsh")) {
            this.executeScript(new File(command));
        }
        this.clearWaitCursor();
    }

    void importCommand(String format) {
        Translator[] trans = ModellingApp.getTranslators();
        int i = 0;
        while (i < trans.length) {
            if (trans[i].canImport() && format.equals(trans[i].getName())) {
                trans[i].importFile(this);
                return;
            }
            ++i;
        }
    }

    void exportCommand(String format) {
        Translator[] trans = ModellingApp.getTranslators();
        int i = 0;
        while (i < trans.length) {
            if (trans[i].canExport() && format.equals(trans[i].getName())) {
                trans[i].exportFile(this, this.theScene);
                return;
            }
            ++i;
        }
    }

    void modellingToolCommand(Object item) {
        ModellingTool[] tools = ModellingApp.getModellingTools();
        int i = 0;
        while (i < this.toolsMenuItem.length) {
            if (this.toolsMenuItem[i] == item) {
                tools[i].commandSelected(this);
            }
            ++i;
        }
    }

    void saveCommand() {
        if (this.theScene.getName() == null) {
            this.saveAsCommand();
        } else {
            this.modified = !ModellingApp.saveScene(this.theScene, this);
        }
    }

    void saveAsCommand() {
        FileDialog fd = new FileDialog((Frame)this, "Save Scene", 1);
        if (this.theScene.getName() == null) {
            fd.setFile("Untitled.aoi");
        } else {
            fd.setFile(this.theScene.getName());
        }
        if (this.theScene.getDirectory() != null) {
            fd.setDirectory(this.theScene.getDirectory());
        } else if (ModellingApp.currentDirectory != null) {
            fd.setDirectory(ModellingApp.currentDirectory);
        }
        fd.setCursor(Cursor.getDefaultCursor());
        fd.show();
        if (fd.getFile() == null) {
            return;
        }
        this.theScene.setName(fd.getFile());
        this.theScene.setDirectory(fd.getDirectory());
        this.setTitle(fd.getFile());
        this.modified = !ModellingApp.saveScene(this.theScene, this);
    }

    void undoCommand() {
        if (this.undo == null) {
            return;
        }
        this.setUndoRecord(this.undo.execute());
        this.rebuildItemList();
        this.updateImage();
        this.updateMenus();
    }

    void cutCommand() {
        this.copyCommand();
        this.clearCommand();
    }

    void copyCommand() {
        int[] sel = this.theScene.getSelectionWithChildren();
        if (sel.length == 0) {
            return;
        }
        ObjectInfo[] copy = new ObjectInfo[sel.length];
        int i = 0;
        while (i < sel.length) {
            copy[i] = this.theScene.getObject(sel[i]);
            ++i;
        }
        copy = ObjectInfo.duplicateAll(copy);
        ModellingApp.copyToClipboard(copy, this.theScene);
        this.updateMenus();
    }

    void pasteCommand() {
        int[] which = new int[ModellingApp.getClipboardSize()];
        int num = this.theScene.getNumObjects();
        int i = 0;
        while (i < which.length) {
            which[i] = num + i;
            ++i;
        }
        ModellingApp.pasteClipboard(this);
        this.setSelection(which);
        this.rebuildItemList();
        this.updateImage();
    }

    void clearCommand() {
        boolean any;
        ObjectInfo info;
        Object[] sel = this.itemTree.getSelectedObjects();
        if (sel.length == 0) {
            return;
        }
        this.theScene.clearSelection();
        this.setUndoRecord(new UndoRecord(this, false));
        int i = sel.length - 1;
        while (i >= 0) {
            info = (ObjectInfo)sel[i];
            int index = this.theScene.indexOf(info);
            this.removeObject(index, this.undo);
            --i;
        }
        do {
            any = false;
            i = 0;
            while (i < this.theScene.getNumObjects()) {
                info = this.theScene.getObject(i);
                if (info.parent != null && this.theScene.indexOf(info.parent) == -1) {
                    this.removeObject(i, this.undo);
                    --i;
                    any = true;
                }
                ++i;
            }
        } while (any);
        this.updateMenus();
        this.updateImage();
    }

    void selectAllCommand() {
        int[] which = new int[this.theScene.getNumObjects()];
        int i = 0;
        while (i < which.length) {
            which[i] = i;
            ++i;
        }
        this.setSelection(which);
        this.updateImage();
    }

    void duplicateCommand() {
        Object[] sel = this.itemTree.getSelectedObjects();
        int[] which = new int[sel.length];
        int num = this.theScene.getNumObjects();
        this.setUndoRecord(new UndoRecord(this, false));
        int i = 0;
        while (i < sel.length) {
            this.addObject(((ObjectInfo)sel[i]).duplicate(), this.undo);
            which[i] = num + i;
            ++i;
        }
        this.setSelection(which);
        this.updateImage();
    }

    void severCommand() {
        Object[] sel = this.itemTree.getSelectedObjects();
        this.setUndoRecord(new UndoRecord(this, false));
        int i = 0;
        while (i < sel.length) {
            ObjectInfo info = (ObjectInfo)sel[i];
            this.undo.addCommand(2, new Object[]{info, info.duplicate()});
            info.object = info.object.duplicate();
            ++i;
        }
    }

    void editObjectCommand() {
        int[] sel = this.theScene.getSelection();
        if (sel.length != 1) {
            return;
        }
        final Object3D obj = this.theScene.getObject((int)sel[0]).object;
        if (obj.editable()) {
            this.setUndoRecord(new UndoRecord(this, false, 0, new Object[]{obj, obj.duplicate()}));
            obj.edit(this, this.theScene.getObject(sel[0]), new Callback(){

                public void execute() {
                    LayoutWindow.this.theScene.objectModified(obj);
                    LayoutWindow.this.updateImage();
                    LayoutWindow.this.updateMenus();
                }
            });
        }
    }

    void objectLayoutCommand() {
        int[] sel = this.theScene.getSelection();
        ObjectInfo[] obj = new ObjectInfo[sel.length];
        if (sel.length == 0) {
            return;
        }
        this.setUndoRecord(new UndoRecord(this, false));
        int i = 0;
        while (i < sel.length) {
            obj[i] = this.theScene.getObject(sel[i]);
            this.undo.addCommand(0, new Object[]{obj[i].object, obj[i].object.duplicate()});
            this.undo.addCommand(1, new Object[]{obj[i].coords, obj[i].coords.duplicate()});
            ++i;
        }
        if (sel.length == 1) {
            Vec3 orig = obj[0].coords.getOrigin();
            double[] angles = obj[0].coords.getRotationAngles();
            Vec3 size = obj[0].object.getBounds().getSize();
            TransformDialog dlg = new TransformDialog(this, "Layout for '" + this.theScene.getObject((int)sel[0]).name + "'", new double[]{orig.x, orig.y, orig.z, angles[0], angles[1], angles[2], size.x, size.y, size.z}, false, false);
            if (!dlg.clickedOk()) {
                return;
            }
            double[] values = dlg.getValues();
            if (!Double.isNaN(values[0])) {
                orig.x = values[0];
            }
            if (!Double.isNaN(values[1])) {
                orig.y = values[1];
            }
            if (!Double.isNaN(values[2])) {
                orig.z = values[2];
            }
            if (!Double.isNaN(values[3])) {
                angles[0] = values[3];
            }
            if (!Double.isNaN(values[4])) {
                angles[1] = values[4];
            }
            if (!Double.isNaN(values[5])) {
                angles[2] = values[5];
            }
            if (!Double.isNaN(values[6])) {
                size.x = values[6];
            }
            if (!Double.isNaN(values[7])) {
                size.y = values[7];
            }
            if (!Double.isNaN(values[8])) {
                size.z = values[8];
            }
            obj[0].coords.setOrigin(orig);
            obj[0].coords.setOrientation(angles[0], angles[1], angles[2]);
            obj[0].object.setSize(size.x, size.y, size.z);
            this.theScene.objectModified(obj[0].object);
            obj[0].object.sceneChanged(obj[0], this.theScene);
        } else {
            TransformDialog dlg = new TransformDialog((Frame)this, "Layout for Selected Objects", false, false);
            if (!dlg.clickedOk()) {
                return;
            }
            double[] values = dlg.getValues();
            i = 0;
            while (i < sel.length) {
                Vec3 orig = obj[i].coords.getOrigin();
                double[] angles = obj[i].coords.getRotationAngles();
                Vec3 size = obj[i].object.getBounds().getSize();
                if (!Double.isNaN(values[0])) {
                    orig.x = values[0];
                }
                if (!Double.isNaN(values[1])) {
                    orig.y = values[1];
                }
                if (!Double.isNaN(values[2])) {
                    orig.z = values[2];
                }
                if (!Double.isNaN(values[3])) {
                    angles[0] = values[3];
                }
                if (!Double.isNaN(values[4])) {
                    angles[1] = values[4];
                }
                if (!Double.isNaN(values[5])) {
                    angles[2] = values[5];
                }
                if (!Double.isNaN(values[6])) {
                    size.x = values[6];
                }
                if (!Double.isNaN(values[7])) {
                    size.y = values[7];
                }
                if (!Double.isNaN(values[8])) {
                    size.z = values[8];
                }
                obj[i].coords.setOrigin(orig);
                obj[i].coords.setOrientation(angles[0], angles[1], angles[2]);
                obj[i].object.setSize(size.x, size.y, size.z);
                ++i;
            }
            i = 0;
            while (i < sel.length) {
                this.theScene.objectModified(obj[i].object);
                obj[i].object.sceneChanged(obj[i], this.theScene);
                ++i;
            }
        }
        this.updateImage();
    }

    void transformObjectCommand() {
        ObjectInfo info;
        int[] sel = this.theScene.getSelection();
        if (sel.length == 0) {
            return;
        }
        TransformDialog dlg = sel.length == 1 ? new TransformDialog(this, "Transform '" + this.theScene.getObject((int)sel[0]).name + "'", new double[]{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 1.0, 1.0}, true, true) : new TransformDialog(this, "Transform Selected Objects", new double[]{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 1.0, 1.0}, true, true);
        if (!dlg.clickedOk()) {
            return;
        }
        double[] values = dlg.getValues();
        BoundingBox bounds = null;
        int i = 0;
        while (i < sel.length) {
            info = this.theScene.getObject(sel[i]);
            bounds = bounds == null ? info.getBounds().transformAndOutset(info.coords.fromLocal()) : bounds.merge(info.getBounds().transformAndOutset(info.coords.fromLocal()));
            ++i;
        }
        Vec3 center = bounds.getCenter();
        if (dlg.applyToChildren()) {
            sel = this.theScene.getSelectionWithChildren();
        }
        Mat4 m = Mat4.identity();
        if (!Double.isNaN(values[3])) {
            m = m.times(Mat4.xrotation(values[3] * Math.PI / 180.0));
        }
        if (!Double.isNaN(values[4])) {
            m = m.times(Mat4.yrotation(values[4] * Math.PI / 180.0));
        }
        if (!Double.isNaN(values[5])) {
            m = m.times(Mat4.zrotation(values[5] * Math.PI / 180.0));
        }
        this.setUndoRecord(new UndoRecord(this, false));
        i = 0;
        while (i < sel.length) {
            info = this.theScene.getObject(sel[i]);
            Object3D obj = info.object;
            CoordinateSystem coords = info.coords;
            this.undo.addCommand(0, new Object[]{obj, obj.duplicate()});
            this.undo.addCommand(1, new Object[]{coords, coords.duplicate()});
            Vec3 orig = coords.getOrigin();
            Vec3 size = obj.getBounds().getSize();
            if (!Double.isNaN(values[0])) {
                orig.x += values[0];
            }
            if (!Double.isNaN(values[1])) {
                orig.y += values[1];
            }
            if (!Double.isNaN(values[2])) {
                orig.z += values[2];
            }
            if (!Double.isNaN(values[6])) {
                size.x *= values[6];
            }
            if (!Double.isNaN(values[7])) {
                size.y *= values[7];
            }
            if (!Double.isNaN(values[8])) {
                size.z *= values[8];
            }
            if (dlg.useSelectionCenter()) {
                Vec3 neworig = orig.minus(center);
                if (!Double.isNaN(values[6])) {
                    neworig.x *= values[6];
                }
                if (!Double.isNaN(values[7])) {
                    neworig.y *= values[7];
                }
                if (!Double.isNaN(values[8])) {
                    neworig.z *= values[8];
                }
                coords.setOrigin(neworig);
                coords.transformCoordinates(m);
                coords.setOrigin(coords.getOrigin().plus(center));
            } else {
                coords.setOrigin(orig);
                coords.transformAxes(m);
            }
            obj.setSize(size.x, size.y, size.z);
            ++i;
        }
        i = 0;
        while (i < sel.length) {
            info = this.theScene.getObject(sel[i]);
            this.theScene.objectModified(info.object);
            info.object.sceneChanged(info, this.theScene);
            ++i;
        }
        this.updateImage();
    }

    void alignObjectsCommand() {
        Vec3 orig;
        Vec3 center;
        BoundingBox bounds;
        CoordinateSystem coords;
        ObjectInfo info;
        int[] sel = this.theScene.getSelection();
        Panel px = new Panel();
        Panel py = new Panel();
        Panel pz = new Panel();
        if (sel.length == 0) {
            return;
        }
        Choice xchoice = new Choice();
        px.add(xchoice);
        xchoice.add("Do not align");
        xchoice.add("Right");
        xchoice.add("Center");
        xchoice.add("Left");
        xchoice.add("Origin");
        px.add(new Label("align to"));
        ValueField vfx = new ValueField(Double.NaN, 0, 5);
        px.add(vfx);
        Choice ychoice = new Choice();
        py.add(ychoice);
        ychoice.add("Do not align");
        ychoice.add("Top");
        ychoice.add("Center");
        ychoice.add("Bottom");
        ychoice.add("Origin");
        py.add(new Label("align to"));
        ValueField vfy = new ValueField(Double.NaN, 0, 5);
        py.add(vfy);
        Choice zchoice = new Choice();
        pz.add(zchoice);
        zchoice.add("Do not align");
        zchoice.add("Front");
        zchoice.add("Center");
        zchoice.add("Back");
        zchoice.add("Origin");
        pz.add(new Label("align to"));
        ValueField vfz = new ValueField(Double.NaN, 0, 5);
        pz.add(vfz);
        ComponentsDialog dlg = new ComponentsDialog((Window)this, "Select how to align the objects:", new Component[]{px, py, pz}, new String[]{"X", "Y", "Z"});
        if (!dlg.clickedOk()) {
            return;
        }
        this.setUndoRecord(new UndoRecord(this, false));
        Vec3 alignTo = new Vec3();
        int i = 0;
        while (i < sel.length) {
            info = this.theScene.getObject(sel[i]);
            coords = info.coords;
            bounds = info.getBounds();
            bounds = bounds.transformAndOutset(coords.fromLocal());
            center = bounds.getCenter();
            orig = coords.getOrigin();
            if (!Double.isNaN(vfx.getValue())) {
                alignTo.x += vfx.getValue();
            } else if (xchoice.getSelectedIndex() == 1) {
                alignTo.x += bounds.maxx;
            } else if (xchoice.getSelectedIndex() == 2) {
                alignTo.x += center.x;
            } else if (xchoice.getSelectedIndex() == 3) {
                alignTo.x += bounds.minx;
            } else if (xchoice.getSelectedIndex() == 4) {
                alignTo.x += orig.x;
            }
            if (!Double.isNaN(vfy.getValue())) {
                alignTo.y += vfy.getValue();
            } else if (ychoice.getSelectedIndex() == 1) {
                alignTo.y += bounds.maxy;
            } else if (ychoice.getSelectedIndex() == 2) {
                alignTo.y += center.y;
            } else if (ychoice.getSelectedIndex() == 3) {
                alignTo.y += bounds.miny;
            } else if (ychoice.getSelectedIndex() == 4) {
                alignTo.y += orig.y;
            }
            if (!Double.isNaN(vfz.getValue())) {
                alignTo.z += vfz.getValue();
            } else if (zchoice.getSelectedIndex() == 1) {
                alignTo.z += bounds.maxz;
            } else if (zchoice.getSelectedIndex() == 2) {
                alignTo.z += center.z;
            } else if (zchoice.getSelectedIndex() == 3) {
                alignTo.z += bounds.minz;
            } else if (zchoice.getSelectedIndex() == 4) {
                alignTo.z += orig.z;
            }
            ++i;
        }
        alignTo.scale(1.0 / (double)sel.length);
        i = 0;
        while (i < sel.length) {
            info = this.theScene.getObject(sel[i]);
            coords = info.coords;
            bounds = info.getBounds();
            bounds = bounds.transformAndOutset(coords.fromLocal());
            center = bounds.getCenter();
            orig = coords.getOrigin();
            this.undo.addCommand(1, new Object[]{coords, coords.duplicate()});
            if (xchoice.getSelectedIndex() == 1) {
                orig.x += alignTo.x - bounds.maxx;
            } else if (xchoice.getSelectedIndex() == 2) {
                orig.x += alignTo.x - center.x;
            } else if (xchoice.getSelectedIndex() == 3) {
                orig.x += alignTo.x - bounds.minx;
            } else if (xchoice.getSelectedIndex() == 4) {
                orig.x += alignTo.x - orig.x;
            }
            if (ychoice.getSelectedIndex() == 1) {
                orig.y += alignTo.y - bounds.maxy;
            } else if (ychoice.getSelectedIndex() == 2) {
                orig.y += alignTo.y - center.y;
            } else if (ychoice.getSelectedIndex() == 3) {
                orig.y += alignTo.y - bounds.miny;
            } else if (ychoice.getSelectedIndex() == 4) {
                orig.y += alignTo.y - orig.y;
            }
            if (zchoice.getSelectedIndex() == 1) {
                orig.z += alignTo.z - bounds.maxz;
            } else if (zchoice.getSelectedIndex() == 2) {
                orig.z += alignTo.z - center.z;
            } else if (zchoice.getSelectedIndex() == 3) {
                orig.z += alignTo.z - bounds.minz;
            } else if (zchoice.getSelectedIndex() == 4) {
                orig.z += alignTo.z - orig.z;
            }
            coords.setOrigin(orig);
            ++i;
        }
        i = 0;
        while (i < sel.length) {
            info = this.theScene.getObject(sel[i]);
            info.object.sceneChanged(info, this.theScene);
            ++i;
        }
        this.updateImage();
    }

    void setTextureCommand() {
        int[] sel = this.theScene.getSelection();
        int count = 0;
        int i = 0;
        while (i < sel.length) {
            if (this.theScene.getObject((int)sel[i]).object.canSetTexture()) {
                ++count;
            }
            ++i;
        }
        if (count == 0) {
            return;
        }
        ObjectInfo[] obj = new ObjectInfo[count];
        i = 0;
        while (i < sel.length) {
            if (this.theScene.getObject((int)sel[i]).object.canSetTexture()) {
                obj[i] = this.theScene.getObject(sel[i]);
            }
            ++i;
        }
        new ObjectTextureDialog((Frame)this, this.theScene, obj);
        i = 0;
        while (i < sel.length) {
            this.theScene.objectModified(this.theScene.getObject((int)sel[i]).object);
            ++i;
        }
        this.modified = true;
        this.updateImage();
    }

    void setMaterialCommand() {
        ObjectInfo info;
        int[] sel = this.theScene.getSelection();
        int count = 0;
        int i = 0;
        while (i < sel.length) {
            info = this.theScene.getObject(sel[i]);
            if (info.object.canSetMaterial()) {
                ++count;
            }
            ++i;
        }
        if (count == 0) {
            return;
        }
        ObjectInfo[] obj = new ObjectInfo[count];
        i = 0;
        while (i < sel.length) {
            info = this.theScene.getObject(sel[i]);
            if (info.object.canSetMaterial()) {
                obj[i] = info;
            }
            ++i;
        }
        new ObjectMaterialDialog((Frame)this, this.theScene, obj);
        this.modified = true;
        this.updateImage();
    }

    void renameObjectCommand() {
        int[] sel = this.theScene.getSelection();
        if (sel.length != 1) {
            return;
        }
        ObjectInfo info = this.theScene.getObject(sel[0]);
        EntriesDialog dlg = new EntriesDialog((Window)this, "Enter new name for selected object:", new String[]{Translate.text("Name")}, new String[]{info.name});
        String[] val = dlg.getEntries();
        if (val == null) {
            return;
        }
        this.setObjectName(sel[0], val[0]);
    }

    void convertToTriangleCommand() {
        Object3D mesh;
        Dialog dlg;
        int[] sel = this.theScene.getSelection();
        if (sel.length != 1) {
            return;
        }
        ObjectInfo info = this.theScene.getObject(sel[0]);
        Object3D obj = info.object;
        if (obj.canConvertToTriangleMesh() == 0) {
            return;
        }
        boolean confirmed = false;
        boolean hasPose = false;
        int i = 0;
        while (i < info.tracks.length) {
            if (info.tracks[i] instanceof PoseTrack) {
                hasPose = true;
                if (!confirmed && !info.tracks[i].isNullTrack()) {
                    dlg = new MessageDialog((Window)this, Translate.text("convertLosesPosesWarning", info.name), new String[]{Translate.text("button.ok"), Translate.text("button.cancel")});
                    if (((MessageDialog)dlg).getChoice() == 1) {
                        return;
                    }
                    confirmed = true;
                }
                if (info.tracks[i].getTimecourse() != null) {
                    info.tracks[i].getTimecourse().removeAllTimepoints();
                }
                info.pose = null;
            }
            ++i;
        }
        if (confirmed) {
            this.theScore.repaintAll();
        }
        this.setUndoRecord(new UndoRecord(this, false, 2, new Object[]{info, info.duplicate()}));
        if (obj.canConvertToTriangleMesh() == 1) {
            if (!confirmed && ((MessageDialog)(dlg = new MessageDialog((Window)this, Translate.text("confirmConvert", info.name), new String[]{Translate.text("button.ok"), Translate.text("button.cancel")}))).getChoice() == 1) {
                return;
            }
            mesh = obj.convertToTriangleMesh(0.0);
        } else {
            double tol;
            dlg = new EntriesDialog((Window)this, "Specify tolerance for triangle mesh:", new String[]{"Max Error"}, new String[]{"0.1"});
            String[] val = ((EntriesDialog)dlg).getEntries();
            if (val == null) {
                return;
            }
            try {
                tol = Double.valueOf(val[0]);
            }
            catch (NumberFormatException ex) {
                new MessageDialog((Window)this, Translate.text("illegalTolerance"));
                return;
            }
            if (tol < 0.0) {
                new MessageDialog((Window)this, Translate.text("negativeTolerance"));
                return;
            }
            mesh = obj.convertToTriangleMesh(tol);
        }
        if (mesh == null) {
            new MessageDialog((Window)this, Translate.text("cannotTriangulate"));
            return;
        }
        mesh.setMaterial(obj.getMaterial());
        mesh.setMaterialMapping(obj.getMaterialMapping());
        Texture tex = obj.getTexture();
        TextureMapping map = obj.getTextureMapping();
        if (tex == null && obj.getMaterial() == null) {
            tex = this.theScene.getDefaultTexture();
            map = tex.getDefaultMapping();
        }
        mesh.setTexture(tex);
        ((Object3D)mesh).setTextureMapping(map);
        if (hasPose) {
            mesh = ((Object3D)mesh).getPosableObject();
        }
        this.theScene.replaceObject(obj, mesh, this.undo);
        this.updateImage();
        this.updateMenus();
    }

    void setObjectVisibility(boolean visible, boolean selectionOnly) {
        this.setUndoRecord(new UndoRecord(this, false));
        if (selectionOnly) {
            int[] sel = this.theScene.getSelection();
            int i = 0;
            while (i < sel.length) {
                ObjectInfo info = this.theScene.getObject(sel[i]);
                this.undo.addCommand(2, new Object[]{info, info.duplicate()});
                info.visible = visible;
                ++i;
            }
        } else {
            int i = 0;
            while (i < this.theScene.getNumObjects()) {
                ObjectInfo info = this.theScene.getObject(i);
                this.undo.addCommand(2, new Object[]{info, info.duplicate()});
                info.visible = visible;
                ++i;
            }
        }
        this.updateImage();
        this.itemTree.repaint();
    }

    void createObjectCommand(String type) {
        String name;
        Object3D obj;
        if ("cube".equals(type)) {
            obj = new Cube(1.0, 1.0, 1.0);
            name = "Cube " + CreateCubeTool.counter++;
        } else if ("sphere".equals(type)) {
            obj = new Sphere(0.5, 0.5, 0.5);
            name = "Sphere " + CreateSphereTool.counter++;
        } else if ("cylinder".equals(type)) {
            obj = new Cylinder(1.0, 0.5, 0.5, 1.0);
            name = "Cylinder " + CreateCylinderTool.counter++;
        } else if ("cone".equals(type)) {
            obj = new Cylinder(1.0, 0.5, 0.5, 0.0);
            name = "Cone " + CreateCylinderTool.counter++;
        } else if ("pointLight".equals(type)) {
            obj = new PointLight(new RGBColor(1.0f, 1.0f, 1.0f), 1.0f, 0.1);
            name = "Light " + CreateLightTool.counter++;
        } else if ("directionalLight".equals(type)) {
            obj = new DirectionalLight(new RGBColor(1.0f, 1.0f, 1.0f), 1.0f);
            name = "Light " + CreateLightTool.counter++;
        } else if ("spotLight".equals(type)) {
            obj = new SpotLight(new RGBColor(1.0f, 1.0f, 1.0f), 1.0f, 20.0, 0.0, 0.1);
            name = "Light " + CreateLightTool.counter++;
        } else if ("camera".equals(type)) {
            obj = new SceneCamera();
            name = "Camera " + CreateCameraTool.counter++;
        } else {
            obj = new NullObject();
            name = "Null";
        }
        obj.setTexture(this.theScene.getDefaultTexture());
        obj.setTextureMapping(obj.getTexture().getDefaultMapping());
        CoordinateSystem coords = new CoordinateSystem(new Vec3(), Vec3.vz(), Vec3.vy());
        ObjectInfo info = new ObjectInfo(obj, coords, name);
        Vec3 orig = coords.getOrigin();
        double[] angles = coords.getRotationAngles();
        Vec3 size = info.getBounds().getSize();
        TransformDialog dlg = new TransformDialog(this, "Layout for '" + name + "'", new double[]{orig.x, orig.y, orig.z, angles[0], angles[1], angles[2], size.x, size.y, size.z}, false, false);
        if (!dlg.clickedOk()) {
            return;
        }
        double[] values = dlg.getValues();
        if (!Double.isNaN(values[0])) {
            orig.x = values[0];
        }
        if (!Double.isNaN(values[1])) {
            orig.y = values[1];
        }
        if (!Double.isNaN(values[2])) {
            orig.z = values[2];
        }
        if (!Double.isNaN(values[3])) {
            angles[0] = values[3];
        }
        if (!Double.isNaN(values[4])) {
            angles[1] = values[4];
        }
        if (!Double.isNaN(values[5])) {
            angles[2] = values[5];
        }
        if (!Double.isNaN(values[6])) {
            size.x = values[6];
        }
        if (!Double.isNaN(values[7])) {
            size.y = values[7];
        }
        if (!Double.isNaN(values[8])) {
            size.z = values[8];
        }
        coords.setOrigin(orig);
        coords.setOrientation(angles[0], angles[1], angles[2]);
        obj.setSize(size.x, size.y, size.z);
        info.addTrack(new PositionTrack(info), 0);
        info.addTrack(new RotationTrack(info), 1);
        this.setUndoRecord(new UndoRecord(this, false));
        this.addObject(info, this.undo);
        this.setSelection(this.theScene.getNumObjects() - 1);
        this.updateImage();
    }

    void createScriptObjectCommand() {
        ComponentsDialog dlg;
        TextField nameField = new TextField("Script");
        Choice scriptChoice = new Choice();
        scriptChoice.add("New Script");
        String[] files = new File(ModellingApp.OBJECT_SCRIPT_DIRECTORY).list();
        if (files != null) {
            int i = 0;
            while (i < files.length) {
                if (files[i].endsWith(".bsh") && files[i].length() > 4) {
                    scriptChoice.add(files[i].substring(0, files[i].length() - 4));
                }
                ++i;
            }
        }
        if (!(dlg = new ComponentsDialog((Window)this, "New Scripted Objects", new Component[]{nameField, scriptChoice}, new String[]{Translate.text("Name"), "Script"})).clickedOk()) {
            return;
        }
        String scriptText = "";
        if (scriptChoice.getSelectedIndex() > 0) {
            try {
                String scriptName = scriptChoice.getSelectedItem() + ".bsh";
                File f = new File(ModellingApp.OBJECT_SCRIPT_DIRECTORY, scriptName);
                scriptText = ModellingApp.loadFile(f);
            }
            catch (IOException ex) {
                new MessageDialog((Window)this, "Error Reading Script", new String[]{Translate.text("errorReadingScript"), ex.getMessage()});
                return;
            }
        }
        ScriptedObject obj = new ScriptedObject("");
        ObjectInfo info = new ObjectInfo(obj, new CoordinateSystem(), nameField.getText());
        this.setUndoRecord(new UndoRecord(this, false));
        this.addObject(info, this.undo);
        this.setSelection(this.theScene.getNumObjects() - 1);
        this.updateImage();
        obj.setScript(scriptText);
        obj.edit(this, info, null);
    }

    void jumpToTimeCommand() {
        ValueField timeField = new ValueField(this.theScene.getTime(), 0);
        ComponentsDialog dlg = new ComponentsDialog((Window)this, "Jump To Time", new Component[]{timeField}, new String[]{Translate.text("Time")});
        if (!dlg.clickedOk()) {
            return;
        }
        double t = timeField.getValue();
        double fps = this.theScene.getFramesPerSecond();
        t = (double)Math.round(t * fps) / fps;
        this.setTime(t);
    }

    void bindToParentCommand() {
        MessageDialog dlg = new MessageDialog((Window)this, Translate.text("confirmBindParent"), new String[]{Translate.text("button.ok"), Translate.text("button.cancel")});
        if (dlg.getChoice() == 1) {
            return;
        }
        int[] sel = this.theScene.getSelection();
        this.setUndoRecord(new UndoRecord(this, false));
        int i = 0;
        while (i < sel.length) {
            ObjectInfo info = this.theScene.getObject(sel[i]);
            if (info.parent != null) {
                Skeleton s = info.parent.getSkeleton();
                ObjectRef relObj = new ObjectRef(info.parent);
                if (s != null) {
                    double nearest = Double.MAX_VALUE;
                    Joint[] jt = s.getJoints();
                    Vec3 pos = info.coords.getOrigin();
                    int j = 0;
                    while (j < jt.length) {
                        ObjectRef r = new ObjectRef(info.parent, jt[j]);
                        double dist = r.getCoords().getOrigin().distance2(pos);
                        if (dist < nearest) {
                            relObj = r;
                            nearest = dist;
                        }
                        ++j;
                    }
                }
                this.undo.addCommand(2, new Object[]{info, info.duplicate()});
                PositionTrack pt = new PositionTrack(info);
                pt.setCoordsObject(relObj);
                info.addTrack(pt, 0);
                pt.setKeyframe(this.theScene.getTime(), this.theScene);
                RotationTrack rt = new RotationTrack(info);
                rt.setCoordsObject(relObj);
                info.addTrack(rt, 1);
                rt.setKeyframe(this.theScene.getTime(), this.theScene);
            }
            ++i;
        }
        this.theScore.rebuildList();
        this.theScore.repaint();
    }

    void renderCommand() {
        new RenderSetupDialog((Frame)this, this.theScene);
    }

    void toggleViewsCommand() {
        GridBagConstraints gc = new GridBagConstraints();
        this.viewsContainer.removeAll();
        gc.gridy = 0;
        gc.gridx = 0;
        gc.gridheight = 2;
        gc.anchor = 11;
        gc.fill = 1;
        this.viewsContainer.add((Component)this.toolsPanel, gc);
        gc.weighty = 1.0;
        gc.weightx = 1.0;
        if (this.numViewsShown == 4) {
            gc.gridx = 1;
            this.sceneMenuItem[0].setLabel(Translate.text("menu.fourViews"));
            this.viewsContainer.add((Component)this.viewPanel[this.currentView], gc);
            this.numViewsShown = 1;
        } else {
            gc.gridheight = 1;
            this.sceneMenuItem[0].setLabel(Translate.text("menu.oneView"));
            gc.gridx = 1;
            this.viewsContainer.add((Component)this.viewPanel[0], gc);
            gc.gridx = 2;
            this.viewsContainer.add((Component)this.viewPanel[1], gc);
            gc.gridy = 1;
            this.viewsContainer.add((Component)this.viewPanel[3], gc);
            gc.gridx = 1;
            this.viewsContainer.add((Component)this.viewPanel[2], gc);
            this.numViewsShown = 4;
        }
        this.viewsContainer.validate();
        this.updateImage();
    }

    void setTemplateCommand() {
        FileDialog dlg = new FileDialog((Frame)this, "Select an image file", 0);
        dlg.show();
        if (dlg.getFile() == null) {
            return;
        }
        try {
            this.theView[0].setTemplateImage(new File(dlg.getDirectory(), dlg.getFile()));
        }
        catch (InterruptedException ex) {
            new MessageDialog((Window)this, Translate.text("errorLoadingImage"));
        }
        this.sceneMenuItem[2].setEnabled(true);
        this.sceneMenuItem[2].setLabel(Translate.text("menu.hideTemplate"));
        int i = 0;
        while (i < this.theView.length) {
            this.theView[i].setShowTemplate(true);
            ++i;
        }
        this.updateImage();
    }

    void setGridCommand() {
        ValueField spaceField = new ValueField(this.theScene.gridSpacing, 3);
        ValueField divField = new ValueField(this.theScene.gridSubdivisions, 7);
        Checkbox showBox = new Checkbox("Show Grid", this.theScene.showGrid);
        Checkbox snapBox = new Checkbox("Snap To Grid", this.theScene.snapToGrid);
        ComponentsDialog dlg = new ComponentsDialog((Window)this, "Select grid options:", new Component[]{spaceField, divField, showBox, snapBox}, new String[]{"Grid Spacing", "Snap-To Subdivisions", "", ""});
        if (!dlg.clickedOk()) {
            return;
        }
        this.theScene.gridSpacing = spaceField.getValue();
        this.theScene.gridSubdivisions = (int)divField.getValue();
        this.theScene.showGrid = showBox.getState();
        this.theScene.snapToGrid = snapBox.getState();
        int i = 0;
        while (i < this.theView.length) {
            this.theView[i].setGrid(this.theScene.gridSpacing, this.theScene.gridSubdivisions, this.theScene.showGrid, this.theScene.snapToGrid);
            ++i;
        }
        this.updateImage();
    }

    void frameWithCameraCommand(boolean selectionOnly) {
        int[] sel = this.theScene.getSelectionWithChildren();
        BoundingBox bb = null;
        if (selectionOnly) {
            int i = 0;
            while (i < sel.length) {
                ObjectInfo info = this.theScene.getObject(sel[i]);
                BoundingBox bounds = info.getBounds().transformAndOutset(info.coords.fromLocal());
                bb = bb == null ? bounds : bb.merge(bounds);
                ++i;
            }
        } else {
            int i = 0;
            while (i < this.theScene.getNumObjects()) {
                ObjectInfo info = this.theScene.getObject(i);
                BoundingBox bounds = info.getBounds().transformAndOutset(info.coords.fromLocal());
                bb = bb == null ? bounds : bb.merge(bounds);
                ++i;
            }
        }
        if (bb == null) {
            return;
        }
        if (this.numViewsShown == 1) {
            this.theView[this.currentView].frameBox(bb);
        } else {
            int i = 0;
            while (i < this.theView.length) {
                this.theView[i].frameBox(bb);
                ++i;
            }
        }
        this.updateImage();
    }

    void texturesCommand() {
        this.theScene.showTexturesDialog(this);
    }

    void materialsCommand() {
        this.theScene.showMaterialsDialog(this);
    }

    void environmentCommand() {
        final RGBColor ambColor = this.theScene.getAmbientColor();
        final RGBColor envColor = this.theScene.getEnvironmentColor();
        final RGBColor fogColor = this.theScene.getFogColor();
        final RGBColor oldAmbColor = ambColor.duplicate();
        final RGBColor oldEnvColor = envColor.duplicate();
        final RGBColor oldFogColor = fogColor.duplicate();
        final Panel ambPatch = ambColor.getSample(50, 30);
        final Panel envPatch = envColor.getSample(50, 30);
        final Panel fogPatch = fogColor.getSample(50, 30);
        final Checkbox fogBox = new Checkbox("Environment Fog", this.theScene.getFogState());
        final ValueField fogField = new ValueField(this.theScene.getFogDistance(), 3);
        final Panel envPanel = new Panel();
        final Choice envChoice = new Choice();
        final Button envButton = new Button("Set:");
        final Label envLabel = new Label();
        final CardLayout envLayout = new CardLayout();
        final Sphere envSphere = new Sphere(1.0, 1.0, 1.0);
        final ObjectInfo envInfo = new ObjectInfo(envSphere, new CoordinateSystem(), "Environment");
        envChoice.add("Solid Color");
        envChoice.add("Texture - Diffuse");
        envChoice.add("Texture - Emissive");
        envChoice.select(this.theScene.getEnvironmentMode());
        envPanel.setLayout(envLayout);
        Panel p = new Panel();
        p.add(envButton);
        p.add(envLabel);
        envPanel.add((Component)envPatch, "solid");
        envPanel.add((Component)p, "texture");
        if (this.theScene.getEnvironmentMode() == 0) {
            envLayout.first(envPanel);
        } else {
            envLayout.last(envPanel);
        }
        envInfo.setTexture(this.theScene.getEnvironmentTexture(), this.theScene.getEnvironmentMapping());
        envLabel.setText(envSphere.getTexture().getName());
        envChoice.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent e) {
                if (envChoice.getSelectedIndex() == 0) {
                    envLayout.show(envPanel, "solid");
                } else {
                    envLayout.show(envPanel, "texture");
                }
            }
        });
        final Callback envTextureCallback = new Callback(){

            public void execute() {
                envLabel.setText(envSphere.getTexture().getName());
                envButton.invalidate();
                envLabel.invalidate();
                envPanel.validate();
            }
        };
        envButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                this.setCursor(envPanel.getParent(), Cursor.getPredefinedCursor(3));
                ObjectTextureDialog otd = new ObjectTextureDialog((Frame)LayoutWindow.this, LayoutWindow.this.theScene, new ObjectInfo[]{envInfo});
                otd.setCallback(envTextureCallback);
                this.setCursor(envPanel.getParent(), Cursor.getDefaultCursor());
            }

            private void setCursor(Component comp, Cursor cur) {
                comp.setCursor(cur);
                if (!(comp instanceof Container)) {
                    return;
                }
                Component[] children = ((Container)comp).getComponents();
                int i = 0;
                while (i < children.length) {
                    this.setCursor(children[i], cur);
                    ++i;
                }
            }
        });
        ambPatch.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent e) {
                new ColorChooser((Frame)LayoutWindow.this, "Ambient Color", ambColor);
                ambPatch.setBackground(ambColor.getColor());
                ambPatch.repaint();
            }
        });
        envPatch.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent e) {
                new ColorChooser((Frame)LayoutWindow.this, "Environment Color", envColor);
                envPatch.setBackground(envColor.getColor());
                envPatch.repaint();
            }
        });
        fogPatch.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent e) {
                new ColorChooser((Frame)LayoutWindow.this, "Fog Color", fogColor);
                fogPatch.setBackground(fogColor.getColor());
                fogPatch.repaint();
            }
        });
        Callback okCallback = new Callback(){

            public void execute() {
                LayoutWindow.this.theScene.setFog(fogBox.getState(), fogField.getValue());
                LayoutWindow.this.theScene.setEnvironmentMode(envChoice.getSelectedIndex());
                LayoutWindow.this.theScene.setEnvironmentTexture(envSphere.getTexture());
                LayoutWindow.this.theScene.setEnvironmentMapping(envSphere.getTextureMapping());
                LayoutWindow.this.modified = true;
            }
        };
        Callback cancelCallback = new Callback(){

            public void execute() {
                ambColor.copy(oldAmbColor);
                envColor.copy(oldEnvColor);
                fogColor.copy(oldFogColor);
            }
        };
        ComponentsDialog dlg = new ComponentsDialog(this, "Environment Properties:", new Component[]{ambPatch, envChoice, envPanel, fogBox, fogPatch, fogField}, new String[]{"Ambient Color", "Environment", "", "", "Fog Color", "Fog Distance"}, okCallback, cancelCallback);
    }

    public void executeScript(File f) {
        String scriptText = null;
        try {
            scriptText = ModellingApp.loadFile(f);
        }
        catch (IOException ex) {
            new MessageDialog((Window)this, "Error Reading Script", new String[]{Translate.text("errorReadingScript"), ex.getMessage()});
            return;
        }
        try {
            ToolScript script = ScriptRunner.parseToolScript(scriptText);
            script.execute(this);
        }
        catch (Exception e) {
            ScriptRunner.displayError(e, this, 1);
        }
        this.updateImage();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

