/*
 * Decompiled with CFR 0.152.
 */
package artofillusion;

import artofillusion.MaterialPreviewer;
import artofillusion.ModellingApp;
import artofillusion.material.Material;
import artofillusion.material.MaterialMapping;
import artofillusion.object.Object3D;
import java.awt.Button;
import java.awt.Choice;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Label;
import java.awt.Panel;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Vector;

public class MaterialMappingDialog
extends Dialog
implements ActionListener,
ItemListener {
    Frame fr;
    Object3D obj;
    Vector mappings;
    Choice mapChoice;
    MaterialPreviewer preview;
    MaterialMapping map;
    MaterialMapping oldMapping;
    Panel editingPanel;
    static /* synthetic */ Class class$artofillusion$object$Object3D;
    static /* synthetic */ Class class$artofillusion$material$Material;

    public MaterialMappingDialog(Frame parent, Object3D obj) {
        super(parent, "Material Mapping", true);
        this.fr = parent;
        this.obj = obj;
        this.map = obj.getMaterialMapping();
        this.oldMapping = this.map.duplicate();
        this.mappings = new Vector();
        Class[] allMappings = ModellingApp.getMaterialMappings();
        int i = 0;
        while (i < allMappings.length) {
            try {
                Method mtd = allMappings[i].getMethod("legalMapping", class$artofillusion$object$Object3D == null ? MaterialMappingDialog.class$("artofillusion.object.Object3D") : class$artofillusion$object$Object3D, class$artofillusion$material$Material == null ? MaterialMappingDialog.class$("artofillusion.material.Material") : class$artofillusion$material$Material);
                Material mat = obj.getMaterial();
                Boolean result = (Boolean)mtd.invoke(null, obj, mat);
                if (result.booleanValue()) {
                    this.mappings.addElement(allMappings[i]);
                }
            }
            catch (Exception ex) {
                // empty catch block
            }
            ++i;
        }
        GridBagConstraints gc = new GridBagConstraints();
        this.setLayout(new GridBagLayout());
        gc.gridwidth = 2;
        this.preview = new MaterialPreviewer(obj.getTexture(), obj.getMaterial(), obj.duplicate(), 160, 160);
        this.add((Component)this.preview, gc);
        this.preview.setMaterialMapping(obj.getMaterialMapping());
        gc.gridwidth = 1;
        gc.gridy = 1;
        this.add((Component)new Label("Mapping:"), gc);
        this.mapChoice = new Choice();
        this.add((Component)this.mapChoice, gc);
        int i2 = 0;
        while (i2 < this.mappings.size()) {
            try {
                Method mtd = ((Class)this.mappings.elementAt(i2)).getMethod("getName", null);
                this.mapChoice.add((String)mtd.invoke(null, null));
                if (this.mappings.elementAt(i2) == this.map.getClass()) {
                    this.mapChoice.select(i2);
                }
            }
            catch (IllegalAccessException ex) {
            }
            catch (IllegalArgumentException ex) {
            }
            catch (InvocationTargetException ex) {
            }
            catch (NoSuchMethodException ex) {
            }
            catch (SecurityException ex) {
                // empty catch block
            }
            ++i2;
        }
        this.mapChoice.addItemListener(this);
        gc.gridwidth = 2;
        gc.gridy = 2;
        this.editingPanel = this.map.getEditingPanel(obj, this.preview);
        this.add((Component)this.editingPanel, gc);
        Panel p = new Panel();
        gc.gridwidth = 2;
        gc.gridy = 3;
        this.add((Component)p, gc);
        Button b = new Button("Ok");
        p.add(b);
        b.setActionCommand("ok");
        b.addActionListener(this);
        b = new Button("Cancel");
        p.add(b);
        b.setActionCommand("cancel");
        b.addActionListener(this);
        this.pack();
        this.setResizable(false);
        ModellingApp.centerWindow(this);
        this.show();
    }

    public void actionPerformed(ActionEvent e) {
        String command = e.getActionCommand();
        String[] finalStrings = new String[9];
        if (command.equals("cancel")) {
            this.setMapping(this.oldMapping);
        }
        this.dispose();
    }

    public void itemStateChanged(ItemEvent e) {
        try {
            Class cls = (Class)this.mappings.elementAt(this.mapChoice.getSelectedIndex());
            if (cls == this.map.getClass()) {
                return;
            }
            Constructor con = cls.getConstructor(class$artofillusion$material$Material == null ? (class$artofillusion$material$Material = MaterialMappingDialog.class$("artofillusion.material.Material")) : class$artofillusion$material$Material);
            Material mat = this.obj.getMaterial();
            this.setMapping((MaterialMapping)con.newInstance(mat));
            this.remove(this.editingPanel);
            GridBagConstraints gc = new GridBagConstraints();
            gc.gridwidth = 2;
            gc.gridy = 2;
            this.editingPanel = this.map.getEditingPanel(this.obj, this.preview);
            this.add((Component)this.editingPanel, gc);
            this.pack();
            this.preview.render();
        }
        catch (IllegalAccessException ex) {
        }
        catch (InstantiationException ex) {
        }
        catch (InvocationTargetException ex) {
        }
        catch (NoSuchMethodException ex) {
            // empty catch block
        }
    }

    private void setMapping(MaterialMapping newmap) {
        this.map = newmap;
        this.obj.setMaterialMapping(newmap);
        this.preview.setMaterialMapping(newmap);
        this.preview.render();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

