/*
 * Decompiled with CFR 0.152.
 */
package artofillusion;

import artofillusion.Camera;
import artofillusion.ModellingApp;
import artofillusion.RenderListener;
import artofillusion.Renderer;
import artofillusion.Scene;
import artofillusion.image.ComplexImage;
import artofillusion.material.Material;
import artofillusion.material.MaterialMapping;
import artofillusion.math.BoundingBox;
import artofillusion.math.CoordinateSystem;
import artofillusion.math.Mat4;
import artofillusion.math.RGBColor;
import artofillusion.math.Vec3;
import artofillusion.object.DirectionalLight;
import artofillusion.object.Object3D;
import artofillusion.object.ObjectInfo;
import artofillusion.object.Sphere;
import artofillusion.object.TriangleMesh;
import artofillusion.texture.Texture;
import artofillusion.texture.TextureMapping;
import artofillusion.texture.UniformTexture;
import java.awt.Canvas;
import java.awt.Color;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Point;
import java.awt.Window;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;

public class MaterialPreviewer
extends Canvas
implements MouseListener,
MouseMotionListener,
RenderListener {
    Scene theScene;
    Camera theCamera;
    Object3D theObject;
    ObjectInfo info;
    CoordinateSystem objectCoords;
    Image theImage;
    int w;
    int h;
    boolean mouseInside;
    boolean renderInProgress;
    Point clickPoint;
    Mat4 rotMatrix;
    public static final int HANDLE_SIZE = 5;
    static final double DRAG_SCALE = Math.PI / 360;

    public MaterialPreviewer(Texture tex, Material mat, int width, int height) {
        this(tex, mat, new Sphere(1.0, 1.0, 1.0), width, height);
    }

    public MaterialPreviewer(Texture tex, Material mat, Object3D obj, int width, int height) {
        ObjectInfo objInfo = new ObjectInfo(obj, new CoordinateSystem(), "");
        if (tex == null) {
            tex = UniformTexture.invisibleTexture();
        }
        objInfo.setTexture(tex, tex.getDefaultMapping());
        if (mat != null) {
            objInfo.setMaterial(mat, mat.getDefaultMapping());
        }
        this.init(objInfo, width, height);
    }

    public MaterialPreviewer(ObjectInfo obj, int width, int height) {
        this.init(obj.duplicate(), width, height);
    }

    private void init(ObjectInfo obj, int width, int height) {
        BoundingBox bounds = obj.getBounds();
        Vec3 size = bounds.getSize();
        double max = Math.max(size.x, Math.max(size.y, size.z)) / 2.0;
        double floor = -bounds.getSize().length() / 2.0;
        CoordinateSystem coords = new CoordinateSystem(new Vec3(0.0, 0.0, 10.0 * max), new Vec3(0.0, 0.0, -1.0), Vec3.vy());
        Vec3[] vert = new Vec3[]{new Vec3(100.0 * max, floor, 100.0 * max), new Vec3(-100.0 * max, floor, 100.0 * max), new Vec3(0.0, floor, -100.0 * max)};
        int[][] face = new int[][]{{0, 1, 2}};
        this.theScene = new Scene();
        this.theCamera = new Camera();
        this.theObject = obj.object;
        this.theCamera.setCameraCoordinates(coords);
        coords = new CoordinateSystem(new Vec3(), new Vec3(-0.5, -0.4, -1.0), Vec3.vy());
        this.theScene.addObject(new DirectionalLight(new RGBColor(1.0f, 1.0f, 1.0f), 0.8f), coords, "", null);
        coords = new CoordinateSystem(new Vec3(), Vec3.vz(), Vec3.vy());
        TriangleMesh tri = new TriangleMesh(vert, (int[][])face);
        this.theScene.addObject(tri, coords, "", null);
        tri.setTexture(this.theScene.getDefaultTexture());
        tri.setTextureMapping(this.theScene.getDefaultTexture().getDefaultMapping());
        this.info = obj;
        this.objectCoords = this.info.coords = new CoordinateSystem();
        this.theScene.addObject(this.info, null);
        this.w = width;
        this.h = height;
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
        this.render();
    }

    public ObjectInfo getObject() {
        return this.info;
    }

    public void setTexture(Texture tex, TextureMapping map) {
        if (tex == null) {
            tex = UniformTexture.invisibleTexture();
        }
        if (map == null) {
            map = tex.getDefaultMapping();
        }
        this.info.setTexture(tex, map);
    }

    public void setMaterial(Material mat) {
        this.theObject.setMaterial(mat);
    }

    public void setMaterialMapping(MaterialMapping map) {
        this.theObject.setMaterialMapping(map);
    }

    public synchronized void render() {
        Renderer rend = ModellingApp.getPreferences().getTexturePreviewRenderer();
        if (rend == null) {
            return;
        }
        rend.cancelRendering(this.theScene);
        this.theCamera.setSize(this.w, this.h);
        this.theCamera.setDistToScreen((double)this.h / 200.0 / Math.tan(0.14));
        rend.configurePreview();
        rend.renderScene(this.theScene, this.theCamera, this, 5.0, 10.0);
        this.renderInProgress = true;
        this.repaint();
    }

    public synchronized void cancelRendering() {
        Renderer rend = ModellingApp.getPreferences().getTexturePreviewRenderer();
        if (rend != null) {
            rend.cancelRendering(this.theScene);
        }
    }

    public void paint(Graphics g) {
        if (this.theImage != null) {
            g.drawImage(this.theImage, 0, 0, this);
        }
        if (this.mouseInside) {
            this.drawHilight(g);
        }
        if (this.renderInProgress) {
            g.setColor(Color.red);
            g.drawRect(0, 0, this.w - 1, this.h - 1);
        }
    }

    private void drawHilight(Graphics g) {
        g.setColor(Color.red);
        g.fillRect(0, 0, 5, 5);
        g.fillRect(this.w - 5, 0, 5, 5);
        g.fillRect(0, this.h - 5, 5, 5);
        g.fillRect(this.w - 5, this.h - 5, 5, 5);
    }

    private void drawObject(Graphics g) {
        g.setColor(Color.gray);
        this.theCamera.setObjectTransform(this.rotMatrix.times(this.objectCoords.fromLocal()));
        Object3D.draw(g, this.theCamera, this.theObject.getWireframeMesh(), this.theObject.getBounds());
    }

    public Dimension getPreferredSize() {
        return new Dimension(this.w, this.h);
    }

    public Dimension getMinimumSize() {
        return new Dimension(this.w, this.h);
    }

    public void imageUpdated(Image image) {
        this.theImage = image;
        this.repaint();
    }

    public void imageComplete(ComplexImage image) {
        this.theImage = image.getImage();
        this.renderInProgress = false;
        this.repaint();
    }

    public void renderingCanceled() {
    }

    public void addNotify() {
        super.addNotify();
        Container c = this.getParent();
        while (c != null && !(c instanceof Window)) {
            c = c.getParent();
        }
        if (!(c instanceof Window)) {
            return;
        }
        ((Window)c).addWindowListener(new WindowAdapter(){

            public void windowClosed(WindowEvent e) {
                Renderer rend = ModellingApp.getPreferences().getTexturePreviewRenderer();
                if (rend != null) {
                    rend.cancelRendering(MaterialPreviewer.this.theScene);
                }
            }
        });
    }

    public void mouseEntered(MouseEvent e) {
        this.mouseInside = true;
        Graphics g = this.getGraphics();
        this.drawHilight(g);
        g.dispose();
    }

    public void mouseExited(MouseEvent e) {
        this.mouseInside = false;
        this.repaint();
    }

    public void mousePressed(MouseEvent e) {
        Graphics g = this.getGraphics();
        this.clickPoint = e.getPoint();
        Renderer rend = ModellingApp.getPreferences().getTexturePreviewRenderer();
        if (rend != null) {
            rend.cancelRendering(this.theScene);
        }
        this.rotMatrix = Mat4.identity();
        this.drawObject(g);
        g.dispose();
    }

    public void mouseReleased(MouseEvent e) {
        Point dragPoint = e.getPoint();
        Vec3 rotAxis = new Vec3((double)(this.clickPoint.y - dragPoint.y) * (Math.PI / 360), (double)(dragPoint.x - this.clickPoint.x) * (Math.PI / 360), 0.0);
        double angle = rotAxis.length();
        if (angle != 0.0) {
            rotAxis = rotAxis.times(1.0 / angle);
            rotAxis = this.theCamera.getViewToWorld().timesDirection(rotAxis);
            this.rotMatrix = Mat4.axisRotation(rotAxis, angle);
            this.objectCoords.transformAxes(this.rotMatrix);
        }
        this.render();
    }

    public void mouseClicked(MouseEvent e) {
        if (e.getClickCount() == 2) {
            this.objectCoords.setOrientation(0.0, 0.0, 0.0);
            this.render();
        }
    }

    public void mouseDragged(MouseEvent e) {
        Graphics g = this.getGraphics();
        Point dragPoint = e.getPoint();
        Vec3 rotAxis = new Vec3((double)(this.clickPoint.y - dragPoint.y) * (Math.PI / 360), (double)(dragPoint.x - this.clickPoint.x) * (Math.PI / 360), 0.0);
        double angle = rotAxis.length();
        rotAxis = rotAxis.times(1.0 / angle);
        rotAxis = this.theCamera.getViewToWorld().timesDirection(rotAxis);
        this.rotMatrix = Mat4.axisRotation(rotAxis, angle);
        g.drawImage(this.theImage, 0, 0, this);
        this.drawHilight(g);
        this.drawObject(g);
        g.dispose();
    }

    public void mouseMoved(MouseEvent e) {
    }
}

