/*
 * Decompiled with CFR 0.152.
 */
package artofillusion;

import artofillusion.MeshEditorWindow;
import artofillusion.MeshViewer;
import artofillusion.ModellingApp;
import artofillusion.Scene;
import artofillusion.TextureParameter;
import artofillusion.TransformPointsDialog;
import artofillusion.UndoRecord;
import artofillusion.ViewerCanvas;
import artofillusion.animation.Joint;
import artofillusion.animation.JointEditorDialog;
import artofillusion.animation.Skeleton;
import artofillusion.math.CoordinateSystem;
import artofillusion.math.Mat4;
import artofillusion.math.Vec3;
import artofillusion.object.Mesh;
import artofillusion.object.MeshVertex;
import artofillusion.object.Object3D;
import artofillusion.object.ObjectInfo;
import artofillusion.texture.LayeredMapping;
import artofillusion.texture.LayeredTexture;
import artofillusion.texture.Texture;
import artofillusion.ui.ComponentsDialog;
import artofillusion.ui.EditingTool;
import artofillusion.ui.EditingWindow;
import artofillusion.ui.MessageDialog;
import artofillusion.ui.PanelDialog;
import artofillusion.ui.ToolPalette;
import artofillusion.ui.Translate;
import artofillusion.ui.ValueChecker;
import artofillusion.ui.ValueField;
import artofillusion.ui.ValueSlider;
import java.awt.Button;
import java.awt.Checkbox;
import java.awt.CheckboxMenuItem;
import java.awt.Choice;
import java.awt.Component;
import java.awt.Container;
import java.awt.FileDialog;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Label;
import java.awt.Menu;
import java.awt.MenuBar;
import java.awt.MenuItem;
import java.awt.Panel;
import java.awt.TextComponent;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.TextEvent;
import java.awt.event.TextListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;

public abstract class MeshEditorWindow
extends Frame
implements ActionListener,
EditingWindow,
ItemListener,
KeyListener {
    EditingWindow parentWindow;
    MeshViewer theView;
    ToolPalette tools;
    EditingTool defaultTool;
    EditingTool currentTool;
    Label helpText;
    Mesh oldMesh;
    MenuBar menubar;
    Menu viewMenu;
    MenuItem undoItem;
    MenuItem templateItem;
    CheckboxMenuItem[] displayItem;
    CheckboxMenuItem[] coordsItem;
    CheckboxMenuItem[] showItem;
    UndoRecord undo;
    static int meshTension = 2;
    static int tensionDistance = 0;
    static final double[] tensionArray = new double[]{5.0, 3.0, 2.0, 1.0, 0.5};

    public MeshEditorWindow(EditingWindow parent, String title, Mesh obj) {
        super(title);
        this.parentWindow = parent;
        this.oldMesh = obj;
        if (ModellingApp.defaultFont != null) {
            this.setFont(ModellingApp.defaultFont);
        }
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent e) {
                MessageDialog dlg = new MessageDialog((Window)MeshEditorWindow.this, "Save changes made in this window?", new String[]{"Save Changes", "Discard Changes", Translate.text("button.cancel")});
                if (dlg.getChoice() == 0) {
                    MeshEditorWindow.this.actionPerformed(new ActionEvent(this, 1001, "ok"));
                }
                if (dlg.getChoice() == 1) {
                    MeshEditorWindow.this.actionPerformed(new ActionEvent(this, 1001, "cancel"));
                }
            }
        });
    }

    protected void recursivelyAddListeners(Component c) {
        if (!(c instanceof TextComponent)) {
            c.addKeyListener(this);
        }
        if (c instanceof Container) {
            Component[] children = ((Container)c).getComponents();
            int i = 0;
            while (i < children.length) {
                this.recursivelyAddListeners(children[i]);
                ++i;
            }
        }
    }

    protected void createViewMenu() {
        this.viewMenu = Translate.menu("view");
        this.menubar.add(this.viewMenu);
        Menu displayMenu = Translate.menu("displayMode");
        this.viewMenu.add(displayMenu);
        this.displayItem = new CheckboxMenuItem[4];
        this.displayItem[0] = Translate.checkboxMenuItem("wireframeDisplay", this, this.theView.getRenderMode() == 0);
        displayMenu.add(this.displayItem[0]);
        this.displayItem[1] = Translate.checkboxMenuItem("shadedDisplay", this, this.theView.getRenderMode() == 1);
        displayMenu.add(this.displayItem[1]);
        this.displayItem[2] = Translate.checkboxMenuItem("smoothDisplay", this, this.theView.getRenderMode() == 2);
        displayMenu.add(this.displayItem[2]);
        this.displayItem[3] = Translate.checkboxMenuItem("transparentDisplay", this, this.theView.getRenderMode() == 3);
        displayMenu.add(this.displayItem[3]);
        this.viewMenu.add(this.createShowMenu());
        Menu coordsMenu = Translate.menu("coordinateSystem");
        this.viewMenu.add(coordsMenu);
        this.coordsItem = new CheckboxMenuItem[2];
        this.coordsItem[0] = Translate.checkboxMenuItem("localCoords", this, !this.theView.getUseWorldCoords());
        coordsMenu.add(this.coordsItem[0]);
        this.coordsItem[1] = Translate.checkboxMenuItem("sceneCoords", this, this.theView.getUseWorldCoords());
        coordsMenu.add(this.coordsItem[1]);
        this.viewMenu.add(Translate.menuItem("grid", this));
        this.templateItem = Translate.menuItem("showTemplate", this);
        this.viewMenu.add(this.templateItem);
        this.viewMenu.add(Translate.menuItem("setTemplate", this));
    }

    protected Menu createShowMenu() {
        Menu menu = Translate.menu("show");
        this.showItem = new CheckboxMenuItem[4];
        this.showItem[0] = Translate.checkboxMenuItem("controlMesh", this, this.theView.getMeshVisible());
        menu.add(this.showItem[0]);
        this.showItem[1] = Translate.checkboxMenuItem("surface", this, this.theView.getSurfaceVisible());
        menu.add(this.showItem[1]);
        this.showItem[2] = Translate.checkboxMenuItem("skeleton", this, this.theView.getSkeletonVisible());
        menu.add(this.showItem[2]);
        this.showItem[3] = Translate.checkboxMenuItem("entireScene", this, this.theView.getSceneVisible());
        menu.add(this.showItem[3]);
        return menu;
    }

    public boolean confirmClose() {
        return true;
    }

    public void setHelpText(String text) {
        this.helpText.setText(text);
    }

    public Frame getFrame() {
        return this;
    }

    public void updateImage() {
        this.theView.updateImage();
        this.theView.repaint();
    }

    public void setUndoRecord(UndoRecord command) {
        this.undo = command;
        this.undoItem.setEnabled(true);
        if (this.undo.isRedo()) {
            this.undoItem.setLabel(Translate.text("menu.redo"));
        } else {
            this.undoItem.setLabel(Translate.text("menu.undo"));
        }
    }

    public Scene getScene() {
        return this.theView.getScene();
    }

    public void keyPressed(KeyEvent e) {
        int code = e.getKeyCode();
        if (e.isShiftDown() && (code == 37 || code == 39 || code == 38 || code == 40)) {
            this.tools.keyPressed(e);
        } else {
            this.currentTool.keyPressed(e, this.theView);
        }
    }

    public void keyReleased(KeyEvent e) {
    }

    public void keyTyped(KeyEvent e) {
    }

    void undoCommand() {
        if (this.undo == null) {
            return;
        }
        this.setUndoRecord(this.undo.execute());
        this.theView.setMesh((Mesh)((Object)this.theView.getObject().object));
        this.theView.updateImage();
        this.theView.repaint();
    }

    public ViewerCanvas getView() {
        return this.theView;
    }

    public void itemStateChanged(ItemEvent e) {
        Object source = e.getSource();
        if (source == this.coordsItem[0] || source == this.coordsItem[1]) {
            int i = 0;
            while (i < this.coordsItem.length) {
                this.coordsItem[i].setState(source == this.coordsItem[i]);
                ++i;
            }
            this.theView.setUseWorldCoords(source == this.coordsItem[1]);
            this.updateImage();
            return;
        }
        if (source == this.showItem[0]) {
            this.theView.setMeshVisible(this.showItem[0].getState());
            this.updateImage();
            return;
        }
        if (source == this.showItem[1]) {
            this.theView.setSurfaceVisible(this.showItem[1].getState());
            this.updateImage();
            return;
        }
        if (source == this.showItem[2]) {
            this.theView.setSkeletonVisible(this.showItem[2].getState());
            this.updateImage();
            return;
        }
        if (source == this.showItem[3]) {
            this.theView.setSceneVisible(this.showItem[3].getState());
            this.updateImage();
            return;
        }
        int i = 0;
        while (i < this.displayItem.length) {
            this.displayItem[i].setState(source == this.displayItem[i]);
            ++i;
        }
        if (source == this.displayItem[0]) {
            this.theView.setRenderMode(0);
        } else if (source == this.displayItem[1]) {
            this.theView.setRenderMode(1);
        } else if (source == this.displayItem[2]) {
            this.theView.setRenderMode(2);
        } else if (source == this.displayItem[3]) {
            this.theView.setRenderMode(3);
        }
        this.updateImage();
    }

    void setPointsCommand() {
        ComponentsDialog dlg;
        String title;
        ValueField zField;
        ValueField yField;
        ValueField xField;
        int j = 0;
        int num = 0;
        final Mesh theMesh = (Mesh)((Object)this.theView.getObject().object);
        Mesh oldMesh = (Mesh)((Object)theMesh.duplicate());
        Skeleton s = theMesh.getSkeleton();
        Joint[] jt = null;
        final int[] selected = this.theView.getSelectionDistance();
        final CoordinateSystem coords = this.theView.thisObjectInScene.coords;
        final MeshVertex[] vert = theMesh.getVertices();
        final Vec3[] points = new Vec3[vert.length];
        ValueSlider weightSlider = null;
        Choice jointChoice = null;
        double weight = -1.0;
        int joint = -2;
        int i = 0;
        while (i < selected.length) {
            if (selected[i] == 0) {
                ++num;
                j = i;
                if (weight == -1.0) {
                    weight = vert[i].ikWeight;
                } else if (vert[i].ikWeight != weight) {
                    weight = Double.NaN;
                }
                if (joint == -2) {
                    joint = vert[i].ikJoint;
                } else if (vert[i].ikJoint != joint) {
                    joint = -3;
                }
            }
            ++i;
        }
        if (num == 0) {
            return;
        }
        if (num == 1) {
            Vec3 pos = vert[j].r;
            if (this.theView.getUseWorldCoords() && coords != null) {
                pos = coords.fromLocal().times(pos);
            }
            xField = new ValueField(pos.x, 0, 5);
            yField = new ValueField(pos.y, 0, 5);
            zField = new ValueField(pos.z, 0, 5);
            title = "Enter coordinates for selected vertex:";
        } else {
            xField = new ValueField(Double.NaN, 0, 5);
            yField = new ValueField(Double.NaN, 0, 5);
            zField = new ValueField(Double.NaN, 0, 5);
            title = "Enter coordinates for selected vertices:";
        }
        TextListener tl = new TextListener(){

            public void textValueChanged(TextEvent ev) {
                int i = 0;
                while (i < selected.length) {
                    points[i] = vert[i].r;
                    if (selected[i] == 0) {
                        if (MeshEditorWindow.this.theView.getUseWorldCoords() && coords != null) {
                            coords.fromLocal().transform(points[i]);
                        }
                        if (!Double.isNaN(xField.getValue())) {
                            points[i].x = xField.getValue();
                        }
                        if (!Double.isNaN(yField.getValue())) {
                            points[i].y = yField.getValue();
                        }
                        if (!Double.isNaN(zField.getValue())) {
                            points[i].z = zField.getValue();
                        }
                        if (MeshEditorWindow.this.theView.getUseWorldCoords() && coords != null) {
                            coords.toLocal().transform(points[i]);
                        }
                    }
                    ++i;
                }
                theMesh.setVertices(points);
                MeshEditorWindow.this.theView.setMesh(theMesh);
                MeshEditorWindow.this.theView.updateImage();
                MeshEditorWindow.this.theView.repaint();
            }
        };
        xField.addTextListener(tl);
        yField.addTextListener(tl);
        zField.addTextListener(tl);
        if (s == null) {
            dlg = new ComponentsDialog((Window)this, title, new Component[]{xField, yField, zField}, new String[]{"X", "Y", "Z"});
        } else {
            weightSlider = new ValueSlider(0.0, 1.0, 100, weight);
            jointChoice = new Choice();
            jointChoice.add("None");
            jt = s.getJoints();
            i = 0;
            while (i < jt.length) {
                jointChoice.add(jt[i].name);
                ++i;
            }
            if (joint == -3) {
                jointChoice.add("");
            }
            jointChoice.select(0);
            i = 0;
            while (i < jt.length) {
                if (jt[i].id == joint) {
                    jointChoice.select(i + 1);
                }
                ++i;
            }
            if (joint == -3) {
                jointChoice.select(jt.length + 1);
            }
            dlg = new ComponentsDialog((Window)this, title, new Component[]{xField, yField, zField, jointChoice, weightSlider}, new String[]{"X", "Y", "Z", "IK Bone", "IK Weight"});
        }
        if (dlg.clickedOk()) {
            i = 0;
            while (i < selected.length) {
                if (selected[i] == 0) {
                    if (weightSlider != null && !Double.isNaN(weightSlider.getValue())) {
                        vert[i].ikWeight = weightSlider.getValue();
                    }
                    if (jointChoice != null) {
                        if (jointChoice.getSelectedIndex() == 0) {
                            vert[i].ikJoint = -1;
                        } else if (jointChoice.getSelectedIndex() <= jt.length) {
                            vert[i].ikJoint = jt[jointChoice.getSelectedIndex() - 1].id;
                        }
                    }
                }
                ++i;
            }
            this.setUndoRecord(new UndoRecord(this, false, 0, new Object[]{theMesh, oldMesh}));
        } else {
            theMesh.copyObject((Object3D)((Object)oldMesh));
            this.theView.setMesh(theMesh);
            this.theView.updateImage();
            this.theView.repaint();
        }
    }

    void transformPointsCommand() {
        Mesh theMesh = (Mesh)((Object)this.theView.getObject().object);
        int[] selected = this.theView.getSelectionDistance();
        MeshVertex[] vert = theMesh.getVertices();
        Vec3[] points = new Vec3[vert.length];
        double[] val = new double[3];
        CoordinateSystem coords = this.theView.thisObjectInScene.coords;
        int i = 0;
        while (i < selected.length && selected[i] == -1) {
            ++i;
        }
        if (i == selected.length) {
            return;
        }
        TransformPointsDialog dlg = new TransformPointsDialog(this);
        val = dlg.getValues();
        if (val == null) {
            return;
        }
        this.setUndoRecord(new UndoRecord(this, false, 0, new Object[]{theMesh, theMesh.duplicate()}));
        Mat4 m = Mat4.translation(val[0], val[1], val[2]);
        m = m.times(Mat4.xrotation(val[3] * Math.PI / 180.0));
        m = m.times(Mat4.yrotation(val[4] * Math.PI / 180.0));
        m = m.times(Mat4.zrotation(val[5] * Math.PI / 180.0));
        m = m.times(Mat4.scale(val[6], val[7], val[8]));
        if (this.theView.getUseWorldCoords() && coords != null) {
            m = coords.toLocal().times(m).times(coords.fromLocal());
        }
        if (dlg.useSelectionCenter()) {
            Vec3 center = new Vec3();
            int j = 0;
            i = 0;
            while (i < selected.length) {
                if (selected[i] == 0) {
                    center.add(vert[i].r);
                    ++j;
                }
                ++i;
            }
            center.scale(1.0 / (double)j);
            m = Mat4.translation(center.x, center.y, center.z).times(m).times(Mat4.translation(-center.x, -center.y, -center.z));
        }
        i = 0;
        while (i < selected.length) {
            points[i] = vert[i].r;
            if (selected[i] == 0) {
                points[i] = m.times(points[i]);
            }
            ++i;
        }
        theMesh.setVertices(points);
        this.theView.setMesh(theMesh);
        this.theView.updateImage();
        this.theView.repaint();
    }

    void randomizeCommand() {
        Mesh theMesh = (Mesh)((Object)this.theView.getObject().object);
        int[] selected = this.theView.getSelectionDistance();
        CoordinateSystem coords = this.theView.thisObjectInScene.coords;
        MeshVertex[] vert = theMesh.getVertices();
        Vec3[] points = new Vec3[vert.length];
        int i = 0;
        while (i < selected.length && selected[i] == -1) {
            ++i;
        }
        if (i == selected.length) {
            return;
        }
        ValueField xfield = new ValueField(0.0, 0);
        ValueField yfield = new ValueField(0.0, 0);
        ValueField zfield = new ValueField(0.0, 0);
        ComponentsDialog dlg = new ComponentsDialog((Window)this, "Maximum random displacement:", new Component[]{xfield, yfield, zfield}, new String[]{"X", "Y", "Z"});
        if (!dlg.clickedOk()) {
            return;
        }
        this.setUndoRecord(new UndoRecord(this, false, 0, new Object[]{theMesh, theMesh.duplicate()}));
        i = 0;
        while (i < selected.length) {
            points[i] = vert[i].r;
            if (selected[i] == 0) {
                if (this.theView.getUseWorldCoords() && coords != null) {
                    coords.fromLocal().transform(points[i]);
                }
                points[i].x += (1.0 - 2.0 * Math.random()) * xfield.getValue();
                points[i].y += (1.0 - 2.0 * Math.random()) * yfield.getValue();
                points[i].z += (1.0 - 2.0 * Math.random()) * zfield.getValue();
                if (this.theView.getUseWorldCoords() && coords != null) {
                    coords.toLocal().transform(points[i]);
                }
            }
            ++i;
        }
        theMesh.setVertices(points);
        this.theView.setMesh(theMesh);
        this.theView.updateImage();
        this.theView.repaint();
    }

    void centerCommand() {
        Mesh theMesh = (Mesh)((Object)this.theView.getObject().object);
        MeshVertex[] vert = theMesh.getVertices();
        Skeleton skeleton = theMesh.getSkeleton();
        Joint[] joint = skeleton.getJoints();
        CoordinateSystem coords = this.theView.thisObjectInScene.coords;
        Vec3 center = theMesh.getBounds().getCenter();
        Vec3[] points = new Vec3[vert.length];
        this.setUndoRecord(new UndoRecord(this, false, 0, new Object[]{theMesh, theMesh.duplicate()}));
        if (this.theView.getUseWorldCoords() && coords != null) {
            coords.fromLocal().transform(center);
            coords.toLocal().transformDirection(center);
        }
        int i = 0;
        while (i < vert.length) {
            points[i] = vert[i].r.minus(center);
            ++i;
        }
        theMesh.setVertices(points);
        int i2 = 0;
        while (i2 < joint.length) {
            joint[i2].coords.setOrigin(joint[i2].coords.getOrigin().minus(center));
            ++i2;
        }
        this.theView.setMesh(theMesh);
        this.theView.updateImage();
        this.theView.repaint();
    }

    void setTensionCommand() {
        ValueField distanceField = new ValueField((double)tensionDistance, 5);
        Choice tensionChoice = new Choice();
        tensionChoice.add("Very low");
        tensionChoice.add("Low");
        tensionChoice.add("Normal");
        tensionChoice.add("High");
        tensionChoice.add("Very High");
        tensionChoice.select(meshTension);
        ComponentsDialog dlg = new ComponentsDialog((Window)this, "Set tension parameters:", new Component[]{distanceField, tensionChoice}, new String[]{"Maximum Distance", "Tension"});
        if (!dlg.clickedOk()) {
            return;
        }
        tensionDistance = (int)distanceField.getValue();
        meshTension = tensionChoice.getSelectedIndex();
    }

    public static double getMeshTension() {
        return tensionArray[meshTension];
    }

    public static int getTensionDistance() {
        return tensionDistance;
    }

    public void setParametersCommand() {
        int k;
        int i;
        Mesh theMesh = (Mesh)((Object)this.theView.getObject().object);
        MeshVertex[] vert = theMesh.getVertices();
        ObjectInfo info = this.theView.getObject();
        TextureParameter[] param = info.texParam;
        int[] paramIndex = null;
        int[] selected = this.theView.getSelectionDistance();
        int j = 0;
        while (j < selected.length && selected[j] != 0) {
            ++j;
        }
        if (j == selected.length) {
            return;
        }
        if (param != null) {
            int num = 0;
            i = 0;
            while (i < param.length) {
                if (info.texParamPerVertex[i]) {
                    ++num;
                }
                ++i;
            }
            paramIndex = new int[num];
            i = 0;
            k = 0;
            while (k < param.length) {
                if (info.texParamPerVertex[k]) {
                    paramIndex[i++] = k;
                }
                ++k;
            }
        }
        if (paramIndex == null || paramIndex.length == 0) {
            new MessageDialog((Window)this, "This object's texture has no per-vertex parameters.");
            return;
        }
        double[] value = new double[paramIndex.length];
        i = 0;
        while (i < paramIndex.length) {
            value[i] = vert[j].param[paramIndex[i]];
            ++i;
        }
        while (j < selected.length) {
            i = 0;
            while (i < paramIndex.length) {
                if (selected[j] == 0 && vert[j].param[paramIndex[i]] != value[i]) {
                    value[i] = Double.NaN;
                }
                ++i;
            }
            ++j;
        }
        ValueField[] field = new ValueField[paramIndex.length];
        ValueSlider[] slider = new ValueSlider[paramIndex.length];
        Panel p = new Panel();
        Container coordsPanel = null;
        class ResetButton
        extends Button
        implements ActionListener {
            int xindex;
            int yindex;
            int zindex;
            ValueField xfield;
            ValueField yfield;
            ValueField zfield;
            private final /* synthetic */ int[] val$selected;
            private final /* synthetic */ MeshVertex[] val$vert;
            private final /* synthetic */ MeshEditorWindow this$0;

            public ResetButton(MeshEditorWindow this$0, int[] val$selected, MeshVertex[] val$vert) {
                super("Reset");
                this.this$0 = this$0;
                this.val$selected = val$selected;
                this.val$vert = val$vert;
                this.xindex = -1;
                this.yindex = -1;
                this.zindex = -1;
                this.addActionListener(this);
            }

            public void addParam(int index, int type, ValueField field) {
                if (type == 1) {
                    this.xindex = index;
                    this.xfield = field;
                } else if (type == 2) {
                    this.yindex = index;
                    this.yfield = field;
                } else if (type == 3) {
                    this.zindex = index;
                    this.zfield = field;
                }
            }

            public void actionPerformed(ActionEvent ev) {
                MessageDialog dl = new MessageDialog((Window)this.this$0, new String[]{"Reset texture mapping coordinates for the selected vertices", "to be equal to the current vertex positions?"}, new String[]{Translate.text("button.ok"), Translate.text("button.cancel")});
                if (dl.getChoice() == 1) {
                    return;
                }
                double xval = Double.NaN;
                double yval = Double.NaN;
                double zval = Double.NaN;
                int ind = 0;
                while (ind < this.val$selected.length) {
                    if (this.val$selected[ind] == 0) {
                        if (this.xindex > -1) {
                            this.val$vert[ind].param[this.xindex] = this.val$vert[ind].r.x;
                            if (Double.isNaN(xval)) {
                                xval = this.val$vert[ind].r.x;
                                this.xfield.setValue(xval);
                            } else if (xval != this.val$vert[ind].r.x) {
                                this.xfield.setValue(Double.NaN);
                            }
                        }
                        if (this.yindex > -1) {
                            this.val$vert[ind].param[this.yindex] = this.val$vert[ind].r.y;
                            if (Double.isNaN(yval)) {
                                yval = this.val$vert[ind].r.y;
                                this.yfield.setValue(yval);
                            } else if (yval != this.val$vert[ind].r.y) {
                                this.yfield.setValue(Double.NaN);
                            }
                        }
                        if (this.zindex > -1) {
                            this.val$vert[ind].param[this.zindex] = this.val$vert[ind].r.z;
                            if (Double.isNaN(zval)) {
                                zval = this.val$vert[ind].r.z;
                                this.zfield.setValue(zval);
                            } else if (zval != this.val$vert[ind].r.z) {
                                this.zfield.setValue(Double.NaN);
                            }
                        }
                    }
                    ++ind;
                }
            }
        }
        ResetButton reset = null;
        GridBagConstraints gc = new GridBagConstraints();
        Object lastOwner = null;
        int line = 0;
        p.setLayout(new GridBagLayout());
        if (info.object.getTexture() instanceof LayeredTexture) {
            LayeredMapping map = (LayeredMapping)info.object.getTextureMapping();
            Texture[] layer = map.getLayers();
            k = 0;
            while (k < layer.length) {
                coordsPanel = null;
                gc.gridx = 0;
                gc.gridy = line++;
                gc.anchor = 17;
                gc.gridwidth = 0;
                gc.insets.left = 0;
                p.add((Component)new Label("Layer " + (k + 1) + ": " + layer[k].getName()), gc);
                TextureParameter[] layerParam = map.getLayerParameters(k);
                boolean any = false;
                i = 0;
                while (i < paramIndex.length) {
                    final TextureParameter pm = param[paramIndex[i]];
                    int m = 0;
                    while (m < layerParam.length) {
                        if (layerParam[m].equals(pm)) break;
                        ++m;
                    }
                    if (m != layerParam.length) {
                        Component toAdd;
                        any = true;
                        if (pm.minVal == -1.7976931348623157E308 || pm.maxVal == Double.MAX_VALUE) {
                            toAdd = field[i] = new ValueField(value[i], 0, 5);
                            field[i].setValueChecker(new ValueChecker(){

                                public boolean isValid(double v) {
                                    return v >= pm.minVal && v <= pm.maxVal;
                                }
                            });
                        } else {
                            slider[i] = new ValueSlider(pm.minVal, pm.maxVal, 100, value[i]);
                            toAdd = slider[i];
                        }
                        if (pm.type == 0) {
                            gc.gridy = line++;
                            gc.gridx = 0;
                            gc.gridwidth = 1;
                            gc.insets.left = 10;
                            p.add((Component)new Label(pm.name), gc);
                            gc.gridx = 1;
                            gc.gridwidth = 0;
                            gc.insets.left = 5;
                            p.add(toAdd, gc);
                            if (coordsPanel != null) {
                                coordsPanel.add(reset);
                            }
                            coordsPanel = null;
                            reset = null;
                        } else if (coordsPanel == null) {
                            coordsPanel = new Panel();
                            gc.gridy = line++;
                            gc.gridx = 0;
                            gc.insets.left = 10;
                            p.add((Component)new Label("Texture Mapping Coordinates:"), gc);
                            gc.gridy = line++;
                            gc.gridx = 0;
                            gc.insets.left = 20;
                            p.add((Component)coordsPanel, gc);
                            coordsPanel.add(new Label(pm.name));
                            coordsPanel.add(toAdd);
                            reset = new ResetButton(this, selected, vert);
                            reset.addParam(paramIndex[i], pm.type, field[i]);
                        } else {
                            coordsPanel.add(new Label(pm.name));
                            coordsPanel.add(toAdd);
                            reset.addParam(paramIndex[i], pm.type, field[i]);
                        }
                    }
                    ++i;
                }
                if (coordsPanel != null) {
                    coordsPanel.add(reset);
                }
                if (!any) {
                    gc.gridy = line++;
                    gc.gridx = 0;
                    gc.gridwidth = 0;
                    gc.insets.left = 10;
                    p.add((Component)new Label("(No per-vertex parameters)"), gc);
                }
                ++k;
            }
        } else {
            gc.gridy = line++;
            gc.anchor = 17;
            gc.gridwidth = 0;
            p.add((Component)new Label("Texture: " + info.object.getTexture().getName()), gc);
            i = 0;
            while (i < paramIndex.length) {
                Component toAdd;
                final TextureParameter pm = param[paramIndex[i]];
                if (pm.minVal == -1.7976931348623157E308 || pm.maxVal == Double.MAX_VALUE) {
                    toAdd = field[i] = new ValueField(value[i], 0, 5);
                    field[i].setValueChecker(new ValueChecker(){

                        public boolean isValid(double v) {
                            return v >= pm.minVal && v <= pm.maxVal;
                        }
                    });
                } else {
                    slider[i] = new ValueSlider(pm.minVal, pm.maxVal, 100, value[i]);
                    toAdd = slider[i];
                }
                if (pm.type == 0) {
                    gc.gridy = line++;
                    gc.gridx = 0;
                    gc.gridwidth = 1;
                    gc.insets.left = 10;
                    p.add((Component)new Label(pm.name), gc);
                    gc.gridx = 1;
                    gc.gridwidth = 0;
                    gc.insets.left = 5;
                    p.add(toAdd, gc);
                    if (coordsPanel != null) {
                        coordsPanel.add(reset);
                    }
                    coordsPanel = null;
                    coordsPanel = null;
                } else if (coordsPanel == null) {
                    coordsPanel = new Panel();
                    gc.gridy = line++;
                    gc.gridx = 0;
                    gc.insets.left = 10;
                    p.add((Component)new Label("Texture Mapping Coordinates:"), gc);
                    gc.gridy = line++;
                    gc.gridx = 0;
                    gc.insets.left = 20;
                    p.add((Component)coordsPanel, gc);
                    coordsPanel.add(new Label(pm.name));
                    coordsPanel.add(toAdd);
                    reset = new ResetButton(this, selected, vert);
                    reset.addParam(paramIndex[i], pm.type, field[i]);
                } else {
                    coordsPanel.add(new Label(pm.name));
                    coordsPanel.add(toAdd);
                    reset.addParam(paramIndex[i], pm.type, field[i]);
                }
                ++i;
            }
            if (coordsPanel != null) {
                coordsPanel.add(reset);
            }
        }
        PanelDialog dlg = new PanelDialog((Window)this, "Texture parameters for selected points:", p);
        if (!dlg.clickedOk()) {
            return;
        }
        this.setUndoRecord(new UndoRecord(this, false, 0, new Object[]{theMesh, theMesh.duplicate()}));
        i = 0;
        while (i < selected.length) {
            if (selected[i] == 0) {
                j = 0;
                while (j < slider.length) {
                    if (field[j] != null && !Double.isNaN(field[j].getValue())) {
                        vert[i].param[paramIndex[j]] = field[j].getValue();
                    }
                    if (slider[j] != null && !Double.isNaN(slider[j].getValue())) {
                        vert[i].param[paramIndex[j]] = slider[j].getValue();
                    }
                    ++j;
                }
            }
            ++i;
        }
    }

    void setTemplateCommand() {
        FileDialog dlg = new FileDialog((Frame)this, "Select an image file", 0);
        dlg.show();
        if (dlg.getFile() == null) {
            return;
        }
        try {
            this.theView.setTemplateImage(new File(dlg.getDirectory(), dlg.getFile()));
        }
        catch (InterruptedException ex) {
            new MessageDialog((Window)this, "An error occurred while loading the image file.");
        }
        this.templateItem.setEnabled(true);
        this.templateItem.setLabel(Translate.text("menu.hideTemplate"));
        this.theView.setShowTemplate(true);
        this.updateImage();
    }

    public void deleteJointCommand() {
        Mesh theMesh = (Mesh)((Object)this.theView.getObject().object);
        Skeleton s = theMesh.getSkeleton();
        if (s == null) {
            return;
        }
        Joint j = s.getJoint(this.theView.getSelectedJoint());
        if (j == null) {
            return;
        }
        MessageDialog dlg = new MessageDialog((Window)this, "Delete the bone '" + j.name + (j.children.length == 0 ? "'?" : "' and all of its children?"), new String[]{"Yes", "No"});
        if (dlg.getChoice() == 1) {
            return;
        }
        this.setUndoRecord(new UndoRecord(this, false, 0, new Object[]{theMesh, theMesh.duplicate()}));
        s.deleteJoint(this.theView.getSelectedJoint());
        this.theView.setSelectedJoint(j.parent == null ? -1 : j.parent.id);
        this.theView.updateImage();
        this.updateMenus();
    }

    public void editJointCommand() {
        Mesh theMesh = (Mesh)((Object)this.theView.getObject().object);
        Skeleton s = theMesh.getSkeleton();
        if (s == null) {
            return;
        }
        Joint j = s.getJoint(this.theView.getSelectedJoint());
        if (j == null) {
            return;
        }
        new JointEditorDialog(this, this.theView, j.id);
        this.theView.updateImage();
        this.updateMenus();
    }

    public void bindSkeletonCommand() {
        Mesh theMesh = (Mesh)((Object)this.theView.getObject().object);
        Skeleton s = theMesh.getSkeleton();
        if (s == null) {
            return;
        }
        int[] selected = this.theView.getSelectionDistance();
        int j = 0;
        while (j < selected.length && selected[j] != 0) {
            ++j;
        }
        if (j == selected.length) {
            return;
        }
        ValueSlider blendSlider = new ValueSlider(0.0, 1.0, 100, 0.5);
        ComponentsDialog dlg = new ComponentsDialog((Window)this, "Bind selected points to skeleton?", new Component[]{blendSlider}, new String[]{"IK Weight Blending"});
        if (!dlg.clickedOk()) {
            return;
        }
        this.setUndoRecord(new UndoRecord(this, false, 0, new Object[]{theMesh, theMesh.duplicate()}));
        double blend = blendSlider.getValue();
        Joint[] joint = s.getJoints();
        Vec3[] pos = new Vec3[joint.length];
        Vec3[] axis = new Vec3[joint.length];
        int i = 0;
        while (i < joint.length) {
            pos[i] = joint[i].coords.getOrigin();
            if (joint[i].parent != null && joint[i].length.pos != 0.0) {
                axis[i] = joint[i].coords.getZDirection();
                axis[i] = axis[i].times(1.0 / axis[i].length());
            }
            ++i;
        }
        MeshVertex[] vert = theMesh.getVertices();
        double[] dist = new double[joint.length];
        i = 0;
        while (i < selected.length) {
            if (selected[i] == 0) {
                int nearest = -1;
                j = 0;
                while (j < joint.length) {
                    dist[j] = this.distToBone(vert[i].r, joint[j], axis[j]);
                    if (nearest == -1 || dist[j] < dist[nearest]) {
                        nearest = j;
                    }
                    ++j;
                }
                if (nearest != -1) {
                    int second = -1;
                    if (joint[nearest].parent != null) {
                        second = s.findJointIndex(joint[nearest].parent.id);
                    }
                    j = 0;
                    while (j < joint[nearest].children.length) {
                        int k = s.findJointIndex(joint[nearest].children[j].id);
                        if (k != -1 && (second == -1 || dist[k] < dist[second])) {
                            second = k;
                        }
                        ++j;
                    }
                    if (second == -1) {
                        vert[i].ikJoint = joint[nearest].id;
                        vert[i].ikWeight = 1.0;
                    } else if (joint[nearest].parent != null && joint[second].id == joint[nearest].parent.id) {
                        vert[i].ikJoint = joint[nearest].id;
                        double ratio = dist[nearest] / dist[second];
                        vert[i].ikWeight = ratio <= 1.0 - blend ? 1.0 : 0.5 + 0.5 * (1.0 - ratio) / blend;
                    } else {
                        double ratio = dist[nearest] / dist[second];
                        if (ratio <= 1.0 - blend) {
                            vert[i].ikJoint = joint[nearest].id;
                            vert[i].ikWeight = 1.0;
                        } else {
                            vert[i].ikJoint = joint[second].id;
                            vert[i].ikWeight = 0.5 - 0.5 * (1.0 - ratio) / blend;
                        }
                    }
                    vert[i].ikWeight = 0.001 * (double)Math.round(vert[i].ikWeight * 1000.0);
                }
            }
            ++i;
        }
    }

    private double distToBone(Vec3 v, Joint j, Vec3 axis) {
        Vec3 end = j.coords.getOrigin();
        if (axis == null) {
            return end.distance(v);
        }
        Vec3 base = j.parent.coords.getOrigin();
        Vec3 diff = v.minus(base);
        double dot = diff.dot(axis);
        if (dot < 0.0) {
            return base.distance(v);
        }
        if (dot > j.length.pos) {
            return end.distance(v);
        }
        diff.subtract(axis.times(dot));
        return diff.length();
    }

    void setGridCommand() {
        ValueField spaceField = new ValueField(this.theView.gridSpacing, 3);
        ValueField divField = new ValueField(this.theView.gridSubdivisions, 7);
        Checkbox showBox = new Checkbox("Show Grid", this.theView.showGrid);
        Checkbox snapBox = new Checkbox("Snap To Grid", this.theView.snapToGrid);
        ComponentsDialog dlg = new ComponentsDialog((Window)this, "Select grid options:", new Component[]{spaceField, divField, showBox, snapBox}, new String[]{"Grid Spacing", "Snap-To Subdivisions", "", ""});
        if (!dlg.clickedOk()) {
            return;
        }
        this.theView.gridSpacing = spaceField.getValue();
        this.theView.gridSubdivisions = (int)divField.getValue();
        this.theView.showGrid = showBox.getState();
        this.theView.snapToGrid = snapBox.getState();
        this.theView.setGrid(spaceField.getValue(), (int)divField.getValue(), showBox.getState(), snapBox.getState());
        this.updateImage();
    }

    public abstract void adjustDeltas(Vec3[] var1);

    public abstract void actionPerformed(ActionEvent var1);

    public abstract void updateMenus();

    public abstract void setTool(EditingTool var1);
}

