/*
 * Decompiled with CFR 0.152.
 */
package artofillusion;

import artofillusion.Callback;
import artofillusion.Camera;
import artofillusion.Scene;
import artofillusion.UndoRecord;
import artofillusion.ViewerCanvas;
import artofillusion.math.CoordinateSystem;
import artofillusion.math.Vec3;
import artofillusion.object.ObjectInfo;
import artofillusion.ui.ComponentsDialog;
import artofillusion.ui.EditingTool;
import artofillusion.ui.EditingWindow;
import artofillusion.ui.EventProcessor;
import artofillusion.ui.Translate;
import java.awt.Checkbox;
import java.awt.Component;
import java.awt.Image;
import java.awt.Point;
import java.awt.Window;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.util.Vector;

public class MoveObjectTool
extends EditingTool {
    static Image icon;
    static Image selectedIcon;
    Point clickPoint;
    Vec3[] objectPos;
    Vector toMove;
    ObjectInfo clickedObject;
    boolean dragged;
    boolean applyToChildren = true;
    EventProcessor process;

    public MoveObjectTool(EditingWindow fr) {
        super(fr);
        icon = this.loadImage("move.gif");
        selectedIcon = this.loadImage("selected/move.gif");
    }

    public void activate() {
        super.activate();
        this.theWindow.setHelpText(Translate.text("moveObjectTool.helpText"));
    }

    public int whichClicks() {
        return 1;
    }

    public Image getIcon() {
        return icon;
    }

    public Image getSelectedIcon() {
        return selectedIcon;
    }

    public void mousePressedOnObject(MouseEvent e, ViewerCanvas view, int obj) {
        Scene theScene = this.theWindow.getScene();
        this.toMove = new Vector();
        this.clickedObject = theScene.getObject(obj);
        int[] sel = this.applyToChildren ? theScene.getSelectionWithChildren() : theScene.getSelection();
        int i = 0;
        while (i < sel.length) {
            this.toMove.addElement(theScene.getObject(sel[i]));
            ++i;
        }
        this.objectPos = new Vec3[this.toMove.size()];
        i = 0;
        while (i < this.objectPos.length) {
            ObjectInfo info = (ObjectInfo)this.toMove.elementAt(i);
            this.objectPos[i] = info.coords.getOrigin();
            ++i;
        }
        this.clickPoint = e.getPoint();
        this.dragged = false;
        this.process = new EventProcessor();
    }

    public void mouseDragged(final MouseEvent e, final ViewerCanvas view) {
        Callback cb = new Callback(){

            public void execute() {
                CoordinateSystem c;
                int i;
                Scene theScene = MoveObjectTool.this.theWindow.getScene();
                Camera cam = view.getCamera();
                Point dragPoint = e.getPoint();
                if (!MoveObjectTool.this.dragged) {
                    UndoRecord undo = new UndoRecord(MoveObjectTool.this.theWindow, false);
                    MoveObjectTool.this.theWindow.setUndoRecord(undo);
                    i = 0;
                    while (i < MoveObjectTool.this.toMove.size()) {
                        ObjectInfo info = (ObjectInfo)MoveObjectTool.this.toMove.elementAt(i);
                        c = info.coords;
                        undo.addCommand(1, new Object[]{c, c.duplicate()});
                        ++i;
                    }
                    MoveObjectTool.this.dragged = true;
                }
                int dx = dragPoint.x - MoveObjectTool.this.clickPoint.x;
                int dy = dragPoint.y - MoveObjectTool.this.clickPoint.y;
                if (e.isShiftDown() && !e.isControlDown()) {
                    if (Math.abs(dx) > Math.abs(dy)) {
                        dy = 0;
                    } else {
                        dx = 0;
                    }
                }
                Vec3 v = e.isControlDown() ? cam.getCameraCoordinates().getZDirection().times((double)(-dy) * 0.01) : cam.findDragVector(MoveObjectTool.this.clickedObject.coords.getOrigin(), dx, dy);
                i = 0;
                while (i < MoveObjectTool.this.toMove.size()) {
                    ObjectInfo info = (ObjectInfo)MoveObjectTool.this.toMove.elementAt(i);
                    c = info.coords;
                    c.setOrigin(MoveObjectTool.this.objectPos[i].plus(v));
                    ++i;
                }
                MoveObjectTool.this.theWindow.updateImage();
                MoveObjectTool.this.theWindow.setHelpText(Translate.text("moveObjectTool.dragText", (double)Math.round(v.x * 100000.0) / 100000.0 + ", " + (double)Math.round(v.y * 100000.0) / 100000.0 + ", " + (double)Math.round(v.z * 100000.0) / 100000.0));
            }
        };
        this.process.addEvent(cb);
    }

    public void mouseReleased(MouseEvent e, ViewerCanvas view) {
        if (this.process != null) {
            this.process.stopProcessing();
        }
        this.process = null;
        int i = 0;
        while (i < this.toMove.size()) {
            ObjectInfo info = (ObjectInfo)this.toMove.elementAt(i);
            info.object.sceneChanged(info, this.theWindow.getScene());
            ++i;
        }
        this.theWindow.setHelpText(Translate.text("moveObjectTool.helpText"));
        this.toMove = null;
        this.objectPos = null;
        this.theWindow.updateImage();
    }

    public void keyPressed(KeyEvent e, ViewerCanvas view) {
        int dy;
        int dx;
        Scene theScene = this.theWindow.getScene();
        Camera cam = view.getCamera();
        int key = e.getKeyCode();
        if (key == 38) {
            dx = 0;
            dy = -1;
        } else if (key == 40) {
            dx = 0;
            dy = 1;
        } else if (key == 37) {
            dx = -1;
            dy = 0;
        } else if (key == 39) {
            dx = 1;
            dy = 0;
        } else {
            return;
        }
        int[] sel = this.applyToChildren ? theScene.getSelectionWithChildren() : theScene.getSelection();
        if (sel.length == 0) {
            return;
        }
        Vec3 v = e.isControlDown() ? cam.getCameraCoordinates().getZDirection().times((double)(-dy) * 0.01) : cam.findDragVector(theScene.getObject((int)sel[0]).coords.getOrigin(), dx, dy);
        UndoRecord undo = new UndoRecord(this.theWindow, false);
        this.theWindow.setUndoRecord(undo);
        this.toMove = new Vector();
        int i = 0;
        while (i < sel.length) {
            this.toMove.addElement(theScene.getObject(sel[i]));
            ++i;
        }
        i = 0;
        while (i < this.toMove.size()) {
            CoordinateSystem c = ((ObjectInfo)this.toMove.elementAt((int)i)).coords;
            undo.addCommand(1, new Object[]{c, c.duplicate()});
            c.setOrigin(c.getOrigin().plus(v));
            ++i;
        }
        i = 0;
        while (i < this.toMove.size()) {
            ObjectInfo info = (ObjectInfo)this.toMove.elementAt(i);
            info.object.sceneChanged(info, this.theWindow.getScene());
            ++i;
        }
        this.theWindow.updateImage();
    }

    public void iconDoubleClicked() {
        Checkbox childrenBox = new Checkbox("Apply to unselected children of selected objects", this.applyToChildren);
        ComponentsDialog dlg = new ComponentsDialog((Window)this.theFrame, "Options for Move Tool:", new Component[]{childrenBox}, new String[]{""});
        if (!dlg.clickedOk()) {
            return;
        }
        this.applyToChildren = childrenBox.getState();
    }
}

