/*
 * Decompiled with CFR 0.152.
 */
package artofillusion;

import artofillusion.Camera;
import artofillusion.UndoRecord;
import artofillusion.ViewerCanvas;
import artofillusion.math.CoordinateSystem;
import artofillusion.math.Mat4;
import artofillusion.math.Vec3;
import artofillusion.object.ObjectInfo;
import artofillusion.ui.EditingTool;
import artofillusion.ui.EditingWindow;
import artofillusion.ui.Translate;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Point;
import java.awt.event.MouseEvent;

public class MoveViewTool
extends EditingTool {
    private static Image icon;
    private static Image selectedIcon;
    private Point clickPoint;
    private Mat4 viewToWorld;
    private Vec3 clickPos;
    private boolean controlDown;
    private CoordinateSystem oldCoords;
    private double oldScale;

    public MoveViewTool(EditingWindow fr) {
        super(fr);
        icon = this.loadImage("moveView.gif");
        selectedIcon = this.loadImage("selected/moveView.gif");
    }

    public void activate() {
        super.activate();
        this.theWindow.setHelpText(Translate.text("moveViewTool.helpText"));
    }

    public int whichClicks() {
        return 0;
    }

    public boolean hilightSelection() {
        return true;
    }

    public Image getIcon() {
        return icon;
    }

    public Image getSelectedIcon() {
        return selectedIcon;
    }

    public void mousePressed(MouseEvent e, ViewerCanvas view) {
        Camera cam = view.getCamera();
        this.controlDown = e.isControlDown();
        this.clickPoint = e.getPoint();
        this.clickPos = cam.convertScreenToWorld(this.clickPoint, cam.getDistToScreen());
        this.oldCoords = cam.getCameraCoordinates().duplicate();
        this.viewToWorld = cam.getViewToWorld();
        this.oldScale = view.getScale();
    }

    public void mouseDragged(MouseEvent e, ViewerCanvas view) {
        Vec3 move;
        Camera cam = view.getCamera();
        Graphics g = view.getGraphics();
        Point dragPoint = e.getPoint();
        CoordinateSystem c = this.oldCoords.duplicate();
        int dx = dragPoint.x - this.clickPoint.x;
        int dy = dragPoint.y - this.clickPoint.y;
        cam.setCameraCoordinates(c);
        if (this.controlDown) {
            if (view.isPerspective()) {
                move = cam.findDragVector(this.clickPos, 0, dy);
                double dist = dy > 0 ? -move.length() : move.length();
                move = this.viewToWorld.timesDirection(Vec3.vz()).times(dist * 2.0);
            } else {
                if ((double)dy < 0.0) {
                    view.setScale(this.oldScale / (1.0 - (double)dy * 0.01));
                } else {
                    view.setScale(this.oldScale * (1.0 + (double)dy * 0.01));
                }
                move = new Vec3();
            }
        } else {
            if (e.isShiftDown()) {
                if (Math.abs(dx) > Math.abs(dy)) {
                    dy = 0;
                } else {
                    dx = 0;
                }
            }
            move = cam.findDragVector(this.clickPos, dx, dy);
        }
        Mat4 m = Mat4.translation(-move.x, -move.y, -move.z);
        c.transformOrigin(m);
        cam.setCameraCoordinates(c);
        view.updateImage();
        view.drawImage(g);
        g.dispose();
    }

    public void mouseReleased(MouseEvent e, ViewerCanvas view) {
        this.mouseDragged(e, view);
        if (this.theWindow != null) {
            ObjectInfo bound = view.getBoundCamera();
            if (bound != null) {
                UndoRecord undo = new UndoRecord(this.theWindow, false, 1, new Object[]{bound.coords, this.oldCoords});
                this.moveChildren(bound, bound.coords.fromLocal().times(this.oldCoords.toLocal()), undo);
                this.theWindow.setUndoRecord(undo);
            }
            this.theWindow.updateImage();
        }
    }

    private void moveChildren(ObjectInfo parent, Mat4 transform, UndoRecord undo) {
        int i = 0;
        while (i < parent.children.length) {
            CoordinateSystem coords = parent.children[i].coords;
            CoordinateSystem oldCoords = coords.duplicate();
            coords.transformCoordinates(transform);
            undo.addCommand(1, new Object[]{coords, oldCoords});
            this.moveChildren(parent.children[i], transform, undo);
            ++i;
        }
    }
}

