/*
 * Decompiled with CFR 0.152.
 */
package artofillusion;

import artofillusion.ListChangeListener;
import artofillusion.MaterialMappingDialog;
import artofillusion.MaterialPreviewer;
import artofillusion.MaterialsDialog;
import artofillusion.ModellingApp;
import artofillusion.Scene;
import artofillusion.material.Material;
import artofillusion.material.MaterialMapping;
import artofillusion.material.UniformMaterial;
import artofillusion.object.Object3D;
import artofillusion.object.ObjectInfo;
import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Label;
import java.awt.List;
import java.awt.Panel;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;

public class ObjectMaterialDialog
extends Dialog
implements ActionListener,
ItemListener,
ListChangeListener {
    Frame fr;
    Scene sc;
    ObjectInfo[] obj;
    Object3D firstObj;
    List matList;
    Button mapButton;
    MaterialPreviewer preview;
    Material oldMaterial;
    MaterialMapping oldMapping;

    public ObjectMaterialDialog(Frame parent, Scene theScene, ObjectInfo[] objects) {
        super(parent, "Object Material", false);
        this.fr = parent;
        this.sc = theScene;
        this.obj = objects;
        this.firstObj = this.obj[0].object;
        this.oldMaterial = this.firstObj.getMaterial();
        this.oldMapping = this.oldMaterial == null ? null : this.firstObj.getMaterialMapping().duplicate();
        GridBagConstraints gc = new GridBagConstraints();
        this.setLayout(new GridBagLayout());
        gc.gridwidth = 2;
        if (this.obj.length == 1) {
            this.add((Component)new Label("Choose material for '" + this.obj[0].name + "':"), gc);
        } else {
            this.add((Component)new Label("Choose material for selected objects:"), gc);
        }
        gc.gridwidth = 1;
        gc.gridx = 0;
        gc.fill = 1;
        gc.weighty = 1.0;
        Panel listPanel = new Panel();
        this.add((Component)listPanel, gc);
        listPanel.setLayout(new BorderLayout());
        this.matList = new List();
        listPanel.add((Component)this.matList, "Center");
        this.buildList();
        this.matList.addItemListener(this);
        this.matList.addActionListener(this);
        Panel p = new Panel();
        listPanel.add((Component)p, "South");
        Button b = new Button("New Material...");
        p.add(b);
        b.setActionCommand("new");
        b.addActionListener(this);
        b = new Button("Materials...");
        p.add(b);
        b.setActionCommand("materials");
        b.addActionListener(this);
        gc.fill = 0;
        gc.weighty = 0.0;
        gc.gridx = 1;
        this.preview = new MaterialPreviewer(this.firstObj.getTexture(), this.oldMaterial, 160, 160);
        this.add((Component)this.preview, gc);
        this.preview.setTexture(this.firstObj.getTexture(), this.firstObj.getTextureMapping());
        this.preview.setMaterialMapping(this.oldMapping);
        this.preview.render();
        p = new Panel();
        gc.gridwidth = 2;
        gc.gridheight = 1;
        gc.gridx = 0;
        this.add((Component)p, gc);
        this.mapButton = new Button("Edit Mapping");
        p.add(this.mapButton);
        this.mapButton.setActionCommand("map");
        this.mapButton.addActionListener(this);
        this.mapButton.setEnabled(!(this.oldMaterial instanceof UniformMaterial) && this.oldMaterial != null);
        b = new Button("Ok");
        p.add(b);
        b.setActionCommand("ok");
        b.addActionListener(this);
        b = new Button("Cancel");
        p.add(b);
        b.setActionCommand("cancel");
        b.addActionListener(this);
        this.pack();
        this.setResizable(false);
        ModellingApp.centerWindow(this);
        this.sc.addMaterialListener(this);
        this.show();
    }

    public void dispose() {
        this.sc.removeMaterialListener(this);
        super.dispose();
    }

    void buildList() {
        this.matList.removeAll();
        this.matList.add("None");
        this.matList.select(0);
        int i = 0;
        while (i < this.sc.getNumMaterials()) {
            this.matList.add(this.sc.getMaterial(i).getName());
            if (this.firstObj.getMaterial() == this.sc.getMaterial(i)) {
                this.matList.select(i + 1);
            }
            ++i;
        }
    }

    public void actionPerformed(ActionEvent e) {
        String command = e.getActionCommand();
        String[] finalStrings = new String[9];
        if (e.getSource() == this.matList) {
            int which = this.matList.getSelectedIndex() - 1;
            if (which > -1) {
                Material mat = this.sc.getMaterial(which);
                mat.edit(this.fr, this.sc);
                this.preview.render();
            }
            return;
        }
        if (command.equals("cancel")) {
            this.firstObj.setMaterial(this.oldMaterial);
            this.firstObj.setMaterialMapping(this.oldMapping);
        } else {
            if (command.equals("map")) {
                new MaterialMappingDialog(this.fr, this.firstObj);
                this.preview.setMaterialMapping(this.firstObj.getMaterialMapping());
                this.preview.render();
                return;
            }
            if (command.equals("new")) {
                MaterialsDialog.showNewMaterialWindow(this, this.sc);
                return;
            }
            if (command.equals("materials")) {
                this.sc.showMaterialsDialog(this.fr);
                this.buildList();
                this.preview.render();
                return;
            }
            int i = 1;
            while (i < this.obj.length) {
                this.obj[i].object.setMaterial(this.firstObj.getMaterial());
                this.obj[i].object.setMaterialMapping(this.firstObj.getMaterialMapping().duplicate());
                ++i;
            }
        }
        this.dispose();
    }

    public void itemStateChanged(ItemEvent e) {
        if (this.matList.getSelectedIndex() < 0) {
            this.matList.select(0);
        }
        if (this.matList.getSelectedIndex() == 0) {
            this.mapButton.setEnabled(false);
            this.firstObj.setMaterial(null);
            this.firstObj.setMaterialMapping(null);
            this.preview.setMaterial(null);
            this.preview.setMaterialMapping(null);
            this.preview.render();
            return;
        }
        Material mat = this.sc.getMaterial(this.matList.getSelectedIndex() - 1);
        this.firstObj.setMaterial(mat);
        if (mat == this.oldMaterial) {
            this.firstObj.setMaterialMapping(this.oldMapping.duplicate());
        } else {
            this.firstObj.setMaterialMapping(mat.getDefaultMapping());
        }
        this.mapButton.setEnabled(!(mat instanceof UniformMaterial));
        this.preview.setMaterial(mat);
        this.preview.setMaterialMapping(this.firstObj.getMaterialMapping());
        this.preview.render();
    }

    public void itemAdded(int index, Object obj) {
        Material mat = (Material)obj;
        this.matList.add(mat.getName(), index + 1);
    }

    public void itemRemoved(int index, Object obj) {
        Material mat = (Material)obj;
        this.matList.remove(index + 1);
        if (this.firstObj.getMaterial() == mat) {
            this.firstObj.setMaterial(null);
            this.firstObj.setMaterialMapping(null);
            this.preview.setMaterial(this.firstObj.getMaterial());
            this.preview.setMaterialMapping(this.firstObj.getMaterialMapping());
            this.preview.render();
            this.mapButton.setEnabled(false);
        }
    }

    public void itemChanged(int index, Object obj) {
        Material mat = (Material)obj;
        this.matList.replaceItem(mat.getName(), index + 1);
    }
}

