/*
 * Decompiled with CFR 0.152.
 */
package artofillusion;

import artofillusion.MoveViewTool;
import artofillusion.ObjectViewer;
import artofillusion.RenderingMesh;
import artofillusion.RotateViewTool;
import artofillusion.math.RGBColor;
import artofillusion.math.Vec3;
import artofillusion.object.Object3D;
import artofillusion.object.ObjectInfo;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Panel;
import java.awt.event.MouseEvent;

public class ObjectPreviewCanvas
extends ObjectViewer {
    private boolean sizeSet;
    static final RGBColor surfaceRGB = new RGBColor(0.8f, 0.8f, 1.0f);
    static final Color surfaceColor = new Color(0.8f, 0.8f, 1.0f);

    public ObjectPreviewCanvas(ObjectInfo obj) {
        this(obj, new Panel());
    }

    public ObjectPreviewCanvas(ObjectInfo obj, Panel p) {
        super(obj, p);
        this.setTool(new RotateViewTool(null));
        this.setMetaTool(new MoveViewTool(null));
        int mode = ObjectViewer.lastRenderMode;
        this.setRenderMode(2);
        ObjectViewer.lastRenderMode = mode;
        this.hideBackfaces = false;
    }

    protected void drawObject(Graphics g) {
        if (this.theObject == null) {
            return;
        }
        if (!this.sizeSet) {
            Dimension dim = this.getSize();
            Vec3 objSize = this.theObject.getBounds().getSize();
            double scale = 0.8 * (double)Math.min(dim.width, dim.height) / Math.max(Math.max(objSize.x, objSize.y), objSize.z);
            this.setScale(scale);
            this.theCamera.setScreenParams(0.0, scale, dim.width, dim.height);
            this.sizeSet = true;
        }
        if (this.renderMode == 0) {
            g.setColor(surfaceColor);
            Object3D.draw(g, this.theCamera, this.objInfo.getWireframePreview(), this.objInfo.getBounds());
        } else if (this.renderMode == 3) {
            RenderingMesh mesh = this.objInfo.getPreviewMesh();
            if (mesh != null) {
                this.renderFlatTransparent(mesh, this.theCamera, this.theCamera.getViewToWorld().timesDirection(Vec3.vz()), surfaceRGB);
            }
        } else if (this.renderMode == 1) {
            RenderingMesh mesh = this.objInfo.getPreviewMesh();
            if (mesh != null) {
                this.renderFlat(mesh, this.theCamera, this.theCamera.getViewToWorld().timesDirection(Vec3.vz()), this.theObject.isClosed(), surfaceRGB);
            }
        } else {
            RenderingMesh mesh = this.objInfo.getPreviewMesh();
            if (mesh != null) {
                this.renderSmooth(mesh, this.theCamera, this.theCamera.getViewToWorld().timesDirection(Vec3.vz()), this.theObject.isClosed(), surfaceRGB);
            }
        }
    }

    public void mousePressed(MouseEvent e) {
        this.requestFocus();
        this.sentClick = true;
        this.activeTool = this.currentTool;
        if (this.metaTool != null && e.isMetaDown()) {
            this.activeTool = this.metaTool;
        }
        this.activeTool.mousePressed(e, this);
    }

    public void mouseReleased(MouseEvent e) {
        if (this.sentClick) {
            this.activeTool.mouseReleased(e, this);
        }
    }
}

