/*
 * Decompiled with CFR 0.152.
 */
package artofillusion;

import artofillusion.ApplicationPreferences;
import artofillusion.ModellingApp;
import artofillusion.Renderer;
import artofillusion.ui.ComponentsDialog;
import artofillusion.ui.MessageDialog;
import artofillusion.ui.Translate;
import artofillusion.ui.ValueField;
import java.awt.Choice;
import java.awt.Component;
import java.awt.Frame;
import java.awt.Window;
import java.util.Locale;

public class PreferencesWindow {
    public PreferencesWindow(Frame parent) {
        ApplicationPreferences prefs = ModellingApp.getPreferences();
        Choice defaultRendChoice = this.getRendererChoice(prefs.getDefaultRenderer());
        Choice objectRendChoice = this.getRendererChoice(prefs.getObjectPreviewRenderer());
        Choice texRendChoice = this.getRendererChoice(prefs.getTexturePreviewRenderer());
        Choice displayChoice = new Choice();
        Choice localeChoice = new Choice();
        ValueField interactiveTolField = new ValueField(prefs.getInteractiveSurfaceError(), 3);
        displayChoice.add(Translate.text("menu.wireframeDisplay"));
        displayChoice.add(Translate.text("menu.shadedDisplay"));
        displayChoice.add(Translate.text("menu.smoothDisplay"));
        displayChoice.select(prefs.getDefaultDisplayMode());
        Locale[] languages = Translate.getAvailableLocales();
        int i = 0;
        while (i < languages.length) {
            localeChoice.add(languages[i].getDisplayName(prefs.getLocale()));
            if (prefs.getLocale().equals(languages[i])) {
                localeChoice.select(i);
            }
            ++i;
        }
        ComponentsDialog dlg = new ComponentsDialog((Window)parent, "Art of Illusion Preferences", new Component[]{defaultRendChoice, objectRendChoice, texRendChoice, displayChoice, interactiveTolField, localeChoice}, new String[]{"Default Renderer", "Object Preview Renderer", "Texture Preview Renderer", "Default Display Mode", "Interactive Surface Error", "Language"});
        if (!dlg.clickedOk()) {
            return;
        }
        Renderer[] renderers = ModellingApp.getRenderers();
        if (renderers.length > 0) {
            prefs.setDefaultRenderer(renderers[defaultRendChoice.getSelectedIndex()]);
            prefs.setObjectPreviewRenderer(renderers[objectRendChoice.getSelectedIndex()]);
            prefs.setTexturePreviewRenderer(renderers[texRendChoice.getSelectedIndex()]);
        }
        prefs.setDefaultDisplayMode(displayChoice.getSelectedIndex());
        prefs.setInteractiveSurfaceError(interactiveTolField.getValue());
        if (!prefs.getLocale().equals(languages[localeChoice.getSelectedIndex()])) {
            new MessageDialog((Window)parent, "The new language setting will apply to new windows, but will not affect any windows which are currently open.");
        }
        prefs.setLocale(languages[localeChoice.getSelectedIndex()]);
        prefs.savePreferences();
    }

    private Choice getRendererChoice(Renderer selected) {
        Renderer[] renderers = ModellingApp.getRenderers();
        Choice c = new Choice();
        int i = 0;
        while (i < renderers.length) {
            c.add(renderers[i].getName());
            ++i;
        }
        if (selected != null) {
            c.select(selected.getName());
        }
        return c;
    }
}

