/*
 * Decompiled with CFR 0.152.
 */
package artofillusion;

import artofillusion.Camera;
import artofillusion.ModellingApp;
import artofillusion.Renderer;
import artofillusion.RenderingDialog;
import artofillusion.Scene;
import artofillusion.image.ImageSaver;
import artofillusion.object.ObjectInfo;
import artofillusion.object.SceneCamera;
import artofillusion.ui.MessageDialog;
import artofillusion.ui.ValueField;
import java.awt.Button;
import java.awt.Checkbox;
import java.awt.CheckboxGroup;
import java.awt.Choice;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Label;
import java.awt.Panel;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Vector;

public class RenderSetupDialog
extends Dialog
implements ActionListener,
ItemListener {
    Renderer[] renderers;
    ObjectInfo[] cameras;
    Scene theScene;
    Choice rendChoice;
    Choice camChoice;
    Checkbox singleBox;
    Checkbox movieBox;
    CheckboxGroup movieGroup;
    ValueField widthField;
    ValueField heightField;
    ValueField startField;
    ValueField endField;
    ValueField fpsField;
    ValueField subimagesField;
    Panel configPanel;
    static Renderer currentRenderer;
    static int currentCamera;
    static int width;
    static int height;
    static int fps;
    static int subimages;
    static double startTime;
    static double endTime;
    static boolean movie;

    public RenderSetupDialog(Frame parent, Scene theScene) {
        super(parent, "Rendering Options", true);
        ObjectInfo obj;
        this.theScene = theScene;
        this.renderers = ModellingApp.getRenderers();
        if (currentRenderer == null) {
            currentRenderer = ModellingApp.getPreferences().getDefaultRenderer();
        }
        int i = 0;
        int count = 0;
        while (i < theScene.getNumObjects()) {
            obj = theScene.getObject(i);
            if (obj.object instanceof SceneCamera) {
                ++count;
            }
            ++i;
        }
        if (count == 0) {
            new MessageDialog((Window)((Frame)this.getParent()), "A scene must contain a camera to be rendered.");
            return;
        }
        if (count <= currentCamera) {
            currentCamera = 0;
        }
        this.cameras = new ObjectInfo[count];
        i = 0;
        count = 0;
        while (i < theScene.getNumObjects()) {
            obj = theScene.getObject(i);
            if (obj.object instanceof SceneCamera) {
                this.cameras[count++] = obj;
            }
            ++i;
        }
        this.layoutDialog();
        this.pack();
        this.setResizable(false);
        ModellingApp.centerWindow(this);
        this.widthField.requestFocus();
        this.show();
    }

    void layoutDialog() {
        Panel p = new Panel();
        GridBagConstraints c = new GridBagConstraints();
        p.setLayout(new GridBagLayout());
        c.gridx = 0;
        c.anchor = 13;
        c.fill = 2;
        c.insets = new Insets(0, 0, 0, 5);
        p.add((Component)new Label("Width:"), c);
        p.add((Component)new Label("Height:"), c);
        p.add((Component)new Label("Render:"), c);
        p.add((Component)new Label("Start Time:"), c);
        p.add((Component)new Label("End Time:"), c);
        c.gridx = 1;
        this.widthField = new ValueField((double)width, 7);
        p.add((Component)this.widthField, c);
        this.heightField = new ValueField((double)height, 7);
        p.add((Component)this.heightField, c);
        this.widthField.addActionListener(this);
        this.heightField.addActionListener(this);
        this.movieGroup = new CheckboxGroup();
        this.singleBox = new Checkbox("Single Image", !movie, this.movieGroup);
        p.add((Component)this.singleBox, c);
        this.singleBox.addItemListener(this);
        this.startField = new ValueField(startTime, 0);
        p.add((Component)this.startField, c);
        this.endField = new ValueField(endTime, 0);
        p.add((Component)this.endField, c);
        c.gridx = 2;
        p.add((Component)new Label("Renderer:"), c);
        p.add((Component)new Label("Camera:"), c);
        this.movieBox = new Checkbox("Movie", movie, this.movieGroup);
        p.add((Component)this.movieBox, c);
        this.movieBox.addItemListener(this);
        p.add((Component)new Label("Frames/Sec:"), c);
        p.add((Component)new Label("Images/Frame:"), c);
        c.gridx = 3;
        this.rendChoice = new Choice();
        p.add((Component)this.rendChoice, c);
        int i = 0;
        while (i < this.renderers.length) {
            this.rendChoice.add(this.renderers[i].getName());
            ++i;
        }
        this.rendChoice.select(currentRenderer.getName());
        this.rendChoice.addItemListener(this);
        this.camChoice = new Choice();
        p.add((Component)this.camChoice, c);
        i = 0;
        while (i < this.cameras.length) {
            this.camChoice.add(this.cameras[i].name);
            ++i;
        }
        this.camChoice.select(currentCamera);
        p.add((Component)new Label(), c);
        this.fpsField = new ValueField(fps, 7);
        p.add((Component)this.fpsField, c);
        this.subimagesField = new ValueField(subimages, 7);
        p.add((Component)this.subimagesField, c);
        this.enableMovieComponents();
        this.add((Component)p, "North");
        this.add((Component)currentRenderer.getConfigPanel(), "Center");
        p = new Panel();
        Button b = new Button("Render");
        p.add(b);
        b.setActionCommand("render");
        b.addActionListener(this);
        b = new Button("Cancel");
        p.add(b);
        b.setActionCommand("cancel");
        b.addActionListener(this);
        this.add((Component)p, "South");
        this.enableMovieComponents();
    }

    public void actionPerformed(ActionEvent e) {
        String command = e.getActionCommand();
        if (command.equals("cancel")) {
            this.dispose();
            this.remove(currentRenderer.getConfigPanel());
        } else {
            width = (int)this.widthField.getValue();
            height = (int)this.heightField.getValue();
            movie = this.movieBox.getState();
            startTime = this.startField.getValue();
            endTime = this.endField.getValue();
            fps = (int)this.fpsField.getValue();
            subimages = (int)this.subimagesField.getValue();
            currentCamera = this.camChoice.getSelectedIndex();
            if (currentRenderer.recordConfiguration()) {
                Camera cam = new Camera();
                SceneCamera sc = (SceneCamera)this.cameras[RenderSetupDialog.currentCamera].object;
                cam.setCameraCoordinates(this.cameras[RenderSetupDialog.currentCamera].coords.duplicate());
                cam.setSize(width, height);
                cam.setDistToScreen((double)height / 200.0 / Math.tan(sc.getFieldOfView() * Math.PI / 360.0));
                if (movie) {
                    ImageSaver saver = new ImageSaver((Frame)this.getParent(), width, height, fps);
                    if (!saver.clickedOk()) {
                        return;
                    }
                    this.dispose();
                    this.remove(currentRenderer.getConfigPanel());
                    new RenderingDialog((Frame)this.getParent(), currentRenderer, this.theScene, cam, this.cameras[currentCamera], startTime, endTime, fps, subimages, saver);
                } else {
                    this.dispose();
                    this.remove(currentRenderer.getConfigPanel());
                    new RenderingDialog((Frame)this.getParent(), currentRenderer, this.theScene, cam, sc.getDepthOfField(), sc.getFocalDistance());
                }
            }
        }
    }

    public static void renderImmediately(Frame parent, Scene theScene) {
        Vector<ObjectInfo> cameras = new Vector<ObjectInfo>();
        int i = 0;
        while (i < theScene.getNumObjects()) {
            if (theScene.getObject((int)i).object instanceof SceneCamera) {
                cameras.addElement(theScene.getObject(i));
            }
            ++i;
        }
        if (cameras.size() == 0) {
            new MessageDialog((Window)parent, "A scene must contain a camera to be rendered.");
            return;
        }
        if (cameras.size() <= currentCamera) {
            currentCamera = 0;
        }
        if (currentRenderer == null) {
            currentRenderer = ModellingApp.getPreferences().getDefaultRenderer();
        }
        currentRenderer.getConfigPanel();
        currentRenderer.recordConfiguration();
        Camera cam = new Camera();
        ObjectInfo cameraInfo = (ObjectInfo)cameras.elementAt(currentCamera);
        SceneCamera sc = (SceneCamera)cameraInfo.object;
        cam.setCameraCoordinates(cameraInfo.coords.duplicate());
        cam.setSize(width, height);
        cam.setDistToScreen((double)height / 200.0 / Math.tan(sc.getFieldOfView() * Math.PI / 360.0));
        new RenderingDialog(parent, currentRenderer, theScene, cam, sc.getDepthOfField(), sc.getFocalDistance());
    }

    public void itemStateChanged(ItemEvent e) {
        Object src = e.getSource();
        if (src == this.singleBox || src == this.movieBox) {
            this.enableMovieComponents();
            return;
        }
        this.remove(currentRenderer.getConfigPanel());
        currentRenderer = this.renderers[this.rendChoice.getSelectedIndex()];
        this.add((Component)currentRenderer.getConfigPanel(), "Center");
        this.pack();
    }

    private void enableMovieComponents() {
        boolean enable = this.movieBox.getState();
        this.startField.setEnabled(enable);
        this.endField.setEnabled(enable);
        this.fpsField.setEnabled(enable);
        this.subimagesField.setEnabled(enable);
    }

    static {
        currentCamera = 0;
        width = 400;
        height = 300;
        fps = 30;
        subimages = 1;
        startTime = 0.0;
        endTime = 1.0;
    }
}

