/*
 * Decompiled with CFR 0.152.
 */
package artofillusion;

import artofillusion.Camera;
import artofillusion.Scene;
import artofillusion.UndoRecord;
import artofillusion.ViewerCanvas;
import artofillusion.math.BoundingBox;
import artofillusion.math.CoordinateSystem;
import artofillusion.math.Mat4;
import artofillusion.math.Vec3;
import artofillusion.object.ObjectInfo;
import artofillusion.ui.EditingTool;
import artofillusion.ui.EditingWindow;
import artofillusion.ui.Translate;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Point;
import java.awt.event.MouseEvent;

public class RotateViewTool
extends EditingTool {
    private static final double DRAG_SCALE = 0.01;
    private static Image icon;
    private static Image selectedIcon;
    private Point clickPoint;
    private Mat4 viewToWorld;
    private boolean controlDown;
    private boolean useSelectionCenter;
    private CoordinateSystem oldCoords;
    private Vec3 rotationCenter;

    public RotateViewTool(EditingWindow fr) {
        super(fr);
        if (icon == null) {
            icon = this.loadImage("rotateView.gif");
            selectedIcon = this.loadImage("selected/rotateView.gif");
        }
    }

    public void activate() {
        super.activate();
        this.theWindow.setHelpText(Translate.text("rotateViewTool.helpText"));
    }

    public int whichClicks() {
        return 0;
    }

    public boolean hilightSelection() {
        return true;
    }

    public Image getIcon() {
        return icon;
    }

    public Image getSelectedIcon() {
        return selectedIcon;
    }

    public void setUseSelectionCenter(boolean use) {
        this.useSelectionCenter = use;
    }

    public void mousePressed(MouseEvent e, ViewerCanvas view) {
        Camera cam = view.getCamera();
        this.controlDown = e.isControlDown();
        this.clickPoint = e.getPoint();
        this.oldCoords = cam.getCameraCoordinates().duplicate();
        this.viewToWorld = cam.getViewToWorld();
        if (!this.useSelectionCenter || this.theWindow == null || this.theWindow.getScene() == null) {
            this.rotationCenter = new Vec3();
            return;
        }
        Scene scene = this.theWindow.getScene();
        int[] selection = scene.getSelection();
        if (selection.length == 0) {
            this.rotationCenter = new Vec3();
            return;
        }
        BoundingBox bounds = null;
        int i = 0;
        while (i < selection.length) {
            ObjectInfo info = scene.getObject(selection[i]);
            BoundingBox objBounds = info.getBounds().transformAndOutset(info.coords.fromLocal());
            bounds = i == 0 ? objBounds : bounds.merge(objBounds);
            ++i;
        }
        this.rotationCenter = bounds.getCenter();
    }

    public void mouseDragged(MouseEvent e, ViewerCanvas view) {
        double angle;
        Vec3 axis;
        Camera cam = view.getCamera();
        Point dragPoint = e.getPoint();
        CoordinateSystem c = this.oldCoords.duplicate();
        int dx = dragPoint.x - this.clickPoint.x;
        int dy = dragPoint.y - this.clickPoint.y;
        if (this.controlDown) {
            axis = this.viewToWorld.timesDirection(Vec3.vz());
            angle = (double)dx * 0.01;
        } else if (e.isShiftDown()) {
            if (Math.abs(dx) > Math.abs(dy)) {
                axis = this.viewToWorld.timesDirection(Vec3.vy());
                angle = (double)dx * 0.01;
            } else {
                axis = this.viewToWorld.timesDirection(Vec3.vx());
                angle = (double)(-dy) * 0.01;
            }
        } else {
            axis = new Vec3((double)(-dy) * 0.01, (double)dx * 0.01, 0.0);
            angle = axis.length();
            axis = axis.times(1.0 / angle);
            axis = this.viewToWorld.timesDirection(axis);
        }
        if (angle != 0.0) {
            c.transformCoordinates(Mat4.translation(-this.rotationCenter.x, -this.rotationCenter.y, -this.rotationCenter.z));
            c.transformCoordinates(Mat4.axisRotation(axis, -angle));
            c.transformCoordinates(Mat4.translation(this.rotationCenter.x, this.rotationCenter.y, this.rotationCenter.z));
            cam.setCameraCoordinates(c);
            view.updateImage();
        }
        Graphics g = view.getGraphics();
        view.drawImage(g);
        g.dispose();
    }

    public void mouseReleased(MouseEvent e, ViewerCanvas view) {
        this.mouseDragged(e, view);
        Point dragPoint = e.getPoint();
        if (dragPoint.x != this.clickPoint.x || dragPoint.y != this.clickPoint.y) {
            view.orientationChanged();
        }
        if (this.theWindow != null) {
            ObjectInfo bound = view.getBoundCamera();
            if (bound != null) {
                UndoRecord undo = new UndoRecord(this.theWindow, false, 1, new Object[]{bound.coords, this.oldCoords});
                this.moveChildren(bound, bound.coords.fromLocal().times(this.oldCoords.toLocal()), undo);
                this.theWindow.setUndoRecord(undo);
            }
            this.theWindow.updateImage();
        }
    }

    private void moveChildren(ObjectInfo parent, Mat4 transform, UndoRecord undo) {
        int i = 0;
        while (i < parent.children.length) {
            CoordinateSystem coords = parent.children[i].coords;
            CoordinateSystem oldCoords = coords.duplicate();
            coords.transformCoordinates(transform);
            undo.addCommand(1, new Object[]{coords, oldCoords});
            this.moveChildren(parent.children[i], transform, undo);
            ++i;
        }
    }
}

