/*
 * Decompiled with CFR 0.152.
 */
package artofillusion;

import artofillusion.Callback;
import artofillusion.Camera;
import artofillusion.Scene;
import artofillusion.UndoRecord;
import artofillusion.ViewerCanvas;
import artofillusion.math.BoundingBox;
import artofillusion.math.CoordinateSystem;
import artofillusion.math.Mat4;
import artofillusion.math.Vec3;
import artofillusion.object.Object3D;
import artofillusion.object.ObjectInfo;
import artofillusion.ui.ComponentsDialog;
import artofillusion.ui.EditingTool;
import artofillusion.ui.EditingWindow;
import artofillusion.ui.EventProcessor;
import artofillusion.ui.Translate;
import java.awt.Checkbox;
import java.awt.Choice;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Label;
import java.awt.Panel;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.MouseEvent;
import java.util.Vector;

public class ScaleObjectTool
extends EditingTool {
    static final int TOP = 1;
    static final int BOTTOM = 2;
    static final int LEFT = 4;
    static final int RIGHT = 8;
    static final int POSITIONS_FIXED = 0;
    static final int POSITIONS_SCALE = 1;
    static final int OPMODE_SCALE = 0;
    static final int OPMODE_MOVE = 1;
    static Image icon;
    static Image selectedIcon;
    BoundingBox[] bounds;
    Point clickPoint;
    Vec3[] objectPos;
    Vector toMove;
    Vec3[] scaleCenter;
    double halfx;
    double halfy;
    double centerx;
    double centery;
    ObjectInfo clickedObject;
    int whichSides;
    int opmode;
    int[] haxis;
    int[] vaxis;
    int[] haxisDir;
    int[] vaxisDir;
    int scaleAround = 0;
    boolean scaleAll;
    boolean dragged;
    boolean applyToChildren = true;
    EventProcessor process;

    public ScaleObjectTool(EditingWindow fr) {
        super(fr);
        icon = this.loadImage("resize.gif");
        selectedIcon = this.loadImage("selected/resize.gif");
    }

    public void activate() {
        super.activate();
        this.theWindow.setHelpText(Translate.text("scaleObjectTool.helpText"));
    }

    public int whichClicks() {
        return 3;
    }

    public Image getIcon() {
        return icon;
    }

    public Image getSelectedIcon() {
        return selectedIcon;
    }

    public void mousePressedOnHandle(MouseEvent e, ViewerCanvas view, int obj, int handle) {
        Scene theScene = this.theWindow.getScene();
        Camera cam = view.getCamera();
        this.opmode = 0;
        this.toMove = new Vector();
        this.clickedObject = theScene.getObject(obj);
        int[] sel = this.applyToChildren ? theScene.getSelectionWithChildren() : theScene.getSelection();
        int i = 0;
        while (i < sel.length) {
            this.toMove.addElement(theScene.getObject(sel[i]));
            ++i;
        }
        this.bounds = new BoundingBox[this.toMove.size()];
        this.scaleCenter = new Vec3[this.toMove.size()];
        this.haxis = new int[this.toMove.size()];
        this.vaxis = new int[this.toMove.size()];
        this.haxisDir = new int[this.toMove.size()];
        this.vaxisDir = new int[this.toMove.size()];
        i = 0;
        while (i < this.bounds.length) {
            this.bounds[i] = ((ObjectInfo)this.toMove.elementAt(i)).getBounds();
            cam.setObjectTransform(((ObjectInfo)this.toMove.elementAt((int)i)).coords.fromLocal());
            Vec3 screenx = cam.getObjectToView().timesDirection(Vec3.vx());
            Vec3 screeny = cam.getObjectToView().timesDirection(Vec3.vy());
            Vec3 screenz = cam.getObjectToView().timesDirection(Vec3.vz());
            this.haxis[i] = Math.abs(screenx.x) > Math.abs(screeny.x) ? (Math.abs(screenz.x) > Math.abs(screenx.x) ? 2 : 0) : (Math.abs(screenz.x) > Math.abs(screeny.x) ? 2 : 1);
            this.vaxis[i] = Math.abs(screenx.y) > Math.abs(screeny.y) ? (Math.abs(screenz.y) > Math.abs(screenx.y) ? 2 : 0) : (Math.abs(screenz.y) > Math.abs(screeny.y) ? 2 : 1);
            if (this.vaxis[i] == this.haxis[i]) {
                this.vaxis[i] = (this.vaxis[i] + 1) % 3;
            }
            Vec3[] dirs = new Vec3[]{screenx, screeny, screenz};
            this.haxisDir[i] = dirs[this.haxis[i]].x > 0.0 ? 1 : -1;
            this.vaxisDir[i] = dirs[this.vaxis[i]].y > 0.0 ? 1 : -1;
            ++i;
        }
        if (e.isControlDown()) {
            if (this.scaleAround == 0) {
                i = 0;
                while (i < this.scaleCenter.length) {
                    this.scaleCenter[i] = ((ObjectInfo)this.toMove.elementAt((int)i)).coords.getOrigin();
                    ++i;
                }
            } else {
                i = 0;
                while (i < this.scaleCenter.length) {
                    this.scaleCenter[i] = this.clickedObject.coords.getOrigin();
                    ++i;
                }
            }
            i = 0;
            while (i < this.scaleCenter.length) {
                this.scaleCenter[i] = ((ObjectInfo)this.toMove.elementAt((int)i)).coords.toLocal().times(this.scaleCenter[i]);
                ++i;
            }
            cam.setObjectTransform(this.clickedObject.coords.fromLocal());
            Rectangle r = cam.findScreenBounds(this.clickedObject.getBounds());
            this.halfx = (double)r.width / 2.0;
            this.halfy = (double)r.height / 2.0;
            this.centerx = (double)r.x + this.halfx;
            this.centery = (double)r.y + this.halfy;
        } else {
            if (this.scaleAround == 0) {
                i = 0;
                while (i < this.scaleCenter.length) {
                    ObjectInfo info = (ObjectInfo)this.toMove.elementAt(i);
                    this.scaleCenter[i] = this.findBorderPos(info.getBounds(), info.coords.getOrigin(), this.haxis[i], this.vaxis[i], this.haxisDir[i], this.vaxisDir[i], handle);
                    ++i;
                }
            } else {
                i = 0;
                while (this.toMove.elementAt(i) != this.clickedObject) {
                    ++i;
                }
                Vec3 center = this.findBorderPos(this.clickedObject.getBounds(), this.clickedObject.coords.getOrigin(), this.haxis[i], this.vaxis[i], this.haxisDir[i], this.vaxisDir[i], handle);
                center = this.clickedObject.coords.fromLocal().times(center);
                i = 0;
                while (i < this.scaleCenter.length) {
                    this.scaleCenter[i] = ((ObjectInfo)this.toMove.elementAt((int)i)).coords.toLocal().times(center);
                    ++i;
                }
            }
            cam.setObjectTransform(this.clickedObject.coords.fromLocal());
            Rectangle r = cam.findScreenBounds(this.clickedObject.getBounds());
            this.halfx = (double)r.width / 2.0;
            this.halfy = (double)r.height / 2.0;
            this.centerx = handle == 0 || handle == 3 || handle == 5 ? (double)(r.x + r.width) : (handle == 1 || handle == 6 ? (double)r.x + this.halfx : (double)r.x);
            this.centery = handle == 0 || handle == 1 || handle == 2 ? (double)(r.y + r.height) : (handle == 3 || handle == 4 ? (double)r.y + this.halfy : (double)r.y);
            this.halfx *= 2.0;
            this.halfy *= 2.0;
        }
        this.dragged = false;
        this.scaleAll = e.isShiftDown();
        this.whichSides = 0;
        if (handle < 3) {
            ++this.whichSides;
        }
        if (handle > 4) {
            this.whichSides += 2;
        }
        if (handle == 0 || handle == 3 || handle == 5) {
            this.whichSides += 4;
        }
        if (handle == 2 || handle == 4 || handle == 7) {
            this.whichSides += 8;
        }
    }

    public void mousePressedOnObject(MouseEvent e, ViewerCanvas view, int obj) {
        Scene theScene = this.theWindow.getScene();
        this.opmode = 1;
        this.toMove = new Vector();
        this.clickedObject = theScene.getObject(obj);
        int[] sel = this.applyToChildren ? theScene.getSelectionWithChildren() : theScene.getSelection();
        int i = 0;
        while (i < sel.length) {
            this.toMove.addElement(theScene.getObject(sel[i]));
            ++i;
        }
        this.objectPos = new Vec3[this.toMove.size()];
        i = 0;
        while (i < this.objectPos.length) {
            ObjectInfo info = (ObjectInfo)this.toMove.elementAt(i);
            this.objectPos[i] = info.coords.getOrigin();
            ++i;
        }
        this.clickPoint = e.getPoint();
        this.dragged = false;
        this.process = new EventProcessor();
    }

    private Vec3 findBorderPos(BoundingBox bb, Vec3 center, int h, int v, int hdir, int vdir, int handle) {
        double swap;
        double maxv;
        double centerv;
        double minv;
        double maxh;
        double centerh;
        double minh;
        if (h == 0) {
            minh = bb.minx;
            centerh = center.x;
            maxh = bb.maxx;
        } else if (h == 1) {
            minh = bb.miny;
            centerh = center.y;
            maxh = bb.maxy;
        } else {
            minh = bb.minz;
            centerh = center.z;
            maxh = bb.maxz;
        }
        if (v == 0) {
            minv = bb.minx;
            centerv = center.x;
            maxv = bb.maxx;
        } else if (v == 1) {
            minv = bb.miny;
            centerv = center.y;
            maxv = bb.maxy;
        } else {
            minv = bb.minz;
            centerv = center.z;
            maxv = bb.maxz;
        }
        if (hdir == -1) {
            swap = minh;
            minh = maxh;
            maxh = swap;
        }
        if (vdir == -1) {
            swap = minv;
            minv = maxv;
            maxv = swap;
        }
        double borderh = handle == 0 || handle == 3 || handle == 5 ? minh : (handle == 1 || handle == 6 ? centerh : maxh);
        double borderv = handle == 0 || handle == 1 || handle == 2 ? minv : (handle == 3 || handle == 4 ? centerv : maxv);
        Vec3 pos = new Vec3(center);
        if (h == 0) {
            pos.x = borderh;
        } else if (v == 0) {
            pos.x = borderv;
        }
        if (h == 1) {
            pos.y = borderh;
        } else if (v == 1) {
            pos.y = borderv;
        }
        if (h == 2) {
            pos.z = borderh;
        } else if (v == 2) {
            pos.z = borderv;
        }
        return pos;
    }

    public void mouseDraggedMoveOp(final MouseEvent e, final ViewerCanvas view) {
        Callback cb = new Callback(){

            public void execute() {
                CoordinateSystem c;
                int i;
                Scene theScene = ScaleObjectTool.this.theWindow.getScene();
                Camera cam = view.getCamera();
                Point dragPoint = e.getPoint();
                if (!ScaleObjectTool.this.dragged) {
                    UndoRecord undo = new UndoRecord(ScaleObjectTool.this.theWindow, false);
                    ScaleObjectTool.this.theWindow.setUndoRecord(undo);
                    i = 0;
                    while (i < ScaleObjectTool.this.toMove.size()) {
                        ObjectInfo info = (ObjectInfo)ScaleObjectTool.this.toMove.elementAt(i);
                        c = info.coords;
                        undo.addCommand(1, new Object[]{c, c.duplicate()});
                        ++i;
                    }
                    ScaleObjectTool.this.dragged = true;
                }
                int dx = dragPoint.x - ScaleObjectTool.this.clickPoint.x;
                int dy = dragPoint.y - ScaleObjectTool.this.clickPoint.y;
                if (e.isShiftDown() && !e.isControlDown()) {
                    if (Math.abs(dx) > Math.abs(dy)) {
                        dy = 0;
                    } else {
                        dx = 0;
                    }
                }
                Vec3 v = e.isControlDown() ? cam.getCameraCoordinates().getZDirection().times((double)(-dy) * 0.01) : cam.findDragVector(ScaleObjectTool.this.clickedObject.coords.getOrigin(), dx, dy);
                i = 0;
                while (i < ScaleObjectTool.this.toMove.size()) {
                    ObjectInfo info = (ObjectInfo)ScaleObjectTool.this.toMove.elementAt(i);
                    c = info.coords;
                    c.setOrigin(ScaleObjectTool.this.objectPos[i].plus(v));
                    ++i;
                }
                ScaleObjectTool.this.theWindow.updateImage();
                ScaleObjectTool.this.theWindow.setHelpText(Translate.text("moveObjectTool.dragText", (double)Math.round(v.x * 100000.0) / 100000.0 + ", " + (double)Math.round(v.y * 100000.0) / 100000.0 + ", " + (double)Math.round(v.z * 100000.0) / 100000.0));
            }
        };
        this.process.addEvent(cb);
    }

    public void mouseDraggedScaleOp(MouseEvent e, ViewerCanvas view) {
        double size;
        double hscale;
        double vscale;
        Graphics g = view.getGraphics();
        Scene theScene = this.theWindow.getScene();
        Camera cam = view.getCamera();
        Point dragPoint = e.getPoint();
        double[] scale = new double[3];
        if (this.dragged) {
            view.drawImage(g);
        }
        this.dragged = true;
        g.setColor(Color.black);
        if (this.scaleAll) {
            vscale = 0.0;
            hscale = 0.0;
        } else {
            vscale = 1.0;
            hscale = 1.0;
        }
        if ((this.whichSides & 1) > 0) {
            size = this.centery - (double)dragPoint.y;
            if (size < 1.0) {
                size = 1.0;
            }
            vscale = size / this.halfy;
        }
        if ((this.whichSides & 2) > 0) {
            size = (double)dragPoint.y - this.centery;
            if (size < 1.0) {
                size = 1.0;
            }
            vscale = size / this.halfy;
        }
        if ((this.whichSides & 4) > 0) {
            size = this.centerx - (double)dragPoint.x;
            if (size < 1.0) {
                size = 1.0;
            }
            hscale = size / this.halfx;
        }
        if ((this.whichSides & 8) > 0) {
            size = (double)dragPoint.x - this.centerx;
            if (size < 1.0) {
                size = 1.0;
            }
            hscale = size / this.halfx;
        }
        int i = 0;
        while (i < this.toMove.size()) {
            ObjectInfo info = (ObjectInfo)this.toMove.elementAt(i);
            if (this.scaleAll) {
                scale[1] = scale[2] = Math.max(hscale, vscale);
                scale[0] = scale[2];
            } else {
                scale[2] = 1.0;
                scale[1] = 1.0;
                scale[0] = 1.0;
                scale[this.haxis[i]] = hscale;
                scale[this.vaxis[i]] = vscale;
            }
            Mat4 objMat = info.coords.toLocal();
            Mat4 m = Mat4.translation(-this.scaleCenter[i].x, -this.scaleCenter[i].y, -this.scaleCenter[i].z);
            m = Mat4.scale(scale[0], scale[1], scale[2]).times(m);
            m = Mat4.translation(this.scaleCenter[i].x, this.scaleCenter[i].y, this.scaleCenter[i].z).times(m);
            cam.setObjectTransform(((ObjectInfo)this.toMove.elementAt((int)i)).coords.fromLocal().times(m));
            cam.drawClippedBox(g, this.bounds[i]);
            ++i;
        }
        if (this.scaleAll) {
            this.theWindow.setHelpText(Translate.text("scaleMeshTool.dragText", Double.toString((double)Math.round(Math.max(hscale, vscale) * 100000.0) / 100000.0)));
        } else if (this.whichSides == 8 || this.whichSides == 4) {
            this.theWindow.setHelpText(Translate.text("scaleMeshTool.dragText", Double.toString((double)Math.round(hscale * 100000.0) / 100000.0)));
        } else if (this.whichSides == 1 || this.whichSides == 2) {
            this.theWindow.setHelpText(Translate.text("scaleMeshTool.dragText", Double.toString((double)Math.round(vscale * 100000.0) / 100000.0)));
        } else {
            this.theWindow.setHelpText(Translate.text("scaleMeshTool.dragText", (double)Math.round(hscale * 100000.0) / 100000.0 + ", " + (double)Math.round(vscale * 100000.0) / 100000.0));
        }
        g.dispose();
    }

    public void mouseDragged(MouseEvent e, ViewerCanvas view) {
        if (this.opmode == 0) {
            this.mouseDraggedScaleOp(e, view);
        } else {
            this.mouseDraggedMoveOp(e, view);
        }
    }

    public void mouseReleasedMoveOp(MouseEvent e, ViewerCanvas view) {
        if (this.process != null) {
            this.process.stopProcessing();
        }
        this.process = null;
        int i = 0;
        while (i < this.toMove.size()) {
            ObjectInfo info = (ObjectInfo)this.toMove.elementAt(i);
            info.object.sceneChanged(info, this.theWindow.getScene());
            ++i;
        }
        this.toMove = null;
        this.objectPos = null;
    }

    public void mouseReleasedScaleOp(MouseEvent e, ViewerCanvas view) {
        double size;
        double hscale;
        double vscale;
        Scene theScene = this.theWindow.getScene();
        Point dragPoint = e.getPoint();
        double[] scale = new double[3];
        if (!this.dragged) {
            return;
        }
        if (this.scaleAll) {
            vscale = 0.0;
            hscale = 0.0;
        } else {
            vscale = 1.0;
            hscale = 1.0;
        }
        if ((this.whichSides & 1) > 0) {
            size = this.centery - (double)dragPoint.y;
            if (size < 1.0) {
                size = 1.0;
            }
            vscale = size / this.halfy;
        }
        if ((this.whichSides & 2) > 0) {
            size = (double)dragPoint.y - this.centery;
            if (size < 1.0) {
                size = 1.0;
            }
            vscale = size / this.halfy;
        }
        if ((this.whichSides & 4) > 0) {
            size = this.centerx - (double)dragPoint.x;
            if (size < 1.0) {
                size = 1.0;
            }
            hscale = size / this.halfx;
        }
        if ((this.whichSides & 8) > 0) {
            size = (double)dragPoint.x - this.centerx;
            if (size < 1.0) {
                size = 1.0;
            }
            hscale = size / this.halfx;
        }
        UndoRecord undo = new UndoRecord(this.theWindow, false);
        this.theWindow.setUndoRecord(undo);
        int i = 0;
        while (i < this.toMove.size()) {
            if (this.scaleAll) {
                scale[1] = scale[2] = Math.max(hscale, vscale);
                scale[0] = scale[2];
            } else {
                scale[2] = 1.0;
                scale[1] = 1.0;
                scale[0] = 1.0;
                scale[this.haxis[i]] = hscale;
                scale[this.vaxis[i]] = vscale;
            }
            Vec3 oldsize = this.bounds[i].getSize();
            ObjectInfo info = (ObjectInfo)this.toMove.elementAt(i);
            Object3D obj = info.object;
            undo.addCommand(0, new Object[]{obj, obj.duplicate()});
            undo.addCommand(1, new Object[]{info.coords, info.coords.duplicate()});
            obj.setSize(scale[0] * oldsize.x, scale[1] * oldsize.y, scale[2] * oldsize.z);
            Vec3 offset = new Vec3(this.scaleCenter[i]);
            offset.x *= 1.0 - scale[0];
            offset.y *= 1.0 - scale[1];
            offset.z *= 1.0 - scale[2];
            info.coords.setOrigin(info.coords.fromLocal().times(offset));
            theScene.objectModified(obj);
            ++i;
        }
    }

    public void mouseReleased(MouseEvent e, ViewerCanvas view) {
        if (this.opmode == 0) {
            this.mouseReleasedScaleOp(e, view);
        } else {
            this.mouseReleasedMoveOp(e, view);
        }
        this.theWindow.updateImage();
        this.theWindow.setHelpText(Translate.text("scaleObjectTool.helpText"));
    }

    public void iconDoubleClicked() {
        Checkbox childrenBox = new Checkbox("Apply to unselected children of selected objects", this.applyToChildren);
        Choice centerChoice = new Choice();
        Panel p = new Panel();
        centerChoice.add("Remain Fixed");
        centerChoice.add("Scale With Objects");
        centerChoice.select(this.scaleAround);
        p.add(new Label("Object Positions"));
        p.add(centerChoice);
        ComponentsDialog dlg = new ComponentsDialog((Window)this.theFrame, "Options for Resize Tool:", new Component[]{childrenBox, p}, new String[]{"", ""});
        if (!dlg.clickedOk()) {
            return;
        }
        this.applyToChildren = childrenBox.getState();
        this.scaleAround = centerChoice.getSelectedIndex();
    }
}

