/*
 * Decompiled with CFR 0.152.
 */
package artofillusion;

import artofillusion.Callback;
import artofillusion.LayoutWindow;
import artofillusion.MeshEditorWindow;
import artofillusion.ModellingApp;
import artofillusion.MoveViewTool;
import artofillusion.ReshapeMeshTool;
import artofillusion.RotateMeshTool;
import artofillusion.RotateViewTool;
import artofillusion.ScaleMeshTool;
import artofillusion.SkewMeshTool;
import artofillusion.SplineMeshViewer;
import artofillusion.TaperMeshTool;
import artofillusion.ThickenMeshTool;
import artofillusion.UndoRecord;
import artofillusion.animation.Joint;
import artofillusion.animation.Skeleton;
import artofillusion.animation.SkeletonTool;
import artofillusion.math.CoordinateSystem;
import artofillusion.math.Vec3;
import artofillusion.object.Curve;
import artofillusion.object.Mesh;
import artofillusion.object.MeshVertex;
import artofillusion.object.ObjectInfo;
import artofillusion.object.SplineMesh;
import artofillusion.ui.ComponentsDialog;
import artofillusion.ui.EditingTool;
import artofillusion.ui.EditingWindow;
import artofillusion.ui.GenericTool;
import artofillusion.ui.MessageDialog;
import artofillusion.ui.ToolPalette;
import artofillusion.ui.Translate;
import artofillusion.ui.ValueSlider;
import java.awt.BorderLayout;
import java.awt.CheckboxMenuItem;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Label;
import java.awt.Menu;
import java.awt.MenuBar;
import java.awt.MenuItem;
import java.awt.Panel;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;

public class SplineMeshEditorWindow
extends MeshEditorWindow
implements EditingWindow,
KeyListener,
ActionListener,
ItemListener {
    ToolPalette modes;
    Menu editMenu;
    Menu meshMenu;
    Menu skeletonMenu;
    MenuItem[] editMenuItem;
    MenuItem[] meshMenuItem;
    MenuItem[] skeletonMenuItem;
    CheckboxMenuItem[] smoothItem;
    CheckboxMenuItem[] closedItem;
    Callback onClose;
    boolean topology;

    public SplineMeshEditorWindow(EditingWindow parent, String title, ObjectInfo obj, Callback onClose, boolean allowTopology) {
        super(parent, title, (Mesh)((Object)obj.object));
        ObjectInfo info = obj.duplicate(obj.object.duplicate());
        this.onClose = onClose;
        this.topology = allowTopology;
        this.helpText = new Label();
        this.add((Component)this.helpText, "South");
        Panel p1 = new Panel();
        this.add((Component)p1, "Center");
        p1.setLayout(new BorderLayout());
        Panel p2 = new Panel();
        p1.add((Component)p2, "North");
        p2.setLayout(new BorderLayout());
        Panel p3 = new Panel();
        p2.add((Component)p3, "West");
        this.theView = new SplineMeshViewer(info, p3);
        p1.add((Component)this.theView, "Center");
        p3 = new Panel();
        p2.add((Component)p3, "East");
        p3.add(Translate.button("ok", this));
        p3.add(Translate.button("cancel", this));
        Panel p4 = new Panel();
        this.add((Component)p4, "West");
        p4.setLayout(new BorderLayout());
        this.tools = new ToolPalette(1, 9);
        p4.add((Component)this.tools, "North");
        this.defaultTool = new ReshapeMeshTool(this);
        this.tools.addTool(this.defaultTool);
        this.tools.addTool(new ScaleMeshTool(this));
        this.tools.addTool(new RotateMeshTool(this, false));
        this.tools.addTool(new SkewMeshTool(this));
        this.tools.addTool(new TaperMeshTool(this));
        this.tools.addTool(new ThickenMeshTool(this));
        this.tools.addTool(new SkeletonTool(this));
        MoveViewTool metaTool = new MoveViewTool(this);
        this.tools.addTool(metaTool);
        RotateViewTool altTool = new RotateViewTool(this);
        this.tools.addTool(altTool);
        this.tools.selectTool(this.defaultTool);
        this.theView.setMetaTool(metaTool);
        this.theView.setAltTool(altTool);
        this.modes = new ToolPalette(1, 2);
        p4.add((Component)this.modes, "South");
        this.modes.addTool(new GenericTool(this, "point.gif", "selected/point.gif"));
        this.modes.addTool(new GenericTool(this, "curve.gif", "selected/curve.gif"));
        ((SplineMeshViewer)this.theView).setSelectionMode(this.modes.getSelection());
        this.helpText.setBackground(ModellingApp.APP_BACKGROUND_COLOR);
        p2.setBackground(ModellingApp.APP_BACKGROUND_COLOR);
        p3.setBackground(ModellingApp.APP_BACKGROUND_COLOR);
        p4.setBackground(ModellingApp.APP_BACKGROUND_COLOR);
        this.menubar = new MenuBar();
        this.setMenuBar(this.menubar);
        this.createEditMenu();
        this.createMeshMenu((SplineMesh)obj.object);
        this.createSkeletonMenu((SplineMesh)obj.object);
        this.createViewMenu();
        this.recursivelyAddListeners(this);
        this.oldMesh = (SplineMesh)obj.object;
        this.pack();
        Dimension d1 = Toolkit.getDefaultToolkit().getScreenSize();
        Dimension d2 = new Dimension(d1.width * 2 / 3, d1.height * 2 / 3);
        ((Component)this).setSize(d2);
        ((Component)this).setLocation((d1.width - d2.width) / 2, (d1.height - d2.height) / 2);
        this.tools.requestFocus();
        this.updateMenus();
    }

    void createEditMenu() {
        this.editMenu = Translate.menu("edit");
        this.menubar.add(this.editMenu);
        this.editMenuItem = new MenuItem[2];
        this.undoItem = Translate.menuItem("undo", this);
        this.editMenu.add(this.undoItem);
        this.undoItem.setEnabled(false);
        this.editMenu.add(Translate.menuItem("selectAll", this));
        this.editMenuItem[0] = Translate.menuItem("extendSelection", this);
        this.editMenu.add(this.editMenuItem[0]);
        this.editMenuItem[1] = Translate.checkboxMenuItem("freehandSelection", this, false);
        this.editMenu.add(this.editMenuItem[1]);
        this.editMenu.addSeparator();
        this.editMenu.add(Translate.menuItem("meshTension", this));
    }

    void createMeshMenu(SplineMesh obj) {
        this.meshMenu = Translate.menu("mesh");
        this.menubar.add(this.meshMenu);
        this.meshMenuItem = new MenuItem[8];
        this.meshMenuItem[0] = Translate.menuItem("deleteCurves", this);
        if (this.topology) {
            this.meshMenu.add(this.meshMenuItem[0]);
        }
        this.meshMenuItem[1] = Translate.menuItem("subdivide", this);
        if (this.topology) {
            this.meshMenu.add(this.meshMenuItem[1]);
        }
        this.meshMenuItem[2] = Translate.menuItem("editPoints", this);
        this.meshMenu.add(this.meshMenuItem[2]);
        this.meshMenuItem[3] = Translate.menuItem("transformPoints", this);
        this.meshMenu.add(this.meshMenuItem[3]);
        this.meshMenuItem[4] = Translate.menuItem("randomize", this);
        this.meshMenu.add(this.meshMenuItem[4]);
        this.meshMenuItem[5] = Translate.menuItem("parameters", this);
        this.meshMenu.add(this.meshMenuItem[5]);
        this.meshMenu.add(Translate.menuItem("centerMesh", this));
        this.meshMenuItem[6] = Translate.menuItem("extractCurve", this);
        this.meshMenu.add(this.meshMenuItem[6]);
        this.meshMenu.addSeparator();
        this.meshMenuItem[7] = Translate.menuItem("smoothness", this);
        this.meshMenu.add(this.meshMenuItem[7]);
        Menu smoothMenu = Translate.menu("smoothingMethod");
        this.meshMenu.add(smoothMenu);
        this.smoothItem = new CheckboxMenuItem[2];
        this.smoothItem[0] = Translate.checkboxMenuItem("interpolating", this, obj.getSmoothingMethod() == 2);
        smoothMenu.add(this.smoothItem[0]);
        this.smoothItem[1] = Translate.checkboxMenuItem("approximating", this, obj.getSmoothingMethod() == 3);
        smoothMenu.add(this.smoothItem[1]);
        Menu closedMenu = new Menu("Closed");
        if (this.topology) {
            this.meshMenu.add(closedMenu);
        }
        this.closedItem = new CheckboxMenuItem[4];
        this.closedItem[0] = Translate.checkboxMenuItem("udirection", this, obj.isUClosed() && !obj.isVClosed());
        closedMenu.add(this.closedItem[0]);
        this.closedItem[1] = Translate.checkboxMenuItem("vdirection", this, !obj.isUClosed() && obj.isVClosed());
        closedMenu.add(this.closedItem[1]);
        this.closedItem[2] = Translate.checkboxMenuItem("both", this, obj.isUClosed() && obj.isVClosed());
        closedMenu.add(this.closedItem[2]);
        this.closedItem[3] = Translate.checkboxMenuItem("neither", this, !obj.isUClosed() && !obj.isVClosed());
        closedMenu.add(this.closedItem[3]);
        if (this.topology) {
            MenuItem item = Translate.menuItem("invertNormals", this);
            this.meshMenu.add(item);
        }
        if (ModellingApp.getPreferences().getObjectPreviewRenderer() != null) {
            this.meshMenu.addSeparator();
            this.meshMenu.add(Translate.menuItem("renderPreview", this));
        }
    }

    void createSkeletonMenu(SplineMesh obj) {
        this.skeletonMenu = Translate.menu("skeleton");
        this.menubar.add(this.skeletonMenu);
        this.skeletonMenuItem = new MenuItem[4];
        this.skeletonMenuItem[0] = Translate.menuItem("editBone", this);
        this.skeletonMenu.add(this.skeletonMenuItem[0]);
        this.skeletonMenuItem[1] = Translate.menuItem("deleteBone", this);
        this.skeletonMenu.add(this.skeletonMenuItem[1]);
        this.skeletonMenuItem[2] = Translate.menuItem("bindSkeleton", this);
        this.skeletonMenu.add(this.skeletonMenuItem[2]);
        this.skeletonMenu.addSeparator();
        this.skeletonMenuItem[3] = Translate.checkboxMenuItem("detachSkeleton", this, false);
        this.skeletonMenu.add(this.skeletonMenuItem[3]);
    }

    public void setTool(EditingTool tool) {
        if (tool instanceof GenericTool) {
            ((SplineMeshViewer)this.theView).setSelectionMode(this.modes.getSelection());
        } else {
            this.theView.setTool(tool);
            this.currentTool = tool;
        }
    }

    public void updateMenus() {
        SplineMesh theMesh = (SplineMesh)this.theView.getObject().object;
        boolean[] selected = ((SplineMeshViewer)this.theView).getSelection();
        boolean curvemode = ((SplineMeshViewer)this.theView).selectMode == 1;
        int count = 0;
        int i = 0;
        while (i < selected.length) {
            if (selected[i]) {
                ++count;
            }
            ++i;
        }
        if (count > 0) {
            this.editMenuItem[0].setEnabled(true);
            this.meshMenuItem[0].setEnabled(curvemode);
            this.meshMenuItem[1].setEnabled(curvemode);
            this.meshMenuItem[2].setEnabled(true);
            this.meshMenuItem[3].setEnabled(true);
            this.meshMenuItem[4].setEnabled(true);
            this.meshMenuItem[5].setEnabled(true);
            this.meshMenuItem[6].setEnabled(curvemode && count == 1);
            this.meshMenuItem[7].setEnabled(curvemode);
        } else {
            this.editMenuItem[0].setEnabled(false);
            i = 0;
            while (i < this.meshMenuItem.length) {
                this.meshMenuItem[i].setEnabled(false);
                ++i;
            }
        }
        this.templateItem.setEnabled(this.theView.getTemplateImage() != null);
        Skeleton s = theMesh.getSkeleton();
        Joint selJoint = s.getJoint(this.theView.getSelectedJoint());
        this.skeletonMenuItem[0].setEnabled(selJoint != null);
        this.skeletonMenuItem[1].setEnabled(selJoint != null && selJoint.children.length == 0);
        this.skeletonMenuItem[2].setEnabled(count > 0);
    }

    public void keyPressed(KeyEvent e) {
        int code = e.getKeyCode();
        if (code == 8 || code == 127) {
            if (this.theView.getCurrentTool() instanceof SkeletonTool) {
                this.deleteJointCommand();
            } else {
                this.deleteCommand();
            }
        } else {
            super.keyPressed(e);
        }
    }

    public void actionPerformed(ActionEvent e) {
        String command = e.getActionCommand();
        this.setCursor(Cursor.getPredefinedCursor(3));
        if (command.equals("ok")) {
            SplineMesh theMesh = (SplineMesh)this.theView.getObject().object;
            if (((SplineMesh)this.oldMesh).getMaterial() != null) {
                if (!theMesh.isClosed()) {
                    this.setCursor(Cursor.getDefaultCursor());
                    MessageDialog dlg = new MessageDialog((Window)this, new String[]{"You have modified this object so that it is no longer a closed surface.", "This means that it can no longer have a material assigned to it.  Are", "you sure you want to continue?"}, new String[]{Translate.text("button.ok"), Translate.text("button.cancel")});
                    if (dlg.getChoice() == 1) {
                        return;
                    }
                    theMesh.setMaterial(null);
                    theMesh.setMaterialMapping(null);
                } else {
                    theMesh.setMaterial(((SplineMesh)this.oldMesh).getMaterial());
                    theMesh.setMaterialMapping(((SplineMesh)this.oldMesh).getMaterialMapping());
                }
            }
            this.oldMesh.copyObject(theMesh);
            this.oldMesh = null;
            this.dispose();
            this.onClose.execute();
        } else if (command.equals("cancel")) {
            this.oldMesh = null;
            this.dispose();
        } else if (command.equals("undo")) {
            this.undoCommand();
        } else if (command.equals("selectAll")) {
            this.selectAllCommand();
        } else if (command.equals("extendSelection")) {
            this.extendSelectionCommand();
        } else if (command.equals("clear")) {
            this.deleteCommand();
        } else if (command.equals("subdivide")) {
            this.subdivideCommand();
        } else if (command.equals("editPoints")) {
            this.setPointsCommand();
        } else if (command.equals("transformPoints")) {
            this.transformPointsCommand();
        } else if (command.equals("randomize")) {
            this.randomizeCommand();
        } else if (command.equals("parameters")) {
            this.setParametersCommand();
        } else if (command.equals("centerMesh")) {
            this.centerCommand();
        } else if (command.equals("extractCurve")) {
            this.extractCurveCommand();
        } else if (command.equals("smoothness")) {
            this.setSmoothnessCommand();
        } else if (command.equals("invertNormals")) {
            this.reverseNormalsCommand();
        } else if (command.equals("meshTension")) {
            this.setTensionCommand();
        } else if (command.equals("renderPreview")) {
            this.theView.previewObject();
        } else if (command.equals("editBone")) {
            this.editJointCommand();
        } else if (command.equals("deleteBone")) {
            this.deleteJointCommand();
        } else if (command.equals("bindSkeleton")) {
            this.bindSkeletonCommand();
        } else if (command.equals("grid")) {
            this.setGridCommand();
        } else if (command.equals("showTemplate")) {
            boolean wasShown = this.theView.getTemplateShown();
            this.templateItem.setLabel(Translate.text(wasShown ? "menu.showTemplate" : "menu.hideTemplate"));
            this.theView.setShowTemplate(!wasShown);
            this.updateImage();
        } else if (command.equals("setTemplate")) {
            this.setTemplateCommand();
        }
        this.setCursor(Cursor.getDefaultCursor());
    }

    public void itemStateChanged(ItemEvent e) {
        Object source = e.getSource();
        if (source == this.editMenuItem[1]) {
            ((SplineMeshViewer)this.theView).setFreehandSelection(((CheckboxMenuItem)this.editMenuItem[1]).getState());
            return;
        }
        if (source == this.skeletonMenuItem[3]) {
            ((SplineMeshViewer)this.theView).setSkeletonDetached(((CheckboxMenuItem)this.skeletonMenuItem[3]).getState());
            return;
        }
        int i = 0;
        while (i < this.smoothItem.length) {
            if (source == this.smoothItem[i]) {
                this.setSmoothingMethod(i + 2);
                return;
            }
            ++i;
        }
        i = 0;
        while (i < this.closedItem.length) {
            if (source == this.closedItem[i]) {
                this.setClosed(i);
                return;
            }
            ++i;
        }
        super.itemStateChanged(e);
    }

    void selectAllCommand() {
        boolean[] selected = ((SplineMeshViewer)this.theView).getSelection();
        int i = 0;
        while (i < selected.length) {
            selected[i] = true;
            ++i;
        }
        ((SplineMeshViewer)this.theView).setSelection(selected);
    }

    void extendSelectionCommand() {
        SplineMesh theMesh = (SplineMesh)this.theView.getObject().object;
        if (((SplineMeshViewer)this.theView).getSelectionMode() == 0) {
            int oldDist = MeshEditorWindow.tensionDistance;
            MeshEditorWindow.tensionDistance = 1;
            int[] dist = ((SplineMeshViewer)this.theView).getSelectionDistance();
            boolean[] selected = new boolean[dist.length];
            MeshEditorWindow.tensionDistance = oldDist;
            int i = 0;
            while (i < dist.length) {
                selected[i] = dist[i] == 0 || dist[i] == 1;
                ++i;
            }
            ((SplineMeshViewer)this.theView).setSelection(selected);
        } else {
            boolean[] oldSelection = ((SplineMeshViewer)this.theView).getSelection();
            boolean[] selected = new boolean[oldSelection.length];
            int usize = theMesh.getUSize();
            int vsize = theMesh.getVSize();
            int i = 0;
            while (i < usize - 1) {
                if (oldSelection[i] || oldSelection[i + 1]) {
                    selected[i + 1] = true;
                    selected[i] = true;
                }
                ++i;
            }
            if (theMesh.isUClosed() && (oldSelection[0] || oldSelection[usize - 1])) {
                selected[usize - 1] = true;
                selected[0] = true;
            }
            int i2 = 0;
            while (i2 < vsize - 1) {
                if (oldSelection[usize + i2] || oldSelection[usize + i2 + 1]) {
                    selected[usize + i2 + 1] = true;
                    selected[usize + i2] = true;
                }
                ++i2;
            }
            if (theMesh.isVClosed() && (oldSelection[usize] || oldSelection[usize + vsize - 1])) {
                selected[usize + vsize - 1] = true;
                selected[usize] = true;
            }
            ((SplineMeshViewer)this.theView).setSelection(selected);
        }
    }

    void deleteCommand() {
        int unum = 0;
        int vnum = 0;
        SplineMesh theMesh = (SplineMesh)this.theView.getObject().object;
        float[] us = theMesh.getUSmoothness();
        float[] vs = theMesh.getVSmoothness();
        boolean[] selected = ((SplineMeshViewer)this.theView).getSelection();
        MeshVertex[] vt = theMesh.getVertices();
        int usize = theMesh.getUSize();
        int vsize = theMesh.getVSize();
        if (((SplineMeshViewer)this.theView).getSelectionMode() != 1) {
            return;
        }
        int i = 0;
        while (i < usize) {
            if (selected[i]) {
                ++unum;
            }
            ++i;
        }
        i = 0;
        while (i < vsize) {
            if (selected[i + usize]) {
                ++vnum;
            }
            ++i;
        }
        if (unum == 0 && vnum == 0) {
            return;
        }
        if (usize - unum < 2 || vsize - vnum < 2) {
            new MessageDialog((Window)this, "A curve must have at least two points.");
            return;
        }
        if (theMesh.isUClosed() && usize - unum < 3 || theMesh.isVClosed() && vsize - vnum < 3) {
            new MessageDialog((Window)this, "A closed curve must have at least three points.");
            return;
        }
        this.setUndoRecord(new UndoRecord(this, false, 0, new Object[]{theMesh, theMesh.duplicate()}));
        MeshVertex[][] v = new MeshVertex[usize - unum][vsize - vnum];
        float[] newus = new float[usize - unum];
        float[] newvs = new float[vsize - vnum];
        i = 0;
        int j = 0;
        while (i < usize) {
            if (!selected[i]) {
                int k = 0;
                int m = 0;
                while (k < vsize) {
                    if (!selected[k + usize]) {
                        newvs[m] = vs[k];
                        v[j][m++] = vt[i + k * usize];
                    }
                    ++k;
                }
                newus[j++] = us[i];
            }
            ++i;
        }
        theMesh.setShape(v, newus, newvs);
        this.theView.setMesh(theMesh);
        this.updateImage();
    }

    void subdivideCommand() {
        int j;
        SplineMesh theMesh = (SplineMesh)this.theView.getObject().object;
        MeshVertex[] vt = theMesh.getVertices();
        float[] us = theMesh.getUSmoothness();
        float[] vs = theMesh.getVSmoothness();
        boolean[] selected = ((SplineMeshViewer)this.theView).getSelection();
        int usplitcount = 0;
        int vsplitcount = 0;
        int method = theMesh.getSmoothingMethod();
        int usize = theMesh.getUSize();
        int vsize = theMesh.getVSize();
        if (((SplineMeshViewer)this.theView).getSelectionMode() != 1) {
            return;
        }
        int i = 0;
        while (!selected[i] && i < selected.length) {
            ++i;
        }
        if (i == selected.length) {
            return;
        }
        boolean[] splitu = theMesh.isUClosed() ? new boolean[usize] : new boolean[usize - 1];
        i = 0;
        while (i < splitu.length) {
            if (selected[i] && selected[(i + 1) % usize]) {
                splitu[i] = true;
                ++usplitcount;
            }
            ++i;
        }
        boolean[] splitv = theMesh.isVClosed() ? new boolean[vsize] : new boolean[vsize - 1];
        i = 0;
        while (i < splitv.length) {
            if (selected[i + usize] && selected[(i + 1) % vsize + usize]) {
                splitv[i] = true;
                ++vsplitcount;
            }
            ++i;
        }
        float[] newus = new float[usize + usplitcount];
        float[] newvs = new float[vsize + vsplitcount];
        boolean[] newsel = new boolean[selected.length + usplitcount + vsplitcount];
        MeshVertex[][] v = new MeshVertex[vsize][usize];
        i = 0;
        while (i < usize) {
            j = 0;
            while (j < vsize) {
                v[j][i] = vt[i + j * usize];
                ++j;
            }
            ++i;
        }
        MeshVertex[][] newv = new MeshVertex[vsize][usize + usplitcount];
        this.splitOneAxis(v, newv, us, newus, splitu, theMesh.isUClosed());
        v = new MeshVertex[usize + usplitcount][vsize];
        i = 0;
        while (i < v.length) {
            j = 0;
            while (j < v[i].length) {
                v[i][j] = newv[j][i];
                ++j;
            }
            ++i;
        }
        newv = new MeshVertex[usize + usplitcount][vsize + vsplitcount];
        this.splitOneAxis(v, newv, vs, newvs, splitv, theMesh.isVClosed());
        i = 0;
        j = 0;
        while (i < usize) {
            if (selected[i]) {
                newsel[j] = true;
            }
            if (i < splitu.length && splitu[i]) {
                newsel[++j] = true;
            }
            ++j;
            ++i;
        }
        i = 0;
        j = 0;
        while (i < vsize) {
            if (selected[i + usize]) {
                newsel[j + usize + usplitcount] = true;
            }
            if (i < splitv.length && splitv[i]) {
                newsel[++j + usize + usplitcount] = true;
            }
            ++j;
            ++i;
        }
        this.setUndoRecord(new UndoRecord(this, false, 0, new Object[]{theMesh, theMesh.duplicate()}));
        theMesh.setShape(newv, newus, newvs);
        this.theView.setMesh(theMesh);
        ((SplineMeshViewer)this.theView).setSelection(newsel);
    }

    private void splitOneAxis(MeshVertex[][] v, MeshVertex[][] newv, float[] s, float[] news, boolean[] split, boolean closed) {
        int k;
        SplineMesh theMesh = (SplineMesh)this.theView.getObject().object;
        int method = theMesh.getSmoothingMethod();
        int i = 0;
        int j = 0;
        while (i < split.length) {
            int p1 = i - 1;
            if (p1 < 0) {
                p1 = closed ? v[0].length - 1 : 0;
            }
            int p3 = i < v[0].length - 1 ? i + 1 : (closed ? 0 : v[0].length - 1);
            if ((split[i] || split[p1]) && method == 3) {
                k = 0;
                while (k < v.length) {
                    newv[k][j] = SplineMesh.calcApproxPoint(v[k], s, p1, i, p3);
                    ++k;
                }
            } else {
                k = 0;
                while (k < v.length) {
                    newv[k][j] = v[k][i];
                    ++k;
                }
            }
            news[j] = split[i] || split[p1] ? Math.min(s[i] * 2.0f, 1.0f) : s[i];
            if (!split[i]) {
                ++j;
            } else {
                if (method == 0) {
                    k = 0;
                    while (k < v.length) {
                        newv[k][j + 1] = MeshVertex.blend(v[k][i], v[k][p3], 0.5, 0.5);
                        ++k;
                    }
                } else if (method == 2) {
                    int p4 = i < v[0].length - 2 ? i + 2 : (closed ? (i + 2) % v[0].length : v[0].length - 1);
                    k = 0;
                    while (k < v.length) {
                        newv[k][j + 1] = SplineMesh.calcInterpPoint(v[k], s, p1, i, p3, p4);
                        ++k;
                    }
                } else {
                    k = 0;
                    while (k < v.length) {
                        newv[k][j + 1] = MeshVertex.blend(v[k][i], v[k][p3], 0.5, 0.5);
                        ++k;
                    }
                }
                news[j + 1] = 1.0f;
                j += 2;
            }
            ++i;
        }
        if (!closed) {
            k = 0;
            while (k < v.length) {
                newv[k][0] = v[k][0];
                newv[k][j] = v[k][i];
                ++k;
            }
            news[j] = s[i];
        }
    }

    void extractCurveCommand() {
        Vec3[] v;
        boolean closed;
        SplineMesh theMesh = (SplineMesh)this.theView.getObject().object;
        MeshVertex[] vt = theMesh.getVertices();
        boolean[] selected = ((SplineMeshViewer)this.theView).getSelection();
        int usize = theMesh.getUSize();
        int vsize = theMesh.getVSize();
        if (((SplineMeshViewer)this.theView).getSelectionMode() != 1) {
            return;
        }
        int which = 0;
        while (which < selected.length && !selected[which]) {
            ++which;
        }
        if (which == selected.length) {
            return;
        }
        if (which < usize) {
            closed = theMesh.isVClosed();
            v = new Vec3[vsize];
        } else {
            closed = theMesh.isUClosed();
            v = new Vec3[usize];
        }
        float[] smoothness = new float[v.length];
        float[] usmoothness = theMesh.getUSmoothness();
        float[] vsmoothness = theMesh.getVSmoothness();
        int i = 0;
        while (i < v.length) {
            if (which < usize) {
                v[i] = vt[which + i * usize].r;
                smoothness[i] = vsmoothness[i];
            } else {
                v[i] = vt[(which - usize) * usize + i].r;
                smoothness[i] = usmoothness[i];
            }
            ++i;
        }
        Curve cv = new Curve(v, smoothness, theMesh.getSmoothingMethod(), closed);
        Component parent = (Component)((Object)this.parentWindow);
        while (parent != null && !(parent instanceof LayoutWindow)) {
            parent = parent.getParent();
        }
        if (parent != null) {
            ((LayoutWindow)parent).addObject(cv, new CoordinateSystem(new Vec3(), new Vec3(0.0, 0.0, 1.0), new Vec3(0.0, 1.0, 0.0)), "Extracted Curve", null);
            ((LayoutWindow)parent).updateImage();
        }
    }

    void setSmoothnessCommand() {
        final SplineMesh theMesh = (SplineMesh)this.theView.getObject().object;
        SplineMesh oldMesh = (SplineMesh)theMesh.duplicate();
        MeshVertex[] vt = theMesh.getVertices();
        final boolean[] selected = ((SplineMeshViewer)this.theView).getSelection();
        final float[] usmoothness = theMesh.getUSmoothness();
        final float[] vsmoothness = theMesh.getVSmoothness();
        if (((SplineMeshViewer)this.theView).getSelectionMode() != 1) {
            return;
        }
        int i = 0;
        while (i < selected.length && !selected[i]) {
            ++i;
        }
        if (i == selected.length) {
            return;
        }
        float value = i < theMesh.getUSize() ? usmoothness[i] : vsmoothness[i - theMesh.getUSize()];
        value = 0.001f * (float)Math.round(value * 1000.0f);
        final ValueSlider smoothness = new ValueSlider(0.0, 1.0, 100, value);
        smoothness.addAdjustmentListener(new AdjustmentListener(){

            public void adjustmentValueChanged(AdjustmentEvent ev) {
                float s = (float)smoothness.getValue();
                int i = 0;
                while (i < selected.length) {
                    if (selected[i]) {
                        if (i < theMesh.getUSize()) {
                            usmoothness[i] = s;
                        } else {
                            vsmoothness[i - theMesh.getUSize()] = s;
                        }
                    }
                    ++i;
                }
                theMesh.setSmoothness(usmoothness, vsmoothness);
                SplineMeshEditorWindow.this.theView.objectChanged();
                SplineMeshEditorWindow.this.theView.updateImage();
                SplineMeshEditorWindow.this.theView.repaint();
            }
        });
        ComponentsDialog dlg = new ComponentsDialog((Window)this, "Set Smoothness for Selected Curves", new Component[]{smoothness}, new String[]{Translate.text("Smoothness")});
        if (dlg.clickedOk()) {
            this.setUndoRecord(new UndoRecord(this, false, 0, new Object[]{theMesh, oldMesh}));
        } else {
            theMesh.copyObject(oldMesh);
            this.theView.objectChanged();
            this.theView.updateImage();
            this.theView.repaint();
        }
    }

    void reverseNormalsCommand() {
        SplineMesh theMesh = (SplineMesh)this.theView.getObject().object;
        this.setUndoRecord(new UndoRecord(this, false, 0, new Object[]{theMesh, theMesh.duplicate()}));
        theMesh.reverseOrientation();
        this.theView.objectChanged();
        this.theView.updateImage();
        this.theView.repaint();
    }

    void setSmoothingMethod(int method) {
        SplineMesh theMesh = (SplineMesh)this.theView.getObject().object;
        this.setUndoRecord(new UndoRecord(this, false, 0, new Object[]{theMesh, theMesh.duplicate()}));
        int i = 0;
        while (i < this.smoothItem.length) {
            this.smoothItem[i].setState(false);
            ++i;
        }
        this.smoothItem[method - 2].setState(true);
        theMesh.setSmoothingMethod(method);
        this.theView.objectChanged();
        this.theView.updateImage();
        this.theView.repaint();
    }

    void setClosed(int item) {
        SplineMesh theMesh = (SplineMesh)this.theView.getObject().object;
        this.setUndoRecord(new UndoRecord(this, false, 0, new Object[]{theMesh, theMesh.duplicate()}));
        int i = 0;
        while (i < this.closedItem.length) {
            this.closedItem[i].setState(i == item);
            ++i;
        }
        theMesh.setClosed(item == 0 || item == 2, item == 1 || item == 2);
        this.theView.setMesh(theMesh);
        this.theView.updateImage();
        this.theView.repaint();
    }

    public void adjustDeltas(Vec3[] delta) {
        int[] dist = this.theView.getSelectionDistance();
        int[] count = new int[delta.length];
        SplineMesh theMesh = (SplineMesh)this.theView.getObject().object;
        int maxDistance = MeshEditorWindow.getTensionDistance();
        int usize = theMesh.getUSize();
        int vsize = theMesh.getVSize();
        double tension = MeshEditorWindow.getMeshTension();
        double[] scale = new double[maxDistance + 1];
        int i = 0;
        while (i < delta.length) {
            if (dist[i] != 0) {
                delta[i].set(0.0, 0.0, 0.0);
            }
            ++i;
        }
        int i2 = 0;
        while (i2 < maxDistance) {
            int j = 0;
            while (j < count.length) {
                count[j] = 0;
                ++j;
            }
            int j2 = 0;
            while (j2 < usize) {
                int k = 0;
                while (k < vsize) {
                    if (dist[j2 + k * usize] == i2) {
                        if (j2 == 0) {
                            if (theMesh.isUClosed() && dist[usize - 1 + k * usize] == i2 + 1) {
                                int n = usize - 1 + k * usize;
                                count[n] = count[n] + 1;
                                delta[usize - 1 + k * usize].add(delta[j2 + k * usize]);
                            }
                        } else if (dist[j2 - 1 + k * usize] == i2 + 1) {
                            int n = j2 - 1 + k * usize;
                            count[n] = count[n] + 1;
                            delta[j2 - 1 + k * usize].add(delta[j2 + k * usize]);
                        }
                        if (j2 == usize - 1) {
                            if (theMesh.isUClosed() && dist[k * usize] == i2 + 1) {
                                int n = k * usize;
                                count[n] = count[n] + 1;
                                delta[k * usize].add(delta[j2 + k * usize]);
                            }
                        } else if (dist[j2 + 1 + k * usize] == i2 + 1) {
                            int n = j2 + 1 + k * usize;
                            count[n] = count[n] + 1;
                            delta[j2 + 1 + k * usize].add(delta[j2 + k * usize]);
                        }
                        if (k == 0) {
                            if (theMesh.isVClosed() && dist[j2 + (vsize - 1) * usize] == i2 + 1) {
                                int n = j2 + (vsize - 1) * usize;
                                count[n] = count[n] + 1;
                                delta[j2 + (vsize - 1) * usize].add(delta[j2 + k * usize]);
                            }
                        } else if (dist[j2 + (k - 1) * usize] == i2 + 1) {
                            int n = j2 + (k - 1) * usize;
                            count[n] = count[n] + 1;
                            delta[j2 + (k - 1) * usize].add(delta[j2 + k * usize]);
                        }
                        if (k == vsize - 1) {
                            if (theMesh.isVClosed() && dist[j2] == i2 + 1) {
                                dist[j2 + k * usize] = i2 + 1;
                                int n = j2;
                                count[n] = count[n] + 1;
                                delta[j2].add(delta[j2 + k * usize]);
                            }
                        } else if (dist[j2 + (k + 1) * usize] == i2 + 1) {
                            int n = j2 + (k + 1) * usize;
                            count[n] = count[n] + 1;
                            delta[j2 + (k + 1) * usize].add(delta[j2 + k * usize]);
                        }
                    }
                    ++k;
                }
                ++j2;
            }
            int j3 = 0;
            while (j3 < count.length) {
                if (count[j3] > 1) {
                    delta[j3].scale(1.0 / (double)count[j3]);
                }
                ++j3;
            }
            ++i2;
        }
        int i3 = 0;
        while (i3 < scale.length) {
            scale[i3] = Math.pow(((double)(maxDistance - i3) + 1.0) / ((double)maxDistance + 1.0), tension);
            ++i3;
        }
        int i4 = 0;
        while (i4 < delta.length) {
            if (dist[i4] > 0) {
                delta[i4].scale(scale[dist[i4]]);
            }
            ++i4;
        }
    }
}

