/*
 * Decompiled with CFR 0.152.
 */
package artofillusion;

import artofillusion.MaterialPreviewer;
import artofillusion.ModellingApp;
import artofillusion.animation.Actor;
import artofillusion.math.Vec2;
import artofillusion.object.Mesh;
import artofillusion.object.MeshVertex;
import artofillusion.object.Object3D;
import artofillusion.object.ObjectInfo;
import artofillusion.texture.LayeredMapping;
import artofillusion.texture.Mapping2D;
import artofillusion.texture.Texture;
import artofillusion.texture.TextureMapping;
import artofillusion.texture.UVMapping;
import java.awt.Button;
import java.awt.Choice;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Label;
import java.awt.Panel;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Vector;

public class TextureMappingDialog
extends Dialog
implements ActionListener,
ItemListener {
    Frame fr;
    ObjectInfo obj;
    Vector mappings;
    Choice mapChoice;
    MaterialPreviewer preview;
    TextureMapping map;
    TextureMapping oldMapping;
    Panel editingPanel;
    boolean layered;
    int layer;
    static /* synthetic */ Class class$artofillusion$object$Object3D;
    static /* synthetic */ Class class$artofillusion$texture$Texture;

    public TextureMappingDialog(Frame parent, ObjectInfo obj, int layer) {
        super(parent, "Texture Mapping", true);
        this.fr = parent;
        this.obj = obj;
        this.layer = layer;
        this.map = obj.object.getTextureMapping();
        this.layered = this.map instanceof LayeredMapping;
        if (this.layered) {
            this.map = ((LayeredMapping)this.map).getLayerMapping(layer);
        }
        this.oldMapping = this.map.duplicate();
        this.mappings = new Vector();
        Class[] allMappings = ModellingApp.getTextureMappings();
        int i = 0;
        while (i < allMappings.length) {
            try {
                Method mtd = allMappings[i].getMethod("legalMapping", class$artofillusion$object$Object3D == null ? TextureMappingDialog.class$("artofillusion.object.Object3D") : class$artofillusion$object$Object3D, class$artofillusion$texture$Texture == null ? TextureMappingDialog.class$("artofillusion.texture.Texture") : class$artofillusion$texture$Texture);
                Texture tex = this.layered ? ((LayeredMapping)obj.object.getTextureMapping()).getLayer(layer) : obj.object.getTexture();
                Boolean result = (Boolean)mtd.invoke(null, obj.object, tex);
                if (result.booleanValue()) {
                    this.mappings.addElement(allMappings[i]);
                }
            }
            catch (Exception ex) {
                // empty catch block
            }
            ++i;
        }
        GridBagConstraints gc = new GridBagConstraints();
        this.setLayout(new GridBagLayout());
        gc.gridwidth = 2;
        Object3D previewObj = obj.object instanceof Actor ? ((Actor)obj.object).getObject().duplicate() : obj.object.duplicate();
        this.preview = new MaterialPreviewer(obj.object.getTexture(), obj.object.getMaterial(), previewObj, 161, 160);
        this.add((Component)this.preview, gc);
        this.setPreviewMapping(this.map);
        gc.gridwidth = 1;
        gc.gridy = 1;
        gc.insets.right = 5;
        this.add((Component)new Label("Mapping:"), gc);
        gc.insets.right = 0;
        gc.anchor = 17;
        this.mapChoice = new Choice();
        this.add((Component)this.mapChoice, gc);
        gc.anchor = 10;
        int i2 = 0;
        while (i2 < this.mappings.size()) {
            try {
                Method mtd = ((Class)this.mappings.elementAt(i2)).getMethod("getName", null);
                this.mapChoice.add((String)mtd.invoke(null, null));
                if (this.mappings.elementAt(i2) == this.map.getClass()) {
                    this.mapChoice.select(i2);
                }
            }
            catch (IllegalAccessException ex) {
            }
            catch (IllegalArgumentException ex) {
            }
            catch (InvocationTargetException ex) {
            }
            catch (NoSuchMethodException ex) {
            }
            catch (SecurityException ex) {
                // empty catch block
            }
            ++i2;
        }
        this.mapChoice.addItemListener(this);
        gc.gridwidth = 2;
        gc.gridy = 2;
        this.editingPanel = this.map.getEditingPanel(obj, this.preview);
        this.add((Component)this.editingPanel, gc);
        Panel p = new Panel();
        gc.gridwidth = 2;
        gc.gridy = 3;
        this.add((Component)p, gc);
        Button b = new Button("Ok");
        p.add(b);
        b.setActionCommand("ok");
        b.addActionListener(this);
        b = new Button("Cancel");
        p.add(b);
        b.setActionCommand("cancel");
        b.addActionListener(this);
        this.pack();
        this.setResizable(false);
        ModellingApp.centerWindow(this);
        this.show();
    }

    public void actionPerformed(ActionEvent e) {
        String command = e.getActionCommand();
        String[] finalStrings = new String[9];
        if (command.equals("cancel")) {
            this.setMapping(this.oldMapping);
        }
        this.dispose();
    }

    public void itemStateChanged(ItemEvent e) {
        try {
            Class cls = (Class)this.mappings.elementAt(this.mapChoice.getSelectedIndex());
            if (cls == this.map.getClass()) {
                return;
            }
            Constructor con = cls.getConstructor(class$artofillusion$texture$Texture == null ? (class$artofillusion$texture$Texture = TextureMappingDialog.class$("artofillusion.texture.Texture")) : class$artofillusion$texture$Texture);
            Texture tex = this.layered ? ((LayeredMapping)this.obj.object.getTextureMapping()).getLayer(this.layer) : this.obj.object.getTexture();
            this.setMapping((TextureMapping)con.newInstance(tex));
            this.remove(this.editingPanel);
            GridBagConstraints gc = new GridBagConstraints();
            gc.gridwidth = 2;
            gc.gridy = 2;
            this.editingPanel = this.map.getEditingPanel(this.obj, this.preview);
            this.add((Component)this.editingPanel, gc);
            this.pack();
            this.preview.render();
        }
        catch (IllegalAccessException ex) {
        }
        catch (InstantiationException ex) {
        }
        catch (InvocationTargetException ex) {
        }
        catch (NoSuchMethodException ex) {
            // empty catch block
        }
    }

    private void setMapping(TextureMapping newmap) {
        this.map = newmap;
        Vec2[] uv = null;
        if (newmap instanceof UVMapping) {
            Mapping2D oldmap = this.layered ? (Mapping2D)((LayeredMapping)this.obj.object.getTextureMapping()).getLayerMapping(this.layer) : (Mapping2D)this.obj.object.getTextureMapping();
            Mesh m = this.obj.object instanceof Actor ? (Mesh)((Object)((Actor)this.obj.object).getObject()) : (Mesh)((Object)this.obj.object);
            uv = oldmap.findTextureCoordinates(m, this.obj.object.getTextureMapping().getParameters());
        }
        if (this.layered) {
            ((LayeredMapping)this.obj.object.getTextureMapping()).setLayerMapping(this.layer, newmap);
            this.obj.object.setTextureMapping(this.obj.object.getTextureMapping());
        } else {
            this.obj.object.setTextureMapping(newmap);
            this.setPreviewMapping(newmap);
        }
        if (uv != null) {
            if (this.obj.object instanceof Actor) {
                ((UVMapping)newmap).setTextureCoordinates((Actor)this.obj.object, this.obj.object.getTextureMapping().getParameters(), uv);
            } else {
                ((UVMapping)newmap).setTextureCoordinates((Mesh)((Object)this.obj.object), this.obj.object.getTextureMapping().getParameters(), uv);
            }
            this.setPreviewMapping(newmap);
        }
        this.preview.render();
    }

    public void setPreviewMapping(TextureMapping newmap) {
        Mesh mesh;
        this.preview.setTexture(this.obj.object.getTexture(), newmap);
        if (this.obj.object instanceof Actor && ((Actor)this.obj.object).getObject() instanceof Mesh) {
            mesh = (Mesh)((Object)((Actor)this.obj.object).getObject());
        } else if (this.obj.object instanceof Mesh) {
            mesh = (Mesh)((Object)this.obj.object);
        } else {
            return;
        }
        Mesh previewMesh = (Mesh)((Object)this.preview.getObject().object);
        MeshVertex[] vert = mesh.getVertices();
        MeshVertex[] previewVert = previewMesh.getVertices();
        int i = 0;
        while (i < vert.length) {
            if (vert[i].param != null && previewVert[i].param != null && vert[i].param.length == previewVert[i].param.length) {
                int j = 0;
                while (j < vert[i].param.length) {
                    previewVert[i].param[j] = vert[i].param[j];
                    ++j;
                }
            }
            ++i;
        }
        this.preview.render();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

