/*
 * Decompiled with CFR 0.152.
 */
package artofillusion;

import artofillusion.LayoutWindow;
import artofillusion.ListChangeListener;
import artofillusion.MaterialPreviewer;
import artofillusion.ModellingApp;
import artofillusion.Scene;
import artofillusion.texture.Texture;
import artofillusion.ui.ComponentsDialog;
import artofillusion.ui.EntriesDialog;
import artofillusion.ui.MessageDialog;
import artofillusion.ui.PanelDialog;
import artofillusion.ui.Translate;
import java.awt.Button;
import java.awt.Choice;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dialog;
import java.awt.FileDialog;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.List;
import java.awt.Panel;
import java.awt.TextField;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InvalidObjectException;
import java.lang.reflect.Method;
import java.util.Vector;
import java.util.zip.GZIPInputStream;

public class TexturesDialog
extends Dialog
implements ActionListener,
ItemListener,
ListChangeListener {
    Scene theScene;
    Frame parent;
    List texList;
    Button[] b;

    public TexturesDialog(Frame fr, Scene sc) {
        super(fr, "Textures", false);
        this.parent = fr;
        this.theScene = sc;
        Panel buttons = new Panel();
        GridLayout layout = new GridLayout(6, 1);
        this.add((Component)buttons, "West");
        buttons.setLayout(layout);
        layout.setVgap(5);
        this.b = new Button[6];
        this.b[0] = new Button("New...");
        buttons.add(this.b[0]);
        this.b[0].addActionListener(this);
        this.b[0].setActionCommand("new");
        this.b[1] = new Button("Copy...");
        buttons.add(this.b[1]);
        this.b[1].addActionListener(this);
        this.b[1].setActionCommand("copy");
        this.b[2] = new Button("Delete...");
        buttons.add(this.b[2]);
        this.b[2].addActionListener(this);
        this.b[2].setActionCommand("delete");
        this.b[3] = new Button("Import...");
        buttons.add(this.b[3]);
        this.b[3].addActionListener(this);
        this.b[3].setActionCommand("import");
        this.b[4] = new Button("Edit...");
        buttons.add(this.b[4]);
        this.b[4].addActionListener(this);
        this.b[4].setActionCommand("edit");
        this.b[5] = new Button("Done");
        buttons.add(this.b[5]);
        this.b[5].addActionListener(this);
        this.b[5].setActionCommand("done");
        this.texList = new List();
        this.add((Component)this.texList, "Center");
        int i = 0;
        while (i < this.theScene.getNumTextures()) {
            this.texList.add(this.theScene.getTexture(i).getName());
            ++i;
        }
        this.texList.addItemListener(this);
        this.texList.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 2 && TexturesDialog.this.texList.getSelectedIndex() != -1) {
                    TexturesDialog.this.actionPerformed(new ActionEvent(TexturesDialog.this.texList, 1001, "edit"));
                }
            }
        });
        sc.addTextureListener(this);
        this.hilightButtons();
        this.pack();
        this.setResizable(false);
        ModellingApp.centerWindow(this);
    }

    public void dispose() {
        this.theScene.removeTextureListener(this);
        super.dispose();
    }

    void hilightButtons() {
        boolean selection = this.texList.getSelectedIndex() != -1;
        this.b[1].setEnabled(selection);
        this.b[2].setEnabled(selection);
        this.b[4].setEnabled(selection);
    }

    public void actionPerformed(ActionEvent e) {
        String command = e.getActionCommand();
        int i = this.texList.getSelectedIndex();
        if (command.equals("new")) {
            TexturesDialog.showNewTextureWindow(this, this.theScene);
        } else if (command.equals("copy")) {
            EntriesDialog dlg = new EntriesDialog((Window)this, "Enter name for new texture:", new String[]{Translate.text("Name")}, new String[]{""});
            String[] val = dlg.getEntries();
            if (val == null) {
                return;
            }
            Texture tex = this.theScene.getTexture(i).duplicate();
            tex.setName(val[0]);
            this.theScene.addTexture(tex);
        } else if (command.equals("delete")) {
            Texture tex = this.theScene.getTexture(i);
            MessageDialog dial = new MessageDialog((Window)this, "Delete texture '" + tex.getName() + "'?", new String[]{Translate.text("button.ok"), Translate.text("button.cancel")});
            if (dial.getChoice() == 1) {
                return;
            }
            this.theScene.removeTexture(i);
        } else if (command.equals("import")) {
            this.showImportWindow();
        } else if (command.equals("edit")) {
            this.setCursor(Cursor.getPredefinedCursor(3));
            Texture tex = this.theScene.getTexture(i);
            tex.edit(this.parent, this.theScene);
            tex.assignNewID();
            this.theScene.changeTexture(i);
            this.setCursor(Cursor.getDefaultCursor());
        } else if (command.equals("done")) {
            this.dispose();
        }
    }

    public void itemStateChanged(ItemEvent e) {
        this.hilightButtons();
    }

    public void itemAdded(int index, Object obj) {
        Texture tex = (Texture)obj;
        this.texList.add(tex.getName(), index);
        this.texList.deselect(this.texList.getSelectedIndex());
        this.texList.select(index);
        this.hilightButtons();
        if (this.parent instanceof LayoutWindow) {
            ((LayoutWindow)this.parent).setModified();
            ((LayoutWindow)this.parent).updateImage();
        }
    }

    public void itemRemoved(int index, Object obj) {
        this.texList.removeAll();
        int j = 0;
        while (j < this.theScene.getNumTextures()) {
            this.texList.add(this.theScene.getTexture(j).getName());
            ++j;
        }
        this.hilightButtons();
        if (this.parent instanceof LayoutWindow) {
            ((LayoutWindow)this.parent).setModified();
            ((LayoutWindow)this.parent).updateImage();
        }
    }

    public void itemChanged(int index, Object obj) {
        Texture tex = (Texture)obj;
        this.texList.replaceItem(tex.getName(), index);
        this.texList.select(index);
        if (this.parent instanceof LayoutWindow) {
            ((LayoutWindow)this.parent).setModified();
            ((LayoutWindow)this.parent).updateImage();
        }
    }

    public static void showNewTextureWindow(Window parent, Scene theScene) {
        parent.setCursor(Cursor.getPredefinedCursor(3));
        TextField nameField = new TextField();
        Choice typeChoice = new Choice();
        Class[] types = ModellingApp.getTextureTypes();
        int j = 0;
        while (j < types.length) {
            try {
                Method mtd = types[j].getMethod("getTypeName", null);
                typeChoice.add((String)mtd.invoke(null, null));
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
            ++j;
        }
        int j2 = 0;
        int k = -1;
        String name = "";
        while (theScene.getTexture(name = "Untitled " + ++j2) != null) {
        }
        nameField.setText(name);
        nameField.selectAll();
        ComponentsDialog dlg = new ComponentsDialog(parent, "Select name and type for new texture:", new Component[]{nameField, typeChoice}, new String[]{Translate.text("Name"), "Type"});
        if (dlg.clickedOk()) {
            Container frame = parent;
            while (!(frame instanceof Frame)) {
                frame = frame.getParent();
            }
            try {
                Texture tex = (Texture)types[typeChoice.getSelectedIndex()].newInstance();
                tex.setName(nameField.getText());
                theScene.addTexture(tex);
                tex.edit((Frame)frame, theScene);
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        parent.setCursor(Cursor.getDefaultCursor());
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void showImportWindow() {
        FileDialog fd = new FileDialog(this.parent, "Import Textures from Scene File", 0);
        fd.show();
        if (fd.getFile() == null) {
            return;
        }
        File f = new File(fd.getDirectory(), fd.getFile());
        FilterInputStream in = null;
        Scene sc = null;
        try {
            try {
                in = new DataInputStream(new GZIPInputStream(new BufferedInputStream(new FileInputStream(f))));
                sc = new Scene((DataInputStream)in, false);
            }
            catch (InvalidObjectException ex) {
                new MessageDialog((Window)this.parent, new String[]{"An error occurred while reading the file.  This file may", "have been created with a later version of Art of Illusion."});
                Object var8_6 = null;
                try {
                    in.close();
                    return;
                }
                catch (Exception ex2) {
                    new MessageDialog((Window)this.parent, new String[]{"An error occurred while reading the file.", ex2.getMessage()});
                    return;
                }
            }
            catch (IOException ex) {
                new MessageDialog((Window)this.parent, new String[]{"An error occurred while reading the file.", ex.getMessage()});
                Object var8_7 = null;
                try {}
                catch (Exception ex2) {
                    new MessageDialog((Window)this.parent, new String[]{"An error occurred while reading the file.", ex2.getMessage()});
                    return;
                }
                in.close();
                return;
            }
            Object var8_5 = null;
        }
        catch (Throwable throwable) {
            Object var8_8 = null;
            try {}
            catch (Exception ex2) {
                new MessageDialog((Window)this.parent, new String[]{"An error occurred while reading the file.", ex2.getMessage()});
                return;
            }
            in.close();
            throw throwable;
        }
        try {}
        catch (Exception ex2) {
            new MessageDialog((Window)this.parent, new String[]{"An error occurred while reading the file.", ex2.getMessage()});
            return;
        }
        in.close();
        if (sc.getNumTextures() == 0) {
            new MessageDialog((Window)this.parent, "This file does not contain any textures.");
            return;
        }
        Panel mainPanel = new Panel();
        Panel p = new Panel();
        final List baseList = new List();
        final List importList = new List();
        final Button addButton = new Button("Add >>");
        final Button removeButton = new Button("<< Remove");
        final Vector<Texture> baseVec = new Vector<Texture>();
        final Vector importVec = new Vector();
        final MaterialPreviewer preview = new MaterialPreviewer(sc.getTexture(0), null, 160, 160);
        int i = 0;
        while (true) {
            if (i >= sc.getNumTextures()) {
                ItemListener itemListen = new ItemListener(){

                    public void itemStateChanged(ItemEvent ev) {
                        if (ev.getSource() == baseList && baseList.getSelectedIndex() > -1) {
                            if (importList.getSelectedIndex() > -1) {
                                importList.deselect(importList.getSelectedIndex());
                            }
                            addButton.setEnabled(true);
                            removeButton.setEnabled(false);
                            Texture tex = (Texture)baseVec.elementAt(baseList.getSelectedIndex());
                            preview.setTexture(tex, tex.getDefaultMapping());
                            preview.render();
                        } else if (importList.getSelectedIndex() > -1) {
                            if (baseList.getSelectedIndex() > -1) {
                                baseList.deselect(baseList.getSelectedIndex());
                            }
                            addButton.setEnabled(false);
                            removeButton.setEnabled(true);
                            Texture tex = (Texture)importVec.elementAt(importList.getSelectedIndex());
                            preview.setTexture(tex, tex.getDefaultMapping());
                            preview.render();
                        }
                    }
                };
                baseList.addItemListener(itemListen);
                importList.addItemListener(itemListen);
                baseList.select(0);
                ActionListener actionListen = new ActionListener(){

                    public void actionPerformed(ActionEvent ev) {
                        Texture tex;
                        int which;
                        if (ev.getSource() == addButton) {
                            which = baseList.getSelectedIndex();
                            if (which < 0) {
                                return;
                            }
                            tex = (Texture)baseVec.elementAt(which);
                            baseVec.removeElementAt(which);
                            baseList.remove(which);
                            importVec.addElement(tex);
                            importList.add(tex.getName());
                            addButton.setEnabled(false);
                        }
                        if (ev.getSource() == removeButton) {
                            which = importList.getSelectedIndex();
                            if (which < 0) {
                                return;
                            }
                            tex = (Texture)importVec.elementAt(which);
                            importVec.removeElementAt(which);
                            importList.remove(which);
                            baseVec.addElement(tex);
                            baseList.add(tex.getName());
                            removeButton.setEnabled(false);
                        }
                    }
                };
                addButton.addActionListener(actionListen);
                removeButton.addActionListener(actionListen);
                removeButton.setEnabled(false);
                p.setLayout(new GridBagLayout());
                GridBagConstraints gc = new GridBagConstraints();
                gc.gridx = 0;
                gc.fill = 2;
                gc.insets.bottom = 5;
                gc.insets.top = 5;
                p.add((Component)addButton, gc);
                p.add((Component)removeButton, gc);
                mainPanel.setLayout(new GridBagLayout());
                gc = new GridBagConstraints();
                gc.gridy = 0;
                gc.weighty = 1.0;
                gc.weightx = 1.0;
                gc.fill = 1;
                gc.ipadx = 20;
                mainPanel.add((Component)baseList, gc);
                gc.weightx = 0.0;
                gc.ipadx = 0;
                mainPanel.add((Component)p, gc);
                gc.weightx = 1.0;
                gc.ipadx = 50;
                mainPanel.add((Component)importList, gc);
                gc.weightx = 0.0;
                gc.ipadx = 0;
                mainPanel.add((Component)preview, gc);
                PanelDialog dlg = new PanelDialog((Window)this.parent, "Select Textures to Import:", mainPanel);
                if (dlg.clickedOk()) break;
                return;
            }
            baseVec.addElement(sc.getTexture(i));
            baseList.add(sc.getTexture(i).getName());
            ++i;
        }
        boolean[] imageUsed = new boolean[sc.getNumImages()];
        int i2 = 0;
        block11: while (i2 < importVec.size()) {
            Texture tex = (Texture)importVec.elementAt(i2);
            int j = 0;
            while (true) {
                if (j >= imageUsed.length) {
                    this.theScene.addTexture(tex);
                    ++i2;
                    continue block11;
                }
                if (!imageUsed[j] && tex.usesImage(sc.getImage(j))) {
                    this.theScene.addImage(sc.getImage(j));
                    imageUsed[j] = true;
                }
                ++j;
            }
            break;
        }
        return;
    }
}

