/*
 * Decompiled with CFR 0.152.
 */
package artofillusion;

import artofillusion.Camera;
import artofillusion.MeshEditorWindow;
import artofillusion.MeshViewer;
import artofillusion.ObjectViewer;
import artofillusion.UndoRecord;
import artofillusion.ViewerCanvas;
import artofillusion.math.Vec2;
import artofillusion.math.Vec3;
import artofillusion.object.Mesh;
import artofillusion.object.MeshVertex;
import artofillusion.ui.EditingTool;
import artofillusion.ui.EditingWindow;
import artofillusion.ui.Translate;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.text.NumberFormat;

public class ThickenMeshTool
extends EditingTool {
    boolean dragged;
    static Image icon;
    static Image selectedIcon;
    Point clickPoint;
    Vec3[] norm;

    public ThickenMeshTool(EditingWindow fr) {
        super(fr);
        icon = this.loadImage("outsetPoints.gif");
        selectedIcon = this.loadImage("selected/outsetPoints.gif");
    }

    public void activate() {
        super.activate();
        MeshViewer view = ((MeshEditorWindow)this.theFrame).theView;
        int[] selected = view.getSelectionDistance();
        int i = 0;
        while (i < selected.length) {
            if (selected[i] == 0) {
                this.theWindow.setHelpText(Translate.text("thickenMeshTool.helpText"));
                return;
            }
            ++i;
        }
        this.theWindow.setHelpText(Translate.text("thickenMeshTool.errorText"));
    }

    public Image getIcon() {
        return icon;
    }

    public Image getSelectedIcon() {
        return selectedIcon;
    }

    public void mousePressed(MouseEvent e, ViewerCanvas view) {
        Mesh mesh = (Mesh)((Object)((MeshViewer)view).getObject().object);
        MeshVertex[] v = mesh.getVertices();
        this.clickPoint = e.getPoint();
        this.dragged = false;
        this.norm = mesh.getNormals();
    }

    public void mouseDragged(MouseEvent e, ViewerCanvas view) {
        Mesh mesh = (Mesh)((Object)((MeshViewer)view).getObject().object);
        MeshVertex[] vert = mesh.getVertices();
        Graphics g = view.getGraphics();
        Camera cam = view.getCamera();
        Point dragPoint = e.getPoint();
        int size = 5;
        int[] selectDist = ((MeshViewer)view).getSelectionDistance();
        if (this.dragged) {
            view.drawImage(g);
        }
        this.dragged = true;
        double distance = 0.01 * (double)(this.clickPoint.y - dragPoint.y);
        Vec3[] v = this.findNewPositions(mesh, vert, (MeshViewer)view, distance);
        g.setColor(Color.gray);
        int i = 0;
        while (i < v.length) {
            if (selectDist[i] > -1) {
                Vec2 p = cam.getObjectToScreen().timesXY(v[i]);
                g.fillRect((int)p.x - size / 2, (int)p.y - size / 2, size, size);
            }
            ++i;
        }
        ((MeshViewer)view).drawDraggedSelection(g, cam, v);
        NumberFormat format = NumberFormat.getNumberInstance();
        format.setMaximumFractionDigits(2);
        if (distance < 0.0) {
            this.theWindow.setHelpText(Translate.text("thickenMeshTool.dragText.inward", format.format(-distance)));
        } else {
            this.theWindow.setHelpText(Translate.text("thickenMeshTool.dragText.outward", format.format(distance)));
        }
        g.dispose();
    }

    public void mouseReleased(MouseEvent e, ViewerCanvas view) {
        Mesh mesh = (Mesh)((Object)((MeshViewer)view).getObject().object);
        MeshVertex[] vert = mesh.getVertices();
        Camera cam = view.getCamera();
        Point dragPoint = e.getPoint();
        double distance = 0.01 * (double)(this.clickPoint.y - dragPoint.y);
        if (distance != 0.0) {
            this.theWindow.setUndoRecord(new UndoRecord(this.theWindow, false, 0, new Object[]{mesh, mesh.duplicate()}));
            Vec3[] v = this.findNewPositions(mesh, vert, (MeshViewer)view, distance);
            mesh.setVertices(v);
        }
        ((ObjectViewer)view).objectChanged();
        this.theWindow.updateImage();
        this.theWindow.setHelpText(Translate.text("thickenMeshTool.helpText"));
        this.norm = null;
    }

    Vec3[] findNewPositions(Mesh mesh, MeshVertex[] vert, MeshViewer view, double distance) {
        Vec3[] v = new Vec3[vert.length];
        int[] selected = view.getSelectionDistance();
        int i = 0;
        while (i < v.length) {
            v[i] = selected[i] == 0 ? this.norm[i].times(distance) : new Vec3();
            ++i;
        }
        ((MeshEditorWindow)this.theFrame).adjustDeltas(v);
        int i2 = 0;
        while (i2 < vert.length) {
            v[i2].add(vert[i2].r);
            ++i2;
        }
        return v;
    }
}

