/*
 * Decompiled with CFR 0.152.
 */
package artofillusion;

import artofillusion.math.SVD;
import artofillusion.math.Vec3;
import artofillusion.object.TriangleMesh;
import java.util.Vector;

public class TriMeshBeveler {
    TriangleMesh mesh;
    boolean[] selectedFace;
    Vec3[][] faceInsets;
    Vec3[] faceNormal;
    Vector newIndex;

    public TriMeshBeveler(TriangleMesh theMesh, boolean[] selection, double height, double width, boolean apply) {
        this.mesh = theMesh;
        this.selectedFace = selection;
        this.newIndex = new Vector();
        if (apply) {
            this.bevelMeshSelection(height, width);
        } else {
            this.bevelMeshFaces(height, width);
        }
    }

    void bevelMeshFaces(double height, double width) {
        int j;
        TriangleMesh.Vertex[] v = (TriangleMesh.Vertex[])this.mesh.getVertices();
        TriangleMesh.Edge[] e = this.mesh.getEdges();
        TriangleMesh.Face[] f = this.mesh.getFaces();
        Vector<int[]> face = new Vector<int[]>();
        Vector<TriangleMesh.Vertex> vert = new Vector<TriangleMesh.Vertex>();
        this.findVertexInsets(height, width);
        int i = 0;
        while (i < v.length) {
            vert.addElement(v[i]);
            ++i;
        }
        i = 0;
        while (i < f.length) {
            if (this.selectedFace[i]) {
                j = vert.size();
                vert.addElement(this.offsetVertex(this.mesh, v[f[i].v1], this.faceInsets[i][0]));
                vert.addElement(this.offsetVertex(this.mesh, v[f[i].v2], this.faceInsets[i][1]));
                vert.addElement(this.offsetVertex(this.mesh, v[f[i].v3], this.faceInsets[i][2]));
                this.newIndex.addElement(new Integer(face.size()));
                face.addElement(new int[]{j, j + 1, j + 2});
                face.addElement(new int[]{f[i].v1, f[i].v2, j});
                face.addElement(new int[]{j, f[i].v2, j + 1});
                face.addElement(new int[]{f[i].v2, f[i].v3, j + 1});
                face.addElement(new int[]{j + 1, f[i].v3, j + 2});
                face.addElement(new int[]{f[i].v3, f[i].v1, j + 2});
                face.addElement(new int[]{j + 2, f[i].v1, j});
            } else {
                face.addElement(new int[]{f[i].v1, f[i].v2, f[i].v3});
            }
            ++i;
        }
        int[][] newface = new int[face.size()][];
        TriangleMesh.Vertex[] newvert = new TriangleMesh.Vertex[vert.size()];
        i = 0;
        while (i < face.size()) {
            newface[i] = (int[])face.elementAt(i);
            ++i;
        }
        i = 0;
        while (i < vert.size()) {
            newvert[i] = (TriangleMesh.Vertex)vert.elementAt(i);
            ++i;
        }
        this.mesh.setShape(newvert, newface);
        TriangleMesh.Edge[] newe = this.mesh.getEdges();
        i = 0;
        while (i < e.length) {
            j = 0;
            while (j < newe.length) {
                if (e[i].v1 == newe[j].v1 && e[i].v2 == newe[j].v2 || e[i].v1 == newe[j].v2 && e[i].v2 == newe[j].v1) {
                    newe[j].smoothness = e[i].smoothness;
                    break;
                }
                ++j;
            }
            ++i;
        }
    }

    void findVertexInsets(double height, double width) {
        TriangleMesh.Vertex[] v = (TriangleMesh.Vertex[])this.mesh.getVertices();
        TriangleMesh.Face[] f = this.mesh.getFaces();
        this.faceInsets = new Vec3[f.length][];
        int i = 0;
        while (i < f.length) {
            if (this.selectedFace[i]) {
                this.faceInsets[i] = new Vec3[3];
                Vec3 e1 = v[f[i].v2].r.minus(v[f[i].v1].r);
                Vec3 e2 = v[f[i].v3].r.minus(v[f[i].v2].r);
                Vec3 e3 = v[f[i].v1].r.minus(v[f[i].v3].r);
                e1.normalize();
                e2.normalize();
                e3.normalize();
                Vec3 normal = e1.cross(e2);
                double length = normal.length();
                if (length == 0.0) {
                    Vec3 vec3 = new Vec3();
                    this.faceInsets[i][2] = vec3;
                    this.faceInsets[i][1] = vec3;
                    this.faceInsets[i][0] = vec3;
                } else {
                    normal.scale(height / length);
                    double dot = -e1.dot(e3);
                    this.faceInsets[i][0] = e1.minus(e3).times(width / Math.sqrt(1.0 - dot * dot)).plus(normal);
                    dot = -e2.dot(e1);
                    this.faceInsets[i][1] = e2.minus(e1).times(width / Math.sqrt(1.0 - dot * dot)).plus(normal);
                    dot = -e3.dot(e2);
                    this.faceInsets[i][2] = e3.minus(e2).times(width / Math.sqrt(1.0 - dot * dot)).plus(normal);
                }
            }
            ++i;
        }
    }

    void bevelMeshSelection(double height, double width) {
        int[] tempFace;
        int m;
        int n;
        int k;
        int j;
        TriangleMesh.Vertex[] v = (TriangleMesh.Vertex[])this.mesh.getVertices();
        TriangleMesh.Edge[] e = this.mesh.getEdges();
        TriangleMesh.Face[] f = this.mesh.getFaces();
        Vec3 temp = new Vec3();
        Vector<int[]> face = new Vector<int[]>();
        Vector<TriangleMesh.Vertex> vert = new Vector<TriangleMesh.Vertex>();
        Vector<int[]> bevel = new Vector<int[]>();
        boolean[] someSelected = new boolean[v.length];
        boolean[] allSelected = new boolean[v.length];
        boolean[] beveled = new boolean[e.length];
        double[][] coeff = new double[3][3];
        double[] rhs = new double[3];
        this.findEdgeInsets(height, width);
        int i = 0;
        while (i < v.length) {
            vert.addElement(v[i]);
            ++i;
        }
        i = 0;
        while (i < f.length) {
            face.addElement(new int[]{f[i].v1, f[i].v2, f[i].v3});
            ++i;
        }
        i = 0;
        while (i < v.length) {
            allSelected[i] = true;
            ++i;
        }
        i = 0;
        while (i < f.length) {
            if (this.selectedFace[i]) {
                someSelected[f[i].v3] = true;
                someSelected[f[i].v2] = true;
                someSelected[f[i].v1] = true;
            } else {
                allSelected[f[i].v3] = false;
                allSelected[f[i].v2] = false;
                allSelected[f[i].v1] = false;
            }
            ++i;
        }
        int[][] vertFace = new int[v.length][];
        int[] numVertFaces = new int[v.length];
        i = 0;
        while (i < f.length) {
            if (this.selectedFace[i]) {
                int n2 = f[i].v1;
                numVertFaces[n2] = numVertFaces[n2] + 1;
                int n3 = f[i].v2;
                numVertFaces[n3] = numVertFaces[n3] + 1;
                int n4 = f[i].v3;
                numVertFaces[n4] = numVertFaces[n4] + 1;
            }
            ++i;
        }
        i = 0;
        while (i < v.length) {
            vertFace[i] = new int[numVertFaces[i]];
            numVertFaces[i] = 0;
            ++i;
        }
        i = 0;
        while (i < f.length) {
            if (this.selectedFace[i]) {
                int n5 = f[i].v1;
                int n6 = numVertFaces[n5];
                numVertFaces[n5] = n6 + 1;
                vertFace[f[i].v1][n6] = i;
                int n7 = f[i].v2;
                int n8 = numVertFaces[n7];
                numVertFaces[n7] = n8 + 1;
                vertFace[f[i].v2][n8] = i;
                int n9 = f[i].v3;
                int n10 = numVertFaces[n9];
                numVertFaces[n9] = n10 + 1;
                vertFace[f[i].v3][n10] = i;
            }
            ++i;
        }
        i = 0;
        while (i < v.length) {
            if (allSelected[i]) {
                j = 0;
                while (j < 3) {
                    coeff[j][2] = 0.0;
                    coeff[j][1] = 0.0;
                    coeff[j][0] = 0.0;
                    rhs[j] = 0.0;
                    ++j;
                }
                j = 0;
                while (j < numVertFaces[i]) {
                    double[] dArray = coeff[0];
                    dArray[0] = dArray[0] + this.faceNormal[vertFace[i][j]].x * this.faceNormal[vertFace[i][j]].x;
                    double[] dArray2 = coeff[0];
                    dArray2[1] = dArray2[1] + this.faceNormal[vertFace[i][j]].x * this.faceNormal[vertFace[i][j]].y;
                    double[] dArray3 = coeff[0];
                    dArray3[2] = dArray3[2] + this.faceNormal[vertFace[i][j]].x * this.faceNormal[vertFace[i][j]].z;
                    double[] dArray4 = coeff[1];
                    dArray4[1] = dArray4[1] + this.faceNormal[vertFace[i][j]].y * this.faceNormal[vertFace[i][j]].y;
                    double[] dArray5 = coeff[1];
                    dArray5[2] = dArray5[2] + this.faceNormal[vertFace[i][j]].y * this.faceNormal[vertFace[i][j]].z;
                    double[] dArray6 = coeff[2];
                    dArray6[2] = dArray6[2] + this.faceNormal[vertFace[i][j]].z * this.faceNormal[vertFace[i][j]].z;
                    rhs[0] = rhs[0] + height * this.faceNormal[vertFace[i][j]].x;
                    rhs[1] = rhs[1] + height * this.faceNormal[vertFace[i][j]].y;
                    rhs[2] = rhs[2] + height * this.faceNormal[vertFace[i][j]].z;
                    this.newIndex.addElement(new Integer(vertFace[i][j]));
                    ++j;
                }
                coeff[1][0] = coeff[0][1];
                coeff[2][0] = coeff[0][2];
                coeff[2][1] = coeff[1][2];
                SVD.solve(coeff, rhs, 0.001);
                temp.set(rhs[0], rhs[1], rhs[2]);
                vert.setElementAt(this.offsetVertex(this.mesh, (TriangleMesh.Vertex)vert.elementAt(i), temp), i);
            } else if (someSelected[i]) {
                TriangleMesh.Face f2;
                TriangleMesh.Face f1;
                boolean[][] touching = new boolean[numVertFaces[i]][numVertFaces[i]];
                j = 1;
                while (j < numVertFaces[i]) {
                    k = 0;
                    while (k < j) {
                        f1 = f[vertFace[i][j]];
                        f2 = f[vertFace[i][k]];
                        if (f1.e1 == f2.e1 || f1.e1 == f2.e2 || f1.e1 == f2.e3 || f1.e2 == f2.e1 || f1.e2 == f2.e2 || f1.e2 == f2.e3 || f1.e3 == f2.e1 || f1.e3 == f2.e2 || f1.e3 == f2.e3) {
                            touching[k][j] = true;
                            touching[j][k] = true;
                        }
                        ++k;
                    }
                    ++j;
                }
                int[] touchCount = new int[numVertFaces[i]];
                j = 0;
                while (j < numVertFaces[i]) {
                    k = 0;
                    while (k < numVertFaces[i]) {
                        int n11 = j;
                        touchCount[n11] = touchCount[n11] + (touching[j][k] ? 1 : 0);
                        ++k;
                    }
                    ++j;
                }
                boolean[] inGroup = new boolean[numVertFaces[i]];
                int[] group = new int[numVertFaces[i]];
                block14: while (true) {
                    int groupCount = 0;
                    j = 0;
                    while (j < numVertFaces[i] && (inGroup[j] || touchCount[j] > 1)) {
                        ++j;
                    }
                    if (j == numVertFaces[i]) break;
                    inGroup[j] = true;
                    group[0] = j;
                    groupCount = 1;
                    block16: while (touchCount[j] > (groupCount == 1 ? 0 : 1)) {
                        j = 0;
                        while (j < numVertFaces[i]) {
                            if (!inGroup[j] && touching[group[groupCount - 1]][j]) {
                                group[groupCount++] = j;
                                inGroup[j] = true;
                                continue block16;
                            }
                            ++j;
                        }
                    }
                    if (groupCount == 1) {
                        f1 = f[vertFace[i][group[0]]];
                        n = -1;
                        m = -1;
                        if (e[f1.e1].v1 == i || e[f1.e1].v2 == i) {
                            bevel.addElement(new int[]{vertFace[i][group[0]], f1.e1});
                            m = 0;
                        }
                        if (e[f1.e2].v1 == i || e[f1.e2].v2 == i) {
                            bevel.addElement(new int[]{vertFace[i][group[0]], f1.e2});
                            if (m == -1) {
                                m = 1;
                            } else {
                                n = 1;
                            }
                        }
                        if (e[f1.e3].v1 == i || e[f1.e3].v2 == i) {
                            bevel.addElement(new int[]{vertFace[i][group[0]], f1.e3});
                            n = 2;
                        }
                    } else {
                        f1 = f[vertFace[i][group[0]]];
                        f2 = f[vertFace[i][group[1]]];
                        if ((e[f1.e1].v1 == i || e[f1.e1].v2 == i) && f2.e1 != f1.e1 && f2.e2 != f1.e1 && f2.e3 != f1.e1) {
                            bevel.addElement(new int[]{vertFace[i][group[0]], f1.e1});
                            m = 0;
                        } else if ((e[f1.e2].v1 == i || e[f1.e2].v2 == i) && f2.e1 != f1.e2 && f2.e2 != f1.e2 && f2.e3 != f1.e2) {
                            bevel.addElement(new int[]{vertFace[i][group[0]], f1.e2});
                            m = 1;
                        } else {
                            bevel.addElement(new int[]{vertFace[i][group[0]], f1.e3});
                            m = 2;
                        }
                        f1 = f[vertFace[i][group[groupCount - 1]]];
                        f2 = f[vertFace[i][group[groupCount - 2]]];
                        if ((e[f1.e1].v1 == i || e[f1.e1].v2 == i) && f2.e1 != f1.e1 && f2.e2 != f1.e1 && f2.e3 != f1.e1) {
                            bevel.addElement(new int[]{vertFace[i][group[groupCount - 1]], f1.e1});
                            n = 0;
                        } else if ((e[f1.e2].v1 == i || e[f1.e2].v2 == i) && f2.e1 != f1.e2 && f2.e2 != f1.e2 && f2.e3 != f1.e2) {
                            bevel.addElement(new int[]{vertFace[i][group[groupCount - 1]], f1.e2});
                            n = 1;
                        } else {
                            bevel.addElement(new int[]{vertFace[i][group[groupCount - 1]], f1.e3});
                            n = 2;
                        }
                    }
                    coeff[0][0] = this.faceInsets[vertFace[i][group[0]]][m].x;
                    coeff[0][1] = this.faceInsets[vertFace[i][group[0]]][m].y;
                    coeff[0][2] = this.faceInsets[vertFace[i][group[0]]][m].z;
                    coeff[1][0] = this.faceInsets[vertFace[i][group[groupCount - 1]]][n].x;
                    coeff[1][1] = this.faceInsets[vertFace[i][group[groupCount - 1]]][n].y;
                    coeff[1][2] = this.faceInsets[vertFace[i][group[groupCount - 1]]][n].z;
                    coeff[2][0] = this.faceNormal[vertFace[i][group[0]]].x + this.faceNormal[vertFace[i][group[groupCount - 1]]].x;
                    coeff[2][1] = this.faceNormal[vertFace[i][group[0]]].y + this.faceNormal[vertFace[i][group[groupCount - 1]]].y;
                    coeff[2][2] = this.faceNormal[vertFace[i][group[0]]].z + this.faceNormal[vertFace[i][group[groupCount - 1]]].z;
                    rhs[0] = rhs[1] = width;
                    rhs[2] = 2.0 * height;
                    SVD.solve(coeff, rhs, 0.001);
                    temp.set(rhs[0], rhs[1], rhs[2]);
                    vert.addElement(this.offsetVertex(this.mesh, (TriangleMesh.Vertex)vert.elementAt(i), temp));
                    k = vert.size() - 1;
                    j = 0;
                    while (true) {
                        if (j >= groupCount) continue block14;
                        tempFace = (int[])face.elementAt(vertFace[i][group[j]]);
                        f1 = f[vertFace[i][group[j]]];
                        if (f1.v1 == i) {
                            tempFace[0] = k;
                        } else if (f1.v2 == i) {
                            tempFace[1] = k;
                        } else {
                            tempFace[2] = k;
                        }
                        this.newIndex.addElement(new Integer(vertFace[i][group[j]]));
                        ++j;
                    }
                    break;
                }
            }
            ++i;
        }
        i = 0;
        while (i < bevel.size()) {
            int[] bev = (int[])bevel.elementAt(i);
            if (!beveled[bev[1]]) {
                beveled[bev[1]] = true;
                j = e[bev[1]].v1;
                k = e[bev[1]].v2;
                if (f[bev[0]].v1 == k && f[bev[0]].v2 == j || f[bev[0]].v2 == k && f[bev[0]].v3 == j || f[bev[0]].v3 == k && f[bev[0]].v1 == j) {
                    m = j;
                    j = k;
                    k = m;
                }
                tempFace = (int[])face.elementAt(bev[0]);
                m = f[bev[0]].v1 == j ? tempFace[0] : (f[bev[0]].v2 == j ? tempFace[1] : tempFace[2]);
                n = f[bev[0]].v1 == k ? tempFace[0] : (f[bev[0]].v2 == k ? tempFace[1] : tempFace[2]);
                face.addElement(new int[]{j, k, m});
                face.addElement(new int[]{m, k, n});
            }
            ++i;
        }
        int[][] newface = new int[face.size()][];
        TriangleMesh.Vertex[] newvert = new TriangleMesh.Vertex[vert.size()];
        i = 0;
        while (i < face.size()) {
            newface[i] = (int[])face.elementAt(i);
            ++i;
        }
        i = 0;
        while (i < vert.size()) {
            newvert[i] = (TriangleMesh.Vertex)vert.elementAt(i);
            ++i;
        }
        this.mesh.setShape(newvert, newface);
        TriangleMesh.Edge[] newe = this.mesh.getEdges();
        i = 0;
        while (i < e.length) {
            j = 0;
            while (j < newe.length) {
                if (e[i].v1 == newe[j].v1 && e[i].v2 == newe[j].v2 || e[i].v1 == newe[j].v2 && e[i].v2 == newe[j].v1) {
                    newe[j].smoothness = e[i].smoothness;
                    break;
                }
                ++j;
            }
            ++i;
        }
    }

    void findEdgeInsets(double height, double width) {
        TriangleMesh.Vertex[] v = (TriangleMesh.Vertex[])this.mesh.getVertices();
        TriangleMesh.Face[] f = this.mesh.getFaces();
        this.faceInsets = new Vec3[f.length][];
        this.faceNormal = new Vec3[f.length];
        int i = 0;
        while (i < f.length) {
            if (this.selectedFace[i]) {
                this.faceInsets[i] = new Vec3[3];
                Vec3 e1 = v[f[i].v2].r.minus(v[f[i].v1].r);
                Vec3 e2 = v[f[i].v3].r.minus(v[f[i].v2].r);
                Vec3 e3 = v[f[i].v1].r.minus(v[f[i].v3].r);
                e1.normalize();
                e2.normalize();
                e3.normalize();
                this.faceNormal[i] = e1.cross(e2);
                double length = this.faceNormal[i].length();
                if (length == 0.0) {
                    this.faceInsets[i][2] = this.faceNormal[i] = new Vec3();
                    this.faceInsets[i][1] = this.faceNormal[i];
                    this.faceInsets[i][0] = this.faceNormal[i];
                } else {
                    this.faceNormal[i].scale(1.0 / length);
                    double dot = -e1.dot(e2);
                    this.faceInsets[i][0] = e2.plus(e1.times(dot));
                    this.faceInsets[i][0].normalize();
                    dot = -e2.dot(e3);
                    this.faceInsets[i][1] = e3.plus(e2.times(dot));
                    this.faceInsets[i][1].normalize();
                    dot = -e3.dot(e1);
                    this.faceInsets[i][2] = e1.plus(e3.times(dot));
                    this.faceInsets[i][2].normalize();
                }
            }
            ++i;
        }
    }

    TriangleMesh.Vertex offsetVertex(TriangleMesh mesh, TriangleMesh.Vertex v, Vec3 offset) {
        TriangleMesh.Vertex vert = mesh.new TriangleMesh.Vertex(v);
        vert.r.add(offset);
        vert.edges = 0;
        vert.firstEdge = -1;
        return vert;
    }

    public boolean[] getNewSelection() {
        boolean[] selected = new boolean[this.mesh.getFaces().length];
        int i = 0;
        while (i < this.newIndex.size()) {
            selected[((Integer)this.newIndex.elementAt((int)i)).intValue()] = true;
            ++i;
        }
        return selected;
    }
}

