/*
 * Decompiled with CFR 0.152.
 */
package artofillusion;

import artofillusion.Callback;
import artofillusion.LayoutWindow;
import artofillusion.MeshEditorWindow;
import artofillusion.ModellingApp;
import artofillusion.MoveViewTool;
import artofillusion.ObjectPreviewCanvas;
import artofillusion.ReshapeMeshTool;
import artofillusion.RotateMeshTool;
import artofillusion.RotateViewTool;
import artofillusion.ScaleMeshTool;
import artofillusion.SkewMeshTool;
import artofillusion.TaperMeshTool;
import artofillusion.ThickenMeshTool;
import artofillusion.TriMeshBeveler;
import artofillusion.TriMeshSimplifier;
import artofillusion.TriMeshViewer;
import artofillusion.UndoRecord;
import artofillusion.animation.Joint;
import artofillusion.animation.Skeleton;
import artofillusion.animation.SkeletonTool;
import artofillusion.math.CoordinateSystem;
import artofillusion.math.Vec3;
import artofillusion.object.Curve;
import artofillusion.object.Mesh;
import artofillusion.object.ObjectInfo;
import artofillusion.object.TriangleMesh;
import artofillusion.ui.ComponentsDialog;
import artofillusion.ui.EditingTool;
import artofillusion.ui.EditingWindow;
import artofillusion.ui.EventProcessor;
import artofillusion.ui.GenericTool;
import artofillusion.ui.MessageDialog;
import artofillusion.ui.PanelDialog;
import artofillusion.ui.ToolPalette;
import artofillusion.ui.Translate;
import artofillusion.ui.ValueField;
import artofillusion.ui.ValueSlider;
import java.awt.BorderLayout;
import java.awt.Checkbox;
import java.awt.CheckboxMenuItem;
import java.awt.Choice;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Label;
import java.awt.Menu;
import java.awt.MenuBar;
import java.awt.MenuItem;
import java.awt.Panel;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.TextEvent;
import java.awt.event.TextListener;
import java.util.Vector;

public class TriMeshEditorWindow
extends MeshEditorWindow
implements EditingWindow,
KeyListener,
ActionListener,
ItemListener {
    ToolPalette modes;
    Menu editMenu;
    Menu meshMenu;
    Menu skeletonMenu;
    MenuItem[] editMenuItem;
    MenuItem[] meshMenuItem;
    MenuItem[] skeletonMenuItem;
    CheckboxMenuItem[] smoothItem;
    Callback onClose;
    boolean topology;

    public TriMeshEditorWindow(EditingWindow parent, String title, ObjectInfo obj, Callback onClose, boolean allowTopology) {
        super(parent, title, (Mesh)((Object)obj.object));
        ObjectInfo info = obj.duplicate(obj.object.duplicate());
        this.onClose = onClose;
        this.topology = allowTopology;
        this.helpText = new Label();
        this.add((Component)this.helpText, "South");
        Panel p1 = new Panel();
        this.add((Component)p1, "Center");
        p1.setLayout(new BorderLayout());
        Panel p2 = new Panel();
        p1.add((Component)p2, "North");
        p2.setLayout(new BorderLayout());
        Panel p3 = new Panel();
        p2.add((Component)p3, "West");
        this.theView = new TriMeshViewer(info, p3);
        p1.add((Component)this.theView, "Center");
        p3 = new Panel();
        p2.add((Component)p3, "East");
        p3.add(Translate.button("ok", this));
        p3.add(Translate.button("cancel", this));
        Panel p4 = new Panel();
        this.add((Component)p4, "West");
        p4.setLayout(new BorderLayout());
        this.tools = new ToolPalette(1, 9);
        p4.add((Component)this.tools, "North");
        this.defaultTool = new ReshapeMeshTool(this);
        this.tools.addTool(this.defaultTool);
        this.tools.addTool(new ScaleMeshTool(this));
        this.tools.addTool(new RotateMeshTool(this, false));
        this.tools.addTool(new SkewMeshTool(this));
        this.tools.addTool(new TaperMeshTool(this));
        this.tools.addTool(new ThickenMeshTool(this));
        this.tools.addTool(new SkeletonTool(this));
        MoveViewTool metaTool = new MoveViewTool(this);
        this.tools.addTool(metaTool);
        RotateViewTool altTool = new RotateViewTool(this);
        this.tools.addTool(altTool);
        this.tools.selectTool(this.defaultTool);
        this.theView.setMetaTool(metaTool);
        this.theView.setAltTool(altTool);
        this.modes = new ToolPalette(1, 3);
        p4.add((Component)this.modes, "South");
        this.modes.addTool(new GenericTool(this, "point.gif", "selected/point.gif"));
        this.modes.addTool(new GenericTool(this, "edge.gif", "selected/edge.gif"));
        this.modes.addTool(new GenericTool(this, "face.gif", "selected/face.gif"));
        ((TriMeshViewer)this.theView).setSelectionMode(this.modes.getSelection());
        this.helpText.setBackground(ModellingApp.APP_BACKGROUND_COLOR);
        p2.setBackground(ModellingApp.APP_BACKGROUND_COLOR);
        p3.setBackground(ModellingApp.APP_BACKGROUND_COLOR);
        p4.setBackground(ModellingApp.APP_BACKGROUND_COLOR);
        this.menubar = new MenuBar();
        this.setMenuBar(this.menubar);
        this.createEditMenu((TriangleMesh)obj.object);
        this.createMeshMenu((TriangleMesh)obj.object);
        this.createSkeletonMenu((TriangleMesh)obj.object);
        this.createViewMenu();
        this.recursivelyAddListeners(this);
        this.oldMesh = (TriangleMesh)obj.object;
        this.pack();
        Dimension d1 = Toolkit.getDefaultToolkit().getScreenSize();
        Dimension d2 = new Dimension(d1.width * 2 / 3, d1.height * 2 / 3);
        ((Component)this).setSize(d2);
        ((Component)this).setLocation((d1.width - d2.width) / 2, (d1.height - d2.height) / 2);
        this.tools.requestFocus();
        this.updateMenus();
    }

    void createEditMenu(TriangleMesh obj) {
        this.editMenu = Translate.menu("edit");
        this.menubar.add(this.editMenu);
        this.editMenuItem = new MenuItem[6];
        this.undoItem = Translate.menuItem("undo", this);
        this.editMenu.add(this.undoItem);
        this.undoItem.setEnabled(false);
        this.editMenu.addSeparator();
        this.editMenuItem[0] = Translate.menuItem("clear", this);
        if (this.topology) {
            this.editMenu.add(this.editMenuItem[0]);
        }
        this.editMenu.add(Translate.menuItem("selectAll", this));
        this.editMenuItem[1] = Translate.menuItem("selectBoundary", this);
        this.editMenu.add(this.editMenuItem[1]);
        this.editMenuItem[2] = Translate.menuItem("extendSelection", this);
        this.editMenu.add(this.editMenuItem[2]);
        this.editMenuItem[3] = Translate.checkboxMenuItem("tolerantSelection", this, false);
        this.editMenu.add(this.editMenuItem[3]);
        this.editMenuItem[4] = Translate.checkboxMenuItem("freehandSelection", this, false);
        this.editMenu.add(this.editMenuItem[4]);
        this.editMenuItem[5] = Translate.checkboxMenuItem("displayAsQuads", this, false);
        this.editMenu.add(this.editMenuItem[5]);
        this.editMenu.addSeparator();
        this.editMenu.add(Translate.menuItem("meshTension", this));
    }

    void createMeshMenu(TriangleMesh obj) {
        this.meshMenu = Translate.menu("mesh");
        this.menubar.add(this.meshMenu);
        this.meshMenuItem = new MenuItem[11];
        this.meshMenuItem[0] = Translate.menuItem("subdivideEdges", this);
        if (this.topology) {
            this.meshMenu.add(this.meshMenuItem[0]);
        }
        this.meshMenuItem[1] = Translate.menuItem("simplify", this);
        if (this.topology) {
            this.meshMenu.add(this.meshMenuItem[1]);
        }
        this.meshMenuItem[2] = Translate.menuItem("editPoints", this);
        this.meshMenu.add(this.meshMenuItem[2]);
        this.meshMenuItem[3] = Translate.menuItem("transformPoints", this);
        this.meshMenu.add(this.meshMenuItem[3]);
        this.meshMenuItem[4] = Translate.menuItem("randomize", this);
        this.meshMenu.add(this.meshMenuItem[4]);
        this.meshMenuItem[5] = Translate.menuItem("bevel", this);
        if (this.topology) {
            this.meshMenu.add(this.meshMenuItem[5]);
        }
        this.meshMenuItem[6] = Translate.menuItem("parameters", this);
        this.meshMenu.add(this.meshMenuItem[6]);
        if (this.topology) {
            this.meshMenu.add(Translate.menuItem("optimize", this));
        }
        this.meshMenu.add(Translate.menuItem("centerMesh", this));
        this.meshMenu.addSeparator();
        this.meshMenuItem[7] = Translate.menuItem("closeBoundary", this);
        if (this.topology) {
            this.meshMenu.add(this.meshMenuItem[7]);
        }
        this.meshMenuItem[8] = Translate.menuItem("joinBoundaries", this);
        if (this.topology) {
            this.meshMenu.add(this.meshMenuItem[8]);
        }
        this.meshMenuItem[9] = Translate.menuItem("extractCurve", this);
        this.meshMenu.add(this.meshMenuItem[9]);
        this.meshMenu.addSeparator();
        this.meshMenuItem[10] = Translate.menuItem("smoothness", this);
        this.meshMenu.add(this.meshMenuItem[10]);
        Menu smoothMenu = Translate.menu("smoothingMethod");
        this.meshMenu.add(smoothMenu);
        this.smoothItem = new CheckboxMenuItem[4];
        this.smoothItem[0] = Translate.checkboxMenuItem("none", this, obj.getSmoothingMethod() == 0);
        smoothMenu.add(this.smoothItem[0]);
        this.smoothItem[1] = Translate.checkboxMenuItem("shading", this, obj.getSmoothingMethod() == 1);
        smoothMenu.add(this.smoothItem[1]);
        this.smoothItem[2] = Translate.checkboxMenuItem("interpolating", this, obj.getSmoothingMethod() == 2);
        smoothMenu.add(this.smoothItem[2]);
        this.smoothItem[3] = Translate.checkboxMenuItem("approximating", this, obj.getSmoothingMethod() == 3);
        smoothMenu.add(this.smoothItem[3]);
        if (this.topology) {
            this.meshMenu.add(Translate.menuItem("invertNormals", this));
        }
        if (ModellingApp.getPreferences().getObjectPreviewRenderer() != null) {
            this.meshMenu.addSeparator();
            this.meshMenu.add(Translate.menuItem("renderPreview", this));
        }
    }

    void createSkeletonMenu(TriangleMesh obj) {
        this.skeletonMenu = Translate.menu("skeleton");
        this.menubar.add(this.skeletonMenu);
        this.skeletonMenuItem = new MenuItem[4];
        this.skeletonMenuItem[0] = Translate.menuItem("editBone", this);
        this.skeletonMenu.add(this.skeletonMenuItem[0]);
        this.skeletonMenuItem[1] = Translate.menuItem("deleteBone", this);
        this.skeletonMenu.add(this.skeletonMenuItem[1]);
        this.skeletonMenuItem[2] = Translate.menuItem("bindSkeleton", this);
        this.skeletonMenu.add(this.skeletonMenuItem[2]);
        this.skeletonMenu.addSeparator();
        this.skeletonMenuItem[3] = Translate.checkboxMenuItem("detachSkeleton", this, false);
        this.skeletonMenu.add(this.skeletonMenuItem[3]);
    }

    public void setTool(EditingTool tool) {
        if (tool instanceof GenericTool) {
            ((TriMeshViewer)this.theView).setSelectionMode(this.modes.getSelection());
        } else {
            this.theView.setTool(tool);
            this.currentTool = tool;
        }
    }

    public void updateMenus() {
        TriangleMesh theMesh = (TriangleMesh)this.theView.getObject().object;
        boolean[] selected = ((TriMeshViewer)this.theView).getSelection();
        boolean any = false;
        int selectionMode = ((TriMeshViewer)this.theView).getSelectionMode();
        int i = 0;
        while (i < selected.length && !selected[i]) {
            ++i;
        }
        if (i < selected.length) {
            any = true;
            this.editMenuItem[0].setEnabled(true);
            this.editMenuItem[2].setEnabled(true);
            i = 0;
            while (i < 11) {
                this.meshMenuItem[i].setEnabled(true);
                ++i;
            }
            if (selectionMode == 1) {
                this.meshMenuItem[0].setLabel(Translate.text("menu.subdivideEdges"));
                this.meshMenuItem[5].setEnabled(false);
                int[][] boundary = ((TriMeshViewer)this.theView).findSelectedBoundaries();
                this.meshMenuItem[6].setEnabled(boundary.length > 0);
                this.meshMenuItem[8].setEnabled(boundary.length == 2);
            } else if (selectionMode == 2) {
                this.meshMenuItem[0].setLabel(Translate.text("menu.subdivideFaces"));
                this.meshMenuItem[7].setEnabled(false);
                this.meshMenuItem[8].setEnabled(false);
                this.meshMenuItem[9].setEnabled(false);
                this.meshMenuItem[10].setEnabled(false);
            } else {
                this.meshMenuItem[0].setEnabled(false);
                this.meshMenuItem[5].setEnabled(false);
                this.meshMenuItem[7].setEnabled(false);
                this.meshMenuItem[8].setEnabled(false);
                this.meshMenuItem[9].setEnabled(false);
            }
            this.meshMenuItem[1].setLabel(Translate.text("menu.simplify"));
        } else {
            this.editMenuItem[0].setEnabled(false);
            this.editMenuItem[2].setEnabled(false);
            this.meshMenuItem[0].setEnabled(false);
            i = 2;
            while (i < 11) {
                this.meshMenuItem[i].setEnabled(false);
                ++i;
            }
            this.meshMenuItem[1].setLabel(Translate.text("menu.simplifyMesh"));
        }
        this.editMenuItem[1].setEnabled(selectionMode == 1 && !this.theView.getObject().object.isClosed());
        this.templateItem.setEnabled(this.theView.getTemplateImage() != null);
        Skeleton s = theMesh.getSkeleton();
        Joint selJoint = s.getJoint(this.theView.getSelectedJoint());
        this.skeletonMenuItem[0].setEnabled(selJoint != null);
        this.skeletonMenuItem[1].setEnabled(selJoint != null && selJoint.children.length == 0);
        this.skeletonMenuItem[2].setEnabled(any);
    }

    public void keyPressed(KeyEvent e) {
        if (e.getKeyCode() == 127 || e.getKeyCode() == 8) {
            if (this.theView.getCurrentTool() instanceof SkeletonTool) {
                this.deleteJointCommand();
            } else {
                this.deleteCommand();
            }
        } else {
            super.keyPressed(e);
        }
    }

    public void actionPerformed(ActionEvent e) {
        String command = e.getActionCommand();
        this.setCursor(Cursor.getPredefinedCursor(3));
        if (command.equals("ok")) {
            TriangleMesh theMesh = (TriangleMesh)this.theView.getObject().object;
            if (((TriangleMesh)this.oldMesh).getMaterial() != null) {
                if (!theMesh.isClosed()) {
                    this.setCursor(Cursor.getDefaultCursor());
                    MessageDialog dlg = new MessageDialog((Window)this, new String[]{"You have modified this object so that it is no longer a closed surface.", "This means that it can no longer have a material assigned to it.  Are", "you sure you want to continue?"}, new String[]{Translate.text("button.ok"), Translate.text("button.cancel")});
                    if (dlg.getChoice() == 1) {
                        return;
                    }
                    theMesh.setMaterial(null);
                    theMesh.setMaterialMapping(null);
                } else {
                    theMesh.setMaterial(((TriangleMesh)this.oldMesh).getMaterial());
                    theMesh.setMaterialMapping(((TriangleMesh)this.oldMesh).getMaterialMapping());
                }
            }
            this.oldMesh.copyObject(theMesh);
            this.oldMesh = null;
            this.dispose();
            this.onClose.execute();
            this.parentWindow.updateImage();
            this.parentWindow.updateMenus();
        } else if (command.equals("cancel")) {
            this.oldMesh = null;
            this.dispose();
        } else if (command.equals("undo")) {
            this.undoCommand();
        } else if (command.equals("clear")) {
            this.deleteCommand();
        } else if (command.equals("selectAll")) {
            this.selectAllCommand();
        } else if (command.equals("selectBoundary")) {
            this.selectBoundaryCommand();
        } else if (command.equals("extendSelection")) {
            this.extendSelectionCommand();
        } else if (command.equals("subdivideEdges")) {
            this.subdivideCommand();
        } else if (command.equals("simplify")) {
            this.simplifyCommand();
        } else if (command.equals("optimize")) {
            this.optimizeCommand();
        } else if (command.equals("editPoints")) {
            this.setPointsCommand();
        } else if (command.equals("transformPoints")) {
            this.transformPointsCommand();
        } else if (command.equals("randomize")) {
            this.randomizeCommand();
        } else if (command.equals("bevel")) {
            this.bevelCommand();
        } else if (command.equals("parameters")) {
            this.setParametersCommand();
        } else if (command.equals("centerMesh")) {
            this.centerCommand();
        } else if (command.equals("closeBoundary")) {
            this.closeBoundaryCommand();
        } else if (command.equals("joinBoundaries")) {
            this.joinBoundariesCommand();
        } else if (command.equals("extractCurve")) {
            this.extractCurveCommand();
        } else if (command.equals("smoothness")) {
            this.setSmoothnessCommand();
        } else if (command.equals("invertNormals")) {
            this.reverseNormalsCommand();
        } else if (command.equals("meshTension")) {
            this.setTensionCommand();
        } else if (command.equals("renderPreview")) {
            this.theView.previewObject();
        } else if (command.equals("editBone")) {
            this.editJointCommand();
        } else if (command.equals("deleteBone")) {
            this.deleteJointCommand();
        } else if (command.equals("bindSkeleton")) {
            this.bindSkeletonCommand();
        } else if (command.equals("grid")) {
            this.setGridCommand();
        } else if (command.equals("showTemplate")) {
            boolean wasShown = this.theView.getTemplateShown();
            this.templateItem.setLabel(Translate.text(wasShown ? "menu.showTemplate" : "menu.hideTemplate"));
            this.theView.setShowTemplate(!wasShown);
            this.updateImage();
        } else if (command.equals("setTemplate")) {
            this.setTemplateCommand();
        }
        this.setCursor(Cursor.getDefaultCursor());
    }

    public void itemStateChanged(ItemEvent e) {
        Object source = e.getSource();
        if (source == this.editMenuItem[3]) {
            ((TriMeshViewer)this.theView).setTolerant(((CheckboxMenuItem)this.editMenuItem[3]).getState());
            return;
        }
        if (source == this.editMenuItem[4]) {
            ((TriMeshViewer)this.theView).setFreehandSelection(((CheckboxMenuItem)this.editMenuItem[4]).getState());
            return;
        }
        if (source == this.editMenuItem[5]) {
            ((TriMeshViewer)this.theView).setQuadMode(((CheckboxMenuItem)this.editMenuItem[5]).getState());
            this.updateImage();
            return;
        }
        if (source == this.skeletonMenuItem[3]) {
            ((TriMeshViewer)this.theView).setSkeletonDetached(((CheckboxMenuItem)this.skeletonMenuItem[3]).getState());
            return;
        }
        int i = 0;
        while (i < this.smoothItem.length) {
            if (source == this.smoothItem[i]) {
                this.setSmoothingMethod(i);
                return;
            }
            ++i;
        }
        super.itemStateChanged(e);
    }

    void selectAllCommand() {
        TriMeshViewer tmv = (TriMeshViewer)this.theView;
        boolean[] selected = tmv.getSelection();
        int i = 0;
        while (i < selected.length) {
            selected[i] = true;
            ++i;
        }
        if (tmv.getSelectionMode() == 1) {
            int i2 = 0;
            while (i2 < selected.length) {
                if (tmv.isEdgeHidden(i2)) {
                    selected[i2] = false;
                }
                ++i2;
            }
        }
        tmv.setSelection(selected);
    }

    void selectBoundaryCommand() {
        TriangleMesh theMesh = (TriangleMesh)this.theView.getObject().object;
        TriangleMesh.Edge[] edge = theMesh.getEdges();
        boolean[] selected = ((TriMeshViewer)this.theView).getSelection();
        int i = 0;
        while (i < selected.length) {
            selected[i] = edge[i].f2 == -1;
            ++i;
        }
        ((TriMeshViewer)this.theView).setSelection(selected);
    }

    void extendSelectionCommand() {
        TriMeshViewer tmv = (TriMeshViewer)this.theView;
        TriangleMesh theMesh = (TriangleMesh)this.theView.getObject().object;
        int[] dist = tmv.getSelectionDistance();
        boolean[] selectedVert = new boolean[dist.length];
        boolean[] selected = tmv.getSelection();
        TriangleMesh.Edge[] edge = theMesh.getEdges();
        int i = 0;
        while (i < edge.length) {
            if (!(dist[edge[i].v1] != 0 && dist[edge[i].v2] != 0 || tmv.isEdgeHidden(i))) {
                selectedVert[edge[i].v2] = true;
                selectedVert[edge[i].v1] = true;
            }
            ++i;
        }
        if (tmv.getSelectionMode() == 0) {
            tmv.setSelection(selectedVert);
        } else if (tmv.getSelectionMode() == 1) {
            int i2 = 0;
            while (i2 < edge.length) {
                selected[i2] = selectedVert[edge[i2].v1] && selectedVert[edge[i2].v2];
                ++i2;
            }
            tmv.setSelection(selected);
        } else {
            TriangleMesh.Face[] face = theMesh.getFaces();
            int i3 = 0;
            while (i3 < face.length) {
                selected[i3] = selectedVert[face[i3].v1] && selectedVert[face[i3].v2] && selectedVert[face[i3].v3];
                ++i3;
            }
            tmv.setSelection(selected);
        }
    }

    void deleteCommand() {
        int i;
        int i2;
        int i3;
        int i4;
        TriangleMesh theMesh = (TriangleMesh)this.theView.getObject().object;
        TriangleMesh.Vertex[] vert = (TriangleMesh.Vertex[])theMesh.getVertices();
        TriangleMesh.Edge[] edge = theMesh.getEdges();
        TriangleMesh.Face[] face = theMesh.getFaces();
        boolean[] selected = ((TriMeshViewer)this.theView).getSelection();
        boolean[] deleteVert = new boolean[vert.length];
        boolean[] deleteEdge = new boolean[edge.length];
        boolean[] deleteFace = new boolean[face.length];
        if (((TriMeshViewer)this.theView).getSelectionMode() == 0) {
            i4 = 0;
            while (i4 < deleteVert.length) {
                deleteVert[i4] = selected[i4];
                ++i4;
            }
            i3 = 0;
            while (i3 < deleteEdge.length) {
                deleteEdge[i3] = deleteVert[edge[i3].v1] || deleteVert[edge[i3].v2];
                ++i3;
            }
            i2 = 0;
            while (i2 < deleteFace.length) {
                deleteFace[i2] = deleteVert[face[i2].v1] || deleteVert[face[i2].v2] || deleteVert[face[i2].v3];
                ++i2;
            }
        } else if (((TriMeshViewer)this.theView).getSelectionMode() == 1) {
            i4 = 0;
            while (i4 < deleteFace.length) {
                deleteFace[i4] = selected[face[i4].e1] || selected[face[i4].e2] || selected[face[i4].e3];
                ++i4;
            }
            i3 = 0;
            while (i3 < deleteEdge.length) {
                deleteEdge[i3] = deleteFace[edge[i3].f1] && (edge[i3].f2 == -1 || deleteFace[edge[i3].f2]);
                ++i3;
            }
            i2 = 0;
            while (i2 < deleteVert.length) {
                deleteVert[i2] = true;
                ++i2;
            }
            i = 0;
            while (i < deleteFace.length) {
                if (!deleteFace[i]) {
                    deleteVert[face[i].v3] = false;
                    deleteVert[face[i].v2] = false;
                    deleteVert[face[i].v1] = false;
                }
                ++i;
            }
        } else {
            i4 = 0;
            while (i4 < deleteFace.length) {
                deleteFace[i4] = selected[i4];
                ++i4;
            }
            i3 = 0;
            while (i3 < deleteEdge.length) {
                deleteEdge[i3] = deleteFace[edge[i3].f1] && (edge[i3].f2 == -1 || deleteFace[edge[i3].f2]);
                ++i3;
            }
            i2 = 0;
            while (i2 < deleteVert.length) {
                deleteVert[i2] = true;
                ++i2;
            }
            i = 0;
            while (i < deleteFace.length) {
                if (!deleteFace[i]) {
                    deleteVert[face[i].v3] = false;
                    deleteVert[face[i].v2] = false;
                    deleteVert[face[i].v1] = false;
                }
                ++i;
            }
        }
        i4 = 0;
        while (i4 < vert.length) {
            int[] e = vert[i4].getEdges();
            int fprev = edge[e[0]].f1;
            int breaks = 0;
            int j = 1;
            while (j < e.length) {
                int f;
                int n = f = edge[e[j]].f1 == fprev ? edge[e[j]].f2 : edge[e[j]].f1;
                if (f == -1) break;
                if (!deleteFace[fprev] && deleteFace[f]) {
                    ++breaks;
                }
                fprev = f;
                ++j;
            }
            if (!deleteFace[fprev] && (edge[e[0]].f2 == -1 || deleteFace[edge[e[0]].f1])) {
                ++breaks;
            }
            if (breaks > 1) {
                new MessageDialog((Window)this, new String[]{"The selection could not be deleted, because it", "would result in an illegal surface."});
                return;
            }
            ++i4;
        }
        int newVertCount = 0;
        int newFaceCount = 0;
        int[] newVertIndex = new int[vert.length];
        int i5 = 0;
        while (i5 < deleteVert.length) {
            newVertIndex[i5] = -1;
            if (!deleteVert[i5]) {
                ++newVertCount;
            }
            ++i5;
        }
        int i6 = 0;
        while (i6 < deleteFace.length) {
            if (!deleteFace[i6]) {
                ++newFaceCount;
            }
            ++i6;
        }
        TriangleMesh.Vertex[] v = new TriangleMesh.Vertex[newVertCount];
        int[][] f = new int[newFaceCount][];
        newVertCount = 0;
        int i7 = 0;
        while (i7 < vert.length) {
            if (!deleteVert[i7]) {
                newVertIndex[i7] = newVertCount;
                v[newVertCount++] = vert[i7];
            }
            ++i7;
        }
        newFaceCount = 0;
        int i8 = 0;
        while (i8 < face.length) {
            if (!deleteFace[i8]) {
                f[newFaceCount++] = new int[]{newVertIndex[face[i8].v1], newVertIndex[face[i8].v2], newVertIndex[face[i8].v3]};
            }
            ++i8;
        }
        TriangleMesh newmesh = new TriangleMesh(v, (int[][])f);
        TriangleMesh.Vertex[] newvert = (TriangleMesh.Vertex[])newmesh.getVertices();
        TriangleMesh.Edge[] newedge = newmesh.getEdges();
        newmesh.getSkeleton().copy(theMesh.getSkeleton());
        newmesh.setTexture(theMesh.getTexture());
        newmesh.setTextureMapping(theMesh.getTextureMapping());
        if (newmesh.isClosed() && theMesh.getMaterial() != null) {
            newmesh.setMaterial(theMesh.getMaterial());
            newmesh.setMaterialMapping(theMesh.getMaterialMapping());
        }
        newmesh.setSmoothingMethod(theMesh.getSmoothingMethod());
        int i9 = 0;
        while (i9 < edge.length) {
            int r1 = newVertIndex[edge[i9].v1];
            int r2 = newVertIndex[edge[i9].v2];
            int j = 0;
            while (j < newedge.length) {
                if (r1 == newedge[j].v1 && r2 == newedge[j].v2 || r1 == newedge[j].v2 && r2 == newedge[j].v1) {
                    newedge[j].smoothness = edge[i9].smoothness;
                }
                ++j;
            }
            ++i9;
        }
        this.setUndoRecord(new UndoRecord(this, false, 0, new Object[]{newmesh, theMesh}));
        this.theView.setMesh(newmesh);
        this.theView.updateImage();
        this.theView.repaint();
    }

    void subdivideCommand() {
        TriangleMesh theMesh = (TriangleMesh)this.theView.getObject().object;
        boolean[] selected = ((TriMeshViewer)this.theView).getSelection();
        if (((TriMeshViewer)this.theView).getSelectionMode() != 1 && ((TriMeshViewer)this.theView).getSelectionMode() != 2) {
            return;
        }
        int i = 0;
        while (!selected[i] && i < selected.length) {
            ++i;
        }
        if (i == selected.length) {
            return;
        }
        if (((TriMeshViewer)this.theView).getSelectionMode() == 1) {
            i = theMesh.getVertices().length;
            TriangleMesh newmesh = theMesh.getSmoothingMethod() == 3 ? TriangleMesh.subdivideLoop(theMesh, selected, Double.MAX_VALUE) : (theMesh.getSmoothingMethod() == 2 ? TriangleMesh.subdivideButterfly(theMesh, selected, Double.MAX_VALUE) : TriangleMesh.subdivideLinear(theMesh, selected));
            this.setUndoRecord(new UndoRecord(this, false, 0, new Object[]{newmesh, theMesh}));
            this.theView.setMesh(newmesh);
            TriangleMesh.Edge[] edges = newmesh.getEdges();
            boolean[] newselection = new boolean[edges.length];
            int j = 0;
            while (j < edges.length) {
                newselection[j] = edges[j].v1 >= i || edges[j].v2 >= i;
                ++j;
            }
            ((TriMeshViewer)this.theView).setSelection(newselection);
        } else {
            i = theMesh.getVertices().length;
            TriangleMesh newmesh = TriangleMesh.subdivideFaces(theMesh, selected);
            this.setUndoRecord(new UndoRecord(this, false, 0, new Object[]{newmesh, theMesh}));
            this.theView.setMesh(newmesh);
            TriangleMesh.Face[] faces = newmesh.getFaces();
            boolean[] newselection = new boolean[faces.length];
            int j = 0;
            while (j < faces.length) {
                newselection[j] = faces[j].v1 >= i || faces[j].v2 >= i || faces[j].v3 >= i;
                ++j;
            }
            ((TriMeshViewer)this.theView).setSelection(newselection);
        }
    }

    void simplifyCommand() {
        int i;
        boolean[] newSel;
        TriangleMesh.Edge[] e;
        TriangleMesh theMesh = (TriangleMesh)this.theView.getObject().object;
        boolean[] selection = ((TriMeshViewer)this.theView).getSelection();
        int selectionMode = ((TriMeshViewer)this.theView).getSelectionMode();
        ValueField errorField = new ValueField(0.01, 1);
        ComponentsDialog dlg = new ComponentsDialog((Window)this, "Specify tolerance for simplified mesh:", new Component[]{errorField}, new String[]{"Max Surface Error"});
        if (!dlg.clickedOk()) {
            return;
        }
        this.setUndoRecord(new UndoRecord(this, false, 0, new Object[]{theMesh, theMesh.duplicate()}));
        if (selectionMode == 0) {
            e = theMesh.getEdges();
            newSel = new boolean[e.length];
            i = 0;
            while (i < e.length) {
                newSel[i] = selection[e[i].v1] && selection[e[i].v2];
                ++i;
            }
            selection = newSel;
        }
        if (selectionMode == 2) {
            e = theMesh.getEdges();
            newSel = new boolean[e.length];
            i = 0;
            while (i < e.length) {
                newSel[i] = selection[e[i].f1] || selection[e[i].f2];
                ++i;
            }
            selection = newSel;
        }
        i = 0;
        while (i < selection.length && !selection[i]) {
            ++i;
        }
        if (i == selection.length) {
            selection = new boolean[selection.length];
            i = 0;
            while (i < selection.length) {
                selection[i] = true;
                ++i;
            }
        }
        new TriMeshSimplifier(theMesh, selection, errorField.getValue(), this);
        this.theView.setMesh(theMesh);
        this.theView.updateImage();
        this.theView.repaint();
    }

    void optimizeCommand() {
        MessageDialog dlg = new MessageDialog((Window)this, "Optimize mesh connectivity?  This will rearrange the mesh edges to produce a smoother surface.", new String[]{Translate.text("button.ok"), Translate.text("button.cancel")});
        if (dlg.getChoice() == 1) {
            return;
        }
        TriangleMesh theMesh = (TriangleMesh)this.theView.getObject().object;
        this.setUndoRecord(new UndoRecord(this, false, 0, new Object[]{theMesh, theMesh.duplicate()}));
        theMesh.copyObject(TriangleMesh.optimizeMesh(theMesh));
        this.theView.setMesh(theMesh);
        boolean[] selection = ((TriMeshViewer)this.theView).getSelection();
        int i = 0;
        while (i < selection.length) {
            selection[i] = false;
            ++i;
        }
        ((TriMeshViewer)this.theView).setSelection(selection);
        this.theView.updateImage();
        this.theView.repaint();
    }

    void bevelCommand() {
        final TriangleMesh theMesh = (TriangleMesh)this.theView.getObject().object;
        TriangleMesh previewMesh = (TriangleMesh)theMesh.duplicate();
        TriangleMesh.Face[] face = theMesh.getFaces();
        final boolean[] selection = ((TriMeshViewer)this.theView).getSelection();
        final ValueField heightField = new ValueField(0.0, 0);
        final ValueField widthField = new ValueField(0.0, 0);
        final Choice applyChoice = new Choice();
        final ObjectPreviewCanvas preview = new ObjectPreviewCanvas(new ObjectInfo(previewMesh, new CoordinateSystem(), ""));
        if (((TriMeshViewer)this.theView).getSelectionMode() != 2) {
            return;
        }
        new TriMeshBeveler(previewMesh, selection, 0.0, 0.0, true);
        applyChoice.add("Selection as a Whole");
        applyChoice.add("Individual Faces");
        applyChoice.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent ev) {
                TriangleMesh m = (TriangleMesh)theMesh.duplicate();
                new TriMeshBeveler(m, selection, heightField.getValue(), widthField.getValue(), applyChoice.getSelectedIndex() == 0);
                preview.setObject(m);
                preview.updateImage();
                preview.repaint();
            }
        });
        TextListener listener = new TextListener(){

            public void textValueChanged(TextEvent ev) {
                TriangleMesh m = (TriangleMesh)theMesh.duplicate();
                new TriMeshBeveler(m, selection, heightField.getValue(), widthField.getValue(), applyChoice.getSelectedIndex() == 0);
                preview.setObject(m);
                preview.updateImage();
                preview.repaint();
            }
        };
        heightField.addTextListener(listener);
        widthField.addTextListener(listener);
        preview.setPreferredSize(200, 200);
        ComponentsDialog dlg = new ComponentsDialog((Window)this, "Bevel/Extrude selected faces:", new Component[]{heightField, widthField, applyChoice, preview}, new String[]{"Extrude Height", "Bevel Width", "Apply To", ""});
        if (!dlg.clickedOk()) {
            return;
        }
        double height = heightField.getValue();
        double width = widthField.getValue();
        this.setUndoRecord(new UndoRecord(this, false, 0, new Object[]{theMesh, theMesh.duplicate()}));
        TriMeshBeveler beveler = new TriMeshBeveler(theMesh, selection, height, width, applyChoice.getSelectedIndex() == 0);
        this.theView.setMesh(theMesh);
        ((TriMeshViewer)this.theView).setSelection(beveler.getNewSelection());
    }

    void closeBoundaryCommand() {
        TriangleMesh theMesh = (TriangleMesh)this.theView.getObject().object;
        TriangleMesh.Vertex[] vt = (TriangleMesh.Vertex[])theMesh.getVertices();
        TriangleMesh.Edge[] ed = theMesh.getEdges();
        TriangleMesh.Face[] fc = theMesh.getFaces();
        int[][] boundary = ((TriMeshViewer)this.theView).findSelectedBoundaries();
        Vec3[] newvert = new Vec3[vt.length + boundary.length];
        int count = 0;
        int i = 0;
        while (i < vt.length) {
            newvert[i] = vt[i].r;
            ++i;
        }
        int i2 = 0;
        while (i2 < boundary.length) {
            count += boundary[i2].length;
            ++i2;
        }
        int[][] newface = new int[fc.length + count][];
        int i3 = 0;
        while (i3 < fc.length) {
            newface[i3] = new int[]{fc[i3].v1, fc[i3].v2, fc[i3].v3};
            ++i3;
        }
        count = fc.length;
        int i4 = 0;
        while (i4 < boundary.length) {
            int j = ed[boundary[i4][0]].v1;
            Vec3 center = new Vec3(vt[j].r);
            int k = 1;
            while (k < boundary[i4].length) {
                TriangleMesh.Edge e = ed[boundary[i4][k]];
                j = e.v1 == j ? e.v2 : e.v1;
                center.add(vt[j].r);
                ++k;
            }
            center.scale(1.0 / (double)boundary[i4].length);
            newvert[vt.length + i4] = center;
            int k2 = 0;
            while (k2 < boundary[i4].length) {
                TriangleMesh.Edge e = ed[boundary[i4][k2]];
                TriangleMesh.Face f = fc[e.f1];
                newface[count++] = f.v1 == e.v1 && f.v2 == e.v2 || f.v2 == e.v1 && f.v3 == e.v2 || f.v3 == e.v1 && f.v1 == e.v2 ? new int[]{e.v2, e.v1, vt.length + i4} : new int[]{e.v1, e.v2, vt.length + i4};
                ++k2;
            }
            ++i4;
        }
        TriangleMesh newmesh = new TriangleMesh(newvert, (int[][])newface);
        TriangleMesh.Vertex[] newvt = (TriangleMesh.Vertex[])newmesh.getVertices();
        TriangleMesh.Edge[] newed = newmesh.getEdges();
        newmesh.setTexture(theMesh.getTexture());
        newmesh.setTextureMapping(theMesh.getTextureMapping());
        if (newmesh.isClosed() && theMesh.getMaterial() != null) {
            newmesh.setMaterial(theMesh.getMaterial());
            newmesh.setMaterialMapping(theMesh.getMaterialMapping());
        }
        newmesh.setSmoothingMethod(theMesh.getSmoothingMethod());
        int i5 = 0;
        while (i5 < vt.length) {
            newvt[i5].smoothness = vt[i5].smoothness;
            newvt[i5].param = vt[i5].param;
            ++i5;
        }
        int i6 = 0;
        while (i6 < newed.length) {
            if (newed[i6].v1 < vt.length && newed[i6].v2 < vt.length) {
                int j = 0;
                while (j < ed.length) {
                    if (newed[i6].v1 == ed[j].v1 && newed[i6].v2 == ed[j].v2 || newed[i6].v1 == ed[j].v2 && newed[i6].v2 == ed[j].v1) {
                        newed[i6].smoothness = ed[j].smoothness;
                    }
                    ++j;
                }
            }
            ++i6;
        }
        this.setUndoRecord(new UndoRecord(this, false, 0, new Object[]{newmesh, theMesh}));
        this.theView.setMesh(newmesh);
        this.theView.updateImage();
        this.theView.repaint();
    }

    void joinBoundariesCommand() {
        TriangleMesh theMesh = (TriangleMesh)this.theView.getObject().object;
        TriangleMesh.Vertex[] vt = (TriangleMesh.Vertex[])theMesh.getVertices();
        TriangleMesh.Edge[] ed = theMesh.getEdges();
        final int[][] boundary = ((TriMeshViewer)this.theView).findSelectedBoundaries();
        final int[][] boundaryVert = new int[2][];
        if (boundary.length != 2) {
            return;
        }
        boundaryVert[0] = new int[boundary[0].length];
        boundaryVert[1] = new int[boundary[1].length];
        boundaryVert[0][0] = ed[boundary[0][0]].v1 == ed[boundary[0][1]].v1 || ed[boundary[0][0]].v1 == ed[boundary[0][1]].v2 ? ed[boundary[0][0]].v2 : ed[boundary[0][0]].v1;
        int i = 0;
        while (i < boundary[0].length - 1) {
            TriangleMesh.Edge e = ed[boundary[0][i]];
            boundaryVert[0][i + 1] = e.v1 == boundaryVert[0][i] ? e.v2 : e.v1;
            ++i;
        }
        boundaryVert[1][0] = ed[boundary[1][0]].v1 == ed[boundary[1][1]].v1 || ed[boundary[1][0]].v1 == ed[boundary[1][1]].v2 ? ed[boundary[1][0]].v2 : ed[boundary[1][0]].v1;
        int i2 = 0;
        while (i2 < boundary[1].length - 1) {
            TriangleMesh.Edge e = ed[boundary[1][i2]];
            boundaryVert[1][i2 + 1] = e.v1 == boundaryVert[1][i2] ? e.v2 : e.v1;
            ++i2;
        }
        double offset = 0.0;
        boolean reverse = false;
        int maxsteps = boundary[0].length > boundary[1].length ? boundary[0].length : boundary[1].length;
        double step0 = (double)boundary[0].length / (double)maxsteps;
        double step1 = (reverse ? -1.0 : 1.0) * (double)boundary[1].length / (double)maxsteps;
        double mindist = Double.MAX_VALUE;
        int i3 = 0;
        while (i3 < maxsteps - 1) {
            double dist = 0.0;
            int j = 0;
            while (j < maxsteps) {
                double p0 = (double)j * step0;
                double p1 = (double)(i3 + j) * step1;
                int i0 = ((int)Math.round(p0) + boundary[0].length) % boundary[0].length;
                int i1 = ((int)Math.round(p1) + boundary[1].length) % boundary[1].length;
                dist += vt[boundaryVert[0][i0]].r.distance2(vt[boundaryVert[1][i1]].r);
                ++j;
            }
            if (dist < mindist) {
                mindist = dist;
                offset = (double)i3 * step1;
                reverse = false;
            }
            dist = 0.0;
            int j2 = 0;
            while (j2 < maxsteps) {
                double p0 = (double)j2 * step0;
                double p1 = (double)(i3 - j2) * step1;
                int i0 = ((int)Math.round(p0) + boundary[0].length) % boundary[0].length;
                int i1 = ((int)Math.round(p1) + boundary[1].length) % boundary[1].length;
                dist += vt[boundaryVert[0][i0]].r.distance2(vt[boundaryVert[1][i1]].r);
                ++j2;
            }
            if (dist < mindist) {
                mindist = dist;
                offset = (double)i3 * step1;
                reverse = true;
            }
            ++i3;
        }
        final ValueSlider offsetSlider = new ValueSlider(-0.5 * (double)boundary[1].length, 0.5 * (double)boundary[1].length, 2 * maxsteps, 0.0);
        final Checkbox reverseBox = new Checkbox("Reverse Direction", false);
        final ObjectPreviewCanvas preview = new ObjectPreviewCanvas(new ObjectInfo(this.doJoinBoundaries(boundary, boundaryVert, offset, reverse), new CoordinateSystem(), ""));
        final double baseOffset = offset;
        final boolean baseReverse = reverse;
        Panel p = new Panel();
        GridBagConstraints gc = new GridBagConstraints();
        p.setLayout(new GridBagLayout());
        gc.gridy = 0;
        p.add((Component)new Label("Offset: "), gc);
        gc.fill = 2;
        gc.anchor = 17;
        p.add((Component)offsetSlider, gc);
        gc.gridy = 1;
        gc.gridwidth = 2;
        gc.fill = 0;
        gc.anchor = 10;
        p.add((Component)reverseBox, gc);
        gc.gridy = 2;
        gc.fill = 1;
        gc.weighty = 1.0;
        gc.weightx = 1.0;
        p.add((Component)preview, gc);
        preview.setPreferredSize(200, 200);
        preview.setRenderMode(1);
        offsetSlider.addAdjustmentListener(new AdjustmentListener(){

            public void adjustmentValueChanged(AdjustmentEvent ev) {
                preview.setObject(TriMeshEditorWindow.this.doJoinBoundaries(boundary, boundaryVert, baseOffset + offsetSlider.getValue(), baseReverse ^ reverseBox.getState()));
                preview.updateImage();
                preview.repaint();
            }
        });
        reverseBox.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent ev) {
                preview.setObject(TriMeshEditorWindow.this.doJoinBoundaries(boundary, boundaryVert, baseOffset + offsetSlider.getValue(), baseReverse ^ reverseBox.getState()));
                preview.updateImage();
                preview.repaint();
            }
        });
        PanelDialog dlg = new PanelDialog((Window)this, "Select parameters for joining the boundary curves:", p);
        if (!dlg.clickedOk()) {
            return;
        }
        this.setUndoRecord(new UndoRecord(this, false, 0, new Object[]{preview.getObject().object, theMesh}));
        this.theView.setMesh((Mesh)((Object)preview.getObject().object));
        this.theView.updateImage();
        this.theView.repaint();
    }

    TriangleMesh doJoinBoundaries(int[][] boundary, int[][] boundaryVert, double offset, boolean reverse) {
        int maxsteps = boundary[0].length > boundary[1].length ? boundary[0].length : boundary[1].length;
        double step0 = (double)boundary[0].length / (double)maxsteps;
        double step1 = (reverse ? -1.0 : 1.0) * (double)boundary[1].length / (double)maxsteps;
        TriangleMesh theMesh = (TriangleMesh)this.theView.getObject().object;
        TriangleMesh.Vertex[] vt = (TriangleMesh.Vertex[])theMesh.getVertices();
        TriangleMesh.Edge[] ed = theMesh.getEdges();
        TriangleMesh.Face[] fc = theMesh.getFaces();
        Vec3[] newvert = new Vec3[vt.length];
        int[][] newface = new int[fc.length + boundary[0].length + boundary[1].length][];
        int i = 0;
        while (i < vt.length) {
            newvert[i] = vt[i].r;
            ++i;
        }
        int i2 = 0;
        while (i2 < fc.length) {
            newface[i2] = new int[]{fc[i2].v1, fc[i2].v2, fc[i2].v3};
            ++i2;
        }
        int count = fc.length;
        double p0 = 0.0;
        double p1 = offset;
        int i0prev = 0;
        int i1prev = ((int)Math.round(p1) + boundary[1].length) % boundary[1].length;
        int i3 = 1;
        while (i3 <= maxsteps) {
            int v2;
            int v1;
            TriangleMesh.Face f;
            TriangleMesh.Edge e;
            p0 += step0;
            p1 += step1;
            while (p1 < 0.0) {
                p1 += (double)boundary[1].length;
            }
            int i0 = (int)Math.round(p0) % boundary[0].length;
            int i1 = (int)Math.round(p1) % boundary[1].length;
            if (i0 != i0prev) {
                e = ed[boundary[0][step0 > 0.0 ? i0prev : i0]];
                f = fc[e.f1];
                v1 = boundaryVert[0][i0prev];
                v2 = boundaryVert[0][i0];
                newface[count++] = f.v1 == v1 && f.v2 == v2 || f.v2 == v1 && f.v3 == v2 || f.v3 == v1 && f.v1 == v2 ? new int[]{v2, v1, boundaryVert[1][i1prev]} : new int[]{v1, v2, boundaryVert[1][i1prev]};
            }
            if (i1 != i1prev) {
                e = ed[boundary[1][step1 > 0.0 ? i1prev : i1]];
                f = fc[e.f1];
                v1 = boundaryVert[1][i1prev];
                v2 = boundaryVert[1][i1];
                newface[count++] = f.v1 == v1 && f.v2 == v2 || f.v2 == v1 && f.v3 == v2 || f.v3 == v1 && f.v1 == v2 ? new int[]{v2, v1, boundaryVert[0][i0]} : new int[]{v1, v2, boundaryVert[0][i0]};
            }
            i0prev = i0;
            i1prev = i1;
            ++i3;
        }
        TriangleMesh newmesh = new TriangleMesh(newvert, (int[][])newface);
        TriangleMesh.Vertex[] newvt = (TriangleMesh.Vertex[])newmesh.getVertices();
        TriangleMesh.Edge[] newed = newmesh.getEdges();
        newmesh.setTexture(theMesh.getTexture());
        newmesh.setTextureMapping(theMesh.getTextureMapping());
        if (newmesh.isClosed() && theMesh.getMaterial() != null) {
            newmesh.setMaterial(theMesh.getMaterial());
            newmesh.setMaterialMapping(theMesh.getMaterialMapping());
        }
        newmesh.setSmoothingMethod(theMesh.getSmoothingMethod());
        int i4 = 0;
        while (i4 < vt.length) {
            newvt[i4].smoothness = vt[i4].smoothness;
            newvt[i4].param = vt[i4].param;
            ++i4;
        }
        int i5 = 0;
        while (i5 < newed.length) {
            if (newed[i5].v1 < vt.length && newed[i5].v2 < vt.length) {
                int j = 0;
                while (j < ed.length) {
                    if (newed[i5].v1 == ed[j].v1 && newed[i5].v2 == ed[j].v2 || newed[i5].v1 == ed[j].v2 && newed[i5].v2 == ed[j].v1) {
                        newed[i5].smoothness = ed[j].smoothness;
                    }
                    ++j;
                }
            }
            ++i5;
        }
        return newmesh;
    }

    void extractCurveCommand() {
        int smoothingMethod;
        TriangleMesh.Edge first;
        TriangleMesh theMesh = (TriangleMesh)this.theView.getObject().object;
        TriangleMesh.Vertex[] vt = (TriangleMesh.Vertex[])theMesh.getVertices();
        TriangleMesh.Edge[] ed = theMesh.getEdges();
        boolean[] selected = ((TriMeshViewer)this.theView).getSelection();
        Vector<TriangleMesh.Edge> edges = new Vector<TriangleMesh.Edge>();
        if (((TriMeshViewer)this.theView).getSelectionMode() != 1) {
            return;
        }
        int i = 0;
        while (i < selected.length) {
            if (selected[i]) {
                edges.addElement(ed[i]);
            }
            ++i;
        }
        if (edges.size() == 0) {
            return;
        }
        TriangleMesh.Edge last = first = (TriangleMesh.Edge)edges.elementAt(0);
        Vector<TriangleMesh.Edge> ordered = new Vector<TriangleMesh.Edge>();
        ordered.addElement(first);
        edges.removeElementAt(0);
        while (edges.size() > 0) {
            i = 0;
            while (i < edges.size()) {
                TriangleMesh.Edge e = (TriangleMesh.Edge)edges.elementAt(i);
                if (e.v1 == first.v1 || e.v2 == first.v1 || e.v1 == first.v2 || e.v2 == first.v2) {
                    ordered.insertElementAt(e, 0);
                    first = e;
                    break;
                }
                if (e.v1 == last.v1 || e.v2 == last.v1 || e.v1 == last.v2 || e.v2 == last.v2) {
                    ordered.addElement(e);
                    last = e;
                    break;
                }
                ++i;
            }
            if (i == edges.size()) {
                new MessageDialog((Window)this, "The selected edges do not form a continuous curve.");
                return;
            }
            edges.removeElementAt(i);
        }
        boolean closed = ordered.size() > 2 && (last.v1 == first.v1 || last.v2 == first.v1 || last.v1 == first.v2 || last.v2 == first.v2);
        Vec3[] v = new Vec3[closed ? ordered.size() : ordered.size() + 1];
        float[] smoothness = new float[v.length];
        TriangleMesh.Edge second = ordered.size() == 1 ? first : (TriangleMesh.Edge)ordered.elementAt(1);
        int prev = first.v1 == second.v1 || first.v1 == second.v2 ? first.v2 : first.v1;
        i = 0;
        while (i < ordered.size()) {
            TriangleMesh.Edge e = (TriangleMesh.Edge)ordered.elementAt(i);
            v[i] = new Vec3(vt[prev].r);
            smoothness[i] = vt[prev].smoothness;
            prev = e.v1 == prev ? e.v2 : e.v1;
            ++i;
        }
        if (!closed) {
            v[i] = new Vec3(vt[prev].r);
            smoothness[i] = vt[prev].smoothness;
        }
        if ((smoothingMethod = theMesh.getSmoothingMethod()) == 1) {
            smoothingMethod = 0;
        }
        Curve cv = new Curve(v, smoothness, smoothingMethod, closed);
        Component parent = (Component)((Object)this.parentWindow);
        while (parent != null && !(parent instanceof LayoutWindow)) {
            parent = parent.getParent();
        }
        if (parent != null) {
            ((LayoutWindow)parent).addObject(cv, new CoordinateSystem(new Vec3(), new Vec3(0.0, 0.0, 1.0), new Vec3(0.0, 1.0, 0.0)), "Extracted Curve", null);
            ((LayoutWindow)parent).updateImage();
        }
    }

    void setSmoothnessCommand() {
        final TriangleMesh theMesh = (TriangleMesh)this.theView.getObject().object;
        TriangleMesh oldMesh = (TriangleMesh)theMesh.duplicate();
        final TriangleMesh.Vertex[] vt = (TriangleMesh.Vertex[])theMesh.getVertices();
        final TriangleMesh.Edge[] ed = theMesh.getEdges();
        final boolean[] selected = ((TriMeshViewer)this.theView).getSelection();
        final boolean pointmode = ((TriMeshViewer)this.theView).getSelectionMode() == 0;
        final EventProcessor processor = new EventProcessor();
        int i = 0;
        while (i < selected.length && !selected[i]) {
            ++i;
        }
        if (i == selected.length) {
            return;
        }
        float value = pointmode ? vt[i].smoothness : ed[i].smoothness;
        value = 0.001f * (float)Math.round(value * 1000.0f);
        final ValueSlider smoothness = new ValueSlider(0.0, 1.0, 100, value);
        smoothness.addAdjustmentListener(new AdjustmentListener(){

            public void adjustmentValueChanged(AdjustmentEvent ev) {
                processor.addEvent(new Callback(this){
                    private final /* synthetic */ 5 this$1;
                    {
                        this.this$1 = this$1;
                    }

                    public void execute() {
                        float s = (float)5.access$000(this.this$1).getValue();
                        int i = 0;
                        while (i < 5.access$100(this.this$1).length) {
                            if (5.access$100(this.this$1)[i]) {
                                if (5.access$200(this.this$1)) {
                                    5.access$300(this.this$1)[i].smoothness = s;
                                } else {
                                    5.access$400(this.this$1)[i].smoothness = s;
                                }
                            }
                            ++i;
                        }
                        5.access$500(this.this$1).setSmoothingMethod(5.access$500(this.this$1).getSmoothingMethod());
                        5.access$600(this.this$1).theView.objectChanged();
                        5.access$600(this.this$1).theView.updateImage();
                        5.access$600(this.this$1).theView.repaint();
                    }
                });
            }

            static /* synthetic */ ValueSlider access$000(5 x0) {
                return x0.smoothness;
            }

            static /* synthetic */ boolean[] access$100(5 x0) {
                return x0.selected;
            }

            static /* synthetic */ boolean access$200(5 x0) {
                return x0.pointmode;
            }

            static /* synthetic */ TriangleMesh.Vertex[] access$300(5 x0) {
                return x0.vt;
            }

            static /* synthetic */ TriangleMesh.Edge[] access$400(5 x0) {
                return x0.ed;
            }

            static /* synthetic */ TriangleMesh access$500(5 x0) {
                return x0.theMesh;
            }

            static /* synthetic */ TriMeshEditorWindow access$600(5 x0) {
                return x0.TriMeshEditorWindow.this;
            }
        });
        ComponentsDialog dlg = new ComponentsDialog((Window)this, "Set Smoothness for Selected " + (pointmode ? "Points" : "Edges"), new Component[]{smoothness}, new String[]{Translate.text("Smoothness")});
        processor.stopProcessing();
        if (dlg.clickedOk()) {
            this.setUndoRecord(new UndoRecord(this, false, 0, new Object[]{theMesh, oldMesh}));
        } else {
            theMesh.copyObject(oldMesh);
            this.theView.objectChanged();
            this.theView.updateImage();
            this.theView.repaint();
        }
    }

    void reverseNormalsCommand() {
        TriangleMesh theMesh = (TriangleMesh)this.theView.getObject().object;
        this.setUndoRecord(new UndoRecord(this, false, 0, new Object[]{theMesh, theMesh.duplicate()}));
        theMesh.reverseNormals();
        this.theView.objectChanged();
        this.theView.updateImage();
        this.theView.repaint();
    }

    void setSmoothingMethod(int method) {
        TriangleMesh theMesh = (TriangleMesh)this.theView.getObject().object;
        this.setUndoRecord(new UndoRecord(this, false, 0, new Object[]{theMesh, theMesh.duplicate()}));
        int i = 0;
        while (i < this.smoothItem.length) {
            this.smoothItem[i].setState(false);
            ++i;
        }
        this.smoothItem[method].setState(true);
        theMesh.setSmoothingMethod(method);
        this.theView.objectChanged();
        this.theView.updateImage();
        this.theView.repaint();
    }

    public void adjustDeltas(Vec3[] delta) {
        int[] dist = this.theView.getSelectionDistance();
        int[] count = new int[delta.length];
        TriangleMesh theMesh = (TriangleMesh)this.theView.getObject().object;
        TriangleMesh.Edge[] edge = theMesh.getEdges();
        int maxDistance = MeshEditorWindow.getTensionDistance();
        double tension = MeshEditorWindow.getMeshTension();
        double[] scale = new double[maxDistance + 1];
        int i = 0;
        while (i < delta.length) {
            if (dist[i] != 0) {
                delta[i].set(0.0, 0.0, 0.0);
            }
            ++i;
        }
        int i2 = 0;
        while (i2 < maxDistance) {
            int j = 0;
            while (j < count.length) {
                count[j] = 0;
                ++j;
            }
            int j2 = 0;
            while (j2 < edge.length) {
                if (dist[edge[j2].v1] == i2 && dist[edge[j2].v2] == i2 + 1) {
                    int n = edge[j2].v2;
                    count[n] = count[n] + 1;
                    delta[edge[j2].v2].add(delta[edge[j2].v1]);
                } else if (dist[edge[j2].v2] == i2 && dist[edge[j2].v1] == i2 + 1) {
                    int n = edge[j2].v1;
                    count[n] = count[n] + 1;
                    delta[edge[j2].v1].add(delta[edge[j2].v2]);
                }
                ++j2;
            }
            int j3 = 0;
            while (j3 < count.length) {
                if (count[j3] > 1) {
                    delta[j3].scale(1.0 / (double)count[j3]);
                }
                ++j3;
            }
            ++i2;
        }
        int i3 = 0;
        while (i3 < scale.length) {
            scale[i3] = Math.pow(((double)(maxDistance - i3) + 1.0) / ((double)maxDistance + 1.0), tension);
            ++i3;
        }
        int i4 = 0;
        while (i4 < delta.length) {
            if (dist[i4] > 0) {
                delta[i4].scale(scale[dist[i4]]);
            }
            ++i4;
        }
    }
}

