/*
 * Decompiled with CFR 0.152.
 */
package artofillusion;

import artofillusion.Camera;
import artofillusion.MeshEditorWindow;
import artofillusion.MeshViewer;
import artofillusion.ObjectViewer;
import artofillusion.TriMeshViewer;
import artofillusion.animation.SkeletonTool;
import artofillusion.math.Vec2;
import artofillusion.math.Vec3;
import artofillusion.object.Mesh;
import artofillusion.object.Object3D;
import artofillusion.object.ObjectInfo;
import artofillusion.object.TriangleMesh;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Panel;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.util.Arrays;
import java.util.Vector;

public class TriMeshViewer
extends MeshViewer {
    boolean[] selected;
    boolean[] visible;
    boolean[] hideEdge;
    boolean draggingSelectionBox;
    boolean dragging;
    boolean tolerant;
    boolean showQuads;
    int[] selectionDistance;
    int maxDistance;
    int deselect;
    int selectMode;
    Point[] screenVert;
    double[] screenZ;
    int[][] boundary;
    public static final int POINT_MODE = 0;
    public static final int EDGE_MODE = 1;
    public static final int FACE_MODE = 2;

    public TriMeshViewer(ObjectInfo obj, Panel p) {
        super(obj, p);
        TriangleMesh mesh = (TriangleMesh)obj.object;
        this.selected = new boolean[mesh.getVertices().length];
        this.visible = new boolean[mesh.getVertices().length];
        this.findQuads();
        this.findSelectionDistance();
    }

    protected void drawObject(Graphics g) {
        Color selectedColor;
        Color meshColor;
        TriangleMesh.Vertex[] v = (TriangleMesh.Vertex[])((TriangleMesh)this.theObject).getVertices();
        this.screenVert = new Point[v.length];
        this.screenZ = new double[v.length];
        if (this.visible.length != v.length) {
            this.visible = new boolean[v.length];
        }
        Vec2[] p = new Vec2[v.length];
        int i = 0;
        while (i < v.length) {
            p[i] = this.theCamera.getObjectToScreen().timesXY(v[i].r);
            this.screenVert[i] = new Point((int)p[i].x, (int)p[i].y);
            this.screenZ[i] = this.theCamera.getObjectToView().timesZ(v[i].r);
            this.visible[i] = this.screenZ[i] > this.theCamera.getClipDistance();
            ++i;
        }
        this.drawSurface(g);
        if (this.currentTool instanceof SkeletonTool) {
            meshColor = Color.gray;
            selectedColor = new Color(255, 127, 255);
        } else {
            meshColor = Color.black;
            selectedColor = Color.magenta;
            if (this.showSkeleton && ((TriangleMesh)this.theObject).getSkeleton() != null) {
                ((TriangleMesh)this.theObject).getSkeleton().draw(this, -1, -1, Color.gray);
            }
        }
        if (this.selectMode == 0) {
            this.drawEdges(g, p, Color.gray, Color.gray);
            this.drawVertices(g, meshColor, this.currentTool.hilightSelection() ? selectedColor : meshColor);
        } else {
            this.drawEdges(g, p, meshColor, this.currentTool.hilightSelection() ? selectedColor : meshColor);
        }
        if (this.currentTool instanceof SkeletonTool && this.showSkeleton && ((TriangleMesh)this.theObject).getSkeleton() != null) {
            ((TriangleMesh)this.theObject).getSkeleton().draw(this, this.getSelectedJoint(), this.getBaseJoint(), Color.black);
        }
    }

    private void drawSurface(Graphics g) {
        if (!this.showSurface) {
            return;
        }
        if (this.renderMode == 0) {
            g.setColor(ObjectViewer.surfaceColor);
            Object3D.draw(g, this.theCamera, this.objInfo.getWireframePreview(), this.objInfo.getBounds());
        } else if (this.renderMode == 3) {
            this.renderFlatTransparent(this.objInfo.getPreviewMesh(), this.theCamera, this.theCamera.getViewToWorld().timesDirection(Vec3.vz()), ObjectViewer.surfaceRGB);
        } else if (this.renderMode == 1) {
            this.renderFlat(this.objInfo.getPreviewMesh(), this.theCamera, this.theCamera.getViewToWorld().timesDirection(Vec3.vz()), this.theObject.isClosed(), ObjectViewer.surfaceRGB);
        } else {
            this.renderSmooth(this.objInfo.getPreviewMesh(), this.theCamera, this.theCamera.getViewToWorld().timesDirection(Vec3.vz()), this.theObject.isClosed(), ObjectViewer.surfaceRGB);
        }
    }

    private void drawVertices(Graphics g, Color unselectedColor, Color selectedColor) {
        int i;
        if (!this.showMesh) {
            return;
        }
        TriangleMesh.Vertex[] v = (TriangleMesh.Vertex[])((TriangleMesh)this.theObject).getVertices();
        if (this.renderMode == 1 || this.renderMode == 2) {
            i = 0;
            while (i < v.length) {
                if (!this.selected[i] && this.visible[i]) {
                    this.renderBox(this.screenVert[i].x - 2, this.screenVert[i].y - 2, 5, 5, this.screenZ[i] - 0.01, unselectedColor);
                }
                ++i;
            }
        } else {
            i = 0;
            while (i < v.length) {
                if (!this.selected[i] && this.visible[i]) {
                    this.drawBox(this.screenVert[i].x - 2, this.screenVert[i].y - 2, 5, 5, unselectedColor);
                }
                ++i;
            }
        }
        if (this.renderMode == 1 || this.renderMode == 2) {
            i = 0;
            while (i < v.length) {
                if (this.selected[i] && this.visible[i]) {
                    this.renderBox(this.screenVert[i].x - 2, this.screenVert[i].y - 2, 5, 5, this.screenZ[i] - 0.01, selectedColor);
                }
                ++i;
            }
        } else {
            i = 0;
            while (i < v.length) {
                if (this.selected[i] && this.visible[i]) {
                    this.drawBox(this.screenVert[i].x - 2, this.screenVert[i].y - 2, 5, 5, selectedColor);
                }
                ++i;
            }
        }
    }

    private void drawEdges(Graphics g, Vec2[] p, Color unselectedColor, Color selectedColor) {
        block36: {
            int i;
            TriangleMesh.Edge[] e;
            block34: {
                block35: {
                    if (!this.showMesh) {
                        return;
                    }
                    e = ((TriangleMesh)this.theObject).getEdges();
                    if (this.renderMode == 1 || this.renderMode == 2) {
                        if (this.selectMode == 0) {
                            i = 0;
                            while (i < e.length) {
                                if (!this.hideEdge[i] && this.visible[e[i].v1] && this.visible[e[i].v2]) {
                                    this.renderLine(p[e[i].v1], this.screenZ[e[i].v1] - 0.01, p[e[i].v2], this.screenZ[e[i].v2] - 0.01, this.theCamera, unselectedColor.getRGB());
                                }
                                ++i;
                            }
                        } else if (this.selectMode == 1) {
                            i = 0;
                            while (i < e.length) {
                                if (!this.selected[i] && !this.hideEdge[i] && this.visible[e[i].v1] && this.visible[e[i].v2]) {
                                    this.renderLine(p[e[i].v1], this.screenZ[e[i].v1] - 0.01, p[e[i].v2], this.screenZ[e[i].v2] - 0.01, this.theCamera, unselectedColor.getRGB());
                                }
                                ++i;
                            }
                        } else {
                            i = 0;
                            while (i < e.length) {
                                if (!(this.hideEdge[i] || !this.visible[e[i].v1] || !this.visible[e[i].v2] || this.selected[e[i].f1] || e[i].f2 != -1 && this.selected[e[i].f2])) {
                                    this.renderLine(p[e[i].v1], this.screenZ[e[i].v1] - 0.01, p[e[i].v2], this.screenZ[e[i].v2] - 0.01, this.theCamera, unselectedColor.getRGB());
                                }
                                ++i;
                            }
                        }
                    } else if (this.selectMode == 0) {
                        i = 0;
                        while (i < e.length) {
                            if (!this.hideEdge[i] && this.visible[e[i].v1] && this.visible[e[i].v2]) {
                                this.drawLine(this.screenVert[e[i].v1], this.screenVert[e[i].v2], unselectedColor);
                            }
                            ++i;
                        }
                    } else if (this.selectMode == 1) {
                        i = 0;
                        while (i < e.length) {
                            if (!this.selected[i] && !this.hideEdge[i] && this.visible[e[i].v1] && this.visible[e[i].v2]) {
                                this.drawLine(this.screenVert[e[i].v1], this.screenVert[e[i].v2], unselectedColor);
                            }
                            ++i;
                        }
                    } else {
                        i = 0;
                        while (i < e.length) {
                            if (!(this.hideEdge[i] || !this.visible[e[i].v1] || !this.visible[e[i].v2] || this.selected[e[i].f1] || e[i].f2 != -1 && this.selected[e[i].f2])) {
                                this.drawLine(this.screenVert[e[i].v1], this.screenVert[e[i].v2], unselectedColor);
                            }
                            ++i;
                        }
                    }
                    if (this.renderMode != 1 && this.renderMode != 2) break block34;
                    if (this.selectMode != 1) break block35;
                    i = 0;
                    while (i < e.length) {
                        if (this.selected[i] && !this.hideEdge[i] && this.visible[e[i].v1] && this.visible[e[i].v2]) {
                            this.renderLine(p[e[i].v1], this.screenZ[e[i].v1] - 0.01, p[e[i].v2], this.screenZ[e[i].v2] - 0.01, this.theCamera, selectedColor.getRGB());
                        }
                        ++i;
                    }
                    break block36;
                }
                if (this.selectMode != 2) break block36;
                i = 0;
                while (i < e.length) {
                    if (!this.hideEdge[i] && this.visible[e[i].v1] && this.visible[e[i].v2] && (this.selected[e[i].f1] || e[i].f2 != -1 && this.selected[e[i].f2])) {
                        this.renderLine(p[e[i].v1], this.screenZ[e[i].v1] - 0.01, p[e[i].v2], this.screenZ[e[i].v2] - 0.01, this.theCamera, selectedColor.getRGB());
                    }
                    ++i;
                }
                break block36;
            }
            if (this.selectMode == 1) {
                i = 0;
                while (i < e.length) {
                    if (this.selected[i] && !this.hideEdge[i] && this.visible[e[i].v1] && this.visible[e[i].v2]) {
                        this.drawLine(this.screenVert[e[i].v1], this.screenVert[e[i].v2], selectedColor);
                    }
                    ++i;
                }
            } else if (this.selectMode == 2) {
                i = 0;
                while (i < e.length) {
                    if (!this.hideEdge[i] && this.visible[e[i].v1] && this.visible[e[i].v2] && (this.selected[e[i].f1] || e[i].f2 != -1 && this.selected[e[i].f2])) {
                        this.drawLine(this.screenVert[e[i].v1], this.screenVert[e[i].v2], selectedColor);
                    }
                    ++i;
                }
            }
        }
    }

    public void drawDraggedSelection(Graphics g, Camera cam, Vec3[] v) {
        TriangleMesh.Vertex[] vert = (TriangleMesh.Vertex[])((TriangleMesh)this.theObject).getVertices();
        TriangleMesh.Edge[] edge = ((TriangleMesh)this.theObject).getEdges();
        if (this.selectMode == 0) {
            int i = 0;
            while (i < vert.length) {
                if (vert[i].r != v[i]) {
                    Vec2 p = cam.getObjectToScreen().timesXY(v[i]);
                    g.fillRect((int)p.x - 2, (int)p.y - 2, 5, 5);
                }
                ++i;
            }
        }
        int i = 0;
        while (i < edge.length) {
            if (!(this.hideEdge[i] || vert[edge[i].v1].r == v[edge[i].v1] && vert[edge[i].v2].r == v[edge[i].v2])) {
                cam.drawClippedLine(g, v[edge[i].v1], v[edge[i].v2]);
            }
            ++i;
        }
    }

    public void setSelectionMode(int mode) {
        boolean[] newSel;
        TriangleMesh.Vertex[] v = (TriangleMesh.Vertex[])((TriangleMesh)this.theObject).getVertices();
        TriangleMesh.Edge[] e = ((TriangleMesh)this.theObject).getEdges();
        TriangleMesh.Face[] f = ((TriangleMesh)this.theObject).getFaces();
        if (mode == this.selectMode) {
            return;
        }
        if (mode == 0) {
            newSel = new boolean[v.length];
            if (this.selectMode == 1) {
                int i = 0;
                while (i < e.length) {
                    if (this.selected[i]) {
                        newSel[e[i].v2] = true;
                        newSel[e[i].v1] = true;
                    }
                    ++i;
                }
            } else {
                int i = 0;
                while (i < f.length) {
                    if (this.selected[i]) {
                        newSel[f[i].v3] = true;
                        newSel[f[i].v2] = true;
                        newSel[f[i].v1] = true;
                    }
                    ++i;
                }
            }
        } else if (mode == 1) {
            newSel = new boolean[e.length];
            if (this.selectMode == 0) {
                if (this.tolerant) {
                    int i = 0;
                    while (i < e.length) {
                        newSel[i] = !this.hideEdge[i] && (this.selected[e[i].v1] || this.selected[e[i].v2]);
                        ++i;
                    }
                } else {
                    int i = 0;
                    while (i < e.length) {
                        newSel[i] = !this.hideEdge[i] && this.selected[e[i].v1] && this.selected[e[i].v2];
                        ++i;
                    }
                }
            } else {
                int i = 0;
                while (i < f.length) {
                    if (this.selected[i]) {
                        newSel[f[i].e3] = true;
                        newSel[f[i].e2] = true;
                        newSel[f[i].e1] = true;
                    }
                    ++i;
                }
            }
        } else {
            newSel = new boolean[f.length];
            if (this.selectMode == 0) {
                if (this.tolerant) {
                    int i = 0;
                    while (i < f.length) {
                        newSel[i] = this.selected[f[i].v1] || this.selected[f[i].v2] || this.selected[f[i].v3];
                        ++i;
                    }
                } else {
                    int i = 0;
                    while (i < f.length) {
                        newSel[i] = this.selected[f[i].v1] && this.selected[f[i].v2] && this.selected[f[i].v3];
                        ++i;
                    }
                }
            } else {
                int i = 0;
                while (i < f.length) {
                    newSel[i] = this.selected[f[i].e1] && this.selected[f[i].e2] && this.selected[f[i].e3];
                    ++i;
                }
            }
        }
        this.selectMode = mode;
        this.setSelection(newSel);
    }

    public int getSelectionMode() {
        return this.selectMode;
    }

    public boolean[] getSelection() {
        return this.selected;
    }

    public boolean isTolerant() {
        return this.tolerant;
    }

    public void setTolerant(boolean tol) {
        this.tolerant = tol;
    }

    public boolean isQuadMode() {
        return this.showQuads;
    }

    public void setQuadMode(boolean quads) {
        this.showQuads = quads;
        this.findQuads();
        this.findSelectionDistance();
    }

    public boolean isEdgeHidden(int which) {
        return this.hideEdge[which];
    }

    public void setSelection(boolean[] sel) {
        this.selected = sel;
        this.findSelectionDistance();
        this.currentTool.getWindow().updateMenus();
        this.updateImage();
        this.repaint();
    }

    public int[] getSelectionDistance() {
        if (this.maxDistance != MeshEditorWindow.getTensionDistance()) {
            this.findSelectionDistance();
        }
        return this.selectionDistance;
    }

    void findSelectionDistance() {
        int i;
        int[] dist = new int[((TriangleMesh)this.theObject).getVertices().length];
        TriangleMesh.Edge[] e = ((TriangleMesh)this.theObject).getEdges();
        TriangleMesh.Face[] f = ((TriangleMesh)this.theObject).getFaces();
        this.maxDistance = MeshEditorWindow.getTensionDistance();
        if (this.selectMode == 0) {
            i = 0;
            while (i < dist.length) {
                dist[i] = this.selected[i] ? 0 : -1;
                ++i;
            }
        } else if (this.selectMode == 1) {
            i = 0;
            while (i < dist.length) {
                dist[i] = -1;
                ++i;
            }
            i = 0;
            while (i < this.selected.length) {
                if (this.selected[i]) {
                    dist[e[i].v2] = 0;
                    dist[e[i].v1] = 0;
                }
                ++i;
            }
        } else {
            i = 0;
            while (i < dist.length) {
                dist[i] = -1;
                ++i;
            }
            i = 0;
            while (i < this.selected.length) {
                if (this.selected[i]) {
                    dist[f[i].v3] = 0;
                    dist[f[i].v2] = 0;
                    dist[f[i].v1] = 0;
                }
                ++i;
            }
        }
        i = 0;
        while (i < this.maxDistance) {
            int j = 0;
            while (j < e.length) {
                if (!this.hideEdge[j]) {
                    if (dist[e[j].v1] == -1 && dist[e[j].v2] == i) {
                        dist[e[j].v1] = i + 1;
                    } else if (dist[e[j].v2] == -1 && dist[e[j].v1] == i) {
                        dist[e[j].v2] = i + 1;
                    }
                }
                ++j;
            }
            ++i;
        }
        this.selectionDistance = dist;
    }

    public void setMesh(Mesh mesh) {
        TriangleMesh obj = (TriangleMesh)mesh;
        this.setObject(obj);
        if (this.selectMode == 0 && this.selected.length != obj.getVertices().length) {
            this.selected = new boolean[obj.getVertices().length];
            this.visible = new boolean[obj.getVertices().length];
        }
        if (this.selectMode == 1 && this.selected.length != obj.getEdges().length) {
            this.selected = new boolean[obj.getEdges().length];
            this.visible = new boolean[obj.getEdges().length];
        }
        if (this.selectMode == 2 && this.selected.length != obj.getFaces().length) {
            this.selected = new boolean[obj.getFaces().length];
            this.visible = new boolean[obj.getFaces().length];
        }
        this.findQuads();
        this.findSelectionDistance();
        this.boundary = null;
        this.currentTool.getWindow().updateMenus();
    }

    public int[][] findSelectedBoundaries() {
        int j;
        if (this.selectMode != 1) {
            return new int[0][0];
        }
        if (this.boundary == null) {
            this.boundary = ((TriangleMesh)this.theObject).findBoundaryEdges();
        }
        boolean[] allSelected = new boolean[this.boundary.length];
        int count = 0;
        int i = 0;
        while (i < this.boundary.length) {
            j = 0;
            while (j < this.boundary[i].length) {
                if (!this.selected[this.boundary[i][j]]) break;
                ++j;
            }
            if (j == this.boundary[i].length) {
                allSelected[i] = true;
                ++count;
            }
            ++i;
        }
        int[][] index = new int[count][];
        j = 0;
        i = 0;
        while (i < allSelected.length) {
            if (allSelected[i]) {
                index[j++] = this.boundary[i];
            }
            ++i;
        }
        return index;
    }

    public void objectChanged() {
        super.objectChanged();
        this.findQuads();
    }

    public void mousePressed(MouseEvent e) {
        TriangleMesh.Vertex[] v = (TriangleMesh.Vertex[])((TriangleMesh)this.theObject).getVertices();
        TriangleMesh.Edge[] ed = ((TriangleMesh)this.theObject).getEdges();
        TriangleMesh.Face[] f = ((TriangleMesh)this.theObject).getFaces();
        this.requestFocus();
        this.sentClick = true;
        this.deselect = -1;
        this.dragging = false;
        this.clickPoint = e.getPoint();
        this.activeTool = this.metaTool != null && e.isMetaDown() ? this.metaTool : (this.altTool != null && e.isAltDown() ? this.altTool : this.currentTool);
        if (this.activeTool.whichClicks() == 0) {
            this.activeTool.mousePressed(e, this);
            this.dragging = true;
            return;
        }
        int i = this.findClickTarget(e.getPoint());
        if (i == -1) {
            this.draggingSelectionBox = true;
            this.beginDraggingSelection(e.getPoint(), false);
            this.sentClick = false;
            return;
        }
        int j = this.selectMode == 1 ? (this.visible[ed[i].v1] ? ed[i].v1 : ed[i].v2) : (this.selectMode == 2 ? (this.visible[f[i].v1] ? f[i].v1 : (this.visible[f[i].v2] ? f[i].v2 : f[i].v3)) : i);
        if (this.selected[i]) {
            if (e.isShiftDown()) {
                this.deselect = i;
            }
            this.activeTool.mousePressedOnHandle(e, this, 0, j);
            return;
        }
        if (!e.isShiftDown()) {
            int k = 0;
            while (k < this.selected.length) {
                this.selected[k] = false;
                ++k;
            }
        }
        this.selected[i] = true;
        if (this.selectMode == 2) {
            if (this.hideEdge[f[i].e1]) {
                this.selected[ed[f[i].e1].f2] = true;
                this.selected[ed[f[i].e1].f1] = true;
            }
            if (this.hideEdge[f[i].e2]) {
                this.selected[ed[f[i].e2].f2] = true;
                this.selected[ed[f[i].e2].f1] = true;
            }
            if (this.hideEdge[f[i].e3]) {
                this.selected[ed[f[i].e3].f2] = true;
                this.selected[ed[f[i].e3].f1] = true;
            }
        }
        this.findSelectionDistance();
        this.currentTool.getWindow().updateMenus();
        if (e.isShiftDown()) {
            this.sentClick = false;
            this.updateImage();
            this.repaint();
        } else {
            this.activeTool.mousePressedOnHandle(e, this, 0, j);
        }
    }

    public void mouseDragged(MouseEvent e) {
        if (!this.dragging) {
            Point p = e.getPoint();
            if (Math.abs(p.x - this.clickPoint.x) < 2 && Math.abs(p.y - this.clickPoint.y) < 2) {
                return;
            }
        }
        this.dragging = true;
        this.deselect = -1;
        super.mouseDragged(e);
    }

    public void mouseReleased(MouseEvent e) {
        int i;
        TriangleMesh.Edge[] ed = ((TriangleMesh)this.theObject).getEdges();
        TriangleMesh.Face[] fc = ((TriangleMesh)this.theObject).getFaces();
        this.moveToGrid(e);
        this.endDraggingSelection();
        if (this.draggingSelectionBox && !e.isShiftDown() && !e.isControlDown()) {
            i = 0;
            while (i < this.selected.length) {
                this.selected[i] = false;
                ++i;
            }
        }
        if (this.selectBounds != null) {
            boolean newsel;
            boolean bl = newsel = !e.isControlDown();
            if (this.selectMode == 0) {
                i = 0;
                while (i < this.selected.length) {
                    if (this.selectionRegionContains(this.screenVert[i])) {
                        this.selected[i] = newsel;
                    }
                    ++i;
                }
            } else if (this.selectMode == 1) {
                if (this.tolerant) {
                    i = 0;
                    while (i < this.selected.length) {
                        if (!this.hideEdge[i] && (this.selectionRegionContains(this.screenVert[ed[i].v1]) || this.selectionRegionContains(this.screenVert[ed[i].v2]))) {
                            this.selected[i] = newsel;
                        }
                        ++i;
                    }
                } else {
                    i = 0;
                    while (i < this.selected.length) {
                        if (!this.hideEdge[i] && this.selectionRegionContains(this.screenVert[ed[i].v1]) && this.selectionRegionContains(this.screenVert[ed[i].v2])) {
                            this.selected[i] = newsel;
                        }
                        ++i;
                    }
                }
            } else if (this.tolerant) {
                i = 0;
                while (i < this.selected.length) {
                    if (this.selectionRegionContains(this.screenVert[fc[i].v1]) || this.selectionRegionContains(this.screenVert[fc[i].v2]) || this.selectionRegionContains(this.screenVert[fc[i].v3])) {
                        this.selected[i] = newsel;
                    }
                    ++i;
                }
            } else {
                i = 0;
                while (i < this.selected.length) {
                    if (this.selectionRegionContains(this.screenVert[fc[i].v1]) && this.selectionRegionContains(this.screenVert[fc[i].v2]) && this.selectionRegionContains(this.screenVert[fc[i].v3])) {
                        this.selected[i] = newsel;
                    }
                    ++i;
                }
            }
        }
        this.draggingSelectionBox = false;
        this.draggingBox = false;
        if (this.sentClick) {
            if (!this.dragging) {
                Point p = e.getPoint();
                e.translatePoint(this.clickPoint.x - p.x, this.clickPoint.y - p.y);
            }
            this.activeTool.mouseReleased(e, this);
        }
        if (this.deselect > -1) {
            this.selected[this.deselect] = false;
            if (this.selectMode == 2) {
                TriangleMesh.Face f = fc[this.deselect];
                if (this.hideEdge[f.e1]) {
                    this.selected[ed[f.e1].f2] = false;
                    this.selected[ed[f.e1].f1] = false;
                }
                if (this.hideEdge[f.e2]) {
                    this.selected[ed[f.e2].f2] = false;
                    this.selected[ed[f.e2].f1] = false;
                }
                if (this.hideEdge[f.e3]) {
                    this.selected[ed[f.e3].f2] = false;
                    this.selected[ed[f.e3].f1] = false;
                }
            }
        }
        this.findSelectionDistance();
        this.currentTool.getWindow().updateMenus();
        this.updateImage();
        this.repaint();
    }

    private int findClickTarget(Point pos) {
        TriangleMesh.Vertex[] vt = (TriangleMesh.Vertex[])((TriangleMesh)this.theObject).getVertices();
        TriangleMesh.Edge[] ed = ((TriangleMesh)this.theObject).getEdges();
        TriangleMesh.Face[] fc = ((TriangleMesh)this.theObject).getFaces();
        double closestz = Double.MAX_VALUE;
        boolean sel = false;
        int which = -1;
        if (this.selectMode == 0) {
            int i = 0;
            while (i < vt.length) {
                if (this.visible[i] && (!sel || this.selected[i])) {
                    double z;
                    Point v1 = this.screenVert[i];
                    if (pos.x >= v1.x - 2 && pos.x <= v1.x + 2 && pos.y >= v1.y - 2 && pos.y <= v1.y + 2 && (z = this.theCamera.getObjectToView().timesZ(vt[i].r)) < closestz) {
                        which = i;
                        closestz = z;
                        sel = this.selected[i];
                    }
                }
                ++i;
            }
        } else if (this.selectMode == 1) {
            int i = 0;
            while (i < ed.length) {
                if (this.visible[ed[i].v1] && this.visible[ed[i].v2] && !this.hideEdge[i] && (!sel || this.selected[i])) {
                    Point v1 = this.screenVert[ed[i].v1];
                    Point v2 = this.screenVert[ed[i].v2];
                    if (!(pos.x < v1.x - 2 && pos.x < v2.x - 2 || pos.x > v1.x + 2 && pos.x > v2.x + 2 || pos.y < v1.y - 2 && pos.y < v2.y - 2 || pos.y > v1.y + 2 && pos.y > v2.y + 2)) {
                        double z;
                        double w;
                        double u;
                        double v;
                        if (Math.abs(v1.x - v2.x) > Math.abs(v1.y - v2.y)) {
                            if (v2.x > v1.x) {
                                v = ((double)pos.x - (double)v1.x) / (double)(v2.x - v1.x);
                                u = 1.0 - v;
                            } else {
                                u = ((double)pos.x - (double)v2.x) / (double)(v1.x - v2.x);
                                v = 1.0 - u;
                            }
                            w = u * (double)v1.y + v * (double)v2.y - (double)pos.y;
                        } else {
                            if (v2.y > v1.y) {
                                v = ((double)pos.y - (double)v1.y) / (double)(v2.y - v1.y);
                                u = 1.0 - v;
                            } else {
                                u = ((double)pos.y - (double)v2.y) / (double)(v1.y - v2.y);
                                v = 1.0 - u;
                            }
                            w = u * (double)v1.x + v * (double)v2.x - (double)pos.x;
                        }
                        if (!(Math.abs(w) > 2.0) && (z = u * this.theCamera.getObjectToView().timesZ(vt[ed[i].v1].r) + v * this.theCamera.getObjectToView().timesZ(vt[ed[i].v2].r)) < closestz) {
                            which = i;
                            closestz = z;
                            sel = this.selected[i];
                        }
                    }
                }
                ++i;
            }
        } else {
            int i = 0;
            while (i < fc.length) {
                if (this.visible[fc[i].v1] && this.visible[fc[i].v2] && this.visible[fc[i].v3] && (!sel || this.selected[i])) {
                    Point v1 = this.screenVert[fc[i].v1];
                    Point v2 = this.screenVert[fc[i].v2];
                    Point v3 = this.screenVert[fc[i].v3];
                    if (!(pos.x < v1.x - 2 && pos.x < v2.x - 2 && pos.x < v3.x - 2 || pos.x > v1.x + 2 && pos.x > v2.x + 2 && pos.x > v3.x + 2 || pos.y < v1.y - 2 && pos.y < v2.y - 2 && pos.y < v3.y - 2 || pos.y > v1.y + 2 && pos.y > v2.y + 2 && pos.y > v3.y + 2)) {
                        double z;
                        double u;
                        double w;
                        double denom;
                        double v;
                        double e1x = v1.x - v2.x;
                        double e1y = v1.y - v2.y;
                        double e2x = v1.x - v3.x;
                        double e2y = v1.y - v3.y;
                        double vy = pos.y - v1.y;
                        double vx = pos.x - v1.x;
                        if (!((v = (e2x *= (denom = 1.0 / (e1x * e2y - e1y * e2x))) * vy - (e2y *= denom) * vx) < 0.0 || v > 1.0 || (w = vx * (e1y *= denom) - vy * (e1x *= denom)) < 0.0 || w > 1.0 || (u = 1.0 - v - w) < 0.0 || u > 1.0 || !((z = u * this.theCamera.getObjectToView().timesZ(vt[fc[i].v1].r) + v * this.theCamera.getObjectToView().timesZ(vt[fc[i].v2].r) + w * this.theCamera.getObjectToView().timesZ(vt[fc[i].v3].r)) < closestz))) {
                            which = i;
                            closestz = z;
                            sel = this.selected[i];
                        }
                    }
                }
                ++i;
            }
        }
        return which;
    }

    private void findQuads() {
        TriangleMesh.Vertex[] v = (TriangleMesh.Vertex[])((TriangleMesh)this.theObject).getVertices();
        TriangleMesh.Edge[] e = ((TriangleMesh)this.theObject).getEdges();
        TriangleMesh.Face[] f = ((TriangleMesh)this.theObject).getFaces();
        if (this.hideEdge == null || this.hideEdge.length != e.length) {
            this.hideEdge = new boolean[e.length];
        } else {
            int i = 0;
            while (i < e.length) {
                this.hideEdge[i] = false;
                ++i;
            }
        }
        if (!this.showQuads) {
            return;
        }
        boolean[] candidate = new boolean[e.length];
        Vec3[] norm = new Vec3[f.length];
        int i = 0;
        while (i < f.length) {
            TriangleMesh.Face fc = f[i];
            norm[i] = v[fc.v2].r.minus(v[fc.v1].r).cross(v[fc.v3].r.minus(v[fc.v1].r));
            double length = norm[i].length();
            if (length > 0.0) {
                norm[i].scale(1.0 / length);
            }
            ++i;
        }
        int i2 = 0;
        while (i2 < e.length) {
            candidate[i2] = e[i2].f2 != -1 && norm[e[i2].f1].dot(norm[e[i2].f2]) > 0.99;
            ++i2;
        }
        class EdgeScore
        implements Comparable {
            public int edge;
            public double score;
            private final /* synthetic */ TriMeshViewer this$0;

            public EdgeScore(TriMeshViewer this$0, int edge, double score) {
                this.this$0 = this$0;
                this.edge = edge;
                this.score = score;
            }

            public int compareTo(Object o) {
                double diff = this.score - ((EdgeScore)o).score;
                if (diff < 0.0) {
                    return -1;
                }
                if (diff > 0.0) {
                    return 1;
                }
                return 0;
            }
        }
        Vector<EdgeScore> scoreVec = new Vector<EdgeScore>(e.length);
        Vec3 temp0 = new Vec3();
        Vec3 temp1 = new Vec3();
        Vec3 temp2 = new Vec3();
        int i3 = 0;
        while (i3 < e.length) {
            if (candidate[i3]) {
                TriangleMesh.Edge ed = e[i3];
                int v1 = ed.v1;
                int v2 = ed.v2;
                TriangleMesh.Face fc = f[ed.f1];
                int v3 = fc.v1 != v1 && fc.v1 != v2 ? fc.v1 : (fc.v2 != v1 && fc.v2 != v2 ? fc.v2 : fc.v3);
                fc = f[ed.f2];
                int v4 = fc.v1 != v1 && fc.v1 != v2 ? fc.v1 : (fc.v2 != v1 && fc.v2 != v2 ? fc.v2 : fc.v3);
                temp0.set(v[v1].r.minus(v[v2].r));
                temp0.normalize();
                temp1.set(v[v1].r.minus(v[v3].r));
                temp1.normalize();
                temp2.set(v[v1].r.minus(v[v4].r));
                temp2.normalize();
                if (!(Math.acos(temp0.dot(temp1)) + Math.acos(temp0.dot(temp2)) > Math.PI)) {
                    double dot = temp1.dot(temp2);
                    double score = dot > 0.0 ? dot : -dot;
                    temp1.set(v[v2].r.minus(v[v3].r));
                    temp1.normalize();
                    temp2.set(v[v2].r.minus(v[v4].r));
                    temp2.normalize();
                    if (!(Math.acos(-temp0.dot(temp1)) + Math.acos(-temp0.dot(temp2)) > Math.PI)) {
                        dot = temp1.dot(temp2);
                        scoreVec.addElement(new EdgeScore(this, i3, score += dot > 0.0 ? dot : -dot));
                    }
                }
            }
            ++i3;
        }
        if (scoreVec.size() == 0) {
            return;
        }
        Object[] score = new EdgeScore[scoreVec.size()];
        scoreVec.copyInto(score);
        Arrays.sort(score);
        boolean[] hasHiddenEdge = new boolean[f.length];
        int i4 = 0;
        while (i4 < score.length) {
            TriangleMesh.Edge ed = e[((EdgeScore)score[i4]).edge];
            if (!hasHiddenEdge[ed.f1] && !hasHiddenEdge[ed.f2]) {
                this.hideEdge[((EdgeScore)score[i4]).edge] = true;
                hasHiddenEdge[ed.f2] = true;
                hasHiddenEdge[ed.f1] = true;
            }
            ++i4;
        }
    }
}

