/*
 * Decompiled with CFR 0.152.
 */
package artofillusion;

import artofillusion.Callback;
import artofillusion.CurveEditorWindow;
import artofillusion.CurveViewer;
import artofillusion.ModellingApp;
import artofillusion.MoveViewTool;
import artofillusion.ReshapeMeshTool;
import artofillusion.RotateMeshTool;
import artofillusion.RotateViewTool;
import artofillusion.ScaleMeshTool;
import artofillusion.SkewMeshTool;
import artofillusion.TaperMeshTool;
import artofillusion.TubeViewer;
import artofillusion.UndoRecord;
import artofillusion.object.Curve;
import artofillusion.object.Mesh;
import artofillusion.object.MeshVertex;
import artofillusion.object.ObjectInfo;
import artofillusion.object.Tube;
import artofillusion.ui.ComponentsDialog;
import artofillusion.ui.EditingWindow;
import artofillusion.ui.MessageDialog;
import artofillusion.ui.ToolPalette;
import artofillusion.ui.Translate;
import artofillusion.ui.ValueField;
import java.awt.BorderLayout;
import java.awt.CheckboxMenuItem;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Label;
import java.awt.Menu;
import java.awt.MenuBar;
import java.awt.MenuItem;
import java.awt.Panel;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;

public class TubeEditorWindow
extends CurveEditorWindow {
    CheckboxMenuItem[] endsItem;

    public TubeEditorWindow(EditingWindow parent, String title, ObjectInfo obj, Callback onClose) {
        super(parent, title, (Mesh)((Object)obj.object));
        ObjectInfo info = obj.duplicate();
        info.object = info.object.duplicate();
        this.onClose = onClose;
        this.helpText = new Label();
        this.add((Component)this.helpText, "South");
        Panel p1 = new Panel();
        this.add((Component)p1, "Center");
        p1.setLayout(new BorderLayout());
        Panel p2 = new Panel();
        p1.add((Component)p2, "North");
        p2.setLayout(new BorderLayout());
        Panel p3 = new Panel();
        p2.add((Component)p3, "West");
        this.theView = new TubeViewer(info, p3);
        p1.add((Component)this.theView, "Center");
        p3 = new Panel();
        p2.add((Component)p3, "East");
        p3.add(Translate.button("ok", this));
        p3.add(Translate.button("cancel", this));
        Panel p4 = new Panel();
        this.add((Component)p4, "West");
        p4.setLayout(new BorderLayout());
        this.tools = new ToolPalette(1, 7);
        p4.add((Component)this.tools, "North");
        this.defaultTool = new ReshapeMeshTool(this);
        this.tools.addTool(this.defaultTool);
        this.tools.addTool(new ScaleMeshTool(this));
        this.tools.addTool(new RotateMeshTool(this, false));
        this.tools.addTool(new SkewMeshTool(this));
        this.tools.addTool(new TaperMeshTool(this));
        MoveViewTool metaTool = new MoveViewTool(this);
        this.tools.addTool(metaTool);
        RotateViewTool altTool = new RotateViewTool(this);
        this.tools.addTool(altTool);
        this.tools.selectTool(this.defaultTool);
        this.theView.setMetaTool(metaTool);
        this.theView.setAltTool(altTool);
        this.helpText.setBackground(ModellingApp.APP_BACKGROUND_COLOR);
        p2.setBackground(ModellingApp.APP_BACKGROUND_COLOR);
        p3.setBackground(ModellingApp.APP_BACKGROUND_COLOR);
        p4.setBackground(ModellingApp.APP_BACKGROUND_COLOR);
        this.menubar = new MenuBar();
        this.setMenuBar(this.menubar);
        this.createEditMenu();
        this.createMeshMenu((Tube)obj.object);
        this.createViewMenu();
        this.recursivelyAddListeners(this);
        this.oldMesh = (Curve)obj.object;
        this.pack();
        Dimension d1 = Toolkit.getDefaultToolkit().getScreenSize();
        Dimension d2 = new Dimension(d1.width * 2 / 3, d1.height * 2 / 3);
        ((Component)this).setSize(d2);
        ((Component)this).setLocation((d1.width - d2.width) / 2, (d1.height - d2.height) / 2);
        this.updateMenus();
    }

    void createEditMenu() {
        this.editMenu = Translate.menu("edit");
        this.menubar.add(this.editMenu);
        this.editMenuItem = new MenuItem[2];
        this.undoItem = Translate.menuItem("undo", this);
        this.editMenu.add(this.undoItem);
        this.undoItem.setEnabled(false);
        this.editMenu.add(Translate.menuItem("selectAll", this));
        this.editMenuItem[0] = Translate.menuItem("extendSelection", this);
        this.editMenu.add(this.editMenuItem[0]);
        this.editMenuItem[1] = Translate.checkboxMenuItem("freehandSelection", this, false);
        this.editMenu.add(this.editMenuItem[1]);
        this.editMenu.addSeparator();
        this.editMenu.add(Translate.menuItem("curveTension", this));
    }

    void createMeshMenu(Tube obj) {
        this.meshMenu = Translate.menu("tube");
        this.menubar.add(this.meshMenu);
        this.meshMenuItem = new MenuItem[8];
        this.meshMenuItem[0] = Translate.menuItem("deletePoints", this);
        this.meshMenu.add(this.meshMenuItem[0]);
        this.meshMenuItem[1] = Translate.menuItem("subdivide", this);
        this.meshMenu.add(this.meshMenuItem[1]);
        this.meshMenuItem[2] = Translate.menuItem("editPoints", this);
        this.meshMenu.add(this.meshMenuItem[2]);
        this.meshMenuItem[3] = Translate.menuItem("transformPoints", this);
        this.meshMenu.add(this.meshMenuItem[3]);
        this.meshMenuItem[4] = Translate.menuItem("randomize", this);
        this.meshMenu.add(this.meshMenuItem[4]);
        this.meshMenuItem[5] = Translate.menuItem("parameters", this);
        this.meshMenu.add(this.meshMenuItem[5]);
        this.meshMenuItem[6] = Translate.menuItem("thickness", this);
        this.meshMenu.add(this.meshMenuItem[6]);
        this.meshMenu.add(Translate.menuItem("centerTube", this));
        this.meshMenu.addSeparator();
        this.meshMenuItem[7] = Translate.menuItem("smoothness", this);
        this.meshMenu.add(this.meshMenuItem[7]);
        this.smoothMenu = Translate.menu("smoothingMethod");
        this.meshMenu.add(this.smoothMenu);
        this.smoothItem = new CheckboxMenuItem[3];
        this.smoothItem[0] = Translate.checkboxMenuItem("none", this, obj.getSmoothingMethod() == 0);
        this.smoothMenu.add(this.smoothItem[0]);
        this.smoothItem[1] = Translate.checkboxMenuItem("interpolating", this, obj.getSmoothingMethod() == 2);
        this.smoothMenu.add(this.smoothItem[1]);
        this.smoothItem[2] = Translate.checkboxMenuItem("approximating", this, obj.getSmoothingMethod() == 3);
        this.smoothMenu.add(this.smoothItem[2]);
        this.endsItem = new CheckboxMenuItem[3];
        Menu endsMenu = Translate.menu("endsStyle");
        this.meshMenu.add(endsMenu);
        this.endsItem[0] = Translate.checkboxMenuItem("openEnds", this, obj.getEndsStyle() == 0);
        endsMenu.add(this.endsItem[0]);
        this.endsItem[1] = Translate.checkboxMenuItem("closedEnds", this, obj.getEndsStyle() == 1);
        endsMenu.add(this.endsItem[1]);
        this.endsItem[2] = Translate.checkboxMenuItem("flatEnds", this, obj.getEndsStyle() == 2);
        endsMenu.add(this.endsItem[2]);
        if (ModellingApp.getPreferences().getObjectPreviewRenderer() != null) {
            this.meshMenu.addSeparator();
            this.meshMenu.add(Translate.menuItem("renderPreview", this));
        }
    }

    protected Menu createShowMenu() {
        Menu menu = Translate.menu("show");
        this.showItem = new CheckboxMenuItem[4];
        this.showItem[0] = Translate.checkboxMenuItem("curve", this, this.theView.getMeshVisible());
        menu.add(this.showItem[0]);
        this.showItem[1] = Translate.checkboxMenuItem("surface", this, this.theView.getSurfaceVisible());
        menu.add(this.showItem[1]);
        this.showItem[3] = Translate.checkboxMenuItem("entireScene", this, this.theView.getSceneVisible());
        menu.add(this.showItem[3]);
        return menu;
    }

    public void updateMenus() {
        boolean[] selected = ((CurveViewer)this.theView).getSelection();
        int i = 0;
        while (i < selected.length && !selected[i]) {
            ++i;
        }
        if (i < selected.length) {
            this.editMenuItem[0].setEnabled(true);
            i = 0;
            while (i < this.meshMenuItem.length) {
                this.meshMenuItem[i].setEnabled(true);
                ++i;
            }
        } else {
            this.editMenuItem[0].setEnabled(false);
            i = 0;
            while (i < this.meshMenuItem.length) {
                this.meshMenuItem[i].setEnabled(false);
                ++i;
            }
        }
        this.templateItem.setEnabled(this.theView.getTemplateImage() != null);
    }

    public void itemStateChanged(ItemEvent ev) {
        int i = 0;
        while (i < this.endsItem.length) {
            if (ev.getSource() == this.endsItem[i]) {
                int j = 0;
                while (j < this.endsItem.length) {
                    this.endsItem[j].setState(false);
                    ++j;
                }
                this.endsItem[i].setState(true);
                ((Tube)this.theView.getObject().object).setEndsStyle(i);
                this.theView.objectChanged();
                this.theView.updateImage();
                this.theView.repaint();
                return;
            }
            ++i;
        }
        super.itemStateChanged(ev);
    }

    public void actionPerformed(ActionEvent e) {
        String command = e.getActionCommand();
        this.setCursor(Cursor.getPredefinedCursor(3));
        if (command.equals("ok")) {
            Tube theMesh = (Tube)this.theView.getObject().object;
            if (((Tube)this.oldMesh).getMaterial() != null) {
                if (!theMesh.isClosed()) {
                    this.setCursor(Cursor.getDefaultCursor());
                    MessageDialog dlg = new MessageDialog((Window)this, new String[]{"You have modified this object so that it is no longer a closed surface.", "This means that it can no longer have a material assigned to it.  Are", "you sure you want to continue?"}, new String[]{Translate.text("button.ok"), Translate.text("button.cancel")});
                    if (dlg.getChoice() == 1) {
                        return;
                    }
                    theMesh.setMaterial(null);
                    theMesh.setMaterialMapping(null);
                } else {
                    theMesh.setMaterial(((Tube)this.oldMesh).getMaterial());
                    theMesh.setMaterialMapping(((Tube)this.oldMesh).getMaterialMapping());
                }
            }
            this.oldMesh.copyObject(theMesh);
            this.oldMesh = null;
            this.dispose();
            this.onClose.execute();
        } else if (command.equals("cancel")) {
            this.oldMesh = null;
            this.dispose();
        } else if (command.equals("undo")) {
            this.undoCommand();
        } else if (command.equals("selectAll")) {
            this.selectAllCommand();
        } else if (command.equals("extendSelection")) {
            this.extendSelectionCommand();
        } else if (command.equals("deletePoints")) {
            this.deleteCommand();
        } else if (command.equals("subdivide")) {
            this.subdivideCommand();
        } else if (command.equals("editPoints")) {
            this.setPointsCommand();
        } else if (command.equals("transformPoints")) {
            this.transformPointsCommand();
        } else if (command.equals("randomize")) {
            this.randomizeCommand();
        } else if (command.equals("parameters")) {
            this.setParametersCommand();
        } else if (command.equals("thickness")) {
            this.setThicknessCommand();
        } else if (command.equals("centerTube")) {
            this.centerCommand();
        } else if (command.equals("smoothness")) {
            this.setSmoothnessCommand();
        } else if (command.equals("curveTension")) {
            this.setTensionCommand();
        } else if (command.equals("closedEnds")) {
            this.toggleClosedCommand();
        } else if (command.equals("renderPreview")) {
            this.theView.previewObject();
        } else if (command.equals("grid")) {
            this.setGridCommand();
        } else if (command.equals("showTemplate")) {
            boolean wasShown = this.theView.getTemplateShown();
            this.templateItem.setLabel(Translate.text(wasShown ? "menu.showTemplate" : "menu.hideTemplate"));
            this.theView.setShowTemplate(!wasShown);
            this.updateImage();
        } else if (command.equals("setTemplate")) {
            this.setTemplateCommand();
        }
        this.setCursor(Cursor.getDefaultCursor());
    }

    void deleteCommand() {
        int num = 0;
        Tube theTube = (Tube)this.theView.getObject().object;
        boolean[] selected = ((TubeViewer)this.theView).getSelection();
        MeshVertex[] vt = theTube.getVertices();
        double[] t = theTube.getThickness();
        float[] s = theTube.getSmoothness();
        int i = 0;
        while (i < selected.length) {
            if (selected[i]) {
                ++num;
            }
            ++i;
        }
        if (num == 0) {
            return;
        }
        if (theTube.getEndsStyle() != 1 && selected.length - num < 2) {
            new MessageDialog((Window)this, "A tube must have at least two points.");
            return;
        }
        if (theTube.getEndsStyle() == 1 && selected.length - num < 3) {
            new MessageDialog((Window)this, "A closed tube must have at least three points.");
            return;
        }
        this.setUndoRecord(new UndoRecord(this, false, 0, new Object[]{theTube, theTube.duplicate()}));
        MeshVertex[] newv = new MeshVertex[vt.length - num];
        double[] newt = new double[vt.length - num];
        float[] news = new float[vt.length - num];
        boolean[] newsel = new boolean[vt.length - num];
        i = 0;
        int j = 0;
        while (i < vt.length) {
            if (!selected[i]) {
                newsel[j] = selected[i];
                newt[j] = t[i];
                news[j] = s[i];
                newv[j++] = vt[i];
            }
            ++i;
        }
        theTube.setShape(newv, news, newt);
        ((TubeViewer)this.theView).setSelection(newsel);
        this.theView.objectChanged();
        this.theView.updateImage();
        this.theView.repaint();
    }

    void subdivideCommand() {
        Tube theTube = (Tube)this.theView.getObject().object;
        MeshVertex[] vt = theTube.getVertices();
        float[] s = theTube.getSmoothness();
        double[] t = theTube.getThickness();
        boolean[] selected = ((TubeViewer)this.theView).getSelection();
        int splitcount = 0;
        int method = theTube.getSmoothingMethod();
        boolean[] split = theTube.getEndsStyle() == 1 ? new boolean[vt.length] : new boolean[vt.length - 1];
        int i = 0;
        while (i < split.length) {
            if (selected[i] && selected[(i + 1) % selected.length]) {
                split[i] = true;
                ++splitcount;
            }
            ++i;
        }
        MeshVertex[] newpos = new MeshVertex[vt.length + splitcount];
        float[] news = new float[vt.length + splitcount];
        double[] newt = new double[vt.length + splitcount];
        boolean[] newsel = new boolean[vt.length + splitcount];
        i = 0;
        int j = 0;
        while (i < split.length) {
            newsel[j] = selected[i];
            int p1 = i - 1;
            if (p1 < 0) {
                p1 = theTube.getEndsStyle() == 1 ? vt.length - 1 : 0;
            }
            int p3 = i < vt.length - 1 ? i + 1 : (theTube.getEndsStyle() == 1 ? 0 : vt.length - 1);
            if (selected[i] && method == 3) {
                newpos[j] = Tube.calcApproxPoint(vt, s, p1, i, p3);
                newt[j] = Tube.calcApproxThickness(t, s, p1, i, p3);
            } else {
                newpos[j] = vt[i];
                newt[j] = t[i];
            }
            news[j] = selected[i] ? Math.min(s[i] * 2.0f, 1.0f) : s[i];
            if (!split[i]) {
                ++j;
            } else {
                if (method == 0) {
                    newpos[j + 1] = MeshVertex.blend(vt[i], vt[p3], 0.5, 0.5);
                } else if (method == 2) {
                    int p4 = i < vt.length - 2 ? i + 2 : (theTube.getEndsStyle() == 1 ? (i + 2) % vt.length : vt.length - 1);
                    newpos[j + 1] = Tube.calcInterpPoint(vt, s, p1, i, p3, p4);
                    newt[j + 1] = Tube.calcInterpThickness(t, s, p1, i, p3, p4);
                } else {
                    newpos[j + 1] = MeshVertex.blend(vt[i], vt[p3], 0.5, 0.5);
                    newt[j + 1] = 0.5 * (t[i] + t[p3]);
                }
                news[j + 1] = 1.0f;
                newsel[j + 1] = true;
                j += 2;
            }
            ++i;
        }
        if (theTube.getEndsStyle() != 1) {
            newpos[0] = vt[0];
            newpos[j] = vt[i];
            newt[0] = t[0];
            newt[j] = t[i];
            news[j] = s[i];
            newsel[j] = selected[i];
        }
        this.setUndoRecord(new UndoRecord(this, false, 0, new Object[]{theTube, theTube.duplicate()}));
        theTube.setShape(newpos, news, newt);
        ((TubeViewer)this.theView).setSelection(newsel);
        this.theView.objectChanged();
        this.theView.updateImage();
        this.theView.repaint();
    }

    public void setThicknessCommand() {
        Tube theTube = (Tube)this.theView.getObject().object;
        double[] thickness = theTube.getThickness();
        double initial = -1.0;
        int[] selected = this.theView.getSelectionDistance();
        int i = 0;
        while (i < selected.length) {
            if (selected[i] == 0) {
                if (initial == -1.0) {
                    initial = thickness[i];
                } else if (initial != thickness[i]) {
                    initial = Double.NaN;
                }
            }
            ++i;
        }
        if (initial == -1.0) {
            return;
        }
        ValueField thicknessField = new ValueField(initial, 1, 5);
        ComponentsDialog dlg = new ComponentsDialog((Window)this, "Thickness for selected points:", new Component[]{thicknessField}, new String[]{"Thickness"});
        if (!dlg.clickedOk() || Double.isNaN(thicknessField.getValue())) {
            return;
        }
        this.setUndoRecord(new UndoRecord(this, false, 0, new Object[]{theTube, theTube.duplicate()}));
        int i2 = 0;
        while (i2 < selected.length) {
            if (selected[i2] == 0) {
                thickness[i2] = thicknessField.getValue();
            }
            ++i2;
        }
        theTube.setThickness(thickness);
        this.theView.objectChanged();
        this.theView.updateImage();
        this.theView.repaint();
    }
}

