/*
 * Decompiled with CFR 0.152.
 */
package artofillusion;

import artofillusion.CurveViewer;
import artofillusion.ObjectViewer;
import artofillusion.math.Vec2;
import artofillusion.math.Vec3;
import artofillusion.object.Mesh;
import artofillusion.object.MeshVertex;
import artofillusion.object.Object3D;
import artofillusion.object.ObjectInfo;
import artofillusion.object.Tube;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Panel;
import java.awt.Point;

public class TubeViewer
extends CurveViewer {
    public TubeViewer(ObjectInfo obj, Panel p) {
        super(obj, p);
    }

    protected void drawObject(Graphics g) {
        if (this.showSurface) {
            if (this.renderMode == 0) {
                g.setColor(ObjectViewer.surfaceColor);
                Object3D.draw(g, this.theCamera, this.objInfo.getWireframePreview(), this.objInfo.getBounds());
            } else if (this.renderMode == 3) {
                this.renderFlatTransparent(this.objInfo.getPreviewMesh(), this.theCamera, this.theCamera.getViewToWorld().timesDirection(Vec3.vz()), ObjectViewer.surfaceRGB);
            } else if (this.renderMode == 1) {
                this.renderFlat(this.objInfo.getPreviewMesh(), this.theCamera, this.theCamera.getViewToWorld().timesDirection(Vec3.vz()), this.theObject.isClosed(), ObjectViewer.surfaceRGB);
            } else {
                this.renderSmooth(this.objInfo.getPreviewMesh(), this.theCamera, this.theCamera.getViewToWorld().timesDirection(Vec3.vz()), this.theObject.isClosed(), ObjectViewer.surfaceRGB);
            }
        }
        if (this.showMesh) {
            Color color;
            int i;
            MeshVertex[] v = ((Mesh)((Object)this.theObject)).getVertices();
            Point[] screenVert = new Point[v.length];
            double[] screenZ = new double[v.length];
            Vec2[] pos = new Vec2[v.length];
            int i2 = 0;
            while (i2 < v.length) {
                pos[i2] = this.theCamera.getObjectToScreen().timesXY(v[i2].r);
                screenVert[i2] = new Point((int)pos[i2].x, (int)pos[i2].y);
                screenZ[i2] = this.theCamera.getObjectToView().timesZ(v[i2].r);
                ++i2;
            }
            if (this.renderMode == 0) {
                g.setColor(Color.black);
                i = 0;
                while (i < v.length - 1) {
                    g.drawLine((int)pos[i].x, (int)pos[i].y, (int)pos[i + 1].x, (int)pos[i + 1].y);
                    ++i;
                }
                if (((Tube)this.theObject).getEndsStyle() == 1) {
                    g.drawLine((int)pos[v.length - 1].x, (int)pos[v.length - 1].y, (int)pos[0].x, (int)pos[0].y);
                }
            } else {
                int col = Color.black.getRGB();
                int i3 = 0;
                while (i3 < v.length - 1) {
                    this.renderLine(pos[i3], screenZ[i3], pos[i3 + 1], screenZ[i3 + 1], this.theCamera, col);
                    ++i3;
                }
                if (((Tube)this.theObject).getEndsStyle() == 1) {
                    this.renderLine(pos[v.length - 1], screenZ[v.length - 1], pos[0], screenZ[0], this.theCamera, col);
                }
            }
            i = 0;
            while (i < v.length) {
                if (!this.selected[i] && this.theCamera.getObjectToView().timesZ(v[i].r) > this.theCamera.getClipDistance()) {
                    if (this.renderMode == 0) {
                        g.fillRect((int)pos[i].x - 2, (int)pos[i].y - 2, 5, 5);
                    } else {
                        double z = this.theCamera.getObjectToView().timesZ(v[i].r);
                        this.renderBox((int)pos[i].x - 2, (int)pos[i].y - 2, 5, 5, z, Color.black);
                    }
                }
                ++i;
            }
            Color color2 = color = this.currentTool.hilightSelection() ? Color.magenta : Color.black;
            if (g != null) {
                g.setColor(color);
            }
            int i4 = 0;
            while (i4 < v.length) {
                if (this.selected[i4] && this.theCamera.getObjectToView().timesZ(v[i4].r) > this.theCamera.getClipDistance()) {
                    if (this.renderMode == 0) {
                        g.fillRect((int)pos[i4].x - 2, (int)pos[i4].y - 2, 5, 5);
                    } else {
                        double z = this.theCamera.getObjectToView().timesZ(v[i4].r);
                        this.renderBox((int)pos[i4].x - 2, (int)pos[i4].y - 2, 5, 5, z, color);
                    }
                }
                ++i4;
            }
        }
    }
}

